/*
 * Decompiled with CFR 0.152.
 */
package org.brailleblaster.libembosser.utils;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.Iterator;
import javax.xml.namespace.NamespaceContext;

public class PEFNamespaceContext
implements NamespaceContext {
    public static final String DC_NAMESPACE = "http://purl.org/dc/elements/1.1/";
    public static final String PEF_NAMESPACE = "http://www.daisy.org/ns/2008/pef";
    public static final String TG_NAMESPACE = "http://www.aph.org/ns/tactile-graphics/1.0";

    @Override
    public String getNamespaceURI(String prefix) {
        Preconditions.checkArgument((prefix != null ? 1 : 0) != 0, (Object)"Prefix cannot be null");
        switch (prefix) {
            case "": 
            case "pef": {
                return PEF_NAMESPACE;
            }
            case "dc": {
                return DC_NAMESPACE;
            }
            case "tg": {
                return TG_NAMESPACE;
            }
            case "xmlns": {
                return "http://www.w3.org/2000/xmlns/";
            }
            case "xml": {
                return "http://www.w3.org/XML/1998/namespace";
            }
        }
        return "";
    }

    @Override
    public String getPrefix(String namespaceURI) {
        Preconditions.checkArgument((namespaceURI != null ? 1 : 0) != 0, (Object)"Namespace URI cannot be null");
        switch (namespaceURI) {
            case "http://www.daisy.org/ns/2008/pef": {
                return "";
            }
            case "http://purl.org/dc/elements/1.1/": {
                return "dc";
            }
            case "http://www.aph.org/ns/tactile-graphics/1.0": {
                return "tg";
            }
            case "xml": {
                return "http://www.w3.org/XML/1998/namespace";
            }
            case "http://www.w3.org/2000/xmlns/": {
                return "xmlns";
            }
        }
        return null;
    }

    @Override
    public Iterator<String> getPrefixes(String namespaceURI) {
        ImmutableList prefixes;
        Preconditions.checkArgument((namespaceURI != null ? 1 : 0) != 0, (Object)"Namespace URI cannot be null");
        switch (namespaceURI) {
            case "http://www.daisy.org/ns/2008/pef": {
                prefixes = ImmutableList.of((Object)"", (Object)"pef");
                break;
            }
            case "http://purl.org/dc/elements/1.1/": {
                prefixes = ImmutableList.of((Object)"dc");
                break;
            }
            case "http://www.aph.org/ns/tactile-graphics/1.0": {
                prefixes = ImmutableList.of((Object)"tg");
                break;
            }
            case "http://www.w3.org/XML/1998/namespace": {
                prefixes = ImmutableList.of((Object)"xml");
                break;
            }
            case "http://www.w3.org/2000/xmlns/": {
                prefixes = ImmutableList.of((Object)"xmlns");
                break;
            }
            default: {
                prefixes = ImmutableList.of();
            }
        }
        return prefixes.iterator();
    }
}

