/*
 * Decompiled with CFR 0.152.
 */
package org.brailleblaster.libembosser.utils;

import com.google.common.base.Charsets;
import com.google.common.primitives.Ints;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.stream.Stream;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.brailleblaster.libembosser.utils.BrailleMapper;
import org.brailleblaster.libembosser.utils.PEFElementType;
import org.brailleblaster.libembosser.utils.xml.NodeUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public final class PefUtils {
    private static final int[] LINE_ENDINGS = new int[]{13, 10, 12, -1};

    public static Document fromBrf(InputStream brf, String id, int cells, int lines, boolean duplex) throws ParserConfigurationException, IOException {
        return PefUtils.fromBrf(new BufferedReader(new InputStreamReader(brf, Charsets.US_ASCII)), id, cells, lines, duplex);
    }

    public static Document fromBrf(Reader brf, String id, int cells, int lines, boolean duplex) throws ParserConfigurationException, IOException {
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        dbf.setNamespaceAware(true);
        DocumentBuilder db = dbf.newDocumentBuilder();
        Document doc = db.newDocument();
        Element root = doc.createElementNS(PEFElementType.PEF.getNamespaceUri(), PEFElementType.PEF.getElementName());
        root.setAttribute("version", "2008-1");
        doc.appendChild(root);
        Element head = doc.createElementNS(PEFElementType.HEAD.getNamespaceUri(), PEFElementType.HEAD.getElementName());
        Element meta = doc.createElementNS(PEFElementType.META.getNamespaceUri(), PEFElementType.META.getElementName());
        Element dcFormat = doc.createElementNS(PEFElementType.DC_FORMAT.getNamespaceUri(), "dc:" + PEFElementType.DC_FORMAT.getElementName());
        dcFormat.setTextContent("application/x-pef+xml");
        meta.appendChild(dcFormat);
        Element dcIdentifier = doc.createElementNS(PEFElementType.DC_IDENTIFIER.getNamespaceUri(), "dc:" + PEFElementType.DC_IDENTIFIER.getElementName());
        dcIdentifier.setTextContent(id);
        meta.appendChild(dcIdentifier);
        head.appendChild(meta);
        root.appendChild(head);
        Element body = doc.createElementNS(PEFElementType.BODY.getNamespaceUri(), PEFElementType.BODY.getElementName());
        Element volume = doc.createElementNS(PEFElementType.VOLUME.getNamespaceUri(), PEFElementType.VOLUME.getElementName());
        volume.setAttribute("cols", Integer.toString(cells));
        volume.setAttribute("rows", Integer.toString(lines));
        volume.setAttribute("duplex", Boolean.toString(duplex));
        Element section = doc.createElementNS(PEFElementType.SECTION.getNamespaceUri(), PEFElementType.SECTION.getElementName());
        int prevChar = 0;
        int curChar = 0;
        do {
            Element page = doc.createElementNS(PEFElementType.PAGE.getNamespaceUri(), PEFElementType.PAGE.getElementName());
            LinkedList<String> rows = new LinkedList<String>();
            do {
                StringBuilder buf = new StringBuilder();
                prevChar = curChar;
                while (!Ints.contains((int[])LINE_ENDINGS, (int)(curChar = brf.read()))) {
                    buf.append((char)curChar);
                }
                if (prevChar == 13 && curChar == 10) continue;
                rows.addLast(BrailleMapper.ASCII_TO_UNICODE_FAST.map(buf.toString()));
            } while (curChar != 12 && curChar != -1);
            while (!rows.isEmpty() && ((String)rows.getLast()).isEmpty()) {
                rows.removeLast();
            }
            for (String row : rows) {
                Element rowElem = doc.createElementNS(PEFElementType.ROW.getNamespaceUri(), PEFElementType.ROW.getElementName());
                rowElem.setTextContent(row);
                page.appendChild(rowElem);
            }
            section.appendChild(page);
        } while (curChar != -1);
        volume.appendChild(section);
        body.appendChild(volume);
        root.appendChild(body);
        return doc;
    }

    public static Stream<Element> findMatchingDescendants(Element element, PEFElementType ... elementTypes) {
        List<PEFElementType> typesList = Arrays.asList(elementTypes);
        return NodeUtils.findMatchingDescendants(element, (Node n) -> {
            if (!(n instanceof Element)) return false;
            if (!PEFElementType.findElementType((Element)n).filter(typesList::contains).isPresent()) return false;
            return true;
        }).map(n -> (Element)n);
    }
}

