/*
 * Decompiled with CFR 0.152.
 */
package org.brailleblaster.libembosser.utils;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import java.util.Properties;
import org.brailleblaster.libembosser.utils.CharMapperFunction;

public class PropertyCharMapper
implements CharMapperFunction {
    private final Map<String, String> map;

    public PropertyCharMapper(String key) {
        ImmutableMap tmpMap;
        try (InputStream in = this.getClass().getResourceAsStream(String.format("/org/brailleblaster/libembosser/brailleMappings/%s.properties", key));){
            Properties properties = new Properties();
            properties.load(in);
            tmpMap = Maps.fromProperties((Properties)properties);
        }
        catch (IOException e) {
            tmpMap = ImmutableMap.of();
        }
        this.map = tmpMap;
    }

    @Override
    public char applyAsChar(char operand) {
        String input = Character.toString(operand);
        return this.map.getOrDefault(input, input).charAt(0);
    }
}

