/*
 * Decompiled with CFR 0.152.
 */
package org.brailleblaster.updater;

import dev.hydraulic.conveyor.control.SoftwareUpdateController;
import java.net.URI;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.brailleblaster.perspectives.mvc.menu.BBSelectionData;
import org.brailleblaster.perspectives.mvc.menu.TopMenu;
import org.brailleblaster.tools.MenuToolModule;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.program.Program;
import org.eclipse.swt.widgets.Shell;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0016R\u0016\u0010\u0004\u001a\n \u0006*\u0004\u0018\u00010\u00050\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\u00020\bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0014\u0010\u000b\u001a\u00020\fX\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0014\u0010\u000f\u001a\u00020\u00108VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012\u00a8\u0006\u0017"}, d2={"Lorg/brailleblaster/updater/UpdaterModule;", "Lorg/brailleblaster/tools/MenuToolModule;", "<init>", "()V", "updater", "Ldev/hydraulic/conveyor/control/SoftwareUpdateController;", "kotlin.jvm.PlatformType", "topMenu", "Lorg/brailleblaster/perspectives/mvc/menu/TopMenu;", "getTopMenu", "()Lorg/brailleblaster/perspectives/mvc/menu/TopMenu;", "title", "", "getTitle", "()Ljava/lang/String;", "enabled", "", "getEnabled", "()Z", "onRun", "", "bbData", "Lorg/brailleblaster/perspectives/mvc/menu/BBSelectionData;", "brailleblaster-updater"})
public final class UpdaterModule
implements MenuToolModule {
    @NotNull
    public static final UpdaterModule INSTANCE = new UpdaterModule();
    private static final SoftwareUpdateController updater = SoftwareUpdateController.getInstance();
    @NotNull
    private static final TopMenu topMenu = TopMenu.HELP;
    @NotNull
    private static final String title = "Check For Updates";

    private UpdaterModule() {
    }

    @NotNull
    public TopMenu getTopMenu() {
        return topMenu;
    }

    @NotNull
    public String getTitle() {
        return title;
    }

    public boolean getEnabled() {
        return updater != null && updater.getCurrentVersion() != null;
    }

    public void onRun(@NotNull BBSelectionData bbData) {
        Intrinsics.checkNotNullParameter((Object)bbData, (String)"bbData");
        if (this.getEnabled()) {
            SoftwareUpdateController.Version version = updater.getCurrentVersion();
            if (version == null) {
                return;
            }
            SoftwareUpdateController.Version currentVersion = version;
            try {
                SoftwareUpdateController.Version latestVersion = updater.getCurrentVersionFromRepository();
                if (latestVersion == null) {
                    MessageDialog.openWarning((Shell)bbData.getManager().getWpManager().getShell(), (String)"Unable to find latest available version", (String)"It was not possible to find the latest version of the software which is available.");
                    return;
                }
                if (latestVersion.compareTo(currentVersion) > 0) {
                    SoftwareUpdateController.Availability availability = updater.canTriggerUpdateCheckUI();
                    if ((availability == null ? -1 : WhenMappings.$EnumSwitchMapping$0[availability.ordinal()]) == 1) {
                        if (MessageDialog.openQuestion((Shell)bbData.getManager().getWpManager().getShell(), (String)"Update available", (String)("You can update to " + latestVersion.getVersion() + ", you are running " + currentVersion.getVersion() + ". Would you like to restart and update the software now?")) && bbData.getManager().getWpManager().close()) {
                            updater.triggerUpdateCheckUI();
                        }
                    } else if (MessageDialog.openQuestion((Shell)bbData.getManager().getWpManager().getShell(), (String)"Update available", (String)("You can update to " + latestVersion.getVersion() + ", you are currently running " + currentVersion.getVersion() + ". It is not possible to automatically update your software, you will need to download it yourself. Would you like to visit the download page?"))) {
                        URI downloadPage = URI.create(System.getProperty("app.repositoryUrl")).resolve("download.html");
                        Program.launch((String)downloadPage.toString());
                    }
                } else {
                    MessageDialog.openInformation((Shell)bbData.getManager().getWpManager().getShell(), (String)"All up-to-date", (String)"Great news, you are running the latest version of the software.");
                }
            }
            catch (SoftwareUpdateController.UpdateCheckException e) {
                MessageDialog.openWarning((Shell)bbData.getManager().getWpManager().getShell(), (String)"Error when checking for update", (String)("There was an error whilst checking for updates. The error message given was " + e.getMessage()));
            }
        }
    }

    @Metadata(mv={2, 3, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[SoftwareUpdateController.Availability.values().length];
            try {
                nArray[SoftwareUpdateController.Availability.AVAILABLE.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

