/*
 * Decompiled with CFR 0.152.
 */
package org.brailleblaster.libembosser.drivers.generic;

import com.google.common.collect.ImmutableList;
import java.math.BigDecimal;
import java.util.List;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.brailleblaster.libembosser.drivers.generic.GenericGraphicsEmbosser;
import org.brailleblaster.libembosser.drivers.generic.GenericTextEmbosser;
import org.brailleblaster.libembosser.spi.Embosser;
import org.brailleblaster.libembosser.spi.EmbosserFactory;
import org.brailleblaster.libembosser.spi.Rectangle;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \t2\u00020\u0001:\u0001\tB\u0005\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004H\u0016J\u0016\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\u0007\u001a\u00020\bH\u0016R\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lorg/brailleblaster/libembosser/drivers/generic/GenericEmbosserFactory;", "Lorg/brailleblaster/libembosser/spi/EmbosserFactory;", "()V", "embossers", "", "Lorg/brailleblaster/libembosser/spi/Embosser;", "getEmbossers", "locale", "Ljava/util/Locale;", "Companion", "libembosser-core-drivers"})
public final class GenericEmbosserFactory
implements EmbosserFactory {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final List<Embosser> embossers;
    private static final Logger log = LoggerFactory.getLogger(GenericEmbosserFactory.class);
    @NotNull
    private static final Rectangle LARGE_GENERIC_PAPER = new Rectangle(new BigDecimal("1000"), new BigDecimal("1000"));
    @NotNull
    private static final Rectangle SMALL_GENERIC_PAPER = new Rectangle(new BigDecimal("30"), new BigDecimal("30"));

    public GenericEmbosserFactory() {
        ImmutableList.Builder builder = ImmutableList.builder().add((Object)new GenericTextEmbosser("libembosser.generic.text", "Text only", LARGE_GENERIC_PAPER, SMALL_GENERIC_PAPER)).add((Object)new GenericTextEmbosser("libembosser.generic.text_with_margins", "Text with margins", LARGE_GENERIC_PAPER, SMALL_GENERIC_PAPER, true));
        try {
            builder.add((Object)new GenericGraphicsEmbosser());
        }
        catch (Exception e) {
            log.warn("Unable to create generic graphics embosser driver", (Throwable)e);
        }
        ImmutableList immutableList = builder.build();
        Intrinsics.checkNotNullExpressionValue((Object)immutableList, (String)"builder.build()");
        this.embossers = (List)immutableList;
    }

    @NotNull
    public List<Embosser> getEmbossers() {
        return this.embossers;
    }

    @NotNull
    public List<Embosser> getEmbossers(@NotNull Locale locale) {
        Intrinsics.checkNotNullParameter((Object)locale, (String)"locale");
        return this.getEmbossers();
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0011\u0010\u0007\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0006R\u0016\u0010\t\u001a\n \u000b*\u0004\u0018\u00010\n0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lorg/brailleblaster/libembosser/drivers/generic/GenericEmbosserFactory$Companion;", "", "()V", "LARGE_GENERIC_PAPER", "Lorg/brailleblaster/libembosser/spi/Rectangle;", "getLARGE_GENERIC_PAPER", "()Lorg/brailleblaster/libembosser/spi/Rectangle;", "SMALL_GENERIC_PAPER", "getSMALL_GENERIC_PAPER", "log", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "libembosser-core-drivers"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Rectangle getLARGE_GENERIC_PAPER() {
            return LARGE_GENERIC_PAPER;
        }

        @NotNull
        public final Rectangle getSMALL_GENERIC_PAPER() {
            return SMALL_GENERIC_PAPER;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

