/*
 * Decompiled with CFR 0.152.
 */
package org.brailleblaster.libembosser.drivers.indexBraille;

import com.google.common.base.Charsets;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.common.io.ByteSource;
import java.util.Map;
import java.util.OptionalInt;
import org.brailleblaster.libembosser.drivers.utils.document.ByteSourceHandlerToFunctionAdapter;
import org.brailleblaster.libembosser.drivers.utils.document.GenericTextDocumentHandler;
import org.brailleblaster.libembosser.drivers.utils.document.events.DocumentEvent;
import org.brailleblaster.libembosser.spi.Layout;

public class IndexBrailleDocumentHandler
implements ByteSourceHandlerToFunctionAdapter {
    private static final ImmutableMap<Layout, Integer> PAPER_MODE_MAPPINGS = new ImmutableMap.Builder().put((Object)Layout.P1ONLY, (Object)1).put((Object)Layout.P2ONLY, (Object)1).put((Object)Layout.INTERPOINT, (Object)2).put((Object)Layout.Z_FOLDING_DOUBLE_HORIZONTAL, (Object)3).put((Object)Layout.SADDLE_STITCH_DOUBLE_SIDED, (Object)4).put((Object)Layout.Z_FOLDING_SINGLE_HORIZONTAL, (Object)5).put((Object)Layout.Z_FOLDING_DOUBLE_VERTICAL, (Object)6).put((Object)Layout.Z_FOLDING_SINGLE_VERTICAL, (Object)7).put((Object)Layout.SADDLE_STITCH_SINGLE_SIDED, (Object)8).build();
    private final GenericTextDocumentHandler textHandler;
    private final ByteSource header;

    private IndexBrailleDocumentHandler(int leftMargin, int topMargin, int cellsPerLine, int linesPerPage, Layout paperMode, OptionalInt paperSize, int copies) {
        this.textHandler = new GenericTextDocumentHandler.Builder().setLeftMargin(0).setTopMargin(0).setCellsPerLine(cellsPerLine).setLinesPerPage(linesPerPage).setCopies(1).setInterpoint(paperMode.isDoubleSide()).setFooter(new byte[]{26}).build();
        String headerString = String.format("\u001bDBT0,LS50,TD0,PN0,MC%d,DP%d,%sBI%d,CH%d,TM%d,LP%d;", copies, PAPER_MODE_MAPPINGS.get((Object)paperMode), "", leftMargin, cellsPerLine, topMargin, linesPerPage);
        this.header = ByteSource.wrap((byte[])headerString.getBytes(Charsets.US_ASCII));
    }

    @Override
    public void onEvent(DocumentEvent event) {
        this.textHandler.onEvent(event);
    }

    @Override
    public ByteSource asByteSource() {
        return ByteSource.concat((ByteSource[])new ByteSource[]{this.header, this.textHandler.asByteSource()});
    }

    public static class Builder {
        private int leftMargin = 0;
        private int topMargin = 0;
        private int cellsPerLine = 40;
        private int linesPerPage = 25;
        private int copies = 1;
        private Layout paperMode = Layout.P1ONLY;
        private OptionalInt paperSize = OptionalInt.empty();

        public Builder setLeftMargin(int leftMargin) {
            this.leftMargin = leftMargin;
            return this;
        }

        public Builder setCellsPerLine(int cellsPerLine) {
            this.cellsPerLine = cellsPerLine;
            return this;
        }

        public Builder setTopMargin(int topMargin) {
            this.topMargin = topMargin;
            return this;
        }

        public Builder setLinesPerPage(int linesPerPage) {
            this.linesPerPage = linesPerPage;
            return this;
        }

        public Builder setCopies(int copies) {
            this.copies = copies;
            return this;
        }

        public Builder setPaperMode(int mode) {
            Preconditions.checkArgument((boolean)PAPER_MODE_MAPPINGS.containsValue((Object)mode), (Object)String.format("Index embossers do not support %s paper mode", mode));
            this.paperMode = PAPER_MODE_MAPPINGS.entrySet().stream().filter(e -> (Integer)e.getValue() == mode).findFirst().map(Map.Entry::getKey).get();
            return this;
        }

        public Builder setPaperMode(Layout sides) {
            Preconditions.checkArgument((boolean)PAPER_MODE_MAPPINGS.containsKey((Object)sides), (Object)String.format("Index embossers do not support %s paper mode", sides.name()));
            this.paperMode = sides;
            return this;
        }

        public Builder setPaper(OptionalInt paper2) {
            Preconditions.checkNotNull((Object)paper2);
            this.paperSize = paper2;
            return this;
        }

        public IndexBrailleDocumentHandler build() {
            return new IndexBrailleDocumentHandler(this.leftMargin, this.topMargin, this.cellsPerLine, this.linesPerPage, this.paperMode, this.paperSize, this.copies);
        }
    }
}

