/*
 * Decompiled with CFR 0.152.
 */
package org.brailleblaster.libembosser.drivers.utils;

import com.google.common.collect.ImmutableSet;
import java.awt.print.PageFormat;
import java.awt.print.Paper;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;
import java.io.InputStream;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import javax.print.DocFlavor;
import javax.print.PrintService;
import javax.print.StreamPrintServiceFactory;
import javax.print.attribute.Attribute;
import javax.print.attribute.HashPrintRequestAttributeSet;
import javax.print.attribute.PrintRequestAttribute;
import javax.print.attribute.PrintRequestAttributeSet;
import javax.print.attribute.standard.Sides;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.brailleblaster.libembosser.drivers.utils.BaseGraphicsEmbosser;
import org.brailleblaster.libembosser.drivers.utils.DocumentHandler;
import org.brailleblaster.libembosser.drivers.utils.DocumentParser;
import org.brailleblaster.libembosser.drivers.utils.DocumentToPrintableHandler;
import org.brailleblaster.libembosser.drivers.utils.ThrowingBiConsumer;
import org.brailleblaster.libembosser.drivers.utils.document.events.DocumentEvent;
import org.brailleblaster.libembosser.drivers.utils.document.filters.InterpointGraphicTransform;
import org.brailleblaster.libembosser.drivers.utils.document.filters.PageFilter;
import org.brailleblaster.libembosser.embossing.attribute.Copies;
import org.brailleblaster.libembosser.embossing.attribute.PageRanges;
import org.brailleblaster.libembosser.embossing.attribute.PaperLayout;
import org.brailleblaster.libembosser.embossing.attribute.PaperMargins;
import org.brailleblaster.libembosser.embossing.attribute.PaperSize;
import org.brailleblaster.libembosser.spi.BrlCell;
import org.brailleblaster.libembosser.spi.EmbossException;
import org.brailleblaster.libembosser.spi.Embosser;
import org.brailleblaster.libembosser.spi.EmbossingAttributeSet;
import org.brailleblaster.libembosser.spi.Margins;
import org.brailleblaster.libembosser.spi.Rectangle;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.w3c.dom.Document;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000p\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0003\b&\u0018\u0000 ,2\u00020\u0001:\u0001,B\u001f\b\u0004\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0006JE\u0010\f\u001a\u00020\r\"\u0004\b\u0000\u0010\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u0002H\u000e2\u0006\u0010\u0012\u001a\u00020\u00132\u0018\u0010\u0014\u001a\u0014\u0012\u0004\u0012\u0002H\u000e\u0012\u0004\u0012\u00020\u0016\u0012\u0004\u0012\u00020\u00170\u0015H\u0002\u00a2\u0006\u0002\u0010\u0018J \u0010\u0019\u001a\u00020\r2\u0006\u0010\u001a\u001a\u00020\u00102\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J \u0010\u001d\u001a\u00020\r2\u0006\u0010\u001a\u001a\u00020\u00102\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\b\u0010 \u001a\u00020\u0003H\u0016J\u0012\u0010!\u001a\u00020\"2\b\u0010#\u001a\u0004\u0018\u00010$H&J\b\u0010%\u001a\u00020\u0003H\u0016J\b\u0010&\u001a\u00020\u0003H\u0016J\u000e\u0010'\u001a\b\u0012\u0004\u0012\u00020\t0(H\u0016J\u0010\u0010)\u001a\u00020*2\u0006\u0010+\u001a\u00020*H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R6\u0010\u0007\u001a(\u0012\f\u0012\n \n*\u0004\u0018\u00010\t0\t \n*\u0014\u0012\u000e\b\u0001\u0012\n \n*\u0004\u0018\u00010\t0\t\u0018\u00010\b0\bX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u000b\u00a8\u0006-"}, d2={"Lorg/brailleblaster/libembosser/drivers/utils/BaseGraphicsEmbosser;", "Lorg/brailleblaster/libembosser/spi/Embosser;", "id", "", "manufacturer", "model", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;)V", "streamPrintServiceFactories", "", "Ljavax/print/StreamPrintServiceFactory;", "kotlin.jvm.PlatformType", "[Ljavax/print/StreamPrintServiceFactory;", "emboss", "", "T", "ps", "Ljavax/print/PrintService;", "input", "attributes", "Lorg/brailleblaster/libembosser/spi/EmbossingAttributeSet;", "parseMethod", "Lorg/brailleblaster/libembosser/drivers/utils/ThrowingBiConsumer;", "Lorg/brailleblaster/libembosser/drivers/utils/DocumentHandler;", "Lorg/brailleblaster/libembosser/drivers/utils/DocumentParser$ParseException;", "(Ljavax/print/PrintService;Ljava/lang/Object;Lorg/brailleblaster/libembosser/spi/EmbossingAttributeSet;Lorg/brailleblaster/libembosser/drivers/utils/ThrowingBiConsumer;)V", "embossBrf", "embosserDevice", "brf", "Ljava/io/InputStream;", "embossPef", "pef", "Lorg/w3c/dom/Document;", "getId", "getLayoutHelper", "Lorg/brailleblaster/libembosser/drivers/utils/DocumentToPrintableHandler$LayoutHelper;", "cell", "Lorg/brailleblaster/libembosser/spi/BrlCell;", "getManufacturer", "getModel", "getStreamPrintServiceFactory", "Ljava/util/Optional;", "mmToPt", "", "mm", "Companion", "libembosser-core-drivers"})
public abstract class BaseGraphicsEmbosser
implements Embosser {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String id;
    @NotNull
    private final String manufacturer;
    @NotNull
    private final String model;
    private final StreamPrintServiceFactory[] streamPrintServiceFactories;
    @NotNull
    private static final Set<Sides> DOUBLE_SIDED_MODES;

    protected BaseGraphicsEmbosser(@NotNull String id, @NotNull String manufacturer, @NotNull String model) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        Intrinsics.checkNotNullParameter((Object)manufacturer, (String)"manufacturer");
        Intrinsics.checkNotNullParameter((Object)model, (String)"model");
        this.id = id;
        this.manufacturer = manufacturer;
        this.model = model;
        this.streamPrintServiceFactories = PrinterJob.lookupStreamPrintServices(DocFlavor.BYTE_ARRAY.POSTSCRIPT.getMimeType());
    }

    @NotNull
    public abstract DocumentToPrintableHandler.LayoutHelper getLayoutHelper(@Nullable BrlCell var1);

    public void embossPef(@NotNull PrintService embosserDevice, @NotNull Document pef, @NotNull EmbossingAttributeSet attributes) throws EmbossException {
        Intrinsics.checkNotNullParameter((Object)embosserDevice, (String)"embosserDevice");
        Intrinsics.checkNotNullParameter((Object)pef, (String)"pef");
        Intrinsics.checkNotNullParameter((Object)attributes, (String)"attributes");
        this.emboss(embosserDevice, pef, attributes, BaseGraphicsEmbosser::embossPef$lambda$0);
    }

    public void embossBrf(@NotNull PrintService embosserDevice, @NotNull InputStream brf, @NotNull EmbossingAttributeSet attributes) throws EmbossException {
        Intrinsics.checkNotNullParameter((Object)embosserDevice, (String)"embosserDevice");
        Intrinsics.checkNotNullParameter((Object)brf, (String)"brf");
        Intrinsics.checkNotNullParameter((Object)attributes, (String)"attributes");
        this.emboss(embosserDevice, brf, attributes, BaseGraphicsEmbosser::embossBrf$lambda$1);
    }

    private final <T> void emboss(PrintService ps, T input, EmbossingAttributeSet attributes, ThrowingBiConsumer<T, DocumentHandler, DocumentParser.ParseException> parseMethod) throws EmbossException {
        List events = new LinkedList();
        try {
            parseMethod.accept(input, arg_0 -> BaseGraphicsEmbosser.emboss$lambda$2(events, arg_0));
        }
        catch (DocumentParser.ParseException e) {
            throw new RuntimeException("Problem parsing document", e);
        }
        Attribute attribute = attributes.get(PaperLayout.class);
        Intrinsics.checkNotNull((Object)attribute, (String)"null cannot be cast to non-null type org.brailleblaster.libembosser.embossing.attribute.PaperLayout");
        Sides sides = Optional.ofNullable((PaperLayout)attribute).filter(arg_0 -> BaseGraphicsEmbosser.emboss$lambda$3((Function1)new Function1<PaperLayout, Boolean>(this){
            final /* synthetic */ BaseGraphicsEmbosser this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            @NotNull
            public final Boolean invoke(PaperLayout it) {
                return this.this$0.supportsInterpoint();
            }
        }, arg_0)).filter(arg_0 -> BaseGraphicsEmbosser.emboss$lambda$4(emboss.duplex.2.INSTANCE, arg_0)).map(arg_0 -> BaseGraphicsEmbosser.emboss$lambda$5(emboss.duplex.3.INSTANCE, arg_0)).orElse(Sides.ONE_SIDED);
        Intrinsics.checkNotNullExpressionValue((Object)sides, (String)"@Throws(EmbossException:\u2026ice.\", e)\n        }\n    }");
        PrintRequestAttribute duplex2 = sides;
        Attribute attribute2 = attributes.get(PageRanges.class);
        Intrinsics.checkNotNull((Object)attribute2, (String)"null cannot be cast to non-null type org.brailleblaster.libembosser.embossing.attribute.PageRanges");
        PageRanges pages = Optional.ofNullable((PageRanges)attribute2).orElseGet(BaseGraphicsEmbosser::emboss$lambda$6);
        Function transform = new PageFilter(pages);
        if (CollectionsKt.contains((Iterable)DOUBLE_SIDED_MODES, (Object)duplex2)) {
            Function function = transform.andThen(new InterpointGraphicTransform());
            Intrinsics.checkNotNullExpressionValue(function, (String)"transform.andThen(InterpointGraphicTransform())");
            transform = function;
        }
        Function handler = transform.andThen(new DocumentToPrintableHandler.Builder().setLayoutHelper(this.getLayoutHelper(BrlCell.NLS)).build());
        Printable printable = (Printable)handler.apply(events.iterator());
        PrinterJob printJob = PrinterJob.getPrinterJob();
        printJob.setJobName("BrailleBlasterEmboss");
        Optional.ofNullable(attributes.get(Copies.class)).map(arg_0 -> BaseGraphicsEmbosser.emboss$lambda$7(emboss.2.INSTANCE, arg_0)).ifPresent(arg_0 -> BaseGraphicsEmbosser.emboss$lambda$8((Function1)new Function1<Integer, Unit>(printJob){
            final /* synthetic */ PrinterJob $printJob;
            {
                this.$printJob = $printJob;
                super(1);
            }

            public final void invoke(@NotNull Integer copies) {
                Intrinsics.checkNotNullParameter((Object)copies, (String)"copies");
                this.$printJob.setCopies(copies);
            }
        }, arg_0));
        try {
            printJob.setPrintService(ps);
            PageFormat pf = printJob.defaultPage();
            Paper paper2 = pf.getPaper();
            Optional.ofNullable(attributes.get(PaperSize.class)).map(arg_0 -> BaseGraphicsEmbosser.emboss$lambda$9(emboss.4.INSTANCE, arg_0)).ifPresent(arg_0 -> BaseGraphicsEmbosser.emboss$lambda$10((Function1)new Function1<Rectangle, Unit>(paper2, this){
                final /* synthetic */ Paper $paper;
                final /* synthetic */ BaseGraphicsEmbosser this$0;
                {
                    this.$paper = $paper;
                    this.this$0 = $receiver;
                    super(1);
                }

                public final void invoke(@NotNull Rectangle r) {
                    Intrinsics.checkNotNullParameter((Object)r, (String)"r");
                    this.$paper.setSize(BaseGraphicsEmbosser.access$mmToPt(this.this$0, r.getWidth().doubleValue()), BaseGraphicsEmbosser.access$mmToPt(this.this$0, r.getHeight().doubleValue()));
                }
            }, arg_0));
            double width2 = paper2.getWidth();
            double height2 = paper2.getHeight();
            Optional.ofNullable(attributes.get(PaperMargins.class)).map(arg_0 -> BaseGraphicsEmbosser.emboss$lambda$11(emboss.6.INSTANCE, arg_0)).ifPresent(arg_0 -> BaseGraphicsEmbosser.emboss$lambda$12((Function1)new Function1<Margins, Unit>(this, paper2, width2, height2){
                final /* synthetic */ BaseGraphicsEmbosser this$0;
                final /* synthetic */ Paper $paper;
                final /* synthetic */ double $width;
                final /* synthetic */ double $height;
                {
                    this.this$0 = $receiver;
                    this.$paper = $paper;
                    this.$width = $width;
                    this.$height = $height;
                    super(1);
                }

                public final void invoke(@NotNull Margins m) {
                    Intrinsics.checkNotNullParameter((Object)m, (String)"m");
                    double left = BaseGraphicsEmbosser.access$mmToPt(this.this$0, m.getLeft().doubleValue());
                    double top = BaseGraphicsEmbosser.access$mmToPt(this.this$0, m.getTop().doubleValue());
                    this.$paper.setImageableArea(left, top, this.$width - left, this.$height - top);
                }
            }, arg_0));
            pf.setPaper(paper2);
            printJob.setPrintable(printable, pf);
            PrintRequestAttributeSet requestAttributes = new HashPrintRequestAttributeSet(duplex2);
            printJob.print(requestAttributes);
        }
        catch (PrinterException e) {
            throw new EmbossException("Problem sending emboss job to embosser device.", (Throwable)e);
        }
    }

    private final double mmToPt(double mm) {
        return mm * 72.0 / 25.4;
    }

    @NotNull
    public Optional<StreamPrintServiceFactory> getStreamPrintServiceFactory() {
        Optional<StreamPrintServiceFactory> optional;
        Intrinsics.checkNotNullExpressionValue((Object)this.streamPrintServiceFactories, (String)"streamPrintServiceFactories");
        if (!(((Object[])this.streamPrintServiceFactories).length == 0)) {
            Optional<StreamPrintServiceFactory> optional2 = Optional.of(this.streamPrintServiceFactories[0]);
            optional = optional2;
            Intrinsics.checkNotNullExpressionValue(optional2, (String)"of(streamPrintServiceFactories[0])");
        } else {
            Optional<StreamPrintServiceFactory> optional3 = Optional.empty();
            optional = optional3;
            Intrinsics.checkNotNullExpressionValue(optional3, (String)"empty()");
        }
        return optional;
    }

    @NotNull
    public String getId() {
        return this.id;
    }

    @NotNull
    public String getManufacturer() {
        return this.manufacturer;
    }

    @NotNull
    public String getModel() {
        return this.model;
    }

    private static final void embossPef$lambda$0(Document inputDoc, DocumentHandler handler) {
        Intrinsics.checkNotNullParameter((Object)inputDoc, (String)"inputDoc");
        Intrinsics.checkNotNullParameter((Object)handler, (String)"handler");
        new DocumentParser().parsePef(inputDoc, handler);
    }

    private static final void embossBrf$lambda$1(InputStream input, DocumentHandler handler) {
        Intrinsics.checkNotNullParameter((Object)input, (String)"input");
        Intrinsics.checkNotNullParameter((Object)handler, (String)"handler");
        new DocumentParser().parseBrf(input, handler);
    }

    private static final void emboss$lambda$2(List $events, DocumentEvent e) {
        Intrinsics.checkNotNullParameter((Object)$events, (String)"$events");
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        $events.add(e);
    }

    private static final boolean emboss$lambda$3(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final boolean emboss$lambda$4(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final Sides emboss$lambda$5(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Sides)$tmp0.invoke(p0);
    }

    private static final PageRanges emboss$lambda$6() {
        return new PageRanges();
    }

    private static final Integer emboss$lambda$7(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Integer)$tmp0.invoke(p0);
    }

    private static final void emboss$lambda$8(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke(p0);
    }

    private static final Rectangle emboss$lambda$9(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Rectangle)$tmp0.invoke(p0);
    }

    private static final void emboss$lambda$10(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke(p0);
    }

    private static final Margins emboss$lambda$11(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Margins)$tmp0.invoke(p0);
    }

    private static final void emboss$lambda$12(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke(p0);
    }

    public static final /* synthetic */ double access$mmToPt(BaseGraphicsEmbosser $this, double mm) {
        return $this.mmToPt(mm);
    }

    static {
        ImmutableSet immutableSet = ImmutableSet.of((Object)Sides.DUPLEX, (Object)Sides.TWO_SIDED_LONG_EDGE, (Object)Sides.TUMBLE, (Object)Sides.TWO_SIDED_SHORT_EDGE);
        Intrinsics.checkNotNullExpressionValue((Object)immutableSet, (String)"of(Sides.DUPLEX, Sides.T\u2026des.TWO_SIDED_SHORT_EDGE)");
        DOUBLE_SIDED_MODES = (Set)immutableSet;
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0017\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lorg/brailleblaster/libembosser/drivers/utils/BaseGraphicsEmbosser$Companion;", "", "()V", "DOUBLE_SIDED_MODES", "", "Ljavax/print/attribute/standard/Sides;", "getDOUBLE_SIDED_MODES", "()Ljava/util/Set;", "libembosser-core-drivers"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Set<Sides> getDOUBLE_SIDED_MODES() {
            return DOUBLE_SIDED_MODES;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

