/*
 * Decompiled with CFR 0.152.
 */
package net.miginfocom.swt;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.ObjectStreamException;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import net.miginfocom.layout.AC;
import net.miginfocom.layout.CC;
import net.miginfocom.layout.ComponentWrapper;
import net.miginfocom.layout.ConstraintParser;
import net.miginfocom.layout.ContainerWrapper;
import net.miginfocom.layout.Grid;
import net.miginfocom.layout.LC;
import net.miginfocom.layout.LayoutCallback;
import net.miginfocom.layout.LayoutUtil;
import net.miginfocom.layout.PlatformDefaults;
import net.miginfocom.swt.SwtComponentWrapper;
import net.miginfocom.swt.SwtContainerWrapper;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;

public final class MigLayout
extends Layout
implements Externalizable {
    private final Map<Control, Object> scrConstrMap = new IdentityHashMap<Control, Object>(8);
    private Object layoutConstraints = "";
    private Object colConstraints = "";
    private Object rowConstraints = "";
    private transient ContainerWrapper cacheParentW = null;
    private final transient Map<ComponentWrapper, CC> ccMap = new HashMap<ComponentWrapper, CC>(8);
    private transient LC lc = null;
    private transient AC colSpecs = null;
    private transient AC rowSpecs = null;
    private transient Grid grid = null;
    private transient Timer debugTimer = null;
    private transient long curDelay = -1L;
    private transient int lastModCount = PlatformDefaults.getModCount();
    private transient int lastHash = -1;
    private transient ArrayList<LayoutCallback> callbackList = null;

    public MigLayout() {
        this("", "", "");
    }

    public MigLayout(String layoutConstraints) {
        this(layoutConstraints, "", "");
    }

    public MigLayout(String layoutConstraints, String colConstraints) {
        this(layoutConstraints, colConstraints, "");
    }

    public MigLayout(String layoutConstraints, String colConstraints, String rowConstraints) {
        this.setLayoutConstraints(layoutConstraints);
        this.setColumnConstraints(colConstraints);
        this.setRowConstraints(rowConstraints);
    }

    public MigLayout(LC layoutConstraints) {
        this(layoutConstraints, null, null);
    }

    public MigLayout(LC layoutConstraints, AC colConstraints) {
        this(layoutConstraints, colConstraints, null);
    }

    public MigLayout(LC layoutConstraints, AC colConstraints, AC rowConstraints) {
        this.setLayoutConstraints(layoutConstraints);
        this.setColumnConstraints(colConstraints);
        this.setRowConstraints(rowConstraints);
    }

    public Object getLayoutConstraints() {
        return this.layoutConstraints;
    }

    public void setLayoutConstraints(Object s) {
        if (s == null || s instanceof String) {
            s = ConstraintParser.prepare((String)((String)s));
            this.lc = ConstraintParser.parseLayoutConstraint((String)((String)s));
        } else if (s instanceof LC) {
            this.lc = (LC)s;
        } else {
            throw new IllegalArgumentException("Illegal constraint type: " + s.getClass().toString());
        }
        this.layoutConstraints = s;
        this.grid = null;
    }

    public Object getColumnConstraints() {
        return this.colConstraints;
    }

    public void setColumnConstraints(Object constr) {
        if (constr == null || constr instanceof String) {
            constr = ConstraintParser.prepare((String)((String)constr));
            this.colSpecs = ConstraintParser.parseColumnConstraints((String)((String)constr));
        } else if (constr instanceof AC) {
            this.colSpecs = (AC)constr;
        } else {
            throw new IllegalArgumentException("Illegal constraint type: " + constr.getClass().toString());
        }
        this.colConstraints = constr;
        this.grid = null;
    }

    public Object getRowConstraints() {
        return this.rowConstraints;
    }

    public void setRowConstraints(Object constr) {
        if (constr == null || constr instanceof String) {
            constr = ConstraintParser.prepare((String)((String)constr));
            this.rowSpecs = ConstraintParser.parseRowConstraints((String)((String)constr));
        } else if (constr instanceof AC) {
            this.rowSpecs = (AC)constr;
        } else {
            throw new IllegalArgumentException("Illegal constraint type: " + constr.getClass().toString());
        }
        this.rowConstraints = constr;
        this.grid = null;
    }

    public Map<Control, Object> getConstraintMap() {
        return new IdentityHashMap<Control, Object>(this.scrConstrMap);
    }

    public void setConstraintMap(Map<Control, Object> map) {
        this.scrConstrMap.clear();
        this.ccMap.clear();
        for (Map.Entry<Control, Object> e : map.entrySet()) {
            this.setComponentConstraintsImpl(e.getKey(), e.getValue(), true);
        }
    }

    private void setComponentConstraintsImpl(Control comp, Object constr, boolean noCheck) {
        if (!noCheck && !this.scrConstrMap.containsKey(comp)) {
            throw new IllegalArgumentException("Component must already be added to parent!");
        }
        SwtComponentWrapper cw = new SwtComponentWrapper(comp);
        if (constr == null || constr instanceof String) {
            String cStr = ConstraintParser.prepare((String)((String)constr));
            this.scrConstrMap.put(comp, constr);
            this.ccMap.put(cw, ConstraintParser.parseComponentConstraint((String)cStr));
        } else if (constr instanceof CC) {
            this.scrConstrMap.put(comp, constr);
            this.ccMap.put(cw, (CC)constr);
        } else {
            throw new IllegalArgumentException("Constraint must be String or ComponentConstraint: " + constr.getClass().toString());
        }
        this.grid = null;
    }

    public boolean isManagingComponent(Control c) {
        return this.scrConstrMap.containsKey(c);
    }

    public void addLayoutCallback(LayoutCallback callback) {
        if (callback == null) {
            throw new NullPointerException();
        }
        if (this.callbackList == null) {
            this.callbackList = new ArrayList(1);
        }
        this.callbackList.add(callback);
    }

    public void removeLayoutCallback(LayoutCallback callback) {
        if (this.callbackList != null) {
            this.callbackList.remove(callback);
        }
    }

    private synchronized void setDebug(ComponentWrapper parentW, boolean b) {
        if (b && (this.debugTimer == null || this.curDelay != (long)this.getDebugMillis())) {
            Composite parent;
            if (this.debugTimer != null) {
                this.debugTimer.cancel();
            }
            this.debugTimer = new Timer(true);
            this.curDelay = this.getDebugMillis();
            this.debugTimer.schedule((TimerTask)new MyDebugRepaintTask(this), this.curDelay, this.curDelay);
            ContainerWrapper pCW = parentW.getParent();
            Composite composite = parent = pCW != null ? (Composite)pCW.getComponent() : null;
            if (parent != null) {
                parent.layout();
            }
        } else if (!b && this.debugTimer != null) {
            this.debugTimer.cancel();
            this.debugTimer = null;
        }
    }

    private boolean getDebug() {
        return this.debugTimer != null;
    }

    private int getDebugMillis() {
        int globalDebugMillis = LayoutUtil.getGlobalDebugMillis();
        return globalDebugMillis > 0 ? globalDebugMillis : this.lc.getDebugMillis();
    }

    private void checkCache(Composite parent) {
        if (parent == null) {
            return;
        }
        this.checkConstrMap(parent);
        ContainerWrapper par = this.checkParent(parent);
        int mc = PlatformDefaults.getModCount();
        if (this.lastModCount != mc) {
            this.grid = null;
            this.lastModCount = mc;
        }
        int hash = parent.getSize().hashCode();
        for (ComponentWrapper cw : this.ccMap.keySet()) {
            hash ^= cw.getLayoutHashCode();
            hash += 285134905;
        }
        if (hash != this.lastHash) {
            this.grid = null;
            this.lastHash = hash;
        }
        this.setDebug((ComponentWrapper)par, this.getDebugMillis() > 0);
        if (this.grid == null) {
            this.grid = new Grid(par, this.lc, this.rowSpecs, this.colSpecs, this.ccMap, this.callbackList);
        }
    }

    private void checkConstrMap(Composite parent) {
        Control[] children = parent.getChildren();
        HashSet<Control> parentCompSet = new HashSet<Control>(Arrays.asList(children));
        Iterator<Map.Entry<ComponentWrapper, CC>> ccIt = this.ccMap.entrySet().iterator();
        while (ccIt.hasNext()) {
            Control c = (Control)ccIt.next().getKey().getComponent();
            if (!c.isDisposed() && parentCompSet.contains(c)) continue;
            ccIt.remove();
            this.scrConstrMap.remove(c);
            this.grid = null;
        }
        for (Control child : children) {
            if (this.scrConstrMap.get(child) == child.getLayoutData()) continue;
            this.setComponentConstraintsImpl(child, child.getLayoutData(), true);
        }
    }

    private ContainerWrapper checkParent(Composite parent) {
        if (parent == null) {
            return null;
        }
        if (this.cacheParentW == null || this.cacheParentW.getComponent() != parent) {
            this.cacheParentW = new SwtContainerWrapper(parent);
        }
        return this.cacheParentW;
    }

    public float getLayoutAlignmentX(Composite parent) {
        return this.lc != null && this.lc.getAlignX() != null ? (float)this.lc.getAlignX().getPixels(1.0f, this.checkParent(parent), null) : 0.0f;
    }

    public float getLayoutAlignmentY(Composite parent) {
        return this.lc != null && this.lc.getAlignY() != null ? (float)this.lc.getAlignY().getPixels(1.0f, this.checkParent(parent), null) : 0.0f;
    }

    protected Point computeSize(Composite parent, int wHint, int hHint, boolean flushCache) {
        this.checkCache(parent);
        int w = LayoutUtil.getSizeSafe((int[])(this.grid != null ? this.grid.getWidth() : null), (int)1);
        int h = LayoutUtil.getSizeSafe((int[])(this.grid != null ? this.grid.getHeight() : null), (int)1);
        return new Point(w, h);
    }

    protected void layout(Composite parent, boolean flushCache) {
        if (flushCache) {
            this.grid = null;
        }
        this.checkCache(parent);
        Rectangle r = parent.getClientArea();
        int[] b = new int[]{r.x, r.y, r.width, r.height};
        boolean layoutAgain = this.grid.layout(b, this.lc.getAlignX(), this.lc.getAlignY(), this.getDebug());
        if (layoutAgain) {
            this.grid = null;
            this.checkCache(parent);
            this.grid.layout(b, this.lc.getAlignX(), this.lc.getAlignY(), this.getDebug());
        }
    }

    protected boolean flushCache(Control control) {
        this.grid = null;
        return true;
    }

    private Object readResolve() throws ObjectStreamException {
        return LayoutUtil.getSerializedObject((Object)this);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        LayoutUtil.setSerializedObject((Object)this, (Object)LayoutUtil.readAsXML((ObjectInput)in));
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        if (this.getClass() == MigLayout.class) {
            LayoutUtil.writeAsXML((ObjectOutput)out, (Object)this);
        }
    }

    private static class MyDebugRepaintTask
    extends TimerTask {
        private final WeakReference<MigLayout> layoutRef;

        private MyDebugRepaintTask(MigLayout layout) {
            this.layoutRef = new WeakReference<MigLayout>(layout);
        }

        @Override
        public void run() {
            final MigLayout layout = (MigLayout)this.layoutRef.get();
            if (layout != null && layout.grid != null) {
                Display.getDefault().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        if (layout.grid != null) {
                            layout.grid.paintDebug();
                        }
                    }
                });
            }
        }
    }
}

