/*
 * Decompiled with CFR 0.152.
 */
package net.miginfocom.swt;

import net.miginfocom.layout.ComponentWrapper;
import net.miginfocom.layout.ContainerWrapper;
import net.miginfocom.layout.PlatformDefaults;
import net.miginfocom.swt.SwtContainerWrapper;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.FontMetrics;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.List;
import org.eclipse.swt.widgets.ProgressBar;
import org.eclipse.swt.widgets.Scrollable;
import org.eclipse.swt.widgets.Slider;
import org.eclipse.swt.widgets.Spinner;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.Text;

public class SwtComponentWrapper
implements ComponentWrapper {
    private static Class<?> styledTextClz;
    private static Color DB_COMP_OUTLINE;
    private static boolean vp;
    private static boolean mz;
    private final Control c;
    private int compType = -1;

    public SwtComponentWrapper(Control c) {
        this.c = c;
    }

    public final int getBaseline(int width, int height) {
        return -1;
    }

    public final Object getComponent() {
        return this.c;
    }

    public final float getPixelUnitFactor(boolean isHor) {
        switch (PlatformDefaults.getLogicalPixelBase()) {
            case 100: {
                GC gc = new GC((Drawable)this.c);
                FontMetrics fm = gc.getFontMetrics();
                float f = isHor ? (float)fm.getAverageCharWidth() / 5.0f : (float)fm.getHeight() / 13.0f;
                gc.dispose();
                return f;
            }
            case 101: {
                Float s;
                Float f = s = isHor ? PlatformDefaults.getHorizontalScaleFactor() : PlatformDefaults.getVerticalScaleFactor();
                if (s != null) {
                    return s.floatValue();
                }
                return (float)(isHor ? this.getHorizontalScreenDPI() : this.getVerticalScreenDPI()) / (float)PlatformDefaults.getDefaultDPI();
            }
        }
        return 1.0f;
    }

    public final int getX() {
        return this.c.getLocation().x;
    }

    public final int getY() {
        return this.c.getLocation().y;
    }

    public final int getWidth() {
        return this.c.getSize().x;
    }

    public final int getHeight() {
        return this.c.getSize().y;
    }

    public final int getScreenLocationX() {
        return this.c.toDisplay((int)0, (int)0).x;
    }

    public final int getScreenLocationY() {
        return this.c.toDisplay((int)0, (int)0).y;
    }

    public final int getMinimumHeight(int sz) {
        return mz ? 0 : this.computeSize((boolean)false, (int)sz).y;
    }

    public final int getMinimumWidth(int sz) {
        return mz ? 0 : this.computeSize((boolean)true, (int)sz).x;
    }

    public final int getPreferredHeight(int sz) {
        return this.computeSize((boolean)false, (int)sz).y;
    }

    public final int getPreferredWidth(int sz) {
        return this.computeSize((boolean)true, (int)sz).x;
    }

    public final int getMaximumHeight(int sz) {
        return Integer.MAX_VALUE;
    }

    public final int getMaximumWidth(int sz) {
        return Integer.MAX_VALUE;
    }

    private Point computeSize(boolean hor, int sz) {
        int hHint;
        int wHint = hor ? -1 : sz;
        int n = hHint = !hor ? -1 : sz;
        if (wHint != -1 || hHint != -1) {
            int trim = 0;
            if (this.c instanceof Scrollable) {
                Rectangle rect = ((Scrollable)this.c).computeTrim(0, 0, 0, 0);
                trim = hor ? rect.width : rect.height;
            } else {
                trim = this.c.getBorderWidth() << 1;
            }
            if (wHint == -1) {
                hHint = Math.max(0, hHint - trim);
            } else {
                wHint = Math.max(0, wHint - trim);
            }
        }
        return this.c.computeSize(wHint, hHint);
    }

    public final ContainerWrapper getParent() {
        return new SwtContainerWrapper(this.c.getParent());
    }

    public int getHorizontalScreenDPI() {
        return PlatformDefaults.getDefaultDPI();
    }

    public int getVerticalScreenDPI() {
        return PlatformDefaults.getDefaultDPI();
    }

    public final int getScreenWidth() {
        return this.c.getDisplay().getBounds().width;
    }

    public final int getScreenHeight() {
        return this.c.getDisplay().getBounds().height;
    }

    public final boolean hasBaseline() {
        return false;
    }

    public final String getLinkId() {
        return null;
    }

    public final void setBounds(int x, int y, int width, int height) {
        this.c.setBounds(x, y, width, height);
    }

    public boolean isVisible() {
        return this.c.getVisible();
    }

    public final int[] getVisualPadding() {
        return null;
    }

    public static boolean isUseVisualPadding() {
        return vp;
    }

    public static void setUseVisualPadding(boolean b) {
        vp = b;
    }

    public static boolean isMinimumSizeZero() {
        return mz;
    }

    public static void setMinimumSizeZero(boolean b) {
        mz = b;
    }

    public int getLayoutHashCode() {
        String id;
        if (this.c.isDisposed()) {
            return -1;
        }
        Point sz = this.c.getSize();
        Point p = this.c.computeSize(-1, -1, false);
        int h = p.x + (p.y << 12) + (sz.x << 22) + (sz.y << 16);
        if (this.c.isVisible()) {
            h += 1324511;
        }
        if ((id = this.getLinkId()) != null) {
            h += id.hashCode();
        }
        return h;
    }

    public final void paintDebugOutline(boolean useVisaualPadding) {
        if (this.c.isDisposed()) {
            return;
        }
        GC gc = new GC((Drawable)this.c);
        gc.setLineJoin(1);
        gc.setLineCap(3);
        gc.setLineStyle(3);
        gc.setForeground(DB_COMP_OUTLINE);
        gc.drawRectangle(0, 0, this.getWidth() - 1, this.getHeight() - 1);
        gc.dispose();
    }

    public int getComponentType(boolean disregardScrollPane) {
        if (this.compType == -1) {
            this.compType = this.checkType();
        }
        return this.compType;
    }

    private static boolean isText(Control c) {
        return c instanceof Text || styledTextClz != null && styledTextClz.isInstance(c);
    }

    private int checkType() {
        int s = this.c.getStyle();
        if (SwtComponentWrapper.isText(this.c)) {
            return (s & 2) > 0 ? 4 : 3;
        }
        if (this.c instanceof Label) {
            return (s & 2) > 0 ? 18 : 2;
        }
        if (this.c instanceof Button) {
            if ((s & 0x20) > 0 || (s & 0x10) > 0) {
                return 16;
            }
            return 5;
        }
        if (this.c instanceof Canvas) {
            return 10;
        }
        if (this.c instanceof List) {
            return 6;
        }
        if (this.c instanceof Table) {
            return 7;
        }
        if (this.c instanceof Spinner) {
            return 13;
        }
        if (this.c instanceof ProgressBar) {
            return 14;
        }
        if (this.c instanceof Slider) {
            return 12;
        }
        if (this.c instanceof Composite) {
            return 1;
        }
        return 0;
    }

    public final int hashCode() {
        return this.c.hashCode();
    }

    public final boolean equals(Object o) {
        if (o == null || !(o instanceof ComponentWrapper)) {
            return false;
        }
        return this.getComponent().equals(((ComponentWrapper)o).getComponent());
    }

    public String toString() {
        return this.getClass().getSimpleName() + "{" + this.c + "}";
    }

    public int getContentBias() {
        return SwtComponentWrapper.isText(this.c) && (this.c.getStyle() & 2) > 0 ? 0 : -1;
    }

    static {
        try {
            styledTextClz = Class.forName("org.eclipse.swt.custom.StyledText");
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        DB_COMP_OUTLINE = new Color((Device)Display.getCurrent(), 0, 0, 200);
        vp = false;
        mz = false;
    }
}

