/*
 * Decompiled with CFR 0.152.
 */
package org.brailleblaster.libembosser.spi;

import java.math.BigDecimal;

public enum BrlCell {
    NLS(new BigDecimal("6.20"), new BigDecimal("10.00"), 6),
    CALIFORNIA_SIGN(new BigDecimal("7.60"), new BigDecimal("10.00"), 6),
    JUMBO(new BigDecimal("8.76"), new BigDecimal("12.70"), 6),
    ENHANCED_LINE_SPACING(new BigDecimal("6.10"), new BigDecimal("15.24"), 6),
    SMALL_ENGLISH(new BigDecimal("5.38"), new BigDecimal("8.46"), 6),
    MARBURG_MEDIUM(new BigDecimal("6.00"), new BigDecimal("10.00"), 6),
    UK(new BigDecimal("6.00"), new BigDecimal("10.00"), 6),
    AUSTRALIAN(new BigDecimal("6.00"), new BigDecimal("10.00"), 6);

    private BigDecimal width;
    private BigDecimal height;
    private int dots;

    private BrlCell(BigDecimal width, BigDecimal height, int dots) {
        this.width = width;
        this.height = height;
        this.dots = dots;
    }

    public BigDecimal getWidth() {
        return this.width;
    }

    public BigDecimal getHeight() {
        return this.height;
    }

    public int getDots() {
        return this.dots;
    }

    public int getCellsForWidth(BigDecimal width) {
        if (BigDecimal.ZERO.compareTo(width) > 0) {
            return 0;
        }
        return width.divideToIntegralValue(this.getWidth()).intValue();
    }

    public int getLinesForHeight(BigDecimal height) {
        return height.divideToIntegralValue(this.getHeight()).intValue();
    }

    public BigDecimal getWidthForCells(int cells) {
        return this.width.multiply(BigDecimal.valueOf(cells));
    }

    public BigDecimal getHeightForLines(int lines) {
        return this.height.multiply(BigDecimal.valueOf(lines));
    }
}

