/*
 * Decompiled with CFR 0.152.
 */
package org.brailleblaster.libembosser.spi;

import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Stream;
import javax.print.PrintService;
import javax.print.StreamPrintServiceFactory;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.brailleblaster.libembosser.spi.EmbossException;
import org.brailleblaster.libembosser.spi.EmbosserOption;
import org.brailleblaster.libembosser.spi.EmbossingAttributeSet;
import org.brailleblaster.libembosser.spi.IEmbosser;
import org.brailleblaster.libembosser.spi.Notification;
import org.brailleblaster.libembosser.spi.OptionIdentifier;
import org.brailleblaster.libembosser.spi.Rectangle;
import org.brailleblaster.libembosser.utils.PefUtils;
import org.jetbrains.annotations.NotNull;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;

public interface Embosser
extends IEmbosser {
    @Override
    @NotNull
    public String getId();

    @Override
    @NotNull
    public String getManufacturer();

    @Override
    @NotNull
    public String getModel();

    @Override
    public void embossPef(@NotNull PrintService var1, @NotNull Document var2, @NotNull EmbossingAttributeSet var3) throws EmbossException;

    @Override
    default public void embossPef(@NotNull PrintService embosserDevice, @NotNull InputStream pef, @NotNull EmbossingAttributeSet attributes) throws EmbossException {
        Document doc;
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        dbf.setNamespaceAware(true);
        try {
            DocumentBuilder db = dbf.newDocumentBuilder();
            doc = db.parse(pef);
        }
        catch (IOException | ParserConfigurationException | SAXException e) {
            throw new EmbossException("Problem parsing XML", e);
        }
        this.embossPef(embosserDevice, doc, attributes);
    }

    @Override
    default public void embossBrf(@NotNull PrintService embosserDevice, @NotNull InputStream brf, @NotNull EmbossingAttributeSet attributes) throws EmbossException {
        Document doc;
        try {
            doc = PefUtils.fromBrf((InputStream)brf, (String)"BrfEmboss", (int)40, (int)25, (boolean)false);
        }
        catch (IOException | ParserConfigurationException e) {
            throw new EmbossException("Unable to convert the BRF to PEF for embossing.", e);
        }
        this.embossPef(embosserDevice, doc, attributes);
    }

    @Override
    @NotNull
    public Rectangle getMaximumPaper();

    @Override
    @NotNull
    public Rectangle getMinimumPaper();

    @Override
    public boolean supportsInterpoint();

    @Override
    @NotNull
    public Optional<StreamPrintServiceFactory> getStreamPrintServiceFactory();

    @Deprecated
    default public Stream<Notification> checkPrerequisites() {
        return Stream.empty();
    }

    @NotNull
    default public Stream<Notification> checkEmboss(int cellsPerLine, int linesPerPage, EmbossingAttributeSet attributes) {
        return Stream.empty();
    }

    @NotNull
    default public Map<OptionIdentifier, EmbosserOption> getOptions() {
        return Collections.emptyMap();
    }

    @NotNull
    default public Embosser customize(@NotNull Map<OptionIdentifier, EmbosserOption> options) {
        return this;
    }
}

