/*
 * Decompiled with CFR 0.152.
 */
package org.brailleblaster.libembosser.spi;

import java.util.Arrays;
import java.util.Base64;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b6\u0018\u00002\u00020\u0001:\u0004\b\t\n\u000bB\u0007\b\u0004\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0007\u001a\u00020\u00002\u0006\u0010\u0003\u001a\u00020\u0004H&R\u0012\u0010\u0003\u001a\u00020\u0004X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006\u0082\u0001\u0004\f\r\u000e\u000f\u00a8\u0006\u0010"}, d2={"Lorg/brailleblaster/libembosser/spi/EmbosserOption;", "", "()V", "value", "", "getValue", "()Ljava/lang/String;", "copy", "BooleanOption", "ByteArrayOption", "IntOption", "StringOption", "Lorg/brailleblaster/libembosser/spi/EmbosserOption$BooleanOption;", "Lorg/brailleblaster/libembosser/spi/EmbosserOption$ByteArrayOption;", "Lorg/brailleblaster/libembosser/spi/EmbosserOption$IntOption;", "Lorg/brailleblaster/libembosser/spi/EmbosserOption$StringOption;", "libembosser-api"})
public abstract class EmbosserOption {
    private EmbosserOption() {
    }

    @NotNull
    public abstract String getValue();

    @NotNull
    public abstract EmbosserOption copy(@NotNull String var1);

    public /* synthetic */ EmbosserOption(DefaultConstructorMarker $constructor_marker) {
        this();
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0007\u0018\u00002\u00020\u0001B\u000f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004B\r\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u000e\u0010\f\u001a\u00020\u00002\u0006\u0010\u0002\u001a\u00020\u0006J\u0010\u0010\f\u001a\u00020\u00002\u0006\u0010\u0002\u001a\u00020\u0003H\u0016R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0014\u0010\u0002\u001a\u00020\u00038VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\r"}, d2={"Lorg/brailleblaster/libembosser/spi/EmbosserOption$BooleanOption;", "Lorg/brailleblaster/libembosser/spi/EmbosserOption;", "value", "", "(Ljava/lang/String;)V", "boolean", "", "(Z)V", "getBoolean", "()Z", "getValue", "()Ljava/lang/String;", "copy", "libembosser-api"})
    public static final class BooleanOption
    extends EmbosserOption {
        private final boolean boolean;

        public BooleanOption(boolean bl) {
            super(null);
            this.boolean = bl;
        }

        public final boolean getBoolean() {
            return this.boolean;
        }

        public BooleanOption(@NotNull String value) {
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            this(Boolean.parseBoolean(value));
        }

        @Override
        @NotNull
        public String getValue() {
            return String.valueOf(this.boolean);
        }

        @Override
        @NotNull
        public BooleanOption copy(@NotNull String value) {
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            return new BooleanOption(value);
        }

        @NotNull
        public final BooleanOption copy(boolean value) {
            return new BooleanOption(value);
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0002\u0010\u0005\n\u0002\b\u0007\u0018\u00002\u00020\u0001B\u000f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004B\u0011\u0012\n\u0010\u0005\u001a\u00020\u0006\"\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u000e\u0010\r\u001a\u00020\u00002\u0006\u0010\u0002\u001a\u00020\u0006J\u0010\u0010\r\u001a\u00020\u00002\u0006\u0010\u0002\u001a\u00020\u0003H\u0016R\u0013\u0010\u0005\u001a\u00020\u00068F\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0014\u0010\u0002\u001a\u00020\u00038VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u000e"}, d2={"Lorg/brailleblaster/libembosser/spi/EmbosserOption$ByteArrayOption;", "Lorg/brailleblaster/libembosser/spi/EmbosserOption;", "value", "", "(Ljava/lang/String;)V", "bytes", "", "", "([B)V", "getBytes", "()[B", "getValue", "()Ljava/lang/String;", "copy", "libembosser-api"})
    public static final class ByteArrayOption
    extends EmbosserOption {
        @NotNull
        private final byte[] bytes;

        public ByteArrayOption(byte ... bytes) {
            Intrinsics.checkNotNullParameter((Object)bytes, (String)"bytes");
            super(null);
            this.bytes = bytes;
        }

        public ByteArrayOption(@NotNull String value) {
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            byte[] byArray = Base64.getDecoder().decode(value);
            Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getDecoder().decode(value)");
            byte[] byArray2 = byArray;
            this(Arrays.copyOf(byArray2, byArray2.length));
        }

        @NotNull
        public final byte[] getBytes() {
            byte[] byArray = Arrays.copyOf(this.bytes, this.bytes.length);
            Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"copyOf(this, size)");
            return byArray;
        }

        @Override
        @NotNull
        public String getValue() {
            String string = Base64.getEncoder().encodeToString(this.getBytes());
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getEncoder().encodeToString(bytes)");
            return string;
        }

        @Override
        @NotNull
        public ByteArrayOption copy(@NotNull String value) {
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            return new ByteArrayOption(value);
        }

        @NotNull
        public final ByteArrayOption copy(@NotNull byte[] value) {
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            return new ByteArrayOption(Arrays.copyOf(value, value.length));
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0007\u001a\u00020\u00002\u0006\u0010\u0002\u001a\u00020\u0003H\u0016R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\b"}, d2={"Lorg/brailleblaster/libembosser/spi/EmbosserOption$StringOption;", "Lorg/brailleblaster/libembosser/spi/EmbosserOption;", "value", "", "(Ljava/lang/String;)V", "getValue", "()Ljava/lang/String;", "copy", "libembosser-api"})
    public static final class StringOption
    extends EmbosserOption {
        @NotNull
        private final String value;

        public StringOption(@NotNull String value) {
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            super(null);
            this.value = value;
        }

        @Override
        @NotNull
        public String getValue() {
            return this.value;
        }

        @Override
        @NotNull
        public StringOption copy(@NotNull String value) {
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            return new StringOption(value);
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0007\u0018\u00002\u00020\u0001B\u000f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004B\r\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u000e\u0010\f\u001a\u00020\u00002\u0006\u0010\u0002\u001a\u00020\u0006J\u0010\u0010\f\u001a\u00020\u00002\u0006\u0010\u0002\u001a\u00020\u0003H\u0016R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0014\u0010\u0002\u001a\u00020\u00038VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\r"}, d2={"Lorg/brailleblaster/libembosser/spi/EmbosserOption$IntOption;", "Lorg/brailleblaster/libembosser/spi/EmbosserOption;", "value", "", "(Ljava/lang/String;)V", "int", "", "(I)V", "getInt", "()I", "getValue", "()Ljava/lang/String;", "copy", "libembosser-api"})
    public static final class IntOption
    extends EmbosserOption {
        private final int int;

        public IntOption(int n) {
            super(null);
            this.int = n;
        }

        public final int getInt() {
            return this.int;
        }

        public IntOption(@NotNull String value) {
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            this(Integer.parseInt(value));
        }

        @Override
        @NotNull
        public String getValue() {
            return String.valueOf(this.int);
        }

        @Override
        @NotNull
        public IntOption copy(@NotNull String value) {
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            return new IntOption(value);
        }

        @NotNull
        public final IntOption copy(int value) {
            return new IntOption(value);
        }
    }
}

