/*
 * Decompiled with CFR 0.152.
 */
package org.brailleblaster.utils.xom;

import com.google.common.base.Preconditions;
import java.util.Deque;
import java.util.LinkedList;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import nu.xom.Comment;
import nu.xom.DocType;
import nu.xom.Document;
import nu.xom.Element;
import nu.xom.NoSuchChildException;
import nu.xom.Node;
import nu.xom.ProcessingInstruction;
import nu.xom.Text;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0002\n\u000bB\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t\u00a8\u0006\f"}, d2={"Lorg/brailleblaster/utils/xom/DocumentTraversal;", "", "<init>", "()V", "traverseDocument", "", "doc", "Lnu/xom/Document;", "handler", "Lorg/brailleblaster/utils/xom/DocumentTraversal$Handler;", "Handler", "PathElement", "xom-utils"})
@SourceDebugExtension(value={"SMAP\nDocumentTraversal.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DocumentTraversal.kt\norg/brailleblaster/utils/xom/DocumentTraversal\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,188:1\n1#2:189\n*E\n"})
public final class DocumentTraversal {
    @NotNull
    public static final DocumentTraversal INSTANCE = new DocumentTraversal();

    private DocumentTraversal() {
    }

    public final void traverseDocument(@NotNull Document doc, @NotNull Handler handler) {
        Intrinsics.checkNotNullParameter((Object)doc, (String)"doc");
        Intrinsics.checkNotNullParameter((Object)handler, (String)"handler");
        if (doc.getRootElement() == null) {
            String string = "Required value was null.";
            throw new IllegalArgumentException(string.toString());
        }
        handler.onStartDocument(doc);
        DocType docType = doc.getDocType();
        if (docType != null) {
            DocType it = docType;
            boolean bl = false;
            handler.onDocType(it);
        }
        Deque stack = new LinkedList();
        Element element = doc.getRootElement();
        Intrinsics.checkNotNullExpressionValue((Object)element, (String)"getRootElement(...)");
        PathElement curPath = new PathElement(element);
        while (true) {
            Element curElement = curPath.getElement();
            boolean descend = true;
            if (curPath.getCurIndex() == 0) {
                descend = handler.onStartElement(curElement);
                stack.push(curPath);
            }
            if (curPath.getCurIndex() >= curElement.getChildCount() || !descend) {
                handler.onEndElement(curElement);
                stack.pop();
                if ((PathElement)stack.peek() == null) break;
            } else {
                Node curNode = curPath.getCurChild();
                if (curNode instanceof Element) {
                    curPath = new PathElement((Element)curNode);
                    continue;
                }
                if (curNode instanceof Text) {
                    handler.onText((Text)curNode);
                } else if (curNode instanceof ProcessingInstruction) {
                    handler.onProcessingInstruction((ProcessingInstruction)curNode);
                } else if (curNode instanceof Comment) {
                    handler.onComment((Comment)curNode);
                } else {
                    handler.onUnknownNode(curNode);
                }
            }
            PathElement pathElement = curPath;
            pathElement.setCurIndex(pathElement.getCurIndex() + 1);
        }
        handler.onEndDocument(doc);
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\bf\u0018\u00002\u00020\u0001J\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0016J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u0004\u001a\u00020\u0005H\u0016J\u0010\u0010\b\u001a\u00020\u00072\u0006\u0010\t\u001a\u00020\nH\u0016J\u0010\u0010\u000b\u001a\u00020\u00072\u0006\u0010\t\u001a\u00020\nH\u0016J\u0010\u0010\f\u001a\u00020\u00072\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u0010\u0010\u000f\u001a\u00020\u00072\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\u0010\u0010\u0012\u001a\u00020\u00072\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J\u0010\u0010\u0015\u001a\u00020\u00072\u0006\u0010\u0016\u001a\u00020\u0017H\u0016J\u0010\u0010\u0018\u001a\u00020\u00072\u0006\u0010\u0019\u001a\u00020\u001aH\u0016\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\u001b\u00c0\u0006\u0001"}, d2={"Lorg/brailleblaster/utils/xom/DocumentTraversal$Handler;", "", "onStartElement", "", "e", "Lnu/xom/Element;", "onEndElement", "", "onStartDocument", "d", "Lnu/xom/Document;", "onEndDocument", "onText", "t", "Lnu/xom/Text;", "onDocType", "dt", "Lnu/xom/DocType;", "onProcessingInstruction", "pi", "Lnu/xom/ProcessingInstruction;", "onComment", "c", "Lnu/xom/Comment;", "onUnknownNode", "n", "Lnu/xom/Node;", "xom-utils"})
    public static interface Handler {
        default public boolean onStartElement(@NotNull Element e) {
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            return true;
        }

        default public void onEndElement(@NotNull Element e) {
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        }

        default public void onStartDocument(@NotNull Document d) {
            Intrinsics.checkNotNullParameter((Object)d, (String)"d");
        }

        default public void onEndDocument(@NotNull Document d) {
            Intrinsics.checkNotNullParameter((Object)d, (String)"d");
        }

        default public void onText(@NotNull Text t) {
            Intrinsics.checkNotNullParameter((Object)t, (String)"t");
        }

        default public void onDocType(@NotNull DocType dt) {
            Intrinsics.checkNotNullParameter((Object)dt, (String)"dt");
        }

        default public void onProcessingInstruction(@NotNull ProcessingInstruction pi) {
            Intrinsics.checkNotNullParameter((Object)pi, (String)"pi");
        }

        default public void onComment(@NotNull Comment c) {
            Intrinsics.checkNotNullParameter((Object)c, (String)"c");
        }

        default public void onUnknownNode(@NotNull Node n) {
            Intrinsics.checkNotNullParameter((Object)n, (String)"n");
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0006\u0010\u0013\u001a\u00020\u0014R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R$\u0010\n\u001a\u00020\t2\u0006\u0010\b\u001a\u00020\t@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000eR\u0011\u0010\u000f\u001a\u00020\u00108F\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012\u00a8\u0006\u0015"}, d2={"Lorg/brailleblaster/utils/xom/DocumentTraversal$PathElement;", "", "element", "Lnu/xom/Element;", "<init>", "(Lnu/xom/Element;)V", "getElement", "()Lnu/xom/Element;", "value", "", "curIndex", "getCurIndex", "()I", "setCurIndex", "(I)V", "curChild", "Lnu/xom/Node;", "getCurChild", "()Lnu/xom/Node;", "hasChildren", "", "xom-utils"})
    private static final class PathElement {
        @NotNull
        private final Element element;
        private int curIndex;

        public PathElement(@NotNull Element element) {
            Intrinsics.checkNotNullParameter((Object)element, (String)"element");
            this.element = element;
        }

        @NotNull
        public final Element getElement() {
            return this.element;
        }

        public final int getCurIndex() {
            return this.curIndex;
        }

        public final void setCurIndex(int value) {
            this.curIndex = Preconditions.checkPositionIndex((int)value, (int)this.element.getChildCount());
        }

        @NotNull
        public final Node getCurChild() {
            if (!this.hasChildren()) {
                throw new NoSuchChildException("Element is empty");
            }
            Node node = this.element.getChild(this.curIndex);
            Intrinsics.checkNotNullExpressionValue((Object)node, (String)"getChild(...)");
            return node;
        }

        public final boolean hasChildren() {
            return this.element.getChildCount() > 0;
        }
    }
}

