/*
 * Decompiled with CFR 0.152.
 */
package org.brailleblaster.utils.xom;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import nu.xom.Node;
import nu.xom.ParentNode;
import org.brailleblaster.utils.xom.NodeContext;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=2, xi=48, d1={"\u0000\u001a\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\"\u001d\u0010\u0000\u001a\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0004\u0010\u0005\"\u001d\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006\n"}, d2={"nodeContextLoader", "Lcom/google/common/cache/CacheLoader;", "Lnu/xom/Node;", "Lorg/brailleblaster/utils/xom/NodeContext;", "getNodeContextLoader", "()Lcom/google/common/cache/CacheLoader;", "nodeCache", "Lcom/google/common/cache/LoadingCache;", "getNodeCache", "()Lcom/google/common/cache/LoadingCache;", "xom-utils"})
public final class NodeContextKt {
    @NotNull
    private static final CacheLoader<Node, NodeContext> nodeContextLoader = (CacheLoader)new CacheLoader<Node, NodeContext>(){

        public NodeContext load(Node key) {
            Intrinsics.checkNotNullParameter((Object)key, (String)"key");
            ParentNode parentNode = key.getParent();
            NodeContext parent = null;
            int index = 0;
            if (parentNode != null) {
                parent = (NodeContext)NodeContextKt.getNodeCache().getUnchecked((Object)parentNode);
                index = parentNode.indexOf(key);
            } else {
                parent = null;
                index = -1;
            }
            return new NodeContext(key, parent, index);
        }
    };
    @NotNull
    private static final LoadingCache<Node, NodeContext> nodeCache;

    @NotNull
    public static final CacheLoader<Node, NodeContext> getNodeContextLoader() {
        return nodeContextLoader;
    }

    @NotNull
    public static final LoadingCache<Node, NodeContext> getNodeCache() {
        return nodeCache;
    }

    static {
        LoadingCache loadingCache = CacheBuilder.newBuilder().maximumSize(10000000L).build(nodeContextLoader);
        Intrinsics.checkNotNullExpressionValue((Object)loadingCache, (String)"build(...)");
        nodeCache = loadingCache;
    }
}

