/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jeuclid.converter;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import javax.xml.parsers.ParserConfigurationException;
import net.sourceforge.jeuclid.LayoutContext;
import net.sourceforge.jeuclid.MathMLParserSupport;
import net.sourceforge.jeuclid.context.LayoutContextImpl;
import net.sourceforge.jeuclid.converter.ConverterPlugin;
import net.sourceforge.jeuclid.converter.ConverterRegistry;
import net.sourceforge.jeuclid.layout.JEuclidView;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

public final class Converter {
    public static final String TYPE_SVG = "image/svg+xml";
    public static final String EXTENSION_SVG = "svg";
    private static final String UNSUPPORTED_OUTPUT_TYPE = "Unsupported output type: ";
    private static final int MAX_RGB_VALUE = 255;
    private static final Log LOGGER = LogFactory.getLog(Converter.class);

    protected Converter() {
    }

    public static Converter getInstance() {
        return SingletonHolder.INSTANCE;
    }

    @Deprecated
    public static Converter getConverter() {
        return Converter.getInstance();
    }

    public Dimension convert(File file, File file2, String string) throws IOException {
        LayoutContextImpl layoutContextImpl = new LayoutContextImpl(LayoutContextImpl.getDefaultLayoutContext());
        return this.convert(file, file2, string, (LayoutContext)layoutContextImpl);
    }

    public Dimension convert(File file, File file2, String string, LayoutContext layoutContext) throws IOException {
        try {
            Document document = MathMLParserSupport.parseFile(file);
            return this.convert((Node)document, file2, string, layoutContext);
        }
        catch (SAXException sAXException) {
            LOGGER.error((Object)("Failed to parse file:" + file), (Throwable)sAXException);
            return null;
        }
    }

    public Dimension convert(Node node, File file, String string, LayoutContext layoutContext) throws IOException {
        BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(Files.newOutputStream(file.toPath(), new OpenOption[0]));
        Dimension dimension = this.convert(node, (OutputStream)bufferedOutputStream, string, layoutContext);
        if (dimension == null) {
            if (!file.delete()) {
                LOGGER.debug((Object)("Could not delete " + file));
            }
        } else {
            try {
                ((OutputStream)bufferedOutputStream).close();
            }
            catch (IOException iOException) {
                LOGGER.debug((Object)iOException);
            }
        }
        return dimension;
    }

    public ConverterPlugin.DocumentWithDimension convert(Node node, String string, LayoutContext layoutContext) {
        ConverterPlugin converterPlugin = ConverterRegistry.getInstance().getConverter(string);
        ConverterPlugin.DocumentWithDimension documentWithDimension = null;
        if (converterPlugin != null) {
            documentWithDimension = converterPlugin.convert(node, layoutContext);
        }
        if (documentWithDimension == null) {
            LOGGER.fatal((Object)(UNSUPPORTED_OUTPUT_TYPE + string));
        }
        return documentWithDimension;
    }

    public Dimension convert(Node node, OutputStream outputStream, String string, LayoutContext layoutContext) throws IOException {
        ConverterPlugin converterPlugin = ConverterRegistry.getInstance().getConverter(string);
        Dimension dimension = null;
        if (converterPlugin == null) {
            LOGGER.fatal((Object)(UNSUPPORTED_OUTPUT_TYPE + string));
        } else {
            try {
                dimension = converterPlugin.convert(node, layoutContext, outputStream);
            }
            catch (IOException iOException) {
                LOGGER.fatal((Object)("Failed to process: " + iOException.getMessage()), (Throwable)iOException);
            }
        }
        return dimension;
    }

    public Dimension convert(String string, OutputStream outputStream, String string2, LayoutContext layoutContext) throws IOException {
        Dimension dimension = null;
        try {
            Document document = MathMLParserSupport.parseString(string);
            dimension = this.convert((Node)document, outputStream, string2, layoutContext);
        }
        catch (SAXException sAXException) {
            LOGGER.error((Object)("SAXException converting:" + string), (Throwable)sAXException);
            dimension = null;
        }
        catch (ParserConfigurationException parserConfigurationException) {
            LOGGER.error((Object)("ParserConfigurationException converting:" + string), (Throwable)parserConfigurationException);
            dimension = null;
        }
        return dimension;
    }

    public BufferedImage render(Node node, LayoutContext layoutContext) throws IOException {
        return this.render(node, layoutContext, 2);
    }

    public BufferedImage render(Node node, LayoutContext layoutContext, int n) throws IOException {
        BufferedImage bufferedImage = new BufferedImage(1, 1, n);
        Graphics2D graphics2D = (Graphics2D)((Image)bufferedImage).getGraphics();
        JEuclidView jEuclidView = new JEuclidView(node, layoutContext, graphics2D);
        int n2 = Math.max(1, (int)Math.ceil(jEuclidView.getWidth()));
        int n3 = (int)Math.ceil(jEuclidView.getAscentHeight());
        int n4 = Math.max(1, (int)Math.ceil(jEuclidView.getDescentHeight()) + n3);
        BufferedImage bufferedImage2 = new BufferedImage(n2, n4, n);
        Graphics2D graphics2D2 = bufferedImage2.createGraphics();
        Color color = bufferedImage2.getColorModel().hasAlpha() ? new Color(255, 255, 255, 0) : Color.WHITE;
        graphics2D2.setColor(color);
        graphics2D2.fillRect(0, 0, n2, n4);
        graphics2D2.setColor(Color.black);
        jEuclidView.draw(graphics2D2, 0.0f, n3);
        return bufferedImage2;
    }

    private static final class SingletonHolder {
        private static final Converter INSTANCE = new Converter();

        private SingletonHolder() {
        }
    }
}

