/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jeuclid.elements.presentation.general;

import java.awt.Color;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.geom.Path2D;
import java.util.List;
import net.sourceforge.jeuclid.LayoutContext;
import net.sourceforge.jeuclid.context.Parameter;
import net.sourceforge.jeuclid.elements.AbstractJEuclidElement;
import net.sourceforge.jeuclid.elements.support.GraphicsSupport;
import net.sourceforge.jeuclid.elements.support.attributes.AttributesHelper;
import net.sourceforge.jeuclid.layout.GraphicsObject;
import net.sourceforge.jeuclid.layout.LayoutInfo;
import net.sourceforge.jeuclid.layout.LayoutStage;
import net.sourceforge.jeuclid.layout.LayoutView;
import net.sourceforge.jeuclid.layout.LayoutableNode;
import net.sourceforge.jeuclid.layout.LineObject;
import net.sourceforge.jeuclid.layout.Path2DShapeObject;
import org.apache.batik.dom.AbstractDocument;
import org.w3c.dom.mathml.MathMLRadicalElement;

public abstract class AbstractRoot
extends AbstractJEuclidElement
implements MathMLRadicalElement {
    private static final String EXTRA_SPACE = "0.1ex";
    private static final String ROOT_WIDTH = "0.5em";
    private static final boolean USE_PATH = true;

    public AbstractRoot(String string, AbstractDocument abstractDocument) {
        super(string, abstractDocument);
    }

    protected abstract List<LayoutableNode> getContent();

    @Override
    protected void layoutStageInvariant(LayoutView layoutView, LayoutInfo layoutInfo, LayoutStage layoutStage, LayoutContext layoutContext) {
        Object object;
        float f;
        Graphics2D graphics2D = layoutView.getGraphics();
        LayoutContext layoutContext2 = this.applyLocalAttributesToContext(layoutContext);
        float f2 = this.getMiddleShift(graphics2D, layoutContext);
        float f3 = GraphicsSupport.lineWidth(layoutContext2);
        float f4 = AttributesHelper.convertSizeToPt(EXTRA_SPACE, layoutContext2, "");
        float f5 = AttributesHelper.convertSizeToPt(ROOT_WIDTH, layoutContext, "");
        Color color = (Color)layoutContext2.getParameter(Parameter.MATHCOLOR);
        float f6 = f3;
        LayoutableNode layoutableNode = (LayoutableNode)((Object)this.getIndex());
        List<GraphicsObject> list = layoutInfo.getGraphicObjects();
        list.clear();
        if (layoutableNode == null) {
            f = 0.0f;
        } else {
            LayoutInfo layoutInfo2 = layoutView.getInfo(layoutableNode);
            float f7 = f2 + f3 / 2.0f + f4 + layoutInfo2.getDescentHeight(layoutStage);
            layoutInfo2.moveTo(f6, -f7, layoutStage);
            list.add(new LineObject(f3, -f2, f6 += layoutInfo2.getWidth(layoutStage), -f2, f3, color));
            f = f7 + layoutInfo2.getAscentHeight(layoutStage);
        }
        float f8 = f6 += f5;
        FontMetrics fontMetrics = this.getFontMetrics(layoutView.getGraphics(), layoutContext2);
        float f9 = fontMetrics.getAscent();
        float f10 = fontMetrics.getDescent();
        for (LayoutableNode object22 : this.getContent()) {
            object = layoutView.getInfo(object22);
            object.moveTo(f6, 0.0f, layoutStage);
            f9 = Math.max(f9, object.getAscentHeight(layoutStage));
            f10 = Math.max(f10, object.getDescentHeight(layoutStage));
            f6 += object.getWidth(layoutStage);
        }
        float f11 = f9 + 2.0f * f4 + f3 / 2.0f;
        layoutInfo.setAscentHeight(Math.max(f11 + f3 / 2.0f, f), layoutStage);
        layoutInfo.setDescentHeight(f10 + f3 / 2.0f, layoutStage);
        layoutInfo.setHorizontalCenterOffset((f6 += 2.0f * f4) / 2.0f, layoutStage);
        layoutInfo.setWidth(f6 + f3, layoutStage);
        layoutInfo.setStretchAscent(f9);
        layoutInfo.setStretchDescent(f10);
        Path2D.Float float_ = new Path2D.Float();
        ((Path2D)float_).moveTo(f8 - f5, -f2);
        ((Path2D)float_).lineTo(f8 - f5 / 2.0f, f10);
        ((Path2D)float_).lineTo(f8, -f11);
        ((Path2D)float_).lineTo(f6, -f11);
        object = this.getMathAttribute("mathvariant");
        Path2DShapeObject.EdgeStyle edgeStyle = Path2DShapeObject.EdgeStyle.Miter;
        if ("script".equals(object)) {
            edgeStyle = Path2DShapeObject.EdgeStyle.Round;
        }
        list.add(new Path2DShapeObject(float_, f3, color, false, edgeStyle));
    }
}

