/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jeuclid.elements.presentation.general;

import net.sourceforge.jeuclid.LayoutContext;
import net.sourceforge.jeuclid.context.Display;
import net.sourceforge.jeuclid.context.Parameter;
import net.sourceforge.jeuclid.elements.presentation.AbstractContainer;
import net.sourceforge.jeuclid.elements.support.attributes.AttributesHelper;
import org.apache.batik.dom.AbstractDocument;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.w3c.dom.Node;
import org.w3c.dom.mathml.MathMLStyleElement;

public final class Mstyle
extends AbstractContainer
implements MathMLStyleElement {
    public static final String ATTR_SCRIPTMINSIZE = "scriptminsize";
    public static final String ATTR_SCRIPTLEVEL = "scriptlevel";
    public static final String ATTR_SCRIPTSIZEMULTIPLIER = "scriptsizemultiplier";
    public static final String ATTR_DISPLAYSTYLE = "displaystyle";
    public static final String ELEMENT = "mstyle";
    private static final Log LOGGER = LogFactory.getLog(Mstyle.class);
    private static final long serialVersionUID = 1L;

    public Mstyle(String string, AbstractDocument abstractDocument) {
        super(string, abstractDocument);
        this.setDefaultMathAttribute(ATTR_DISPLAYSTYLE, "");
    }

    protected Node newNode() {
        return new Mstyle(this.nodeName, this.ownerDocument);
    }

    @Override
    public String getScriptlevel() {
        return this.getMathAttribute(ATTR_SCRIPTLEVEL);
    }

    @Override
    public void setScriptlevel(String string) {
        this.setAttribute(ATTR_SCRIPTLEVEL, string);
    }

    @Override
    public String getScriptminsize() {
        return this.getMathAttribute(ATTR_SCRIPTMINSIZE);
    }

    @Override
    public void setScriptminsize(String string) {
        this.setAttribute(ATTR_SCRIPTMINSIZE, string);
    }

    @Override
    public LayoutContext getChildLayoutContext(int n, LayoutContext layoutContext) {
        return new StyleLayoutContext(layoutContext);
    }

    @Override
    public String getBackground() {
        return this.getMathbackground();
    }

    public String getColor() {
        return this.getMathcolor();
    }

    @Override
    public String getDisplaystyle() {
        return this.getMathAttribute(ATTR_DISPLAYSTYLE);
    }

    @Override
    public String getScriptsizemultiplier() {
        return this.getMathAttribute(ATTR_SCRIPTSIZEMULTIPLIER);
    }

    @Override
    public void setBackground(String string) {
        this.setMathbackground(string);
    }

    public void setColor(String string) {
        this.setMathcolor(string);
    }

    @Override
    public void setDisplaystyle(String string) {
        this.setAttribute(ATTR_DISPLAYSTYLE, string);
    }

    @Override
    public void setScriptsizemultiplier(String string) {
        this.setAttribute(ATTR_SCRIPTSIZEMULTIPLIER, string);
    }

    @Override
    public String getMediummathspace() {
        throw new UnsupportedOperationException();
    }

    @Override
    public String getNegativemediummathspace() {
        throw new UnsupportedOperationException();
    }

    @Override
    public String getNegativethickmathspace() {
        throw new UnsupportedOperationException();
    }

    @Override
    public String getNegativethinmathspace() {
        throw new UnsupportedOperationException();
    }

    @Override
    public String getNegativeverythickmathspace() {
        throw new UnsupportedOperationException();
    }

    @Override
    public String getNegativeverythinmathspace() {
        throw new UnsupportedOperationException();
    }

    @Override
    public String getNegativeveryverythickmathspace() {
        throw new UnsupportedOperationException();
    }

    @Override
    public String getNegativeveryverythinmathspace() {
        throw new UnsupportedOperationException();
    }

    @Override
    public String getThickmathspace() {
        throw new UnsupportedOperationException();
    }

    @Override
    public String getThinmathspace() {
        throw new UnsupportedOperationException();
    }

    @Override
    public String getVerythickmathspace() {
        throw new UnsupportedOperationException();
    }

    @Override
    public String getVerythinmathspace() {
        throw new UnsupportedOperationException();
    }

    @Override
    public String getVeryverythickmathspace() {
        throw new UnsupportedOperationException();
    }

    @Override
    public String getVeryverythinmathspace() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setMediummathspace(String string) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setNegativemediummathspace(String string) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setNegativethickmathspace(String string) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setNegativethinmathspace(String string) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setNegativeverythickmathspace(String string) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setNegativeverythinmathspace(String string) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setNegativeveryverythickmathspace(String string) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setNegativeveryverythinmathspace(String string) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setThickmathspace(String string) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setThinmathspace(String string) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setVerythickmathspace(String string) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setVerythinmathspace(String string) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setVeryverythickmathspace(String string) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setVeryverythinmathspace(String string) {
        throw new UnsupportedOperationException();
    }

    private class StyleLayoutContext
    implements LayoutContext {
        private final LayoutContext context;

        protected StyleLayoutContext(LayoutContext layoutContext) {
            this.context = layoutContext;
        }

        @Override
        public Object getParameter(Parameter parameter) {
            Object object = Mstyle.this.applyLocalAttributesToContext(this.context).getParameter(parameter);
            if (Parameter.DISPLAY.equals((Object)parameter)) {
                object = this.applyDisplay(object);
            } else if (Parameter.SCRIPTLEVEL.equals((Object)parameter)) {
                object = this.applyScriptlevel(object);
            } else if (Parameter.SCRIPTMINSIZE.equals((Object)parameter)) {
                object = this.applyScriptMinsize(object);
            }
            return object;
        }

        private Object applyScriptMinsize(Object object) {
            String string = Mstyle.this.getScriptminsize();
            if (string != null && !string.isEmpty()) {
                return Float.valueOf(AttributesHelper.convertSizeToPt(string, this.context, "pt"));
            }
            return object;
        }

        private Object applyScriptlevel(Object object) {
            Object object2 = object;
            String string = Mstyle.this.getScriptlevel();
            if (string == null) {
                string = "";
            }
            if (!(string = string.trim()).isEmpty()) {
                char c = string.charAt(0);
                boolean bl = false;
                if (c == '+') {
                    bl = true;
                    string = string.substring(1);
                } else if (c == '-') {
                    bl = true;
                }
                try {
                    int n = Integer.parseInt(string);
                    object2 = bl ? Integer.valueOf((Integer)object2 + n) : Integer.valueOf(n);
                }
                catch (NumberFormatException numberFormatException) {
                    LOGGER.warn((Object)("Error in scriptlevel attribute for mstyle: " + string));
                }
            }
            return object2;
        }

        private Object applyDisplay(Object object) {
            Object object2 = object;
            String string = Mstyle.this.getDisplaystyle();
            if ("true".equalsIgnoreCase(string)) {
                object2 = Display.BLOCK;
            }
            if ("false".equalsIgnoreCase(string)) {
                object2 = Display.INLINE;
            }
            return object2;
        }
    }
}

