/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jeuclid.elements.support.text;

import java.io.Serializable;
import net.sourceforge.jeuclid.elements.support.attributes.MathVariant;

public class CodePointAndVariant
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final int codePoint;
    private final MathVariant variant;

    public CodePointAndVariant(int n, MathVariant mathVariant) {
        assert (mathVariant != null);
        this.codePoint = n;
        this.variant = mathVariant;
    }

    public final int getCodePoint() {
        return this.codePoint;
    }

    public final MathVariant getVariant() {
        return this.variant;
    }

    public int hashCode() {
        int n = 1;
        n = 31 * n + this.codePoint;
        n = 31 * n + this.variant.hashCode();
        return n;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        CodePointAndVariant codePointAndVariant = (CodePointAndVariant)object;
        if (this.codePoint != codePointAndVariant.codePoint) {
            return false;
        }
        return !(this.variant == null ? codePointAndVariant.variant != null : !this.variant.equals(codePointAndVariant.variant));
    }

    public String toString() {
        return String.format("[0x%s %s]", Integer.toHexString(this.codePoint), this.variant.toString());
    }
}

