/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jeuclid.font;

import java.awt.Font;
import java.awt.FontFormatException;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.Set;
import net.sourceforge.jeuclid.font.DefaultFontFactory;

public abstract class FontFactory {
    private static final ThreadLocal<FontFactory> THREAD_FONT_FACTORY = ThreadLocal.withInitial(() -> null);
    public static final String SANSSERIF = "sansserif";
    private static FontFactory instance;

    public static void setThreadFontFactory(FontFactory fontFactory) {
        THREAD_FONT_FACTORY.set(fontFactory);
    }

    public static FontFactory getThreadFontFactory() {
        return THREAD_FONT_FACTORY.get();
    }

    public static void clearThreadFontFactory() {
        THREAD_FONT_FACTORY.remove();
    }

    public static FontFactory getInstance() {
        FontFactory fontFactory = FontFactory.getThreadFontFactory();
        if (fontFactory != null) {
            return fontFactory;
        }
        if (instance == null) {
            instance = new DefaultFontFactory();
        }
        return instance;
    }

    public abstract Font getFont(String var1, int var2, float var3);

    public abstract Font getFont(List<String> var1, int var2, int var3, float var4);

    public abstract Font registerFont(int var1, File var2) throws IOException, FontFormatException;

    public abstract Font registerFont(int var1, InputStream var2) throws IOException, FontFormatException;

    public abstract Set<String> listFontNames();
}

