/*
 * Decompiled with CFR 0.152.
 */
package org.brailleblaster.libembosser.drivers.braillo;

import com.google.common.base.Charsets;
import com.google.common.base.Preconditions;
import com.google.common.io.ByteSource;
import org.brailleblaster.libembosser.drivers.braillo.AbstractBrailloDocumentHandler;

public class Braillo270DocumentHandler
extends AbstractBrailloDocumentHandler {
    private ByteSource headerSource;

    private Braillo270DocumentHandler(Firmware firmware, int cellsPerLine, double sheetLength, int topMargin, int bottomMargin, int leftMargin, int rightMargin, boolean interpoint, boolean zfolding, int copies) {
        super(cellsPerLine, sheetLength, topMargin, bottomMargin, leftMargin, rightMargin, interpoint, copies);
        this.headerSource = firmware.getHeader(cellsPerLine, sheetLength, interpoint, zfolding);
    }

    @Override
    protected ByteSource getHeader() {
        return this.headerSource;
    }

    public static class Builder {
        private final Firmware firmware;
        private int cellsPerLine = 40;
        private double sheetLength = 11.0;
        private int leftMargin = 0;
        private int rightMargin = 0;
        private int topMargin = 0;
        private int bottomMargin = 0;
        private boolean interpoint = true;
        private boolean zfolding = false;
        private int copies = 1;

        public Builder(Firmware firmware) {
            this.firmware = firmware;
        }

        public Braillo270DocumentHandler build() {
            return new Braillo270DocumentHandler(this.firmware, this.cellsPerLine, this.sheetLength, this.topMargin, this.bottomMargin, this.leftMargin, this.rightMargin, this.interpoint, this.zfolding, this.copies);
        }

        public Builder setCopies(int copies) {
            Preconditions.checkArgument((copies > 0 ? 1 : 0) != 0);
            this.copies = copies;
            return this;
        }

        public Builder setCellsPerLine(int cellsPerLine) {
            Preconditions.checkArgument((27 <= cellsPerLine && cellsPerLine <= 42 ? 1 : 0) != 0, (String)"Cells per line invalid %s, valid range is 27 <= cells per line <= 42", (int)cellsPerLine);
            this.cellsPerLine = cellsPerLine;
            return this;
        }

        public Builder setSheetlength(double sheetLength) {
            Preconditions.checkArgument((boolean)this.firmware.isValidSheetLength(sheetLength), (String)"Sheet length invalid %s, valid range is %s < sheet length <= %s", (Object)sheetLength, (Object)this.firmware.getMinSheetLength(), (Object)this.firmware.getMaxSheetLength());
            this.sheetLength = sheetLength;
            return this;
        }

        public Builder setTopMargin(int topMargin) {
            this.topMargin = topMargin;
            return this;
        }

        public Builder setBottomMargin(int bottomMargin) {
            this.bottomMargin = bottomMargin;
            return this;
        }

        public Builder setLeftMargin(int leftMargin) {
            this.leftMargin = leftMargin;
            return this;
        }

        public Builder setRightMargin(int rightMargin) {
            this.rightMargin = rightMargin;
            return this;
        }

        public Builder setInterpoint(boolean interpoint) {
            this.interpoint = interpoint;
            return this;
        }

        public Builder setZFolding(boolean zfolding) {
            this.zfolding = zfolding;
            return this;
        }
    }

    public static enum Firmware {
        V1_11(9.5, 14.0){

            @Override
            public ByteSource getHeader(int cellsPerLine, double sheetLength, boolean interpoint, boolean zfolding) {
                String cells = Integer.toHexString(cellsPerLine - 27).toUpperCase();
                int sl = (int)Math.ceil(sheetLength * 2.0) - 20;
                return ByteSource.wrap((byte[])String.format("\u001bE\u001bA\u001b6\u001b\u001e%1d\u001b\u001f%s", sl, cells).getBytes(Charsets.US_ASCII));
            }
        }
        ,
        V12_16(3.5, 14.0){
            String[] lengths = new String[]{"0", "1", "1", "2", "2", "3", "3", "4", "4", "5", "5", "6", "7", "8", "9", "A", "B", "C", "D", "E", "F"};

            @Override
            public ByteSource getHeader(int cellsPerLine, double sheetLength, boolean interpoint, boolean zfolding) {
                String cells = Integer.toHexString(cellsPerLine - 27).toUpperCase();
                int sl = (int)Math.ceil(sheetLength * 2.0) - 8;
                return ByteSource.wrap((byte[])String.format("\u001bE\u001bA\u001b6\u001b\u001e%s\u001b\u001f%s\u001bS%s\u001bQ%s", this.lengths[sl], cells, Character.valueOf(interpoint ? (char)'1' : '0'), Character.valueOf(zfolding ? (char)'1' : '0')).getBytes(Charsets.US_ASCII));
            }
        };

        private final double minSheetLength;
        private final double maxSheetLength;

        private Firmware(double minSheet, double maxSheet) {
            this.minSheetLength = minSheet;
            this.maxSheetLength = maxSheet;
        }

        public abstract ByteSource getHeader(int var1, double var2, boolean var4, boolean var5);

        public boolean isValidSheetLength(double sheetLength) {
            return this.minSheetLength < sheetLength && sheetLength <= this.maxSheetLength;
        }

        public double getMinSheetLength() {
            return this.minSheetLength;
        }

        public double getMaxSheetLength() {
            return this.maxSheetLength;
        }
    }
}

