/*
 * Decompiled with CFR 0.152.
 */
package org.brailleblaster;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.brailleblaster.util.FileUtils;
import org.brailleblaster.utils.OS;
import org.brailleblaster.utils.Platform;
import org.brailleblaster.utils.PropertyFileManager;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0015\n\u0002\u0010\u000b\n\u0002\b\u000e\u0018\u00002\u00020\u0001B/\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u0012\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b\u00a2\u0006\u0004\b\n\u0010\u000bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0011\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\rR\u0011\u0010\u0013\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\rR\u0011\u0010\u0015\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u0011\u0010\u0018\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\rR\u0011\u0010\u001a\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\rR\u0011\u0010\u001c\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\rR\u0011\u0010\u001e\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001f\u0010\rR\u0011\u0010 \u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b!\u0010\rR\u0011\u0010\"\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b#\u0010\rR\u0014\u0010$\u001a\u00020%X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b&\u0010'R\u0011\u0010(\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b)\u0010\rR\u0011\u0010*\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b+\u0010\rR\u0011\u0010,\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b-\u0010.R\u0013\u0010/\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b0\u0010\rR\u0013\u00101\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b2\u0010\r\u00a8\u00063"}, d2={"Lorg/brailleblaster/BBIniImpl;", "", "bbDistPath", "Ljava/nio/file/Path;", "bbUserPath", "propManager", "Lorg/brailleblaster/utils/PropertyFileManager;", "debugArgs", "", "", "<init>", "(Ljava/nio/file/Path;Ljava/nio/file/Path;Lorg/brailleblaster/utils/PropertyFileManager;Ljava/util/List;)V", "getBbDistPath", "()Ljava/nio/file/Path;", "log", "Lorg/slf4j/Logger;", "nativePath", "nativeBinPath", "getNativeBinPath", "nativeLibraryPath", "getNativeLibraryPath", "nativeLibrarySuffix", "getNativeLibrarySuffix", "()Ljava/lang/String;", "programDataPath", "getProgramDataPath", "userProgramDataPath", "getUserProgramDataPath", "autoSavePath", "getAutoSavePath", "autoSaveCrashPath", "getAutoSaveCrashPath", "recentDocsPath", "getRecentDocsPath", "recentSaves", "getRecentSaves", "releaseBuild", "", "getReleaseBuild", "()Z", "helpDocsPath", "getHelpDocsPath", "logFilesPath", "getLogFilesPath", "propertyFileManager", "getPropertyFileManager", "()Lorg/brailleblaster/utils/PropertyFileManager;", "debugFilePath", "getDebugFilePath", "debugSavePath", "getDebugSavePath", "brailleblaster-core"})
public final class BBIniImpl {
    @NotNull
    private final Path bbDistPath;
    @NotNull
    private final Logger log;
    @NotNull
    private final Path nativePath;
    @NotNull
    private final Path nativeBinPath;
    @NotNull
    private final Path nativeLibraryPath;
    @NotNull
    private final String nativeLibrarySuffix;
    @NotNull
    private final Path programDataPath;
    @NotNull
    private final Path userProgramDataPath;
    @NotNull
    private final Path autoSavePath;
    @NotNull
    private final Path autoSaveCrashPath;
    @NotNull
    private final Path recentDocsPath;
    @NotNull
    private final Path recentSaves;
    private final boolean releaseBuild;
    @NotNull
    private final Path helpDocsPath;
    @NotNull
    private final Path logFilesPath;
    @NotNull
    private final PropertyFileManager propertyFileManager;
    @Nullable
    private final Path debugFilePath;
    @Nullable
    private final Path debugSavePath;

    /*
     * WARNING - void declaration
     */
    public BBIniImpl(@NotNull Path bbDistPath, @NotNull Path bbUserPath, @Nullable PropertyFileManager propManager, @NotNull List<String> debugArgs) {
        Path path;
        Path path2;
        Object dfp;
        Object object;
        Path p;
        BBIniImpl bBIniImpl;
        String[] it;
        Intrinsics.checkNotNullParameter((Object)bbDistPath, (String)"bbDistPath");
        Intrinsics.checkNotNullParameter((Object)bbUserPath, (String)"bbUserPath");
        Intrinsics.checkNotNullParameter(debugArgs, (String)"debugArgs");
        this.bbDistPath = bbDistPath;
        Logger logger = LoggerFactory.getLogger(this.getClass());
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getLogger(...)");
        this.log = logger;
        Object object2 = "native";
        String[] stringArray = new String[1];
        Intrinsics.checkNotNullExpressionValue((Object)(Platform.getOs() + "-" + Platform.getArch()).toLowerCase(Locale.ROOT), (String)"toLowerCase(...)");
        Path path3 = Paths.get((String)object2, Arrays.copyOf(stringArray, stringArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)path3, (String)"get(...)");
        Path path4 = this.bbDistPath.resolve(path3);
        Intrinsics.checkNotNullExpressionValue((Object)path4, (String)"resolve(...)");
        this.nativePath = path4;
        Path path5 = this.nativePath.resolve("bin");
        Intrinsics.checkNotNullExpressionValue((Object)path5, (String)"resolve(...)");
        this.nativeBinPath = path5;
        Path path6 = this.nativePath.resolve("lib");
        Intrinsics.checkNotNullExpressionValue((Object)path6, (String)"resolve(...)");
        this.nativeLibraryPath = path6;
        this.nativeLibrarySuffix = switch (WhenMappings.$EnumSwitchMapping$0[Platform.getOs().ordinal()]) {
            case 1 -> ".dll";
            case 2 -> ".dylib";
            default -> ".so";
        };
        Path path7 = this.bbDistPath.resolve("programData");
        Intrinsics.checkNotNullExpressionValue((Object)path7, (String)"resolve(...)");
        this.programDataPath = path7;
        object2 = bbUserPath.resolve("programData");
        stringArray = object2;
        BBIniImpl bBIniImpl2 = this;
        boolean bl = false;
        Intrinsics.checkNotNull((Object)it);
        LinkOption[] linkOptionArray = new LinkOption[]{};
        if (!Files.exists((Path)it, Arrays.copyOf(linkOptionArray, linkOptionArray.length))) {
            try {
                FileAttribute[] fileAttributeArray = new FileAttribute[]{};
                Intrinsics.checkNotNullExpressionValue((Object)Files.createDirectories((Path)it, Arrays.copyOf(fileAttributeArray, fileAttributeArray.length)), (String)"createDirectories(...)");
            }
            catch (IOException e) {
                this.log.warn("Unable to create user program data directory", (Throwable)e);
            }
        }
        Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"also(...)");
        bBIniImpl2.userProgramDataPath = object2;
        it = object2 = this.userProgramDataPath.resolve("autoSave");
        BBIniImpl bBIniImpl3 = this;
        boolean bl2 = false;
        Intrinsics.checkNotNull((Object)it);
        LinkOption[] linkOptionArray2 = new LinkOption[]{};
        if (!Files.exists((Path)it, Arrays.copyOf(linkOptionArray2, linkOptionArray2.length))) {
            try {
                FileAttribute[] fileAttributeArray = new FileAttribute[]{};
                Intrinsics.checkNotNullExpressionValue((Object)Files.createDirectories((Path)it, Arrays.copyOf(fileAttributeArray, fileAttributeArray.length)), (String)"createDirectories(...)");
            }
            catch (IOException e) {
                this.log.warn("Unable to create autosave directory", (Throwable)e);
            }
        }
        Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"also(...)");
        bBIniImpl3.autoSavePath = object2;
        Path path8 = this.autoSavePath.resolve("auto_save_error.txt");
        Intrinsics.checkNotNullExpressionValue((Object)path8, (String)"resolve(...)");
        this.autoSaveCrashPath = path8;
        it = object2 = this.userProgramDataPath.resolve("recent_documents.txt");
        BBIniImpl bBIniImpl4 = this;
        boolean bl3 = false;
        FileUtils.INSTANCE.create(it.toString());
        Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"also(...)");
        bBIniImpl4.recentDocsPath = object2;
        it = object2 = this.autoSavePath.resolve("recent_saves.txt");
        bBIniImpl4 = this;
        boolean bl4 = false;
        FileUtils.INSTANCE.create(it.toString());
        Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"also(...)");
        bBIniImpl4.recentSaves = object2;
        Path path9 = this.bbDistPath.resolve("docs");
        Intrinsics.checkNotNullExpressionValue((Object)path9, (String)"resolve(...)");
        this.helpDocsPath = path9;
        it = object2 = bbUserPath.resolve("log");
        bBIniImpl4 = this;
        boolean bl5 = false;
        Intrinsics.checkNotNull((Object)it);
        LinkOption[] linkOptionArray3 = new LinkOption[]{};
        if (!Files.exists((Path)it, Arrays.copyOf(linkOptionArray3, linkOptionArray3.length))) {
            try {
                FileAttribute[] fileAttributeArray = new FileAttribute[]{};
                Intrinsics.checkNotNullExpressionValue((Object)Files.createDirectories((Path)it, Arrays.copyOf(fileAttributeArray, fileAttributeArray.length)), (String)"createDirectories(...)");
            }
            catch (IOException e) {
                this.log.warn("Unable to create log directory", (Throwable)e);
            }
        }
        Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"also(...)");
        bBIniImpl4.logFilesPath = object2;
        BBIniImpl bBIniImpl5 = this;
        PropertyFileManager propertyFileManager = propManager;
        if (propertyFileManager == null) {
            void it2;
            Object object3 = "settings";
            object2 = new String[]{"user_settings.properties"};
            Path path10 = Paths.get((String)object3, Arrays.copyOf(object2, ((String[])object2).length));
            Intrinsics.checkNotNullExpressionValue((Object)path10, (String)"get(...)");
            object3 = this.userProgramDataPath.resolve(path10);
            object2 = object3;
            BBIniImpl bBIniImpl6 = bBIniImpl5;
            boolean bl6 = false;
            Intrinsics.checkNotNull((Object)it2);
            LinkOption[] linkOptionArray4 = new LinkOption[]{};
            if (!Files.exists((Path)it2, Arrays.copyOf(linkOptionArray4, linkOptionArray4.length))) {
                try {
                    FileAttribute[] fileAttributeArray = new FileAttribute[]{};
                    Intrinsics.checkNotNullExpressionValue((Object)Files.createFile((Path)it2, Arrays.copyOf(fileAttributeArray, fileAttributeArray.length)), (String)"createFile(...)");
                }
                catch (IOException e) {
                    throw new RuntimeException("Cannot create user settings at " + (Path)it2, e);
                }
            }
            bBIniImpl5 = bBIniImpl6;
            String string = object3.toString();
            propertyFileManager = new PropertyFileManager(string);
        }
        bBIniImpl5.propertyFileManager = propertyFileManager;
        BBIniImpl bBIniImpl7 = this;
        String string = (String)CollectionsKt.firstOrNull(debugArgs);
        if (string != null) {
            Object object4;
            String bl6 = string;
            bBIniImpl = bBIniImpl7;
            boolean bl7 = false;
            Path path11 = Paths.get((String)it3, new String[0]);
            Intrinsics.checkNotNullExpressionValue((Object)path11, (String)"get(...)");
            p = path11.toAbsolutePath();
            Intrinsics.checkNotNull((Object)p);
            LinkOption[] linkOptionArray5 = new LinkOption[]{};
            if (Files.exists(p, Arrays.copyOf(linkOptionArray5, linkOptionArray5.length))) {
                object4 = p;
            } else {
                object = "testFiles";
                String[] stringArray2 = new String[]{it3};
                Path path12 = Paths.get((String)object, Arrays.copyOf(stringArray2, stringArray2.length));
                Intrinsics.checkNotNullExpressionValue((Object)path12, (String)"get(...)");
                object = this.programDataPath.resolve(path12);
                dfp = object;
                boolean bl8 = false;
                Intrinsics.checkNotNull((Object)dfp);
                LinkOption[] linkOptionArray6 = new LinkOption[]{};
                if (!Files.exists((Path)dfp, Arrays.copyOf(linkOptionArray6, linkOptionArray6.length))) {
                    throw new RuntimeException("debug file " + (Path)dfp + " does not exist");
                }
                object4 = object;
            }
            path2 = object4;
            bBIniImpl7 = bBIniImpl;
        } else {
            path2 = null;
        }
        bBIniImpl7.debugFilePath = path2;
        BBIniImpl bBIniImpl8 = this;
        String string2 = (String)CollectionsKt.getOrNull(debugArgs, (int)1);
        if (string2 != null) {
            Object object5;
            String it3 = string2;
            bBIniImpl = bBIniImpl8;
            boolean bl9 = false;
            Path path13 = Paths.get(it3, new String[0]);
            Intrinsics.checkNotNullExpressionValue((Object)path13, (String)"get(...)");
            p = path13.toAbsolutePath();
            Intrinsics.checkNotNull((Object)p);
            LinkOption[] linkOptionArray7 = new LinkOption[]{};
            if (Files.exists(p, Arrays.copyOf(linkOptionArray7, linkOptionArray7.length))) {
                object5 = p;
            } else {
                object = "testFiles";
                dfp = new String[]{it3};
                Path path14 = Paths.get((String)object, Arrays.copyOf(dfp, ((String[])dfp).length));
                Intrinsics.checkNotNullExpressionValue((Object)path14, (String)"get(...)");
                object = this.programDataPath.resolve(path14);
                dfp = object;
                boolean bl10 = false;
                Intrinsics.checkNotNull((Object)dfp);
                LinkOption[] linkOptionArray8 = new LinkOption[]{};
                if (!Files.exists((Path)dfp, Arrays.copyOf(linkOptionArray8, linkOptionArray8.length))) {
                    throw new RuntimeException("debug file " + (Path)dfp + " does not exist");
                }
                object5 = object;
            }
            path = object5;
            bBIniImpl8 = bBIniImpl;
        } else {
            path = null;
        }
        bBIniImpl8.debugSavePath = path;
    }

    @NotNull
    public final Path getBbDistPath() {
        return this.bbDistPath;
    }

    @NotNull
    public final Path getNativeBinPath() {
        return this.nativeBinPath;
    }

    @NotNull
    public final Path getNativeLibraryPath() {
        return this.nativeLibraryPath;
    }

    @NotNull
    public final String getNativeLibrarySuffix() {
        return this.nativeLibrarySuffix;
    }

    @NotNull
    public final Path getProgramDataPath() {
        return this.programDataPath;
    }

    @NotNull
    public final Path getUserProgramDataPath() {
        return this.userProgramDataPath;
    }

    @NotNull
    public final Path getAutoSavePath() {
        return this.autoSavePath;
    }

    @NotNull
    public final Path getAutoSaveCrashPath() {
        return this.autoSaveCrashPath;
    }

    @NotNull
    public final Path getRecentDocsPath() {
        return this.recentDocsPath;
    }

    @NotNull
    public final Path getRecentSaves() {
        return this.recentSaves;
    }

    public final boolean getReleaseBuild() {
        return this.releaseBuild;
    }

    @NotNull
    public final Path getHelpDocsPath() {
        return this.helpDocsPath;
    }

    @NotNull
    public final Path getLogFilesPath() {
        return this.logFilesPath;
    }

    @NotNull
    public final PropertyFileManager getPropertyFileManager() {
        return this.propertyFileManager;
    }

    @Nullable
    public final Path getDebugFilePath() {
        return this.debugFilePath;
    }

    @Nullable
    public final Path getDebugSavePath() {
        return this.debugSavePath;
    }

    @Metadata(mv={2, 3, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[OS.values().length];
            try {
                nArray[OS.Windows.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[OS.Mac.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

