/*
 * Decompiled with CFR 0.152.
 */
package org.brailleblaster.archiver2;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileSystems;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.brailleblaster.BBIni;
import org.brailleblaster.archiver2.Archiver2;
import org.brailleblaster.archiver2.ArchiverFactory;
import org.brailleblaster.pandoc.FixImage;
import org.brailleblaster.pandoc.FixMathML;
import org.brailleblaster.pandoc.FixNestedList;
import org.brailleblaster.pandoc.Fixer;
import org.brailleblaster.util.PanDocKt;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J&\u0010\u000f\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\f0\u00102\u0006\u0010\u0011\u001a\u00020\f2\b\u0010\u0012\u001a\u0004\u0018\u00010\fH\u0002J\u0010\u0010\u0013\u001a\u00020\f2\u0006\u0010\u0011\u001a\u00020\fH\u0002R \u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\f0\u000bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u000e\u0010\u0014\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0016\u001a\n \u0018*\u0004\u0018\u00010\u00170\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lorg/brailleblaster/archiver2/PandocArchiverLoader;", "Lorg/brailleblaster/archiver2/ArchiverFactory$FileLoader;", "<init>", "()V", "tryLoad", "Lorg/brailleblaster/archiver2/Archiver2;", "file", "Ljava/nio/file/Path;", "fileData", "Lorg/brailleblaster/archiver2/ArchiverFactory$ParseData;", "extensionsAndDescription", "", "", "getExtensionsAndDescription", "()Ljava/util/Map;", "pandocImport", "Lkotlin/Pair;", "filename", "fromFormat", "checkFileEncoding", "PANDOCDIR", "PANDOCLUA", "log", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "brailleblaster-core"})
public final class PandocArchiverLoader
implements ArchiverFactory.FileLoader {
    @NotNull
    public static final PandocArchiverLoader INSTANCE = new PandocArchiverLoader();
    @NotNull
    private static final Map<String, String> extensionsAndDescription;
    @NotNull
    private static final String PANDOCDIR;
    @NotNull
    private static final String PANDOCLUA;
    private static final Logger log;

    private PandocArchiverLoader() {
    }

    @Override
    @NotNull
    public Archiver2 tryLoad(@NotNull Path file, @NotNull ArchiverFactory.ParseData fileData) throws Exception {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)fileData, (String)"fileData");
        Archiver2 archiver = null;
        String fromFormat = switch (WhenMappings.$EnumSwitchMapping$0[fileData.getType().ordinal()]) {
            case 1 -> "docx+styles+empty_paragraphs";
            case 2 -> "epub";
            case 3 -> "html+empty_paragraphs";
            case 4 -> "markdown";
            case 5 -> "odt";
            case 6 -> "latex";
            default -> null;
        };
        Pair<String, String> pair = this.pandocImport(((Object)file).toString(), fromFormat);
        String bbxFile = (String)pair.component1();
        String fileTabName = (String)pair.component2();
        Path newFilePath = FileSystems.getDefault().getPath(bbxFile, new String[0]);
        Intrinsics.checkNotNull((Object)newFilePath);
        archiver = ArchiverFactory.INSTANCE.load(newFilePath);
        archiver.setNewPath(Paths.get(fileTabName, new String[0]));
        archiver.setImportedFrom(file);
        return archiver;
    }

    @Override
    @NotNull
    public Map<String, String> getExtensionsAndDescription() {
        return extensionsAndDescription;
    }

    private final Pair<String, String> pandocImport(String filename, String fromFormat) throws Exception {
        File wrkDir = null;
        String outFilename = null;
        this.checkFileEncoding(filename);
        int dot = StringsKt.lastIndexOf$default((CharSequence)filename, (char)'.', (int)0, (boolean)false, (int)6, null);
        Object newFilename = dot > -1 ? StringsKt.take((String)filename, (int)dot) : filename;
        outFilename = newFilename;
        String fileTabName = (String)newFilename + ".bbz";
        newFilename = (String)newFilename + "-";
        try {
            wrkDir = new File(PANDOCLUA);
            File outFile = File.createTempFile("bb-" + outFilename + "-pandoc-err-", ".txt");
            outFile.deleteOnExit();
            File bbFile = File.createTempFile((String)newFilename, ".bbx");
            bbFile.deleteOnExit();
            String string = bbFile.getAbsolutePath();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getAbsolutePath(...)");
            newFilename = string;
            Object object = new String[]{PanDocKt.getPANDOC_CMD(), "--from=" + fromFormat, "--to=bbx.lua", "--output=" + bbFile.getAbsolutePath(), filename};
            ProcessBuilder pb = new ProcessBuilder((String[])object).directory(wrkDir).redirectError(ProcessBuilder.Redirect.INHERIT).redirectErrorStream(true).redirectOutput(outFile);
            Map<String, String> map = pb.environment();
            Intrinsics.checkNotNullExpressionValue(map, (String)"environment(...)");
            object = map;
            String string2 = "PANDOCCMD";
            String string3 = PanDocKt.getPANDOC_CMD();
            object.put(string2, string3);
            Object logStr = "\n***** PandocArchiverLoader *****\n";
            logStr = StringsKt.trimIndent((String)("\n                " + (String)logStr + pb.command() + "\n                \n                "));
            logStr = StringsKt.trimIndent((String)("\n                " + (String)logStr + "input file:" + filename + "\n                output file:" + (String)newFilename + "\n                \n                "));
            logStr = (String)logStr + "********************************\n";
            log.debug((String)logStr);
            Process proc = pb.start();
            int status = proc.waitFor();
            log.debug("***** pandoc done *****\n");
            if (status != 0) {
                log.error("pandocImport: unable to import file:" + filename + ", pandoc gave exit code " + status);
                proc.destroyForcibly();
                throw new Exception("pandocImport: unable to import file:" + filename);
            }
            FixNestedList fixNestedList = new FixNestedList();
            FixImage fixImage = new FixImage();
            FixMathML fixMath = new FixMathML();
            Fixer fixer = new Fixer((String)newFilename);
            fixer.addFixer(fixMath);
            fixer.addFixer(fixNestedList);
            fixer.addFixer(fixImage);
            fixer.processFixers();
        }
        catch (Exception ex) {
            StringWriter strWriter = new StringWriter();
            PrintWriter prWriter = new PrintWriter(strWriter);
            ex.printStackTrace(prWriter);
            log.debug("\n***** PandocArchiverLoader *****\n");
            log.debug(strWriter.toString());
            log.debug("\n********************************\n");
            prWriter.close();
            throw ex;
        }
        return TuplesKt.to((Object)newFilename, (Object)fileTabName);
    }

    private final String checkFileEncoding(String filename) throws Exception {
        String fname = filename;
        StringBuilder sb = new StringBuilder();
        char[] buffer = new char[4096];
        FileOutputStream fos = null;
        OutputStreamWriter osw = null;
        FileInputStream fis = new FileInputStream(fname);
        InputStreamReader isr = new InputStreamReader(fis);
        String defaultEncoding = isr.getEncoding();
        isr.close();
        if (!StringsKt.equals((String)defaultEncoding, (String)"utf-8", (boolean)true) && !StringsKt.endsWith$default((String)filename, (String)".epub", (boolean)false, (int)2, null)) {
            fis = new FileInputStream(filename);
            isr = new InputStreamReader((InputStream)fis, StandardCharsets.UTF_8);
            int stat = 0;
            while (isr.ready() && -1 < stat) {
                stat = isr.read(buffer, 0, 4096);
                if (stat <= 0) continue;
                StringBuilder stringBuilder = sb;
                int n = 0;
                Intrinsics.checkNotNullExpressionValue((Object)stringBuilder.append(buffer, n, stat - n), (String)"append(...)");
            }
            isr.close();
            Object prefix = "bbtemp-";
            String suffix = ".txt";
            int dot = StringsKt.lastIndexOf$default((CharSequence)filename, (String)".", (int)0, (boolean)false, (int)6, null);
            if (-1 < dot) {
                suffix = StringsKt.drop((String)filename, (int)dot);
                prefix = StringsKt.take((String)filename, (int)dot) + "-";
            }
            File tmpFile = File.createTempFile((String)prefix, suffix);
            tmpFile.deleteOnExit();
            fos = new FileOutputStream(tmpFile);
            osw = new OutputStreamWriter((OutputStream)fos, StandardCharsets.UTF_8);
            osw.write(sb.toString());
            osw.close();
            String string = tmpFile.getAbsolutePath();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getAbsolutePath(...)");
            fname = string;
        }
        return fname;
    }

    static {
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"*.docx", (Object)"Microsoft Word Files (*.docx)"), TuplesKt.to((Object)"*.epub", (Object)"Epub Books (*.epub)"), TuplesKt.to((Object)"*.htm", (Object)"HTML Files (*.htm)"), TuplesKt.to((Object)"*.html", (Object)"HTML Files (*.html)"), TuplesKt.to((Object)"*.xhtml;*.xhtm;*.xht", (Object)"XHTML Files (*.xhtml;*.xhtm;*.xht)"), TuplesKt.to((Object)"*.md", (Object)"Markdown Files (*.md)"), TuplesKt.to((Object)"*.odt", (Object)"Open Document Files (*.odt)"), TuplesKt.to((Object)"*.tex", (Object)"LaTeX files (*.tex)")};
        extensionsAndDescription = MapsKt.mapOf((Pair[])pairArray);
        Path path = BBIni.getProgramDataPath().resolve("pandoc");
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"resolve(...)");
        PANDOCDIR = ((Object)path.toAbsolutePath()).toString();
        PANDOCLUA = PANDOCDIR + "/lua";
        log = LoggerFactory.getLogger(PandocArchiverLoader.class);
    }

    @Metadata(mv={2, 3, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[ArchiverFactory.Types.values().length];
            try {
                nArray[ArchiverFactory.Types.DOCX.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ArchiverFactory.Types.EPUB.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ArchiverFactory.Types.HTML.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ArchiverFactory.Types.MD.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ArchiverFactory.Types.ODT.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ArchiverFactory.Types.TEX.ordinal()] = 6;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

