/*
 * Decompiled with CFR 0.152.
 */
package org.brailleblaster.bbx;

import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import nu.xom.Attribute;
import nu.xom.Document;
import nu.xom.Element;
import nu.xom.Node;
import nu.xom.ParentNode;
import org.brailleblaster.bbx.BBX;
import org.brailleblaster.bbx.BBXUtilsKt;
import org.brailleblaster.bbx.fixers.to3.ImageBlockToContainerImportFixer;
import org.brailleblaster.math.mathml.MathModuleUtils;
import org.brailleblaster.perspectives.braille.Manager;
import org.brailleblaster.settings.UTDManager;
import org.brailleblaster.utd.IStyle;
import org.brailleblaster.utd.exceptions.NodeException;
import org.brailleblaster.utd.internal.xml.FastXPath;
import org.brailleblaster.utd.internal.xml.XMLHandler;
import org.brailleblaster.utd.properties.EmphasisType;
import org.brailleblaster.utd.toc.TOCAttributes;
import org.brailleblaster.utd.utils.UTDHelper;
import org.brailleblaster.utd.utils.dom.BoxUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0017\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u00013B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0007J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\b\u001a\u00020\u000bH\u0007J\u0010\u0010\f\u001a\u00020\u000b2\u0006\u0010\b\u001a\u00020\tH\u0007J\u0016\u0010\r\u001a\u00020\u000b2\u0006\u0010\u000e\u001a\u00020\u000b2\u0006\u0010\u000f\u001a\u00020\u0010J\u0016\u0010\r\u001a\u00020\u000b2\u0006\u0010\u000e\u001a\u00020\u000b2\u0006\u0010\u0011\u001a\u00020\u0012J\u000e\u0010\u0013\u001a\u00020\u000b2\u0006\u0010\u000e\u001a\u00020\u000bJ\u0012\u0010\u0014\u001a\u00020\u00152\b\u0010\u0016\u001a\u0004\u0018\u00010\u0017H\u0002J\u0010\u0010\u0018\u001a\u0004\u0018\u00010\u00192\u0006\u0010\u001a\u001a\u00020\u001bJ\u000e\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001dJ\u000e\u0010\u001f\u001a\u00020\u001d2\u0006\u0010 \u001a\u00020\u001dJ\u000e\u0010!\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001dJ\u000e\u0010\"\u001a\u00020\u001d2\u0006\u0010#\u001a\u00020\u001dJ \u0010$\u001a\u00020\u00152\b\u0010%\u001a\u0004\u0018\u00010\u000b2\u0006\u0010&\u001a\u00020\u000b2\u0006\u0010\u000f\u001a\u00020\u0012J\u0012\u0010'\u001a\u0004\u0018\u00010\t2\u0006\u0010\b\u001a\u00020\tH\u0007J\u000e\u0010(\u001a\u00020\u001d2\u0006\u0010)\u001a\u00020\tJ\u0016\u0010*\u001a\u00020\t2\u0006\u0010+\u001a\u00020\t2\u0006\u0010,\u001a\u00020\tJ\u0010\u0010-\u001a\u0004\u0018\u00010\u001b2\u0006\u0010.\u001a\u00020\u0010J\u000e\u0010/\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tJ\u0010\u00100\u001a\u00020\u000b2\b\u00101\u001a\u0004\u0018\u00010\u001bJ\u0010\u00100\u001a\u00020\u000b2\u0006\u00102\u001a\u00020\u000bH\u0007R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00064"}, d2={"Lorg/brailleblaster/bbx/BBXUtils;", "", "<init>", "()V", "log", "Lorg/slf4j/Logger;", "isPageNumAncestor", "", "node", "Lnu/xom/Node;", "findBlockChild", "Lnu/xom/Element;", "findBlock", "stripStyle", "elementToStrip", "m", "Lorg/brailleblaster/perspectives/braille/Manager;", "utdMan", "Lorg/brailleblaster/settings/UTDManager;", "stripStyleExceptOverrideStyle", "detachAttribute", "", "attrib", "Lnu/xom/Attribute;", "parseListStyle", "Lorg/brailleblaster/bbx/BBXUtils$ListStyleData;", "styleName", "", "indentFromLevel", "", "level", "indentToLevel", "indent", "runoverFromLevel", "runoverToLevel", "runover", "checkListStyle", "listContainer", "startItem", "cleanupBlock", "getIndexInBlock", "n", "getCommonParent", "start", "end", "getDocumentTitle", "manager", "isUneditable", "wrapAsTransNote", "textToWrap", "element", "ListStyleData", "brailleblaster-core"})
@SourceDebugExtension(value={"SMAP\nBBXUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BBXUtils.kt\norg/brailleblaster/bbx/BBXUtils\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n*L\n1#1,393:1\n1#2:394\n184#3,2:395\n*S KotlinDebug\n*F\n+ 1 BBXUtils.kt\norg/brailleblaster/bbx/BBXUtils\n*L\n351#1:395,2\n*E\n"})
public final class BBXUtils {
    @NotNull
    public static final BBXUtils INSTANCE = new BBXUtils();
    @NotNull
    private static final Logger log;

    private BBXUtils() {
    }

    @JvmStatic
    public static final boolean isPageNumAncestor(@NotNull Node node) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        return BBXUtilsKt.isPageNumAncestor(node);
    }

    @JvmStatic
    @NotNull
    public static final Element findBlockChild(@NotNull Element node) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        return BBXUtilsKt.findBlockChild(node);
    }

    @JvmStatic
    @NotNull
    public static final Element findBlock(@NotNull Node node) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        return BBXUtilsKt.findBlock(node);
    }

    @NotNull
    public final Element stripStyle(@NotNull Element elementToStrip, @NotNull Manager m) {
        Intrinsics.checkNotNullParameter((Object)elementToStrip, (String)"elementToStrip");
        Intrinsics.checkNotNullParameter((Object)m, (String)"m");
        return this.stripStyle(elementToStrip, m.getDocument().getSettingsManager());
    }

    @NotNull
    public final Element stripStyle(@NotNull Element elementToStrip, @NotNull UTDManager utdMan) {
        Intrinsics.checkNotNullParameter((Object)elementToStrip, (String)"elementToStrip");
        Intrinsics.checkNotNullParameter((Object)utdMan, (String)"utdMan");
        this.stripStyleExceptOverrideStyle(elementToStrip);
        utdMan.removeOverrideStyle(elementToStrip);
        return elementToStrip;
    }

    @NotNull
    public final Element stripStyleExceptOverrideStyle(@NotNull Element elementToStrip) {
        Intrinsics.checkNotNullParameter((Object)elementToStrip, (String)"elementToStrip");
        this.detachAttribute(BBX.BLOCK.MARGIN.ATTRIB_INDENT.getAttribute(elementToStrip));
        this.detachAttribute(BBX.BLOCK.MARGIN.ATTRIB_RUNOVER.getAttribute(elementToStrip));
        this.detachAttribute(BBX.BLOCK.LIST_ITEM.ATTRIB_ITEM_LEVEL.getAttribute(elementToStrip));
        this.detachAttribute(TOCAttributes.TYPE.getAttribute(elementToStrip));
        return elementToStrip;
    }

    private final void detachAttribute(Attribute attrib) {
        block0: {
            Attribute attribute = attrib;
            if (attribute == null) break block0;
            attribute.detach();
        }
    }

    @Nullable
    public final ListStyleData parseListStyle(@NotNull String styleName) {
        Intrinsics.checkNotNullParameter((Object)styleName, (String)"styleName");
        BBX.ListType listType = null;
        BBX.MarginType marginType = null;
        switch (styleName.charAt(0)) {
            case 'L': {
                listType = BBX.ListType.NORMAL;
                marginType = null;
                break;
            }
            case 'G': {
                listType = BBX.ListType.DEFINITION;
                marginType = null;
                break;
            }
            case 'P': {
                listType = BBX.ListType.POEM;
                marginType = null;
                break;
            }
            case 'I': {
                listType = null;
                marginType = BBX.MarginType.INDEX;
                break;
            }
            case 'E': {
                listType = null;
                marginType = BBX.MarginType.EXERCISE;
                break;
            }
            case 'T': {
                listType = null;
                marginType = BBX.MarginType.TOC;
                break;
            }
            default: {
                boolean hasHyphen = false;
                char[] cArray = styleName.toCharArray();
                Intrinsics.checkNotNullExpressionValue((Object)cArray, (String)"toCharArray(...)");
                for (char c : cArray) {
                    if (c == '-') {
                        if (hasHyphen) {
                            return null;
                        }
                        hasHyphen = true;
                        continue;
                    }
                    if (Character.isDigit(c)) continue;
                    return null;
                }
                if (!hasHyphen) {
                    return null;
                }
                listType = null;
                marginType = BBX.MarginType.NUMERIC;
            }
        }
        String[] hasHyphen = new String[]{"-"};
        List args = StringsKt.split$default((CharSequence)styleName, (String[])hasHyphen, (boolean)false, (int)2, (int)2, null);
        if (args.size() != 2) {
            return null;
        }
        int indent = 0;
        int runover = 0;
        try {
            String string;
            if (marginType == BBX.MarginType.NUMERIC) {
                string = (String)args.get(0);
            } else {
                String string2 = ((String)args.get(0)).substring(1);
                string = string2;
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"substring(...)");
            }
            String firstNumber = string;
            indent = Integer.parseInt(firstNumber);
            runover = Integer.parseInt((String)args.get(1));
        }
        catch (Exception e) {
            log.trace("Unable to parse style {}", (Object)styleName, (Object)e);
            return null;
        }
        return new ListStyleData(listType, marginType, indent, runover);
    }

    public final int indentFromLevel(int level) {
        return level * 2 + 1;
    }

    public final int indentToLevel(int indent) {
        return (indent - 1) / 2;
    }

    public final int runoverFromLevel(int level) {
        return (level + 1) * 2 + 1;
    }

    public final int runoverToLevel(int runover) {
        return (runover - 1) / 2 - 1;
    }

    public final void checkListStyle(@Nullable Element listContainer, @NotNull Element startItem, @NotNull UTDManager m) {
        Node node;
        Intrinsics.checkNotNullParameter((Object)startItem, (String)"startItem");
        Intrinsics.checkNotNullParameter((Object)m, (String)"m");
        if (listContainer == null || !BBX.CONTAINER.LIST.isA((Node)listContainer)) {
            throw new NodeException("ListContainer must be a list, given ", (Node)listContainer, null, 4, null);
        }
        if (BBX.CONTAINER.isA((Node)startItem)) {
            return;
        }
        if (!BBX.BLOCK.isA((Node)startItem)) {
            throw new NodeException("startItem must be a block, given ", (Node)startItem, null, 4, null);
        }
        if (startItem.getParent() != listContainer) {
            return;
        }
        Iterator iterator = FastXPath.INSTANCE.followingAndSelf((Node)startItem).iterator();
        while (iterator.hasNext() && XMLHandler.Companion.ancestorElementIs(node = (Node)iterator.next(), arg_0 -> BBXUtils.checkListStyle$lambda$0(listContainer, arg_0))) {
            IStyle style;
            if (!BBX.BLOCK.isA(node) || (style = m.getEngine().getStyle(node)) == null) continue;
            style.getName();
            String string = style.getName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
            if (this.parseListStyle(string) != null) continue;
            Element listCopy = listContainer.copy();
            listCopy.removeChildren();
            int index = listContainer.indexOf(node);
            for (int i = index - 1; -1 < i; --i) {
                Node listItem = listContainer.getChild(i);
                listItem.detach();
                listCopy.insertChild(listItem, 0);
            }
            node.detach();
            listContainer.getParent().insertChild(node, listContainer.getParent().indexOf((Node)listContainer));
            if (listCopy.getChildCount() > 0) {
                node.getParent().insertChild((Node)listCopy, node.getParent().indexOf(node));
            }
            if (listContainer.getChildCount() != 0) continue;
            listContainer.detach();
        }
    }

    @JvmStatic
    @Nullable
    public static final Node cleanupBlock(@NotNull Node node) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        Element element = BBXUtilsKt.findBlockOrNull(node);
        if (element == null) {
            return null;
        }
        Element block = element;
        UTDHelper.stripUTDRecursive((Element)block);
        String string = block.getValue();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getValue(...)");
        if (((CharSequence)string).length() == 0) {
            Node parent = (Node)block.getParent();
            Element image = XMLHandler.Companion.childrenRecursiveVisitor(block, BBXUtils::cleanupBlock$lambda$0);
            if (image == null) {
                block.detach();
            } else {
                ImageBlockToContainerImportFixer.Companion.convertImageBlockToContainer(image);
            }
            while (parent != null) {
                if (BBX.CONTAINER.isA(parent)) {
                    if (BBX.CONTAINER.BOX.isA(parent)) {
                        Node node2 = parent.copy();
                        Intrinsics.checkNotNull((Object)node2, (String)"null cannot be cast to non-null type nu.xom.Element");
                        Element boxCopy = (Element)node2;
                        UTDHelper.stripUTDRecursive((Element)boxCopy);
                        String string2 = boxCopy.getValue();
                        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getValue(...)");
                        if (((CharSequence)string2).length() == 0) {
                            ParentNode parentNode = parent.getParent();
                            Intrinsics.checkNotNullExpressionValue((Object)parentNode, (String)"getParent(...)");
                            Node temp = (Node)parentNode;
                            BoxUtils.stripBoxBrl((Element)((Element)parent));
                            ((Element)parent).detach();
                            parent = temp;
                            continue;
                        }
                        return parent;
                    }
                    String string3 = parent.getValue();
                    Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"getValue(...)");
                    if (((CharSequence)string3).length() == 0 && XMLHandler.Companion.childrenRecursiveNodeVisitor(parent, BBXUtils::cleanupBlock$lambda$1) == null) {
                        ParentNode parentNode = parent.getParent();
                        Intrinsics.checkNotNullExpressionValue((Object)parentNode, (String)"getParent(...)");
                        Node temp = (Node)parentNode;
                        parent.detach();
                        parent = temp;
                        continue;
                    }
                    return parent;
                }
                return parent;
            }
            return null;
        }
        return (Node)block;
    }

    public final int getIndexInBlock(@NotNull Node n) {
        ParentNode block;
        Intrinsics.checkNotNullParameter((Object)n, (String)"n");
        Node parent = n;
        for (block = n.getParent(); block != null && !BBX.BLOCK.isA((Node)block); block = block.getParent()) {
            parent = (Node)block;
        }
        if (block == null) {
            boolean bl = false;
            String string = "Node is not in a block.";
            throw new IllegalArgumentException(string.toString());
        }
        return block.indexOf(parent);
    }

    @NotNull
    public final Node getCommonParent(@NotNull Node start, @NotNull Node end) {
        Intrinsics.checkNotNullParameter((Object)start, (String)"start");
        Intrinsics.checkNotNullParameter((Object)end, (String)"end");
        if (!Intrinsics.areEqual((Object)start.getParent(), (Object)end.getParent())) {
            Node node;
            Object v0;
            block4: {
                Sequence startAncestors = FastXPath.ancestor((Node)start);
                Sequence endAncestors = FastXPath.ancestor((Node)end);
                Sequence $this$firstOrNull$iv = startAncestors;
                boolean $i$f$firstOrNull = false;
                for (Object element$iv : $this$firstOrNull$iv) {
                    Element it = (Element)element$iv;
                    boolean bl = false;
                    if (!SequencesKt.contains((Sequence)endAncestors, (Object)it)) continue;
                    v0 = element$iv;
                    break block4;
                }
                v0 = null;
            }
            Element element = v0;
            if (element != null) {
                node = (Node)element;
            } else {
                ParentNode parentNode = start.getParent();
                Intrinsics.checkNotNullExpressionValue((Object)parentNode, (String)"getParent(...)");
                node = (Node)parentNode;
            }
            return node;
        }
        ParentNode parentNode = start.getParent();
        Intrinsics.checkNotNullExpressionValue((Object)parentNode, (String)"getParent(...)");
        return (Node)parentNode;
    }

    @Nullable
    public final String getDocumentTitle(@NotNull Manager manager) {
        Element title;
        Intrinsics.checkNotNullParameter((Object)manager, (String)"manager");
        Element head = UTDHelper.getDocumentHead((Document)manager.getDoc());
        if (head != null && (title = head.getFirstChildElement("doctitle")) != null) {
            return title.getValue();
        }
        return manager.getDocumentName();
    }

    public final boolean isUneditable(@NotNull Node node) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        return XMLHandler.Companion.ancestorVisitor(node, BBXUtils::isUneditable$lambda$0) != null || MathModuleUtils.isSpatialMath(node);
    }

    @NotNull
    public final Element wrapAsTransNote(@Nullable String textToWrap) {
        EmphasisType[] emphasisTypeArray = new EmphasisType[]{EmphasisType.TRANS_NOTE};
        Element transElement = BBX.INLINE.EMPHASIS.create(emphasisTypeArray);
        transElement.appendChild(textToWrap);
        Intrinsics.checkNotNull((Object)transElement);
        return transElement;
    }

    @JvmStatic
    @NotNull
    public static final Element wrapAsTransNote(@NotNull Element element) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Element newEl = INSTANCE.wrapAsTransNote(element.getValue());
        element.removeChildren();
        element.appendChild((Node)newEl);
        return element;
    }

    private static final boolean checkListStyle$lambda$0(Element $listContainer, Element e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        return e == $listContainer;
    }

    private static final boolean cleanupBlock$lambda$0(Element it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return BBX.SPAN.IMAGE.isA((Node)it);
    }

    private static final boolean cleanupBlock$lambda$1(Node it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return BBX.SPAN.IMAGE.isA(it);
    }

    private static final boolean isUneditable$lambda$0(Node it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return BBX.CONTAINER.TABLE.isA(it);
    }

    static {
        Logger logger = LoggerFactory.getLogger(BBXUtils.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getLogger(...)");
        log = logger;
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u000f\u0018\u00002\u00020\u0001B+\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\u0007\u00a2\u0006\u0004\b\t\u0010\nR\u0013\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\b\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0010R\u0011\u0010\u0012\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0010R\u0011\u0010\u0014\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0010\u00a8\u0006\u0016"}, d2={"Lorg/brailleblaster/bbx/BBXUtils$ListStyleData;", "", "listType", "Lorg/brailleblaster/bbx/BBX$ListType;", "marginType", "Lorg/brailleblaster/bbx/BBX$MarginType;", "indent", "", "runover", "<init>", "(Lorg/brailleblaster/bbx/BBX$ListType;Lorg/brailleblaster/bbx/BBX$MarginType;II)V", "getListType", "()Lorg/brailleblaster/bbx/BBX$ListType;", "getMarginType", "()Lorg/brailleblaster/bbx/BBX$MarginType;", "getIndent", "()I", "getRunover", "indentLevel", "getIndentLevel", "runoverLevel", "getRunoverLevel", "brailleblaster-core"})
    public static final class ListStyleData {
        @Nullable
        private final BBX.ListType listType;
        @Nullable
        private final BBX.MarginType marginType;
        private final int indent;
        private final int runover;
        private final int indentLevel;
        private final int runoverLevel;

        public ListStyleData(@Nullable BBX.ListType listType, @Nullable BBX.MarginType marginType, int indent, int runover) {
            this.listType = listType;
            this.marginType = marginType;
            this.indent = indent;
            this.runover = runover;
            this.indentLevel = INSTANCE.indentToLevel(this.indent);
            this.runoverLevel = INSTANCE.runoverToLevel(this.runover);
        }

        @Nullable
        public final BBX.ListType getListType() {
            return this.listType;
        }

        @Nullable
        public final BBX.MarginType getMarginType() {
            return this.marginType;
        }

        public final int getIndent() {
            return this.indent;
        }

        public final int getRunover() {
            return this.runover;
        }

        public final int getIndentLevel() {
            return this.indentLevel;
        }

        public final int getRunoverLevel() {
            return this.runoverLevel;
        }
    }
}

