/*
 * Decompiled with CFR 0.152.
 */
package org.brailleblaster.bbx.fixers;

import java.util.EnumSet;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import nu.xom.Comment;
import nu.xom.Element;
import nu.xom.Node;
import nu.xom.ParentNode;
import nu.xom.Text;
import org.brailleblaster.bbx.BBX;
import org.brailleblaster.bbx.BookToBBXConverter;
import org.brailleblaster.bbx.fixers.AbstractFixer;
import org.brailleblaster.utd.NamespaceMap;
import org.brailleblaster.utd.exceptions.NodeException;
import org.brailleblaster.utd.internal.xml.XMLHandler;
import org.brailleblaster.utd.matchers.INodeMatcher;
import org.brailleblaster.utd.properties.EmphasisType;
import org.brailleblaster.utils.xom.NodeUtilsKt;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 \r2\u00020\u0001:\u0002\f\rB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0018\u0010\b\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u0007H\u0002\u00a8\u0006\u000e"}, d2={"Lorg/brailleblaster/bbx/fixers/EmphasisImportFixer;", "Lorg/brailleblaster/bbx/fixers/AbstractFixer;", "<init>", "()V", "fix", "", "matchedNode", "Lnu/xom/Node;", "recursiveApplyEmphasis", "emphasisBeingUnwrapped", "Lnu/xom/Element;", "curNode", "HasElementChildrenMatcher", "Companion", "brailleblaster-core"})
public final class EmphasisImportFixer
extends AbstractFixer {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private static final Logger log = LoggerFactory.getLogger(EmphasisImportFixer.class);

    @Override
    public void fix(@NotNull Node matchedNode) {
        Intrinsics.checkNotNullParameter((Object)matchedNode, (String)"matchedNode");
        BBX.INLINE.EMPHASIS.assertIsA(matchedNode);
        Element emphasis = (Element)matchedNode;
        this.recursiveApplyEmphasis(emphasis, (Node)emphasis);
        XMLHandler.Companion.unwrapElement(emphasis);
    }

    private final void recursiveApplyEmphasis(Element emphasisBeingUnwrapped, Node curNode) {
        EnumSet emphasisBits = (EnumSet)BBX.INLINE.EMPHASIS.ATTRIB_EMPHASIS.get(emphasisBeingUnwrapped);
        if (curNode instanceof Text) {
            ParentNode parentNode = ((Text)curNode).getParent();
            Intrinsics.checkNotNull((Object)parentNode, (String)"null cannot be cast to non-null type nu.xom.Element");
            Element textParent = (Element)parentNode;
            if (BBX.INLINE.EMPHASIS.ATTRIB_EMPHASIS.has((Node)textParent) && textParent != emphasisBeingUnwrapped) {
                BBX.INLINE.EMPHASIS.ATTRIB_EMPHASIS.set(textParent, arg_0 -> EmphasisImportFixer.recursiveApplyEmphasis$lambda$0(emphasisBits, arg_0));
            } else {
                Element newInline = BBX.INLINE.EMPHASIS.create(emphasisBits);
                Intrinsics.checkNotNull((Object)newInline);
                XMLHandler.Companion.wrapNodeWithElement(curNode, newInline);
            }
        } else if (curNode instanceof Element) {
            for (Node curChild : NodeUtilsKt.getChildNodes((ParentNode)((ParentNode)curNode))) {
                if (BBX.INLINE.MATHML.isA(curChild)) {
                    BBX.EnumSetAttribute<EmphasisType> enumSetAttribute = BBX.INLINE.EMPHASIS.ATTRIB_EMPHASIS;
                    Intrinsics.checkNotNull((Object)curChild, (String)"null cannot be cast to non-null type nu.xom.Element");
                    enumSetAttribute.set((Element)curChild, emphasisBits);
                    continue;
                }
                this.recursiveApplyEmphasis(emphasisBeingUnwrapped, curChild);
            }
        } else if (!(curNode instanceof Comment)) {
            if (BookToBBXConverter.STRICT_MODE) {
                throw new NodeException("Unhandled node", curNode, null, 4, null);
            }
            log.warn("Unhandled node {}", (Object)XMLHandler.Companion.toXMLSimple(curNode));
        }
    }

    private static final EnumSet recursiveApplyEmphasis$lambda$0(EnumSet $emphasisBits, EnumSet types) {
        Intrinsics.checkNotNullParameter((Object)types, (String)"types");
        types.addAll($emphasisBits);
        return types;
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0016\u0010\u0004\u001a\n \u0006*\u0004\u0018\u00010\u00050\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lorg/brailleblaster/bbx/fixers/EmphasisImportFixer$Companion;", "", "<init>", "()V", "log", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "brailleblaster-core"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016\u00a8\u0006\n"}, d2={"Lorg/brailleblaster/bbx/fixers/EmphasisImportFixer$HasElementChildrenMatcher;", "Lorg/brailleblaster/utd/matchers/INodeMatcher;", "<init>", "()V", "isMatch", "", "node", "Lnu/xom/Node;", "namespaces", "Lorg/brailleblaster/utd/NamespaceMap;", "brailleblaster-core"})
    public static final class HasElementChildrenMatcher
    implements INodeMatcher {
        public boolean isMatch(@NotNull Node node, @NotNull NamespaceMap namespaces) {
            Intrinsics.checkNotNullParameter((Object)node, (String)"node");
            Intrinsics.checkNotNullParameter((Object)namespaces, (String)"namespaces");
            return !(node instanceof Element) ? false : ((Element)node).getChildElements().size() != 0;
        }
    }
}

