/*
 * Decompiled with CFR 0.152.
 */
package org.brailleblaster.bbx.fixers;

import jakarta.xml.bind.Unmarshaller;
import jakarta.xml.bind.annotation.XmlAttribute;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import nu.xom.Element;
import nu.xom.Node;
import nu.xom.Text;
import org.brailleblaster.bbx.BBX;
import org.brailleblaster.bbx.fixers.AbstractFixer;
import org.brailleblaster.utd.NamespaceMap;
import org.brailleblaster.utd.internal.xml.XMLHandler;
import org.brailleblaster.utd.matchers.INodeMatcher;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0003\u0018\u0000 \u00152\u00020\u0001:\u0002\u0014\u0015B\t\b\u0012\u00a2\u0006\u0004\b\u0002\u0010\u0003B'\b\u0016\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u0012\b\u0010\b\u001a\u0004\u0018\u00010\t\u00a2\u0006\u0004\b\u0002\u0010\nJ\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u001c\u0010\u000f\u001a\u00020\f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\u0013H\u0016R\u0012\u0010\u0004\u001a\u0004\u0018\u00010\u00058\u0002X\u0083\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0006\u001a\u0004\u0018\u00010\u00078\u0002X\u0083\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\b\u001a\u0004\u0018\u00010\t8\u0002X\u0083\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lorg/brailleblaster/bbx/fixers/FloatingTextImportFixer;", "Lorg/brailleblaster/bbx/fixers/AbstractFixer;", "<init>", "()V", "styleName", "", "blockType", "Lorg/brailleblaster/bbx/BBX$BlockSubType;", "spanType", "Lorg/brailleblaster/bbx/BBX$SpanSubType;", "(Ljava/lang/String;Lorg/brailleblaster/bbx/BBX$BlockSubType;Lorg/brailleblaster/bbx/BBX$SpanSubType;)V", "fix", "", "matchedNode", "Lnu/xom/Node;", "afterUnmarshal", "unmarshaller", "Ljakarta/xml/bind/Unmarshaller;", "parent", "", "Matcher", "Companion", "brailleblaster-core"})
@SourceDebugExtension(value={"SMAP\nFloatingTextImportFixer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FloatingTextImportFixer.kt\norg/brailleblaster/bbx/fixers/FloatingTextImportFixer\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,106:1\n1#2:107\n*E\n"})
public final class FloatingTextImportFixer
extends AbstractFixer {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @XmlAttribute
    @Nullable
    private final String styleName;
    @XmlAttribute
    @Nullable
    private final BBX.BlockSubType blockType;
    @XmlAttribute
    @Nullable
    private final BBX.SpanSubType spanType;
    private static final Logger log = LoggerFactory.getLogger(FloatingTextImportFixer.class);

    private FloatingTextImportFixer() {
        this.styleName = null;
        this.blockType = null;
        this.spanType = null;
    }

    public FloatingTextImportFixer(@Nullable String styleName, @Nullable BBX.BlockSubType blockType, @Nullable BBX.SpanSubType spanType) {
        this.styleName = styleName;
        this.blockType = blockType;
        this.spanType = spanType;
    }

    @Override
    public void fix(@NotNull Node matchedNode) {
        Element element;
        Intrinsics.checkNotNullParameter((Object)matchedNode, (String)"matchedNode");
        if (this.spanType != null) {
            var3_2 = this.spanType.create();
            Intrinsics.checkNotNull((Object)var3_2);
            element = var3_2;
        } else if (this.blockType != null) {
            var3_2 = this.blockType.create();
            Intrinsics.checkNotNull((Object)var3_2);
            element = var3_2;
        } else {
            var3_2 = BBX.BLOCK.STYLE.create(this.styleName);
            Intrinsics.checkNotNull((Object)var3_2);
            element = var3_2;
        }
        Element wrapperBlock = element;
        matchedNode.getParent().insertChild((Node)wrapperBlock, matchedNode.getParent().indexOf(matchedNode));
        log.trace("Starting with cursor {}", (Object)XMLHandler.Companion.toXMLSimple(matchedNode));
        Node cursor = matchedNode;
        while (cursor != null && Matcher.Companion.getINSTANCE().isMatch(cursor, new NamespaceMap())) {
            Node nextNode = XMLHandler.Companion.nextSiblingNode(cursor);
            cursor.detach();
            wrapperBlock.appendChild(cursor);
            cursor = nextNode;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void afterUnmarshal(@Nullable Unmarshaller unmarshaller, @Nullable Object parent) {
        if (this.spanType != null) {
            if (this.blockType != null) throw new RuntimeException("Cannot specify both spanType and blocktype or styleName");
            if (this.styleName == null) return;
            throw new RuntimeException("Cannot specify both spanType and blocktype or styleName");
        }
        if (!(this.blockType == null || this.styleName == null)) {
            boolean $i$a$-require-FloatingTextImportFixer$afterUnmarshal$32 = false;
            String $i$a$-require-FloatingTextImportFixer$afterUnmarshal$32 = "Cannot specify both style and block type";
            throw new IllegalArgumentException($i$a$-require-FloatingTextImportFixer$afterUnmarshal$32.toString());
        }
        if (this.blockType != null) return;
        String string = this.styleName;
        Intrinsics.checkNotNull((Object)string);
        if (((CharSequence)string).length() != 0) return;
        boolean bl = true;
        if (!bl) {
            return;
        }
        boolean bl2 = false;
        if (bl2) return;
        boolean bl3 = false;
        String string2 = "Missing styleName attribute ";
        throw new IllegalArgumentException(string2.toString());
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0016\u0010\u0004\u001a\n \u0006*\u0004\u0018\u00010\u00050\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lorg/brailleblaster/bbx/fixers/FloatingTextImportFixer$Companion;", "", "<init>", "()V", "log", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "brailleblaster-core"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \n2\u00020\u0001:\u0001\nB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016\u00a8\u0006\u000b"}, d2={"Lorg/brailleblaster/bbx/fixers/FloatingTextImportFixer$Matcher;", "Lorg/brailleblaster/utd/matchers/INodeMatcher;", "<init>", "()V", "isMatch", "", "node", "Lnu/xom/Node;", "namespaces", "Lorg/brailleblaster/utd/NamespaceMap;", "Companion", "brailleblaster-core"})
    public static final class Matcher
    implements INodeMatcher {
        @NotNull
        public static final Companion Companion = new Companion(null);
        @NotNull
        private static Matcher INSTANCE = new Matcher();

        public boolean isMatch(@NotNull Node node, @NotNull NamespaceMap namespaces) {
            Intrinsics.checkNotNullParameter((Object)node, (String)"node");
            Intrinsics.checkNotNullParameter((Object)namespaces, (String)"namespaces");
            return node instanceof Text || BBX.SPAN.isA(node) || BBX.INLINE.isA(node);
        }

        @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u001a\u0010\u0004\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\t\u00a8\u0006\n"}, d2={"Lorg/brailleblaster/bbx/fixers/FloatingTextImportFixer$Matcher$Companion;", "", "<init>", "()V", "INSTANCE", "Lorg/brailleblaster/bbx/fixers/FloatingTextImportFixer$Matcher;", "getINSTANCE", "()Lorg/brailleblaster/bbx/fixers/FloatingTextImportFixer$Matcher;", "setINSTANCE", "(Lorg/brailleblaster/bbx/fixers/FloatingTextImportFixer$Matcher;)V", "brailleblaster-core"})
        public static final class Companion {
            private Companion() {
            }

            @NotNull
            public final Matcher getINSTANCE() {
                return INSTANCE;
            }

            public final void setINSTANCE(@NotNull Matcher matcher) {
                Intrinsics.checkNotNullParameter((Object)matcher, (String)"<set-?>");
                INSTANCE = matcher;
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }
}

