/*
 * Decompiled with CFR 0.152.
 */
package org.brailleblaster.bbx.fixers;

import java.util.ArrayDeque;
import java.util.Deque;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import nu.xom.Element;
import nu.xom.Node;
import nu.xom.ParentNode;
import org.brailleblaster.bbx.BBX;
import org.brailleblaster.bbx.BookToBBXConverter;
import org.brailleblaster.bbx.fixers.AbstractFixer;
import org.brailleblaster.utd.exceptions.NodeException;
import org.brailleblaster.utd.internal.xml.XMLHandler;
import org.brailleblaster.utils.xom.NodeUtilsKt;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \b2\u00020\u0001:\u0001\bB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016\u00a8\u0006\t"}, d2={"Lorg/brailleblaster/bbx/fixers/ListLevelImportFixer;", "Lorg/brailleblaster/bbx/fixers/AbstractFixer;", "<init>", "()V", "fix", "", "matchedNode", "Lnu/xom/Node;", "Companion", "brailleblaster-core"})
public final class ListLevelImportFixer
extends AbstractFixer {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private static final Logger log = LoggerFactory.getLogger(ListLevelImportFixer.class);

    @Override
    public void fix(@NotNull Node matchedNode) {
        Intrinsics.checkNotNullParameter((Object)matchedNode, (String)"matchedNode");
        BBX.CONTAINER.LIST.assertIsA(matchedNode);
        Element listContainer = (Element)matchedNode;
        Deque childrenToProcess = new ArrayDeque();
        childrenToProcess.addAll(NodeUtilsKt.getChildNodes((ParentNode)((ParentNode)listContainer)));
        int maxLevel = 0;
        while (!childrenToProcess.isEmpty()) {
            Object e = childrenToProcess.pop();
            Element element = e instanceof Element ? (Element)e : null;
            if (element == null) continue;
            Element curChildNode = element;
            if (BBX.CONTAINER.isA((Node)curChildNode)) {
                childrenToProcess.addAll(NodeUtilsKt.getChildNodes((ParentNode)((ParentNode)curChildNode)));
                continue;
            }
            if (BBX.BLOCK.isA((Node)curChildNode)) {
                int curLevel = 0;
                if (BBX.BLOCK.LIST_ITEM.isA((Node)curChildNode)) {
                    Object t = BBX.BLOCK.LIST_ITEM.ATTRIB_ITEM_LEVEL.get(curChildNode);
                    Intrinsics.checkNotNullExpressionValue(t, (String)"get(...)");
                    curLevel = ((Number)t).intValue();
                } else if (BBX.CONTAINER.LIST.ATTRIB_LIST_TYPE.has((Node)curChildNode) && BBX.CONTAINER.LIST.ATTRIB_LIST_TYPE.get(curChildNode) == BBX.ListType.POEM_LINE_GROUP) {
                    Object t = BBX.CONTAINER.LIST.ATTRIB_LIST_LEVEL.get(curChildNode);
                    Intrinsics.checkNotNullExpressionValue(t, (String)"get(...)");
                    curLevel = ((Number)t).intValue();
                    BBX.CONTAINER.LIST.ATTRIB_LIST_LEVEL.detach(curChildNode);
                } else {
                    if (BookToBBXConverter.STRICT_MODE) {
                        throw new NodeException("Unhandled element", (Node)curChildNode, null, 4, null);
                    }
                    log.warn("Unhandled element {}", (Object)XMLHandler.Companion.toXMLSimple((Node)curChildNode));
                    curLevel = 0;
                }
                maxLevel = Math.max(maxLevel, curLevel);
                continue;
            }
            if (BookToBBXConverter.STRICT_MODE) {
                throw new NodeException("Unexpected list child", (Node)curChildNode, null, 4, null);
            }
            log.warn("Unexpected list child {}", (Object)XMLHandler.Companion.toXMLSimple((Node)curChildNode));
        }
        BBX.CONTAINER.LIST.ATTRIB_LIST_LEVEL.set(listContainer, maxLevel);
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0016\u0010\u0004\u001a\n \u0006*\u0004\u0018\u00010\u00050\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lorg/brailleblaster/bbx/fixers/ListLevelImportFixer$Companion;", "", "<init>", "()V", "log", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "brailleblaster-core"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

