/*
 * Decompiled with CFR 0.152.
 */
package org.brailleblaster.bbx.fixers;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import nu.xom.Element;
import nu.xom.Node;
import nu.xom.ParentNode;
import org.brailleblaster.bbx.BBX;
import org.brailleblaster.bbx.fixers.AbstractFixer;
import org.brailleblaster.utd.NamespaceMap;
import org.brailleblaster.utd.internal.xml.FastXPath;
import org.brailleblaster.utd.internal.xml.XMLHandler;
import org.brailleblaster.utd.matchers.INodeMatcher;
import org.brailleblaster.utils.xom.NodeUtilsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001\bB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016\u00a8\u0006\t"}, d2={"Lorg/brailleblaster/bbx/fixers/NestedListImportFixer;", "Lorg/brailleblaster/bbx/fixers/AbstractFixer;", "<init>", "()V", "fix", "", "matchedNode", "Lnu/xom/Node;", "NoDescendantListMatcher", "brailleblaster-core"})
public final class NestedListImportFixer
extends AbstractFixer {
    @Override
    public void fix(@NotNull Node matchedNode) {
        Intrinsics.checkNotNullParameter((Object)matchedNode, (String)"matchedNode");
        BBX.CONTAINER.LIST.assertIsA(matchedNode);
        Element nestedList = (Element)matchedNode;
        for (Node curChild : NodeUtilsKt.getChildNodes((ParentNode)((ParentNode)nestedList))) {
            if (!BBX.BLOCK.LIST_ITEM.isA(curChild)) continue;
            BBX.IntAttribute intAttribute = BBX.BLOCK.LIST_ITEM.ATTRIB_ITEM_LEVEL;
            Intrinsics.checkNotNull((Object)curChild, (String)"null cannot be cast to non-null type nu.xom.Element");
            intAttribute.set((Element)curChild, NestedListImportFixer::fix$lambda$0);
        }
        ParentNode parentNode = nestedList.getParent();
        Intrinsics.checkNotNull((Object)parentNode, (String)"null cannot be cast to non-null type nu.xom.Element");
        Element parentList = (Element)parentNode;
        BBX.CONTAINER.LIST.assertIsA((Node)parentList);
        XMLHandler.Companion.unwrapElement(nestedList);
    }

    private static final Integer fix$lambda$0(int level) {
        return level + 1;
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016\u00a8\u0006\n"}, d2={"Lorg/brailleblaster/bbx/fixers/NestedListImportFixer$NoDescendantListMatcher;", "Lorg/brailleblaster/utd/matchers/INodeMatcher;", "<init>", "()V", "isMatch", "", "node", "Lnu/xom/Node;", "namespaces", "Lorg/brailleblaster/utd/NamespaceMap;", "brailleblaster-core"})
    @SourceDebugExtension(value={"SMAP\nNestedListImportFixer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 NestedListImportFixer.kt\norg/brailleblaster/bbx/fixers/NestedListImportFixer$NoDescendantListMatcher\n+ 2 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n*L\n1#1,57:1\n1276#2,2:58\n*S KotlinDebug\n*F\n+ 1 NestedListImportFixer.kt\norg/brailleblaster/bbx/fixers/NestedListImportFixer$NoDescendantListMatcher\n*L\n54#1:58,2\n*E\n"})
    public static final class NoDescendantListMatcher
    implements INodeMatcher {
        /*
         * WARNING - void declaration
         */
        public boolean isMatch(@NotNull Node node, @NotNull NamespaceMap namespaces) {
            boolean bl;
            block2: {
                void $this$any$iv;
                Intrinsics.checkNotNullParameter((Object)node, (String)"node");
                Intrinsics.checkNotNullParameter((Object)namespaces, (String)"namespaces");
                if (!BBX.CONTAINER.LIST.isA(node)) {
                    return false;
                }
                Element nestedList = (Element)node;
                Sequence sequence = FastXPath.descendant((Node)((Node)nestedList));
                boolean $i$f$any = false;
                for (Object element$iv : $this$any$iv) {
                    Node it = (Node)element$iv;
                    boolean bl2 = false;
                    if (!BBX.CONTAINER.LIST.isA(it)) continue;
                    bl = true;
                    break block2;
                }
                bl = false;
            }
            return bl;
        }
    }
}

