/*
 * Decompiled with CFR 0.152.
 */
package org.brailleblaster.bbx.fixers;

import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import nu.xom.Attribute;
import nu.xom.Element;
import nu.xom.Node;
import nu.xom.ParentNode;
import org.brailleblaster.utd.exceptions.NodeException;
import org.brailleblaster.utd.internal.xml.FastXPath;
import org.brailleblaster.utd.internal.xml.XMLHandler;
import org.brailleblaster.utd.internal.xml.XMLHandlerKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001e\u0010\u0007\u001a\u0004\u0018\u00010\b2\b\u0010\t\u001a\u0004\u0018\u00010\b2\b\u0010\n\u001a\u0004\u0018\u00010\u000bH\u0007R\u0016\u0010\u0004\u001a\n \u0006*\u0004\u0018\u00010\u00050\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lorg/brailleblaster/bbx/fixers/NodeTreeSplitter;", "", "<init>", "()V", "log", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "split", "Lnu/xom/Element;", "root", "splitAt", "Lnu/xom/Node;", "brailleblaster-core"})
@SourceDebugExtension(value={"SMAP\nNodeTreeSplitter.kt\nKotlin\n*S Kotlin\n*F\n+ 1 NodeTreeSplitter.kt\norg/brailleblaster/bbx/fixers/NodeTreeSplitter\n+ 2 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n*L\n1#1,160:1\n2296#2,2:161\n*S KotlinDebug\n*F\n+ 1 NodeTreeSplitter.kt\norg/brailleblaster/bbx/fixers/NodeTreeSplitter\n*L\n64#1:161,2\n*E\n"})
public final class NodeTreeSplitter {
    @NotNull
    public static final NodeTreeSplitter INSTANCE = new NodeTreeSplitter();
    private static final Logger log = LoggerFactory.getLogger(NodeTreeSplitter.class);

    private NodeTreeSplitter() {
    }

    @JvmStatic
    @Nullable
    public static final Element split(@Nullable Element root, @Nullable Node splitAt) {
        boolean bl;
        Object[] node;
        block19: {
            if (root == null) {
                throw new NullPointerException("oldRootElement");
            }
            if (splitAt == null) {
                throw new NullPointerException("oldTrigger");
            }
            if (root == splitAt) {
                log.error("root " + XMLHandler.Companion.toXMLSimple((Node)root));
                log.error("splitAt " + XMLHandler.Companion.toXMLSimple(splitAt));
                throw new NodeException("root == splitAt, splitAt: ", splitAt, null, 4, null);
            }
            Sequence $this$none$iv = FastXPath.descendant((Node)((Node)root));
            boolean $i$f$none = false;
            for (Object element$iv : $this$none$iv) {
                node = (Object[])element$iv;
                boolean bl2 = false;
                if (!(node == splitAt)) continue;
                bl = false;
                break block19;
            }
            bl = true;
        }
        if (bl) {
            root.addAttribute(new Attribute("root", "this"));
            throw new NodeException("SplitAt isn't under elem w/ root=this attrub", splitAt, null, 4, null);
        }
        Node splitCursor = splitAt;
        ParentNode parentNode = splitAt.getParent();
        Intrinsics.checkNotNull((Object)parentNode, (String)"null cannot be cast to non-null type nu.xom.Element");
        Element parent = (Element)parentNode;
        int splitStart = 0;
        Element newRoot = null;
        while (splitCursor != root) {
            log.trace("cursor " + XMLHandler.Companion.toXMLSimple(splitCursor) + " parent " + XMLHandler.Companion.toXMLSimple((Node)parent));
            splitStart = parent.indexOf(splitCursor) + 1;
            node = new Object[]{parent.indexOf(splitCursor), splitStart, parent.getChildCount()};
            log.trace("index {} splitStart {} parent.children {}", node);
            if (splitStart == -1) {
                throw new NodeException("index not found?", splitCursor, null, 4, null);
            }
            if (splitStart - 1 < parent.getChildCount()) {
                Element prevNewRoot = newRoot;
                newRoot = XMLHandlerKt.shallowcopy((Element)parent);
                log.trace("Making root " + newRoot.toXML());
                if (prevNewRoot != null) {
                    prevNewRoot.detach();
                    newRoot.appendChild((Node)prevNewRoot);
                }
                while (parent.getChildCount() > splitStart) {
                    Node next = parent.getChild(splitStart);
                    log.debug("moving into root " + next.toXML());
                    next.detach();
                    newRoot.appendChild(next);
                }
                if (newRoot.getChildCount() == 0) {
                    newRoot.detach();
                    newRoot = null;
                }
            }
            splitCursor = (Node)parent;
            ParentNode parentNode2 = ((Element)splitCursor).getParent();
            Intrinsics.checkNotNull((Object)parentNode2, (String)"null cannot be cast to non-null type nu.xom.Element");
            parent = (Element)parentNode2;
        }
        if (parent != root.getParent()) {
            throw new NodeException("Unexpected parent of root", (Node)parent, null, 4, null);
        }
        if (newRoot != null) {
            parent.insertChild((Node)newRoot, parent.indexOf((Node)root) + 1);
        }
        splitAt.detach();
        parent.insertChild(splitAt, parent.indexOf((Node)root) + 1);
        if (newRoot != null && root.getChildCount() == 0) {
            log.trace("Re-using empty root before element");
            while (newRoot.getChildCount() != 0) {
                Node firstChild = newRoot.getChild(0);
                firstChild.detach();
                root.appendChild(firstChild);
            }
            splitAt.detach();
            parent.insertChild(splitAt, parent.indexOf((Node)root));
            newRoot.detach();
        } else if (newRoot != null && newRoot.getChildCount() == 0) {
            newRoot.detach();
        } else {
            log.trace("both roots filled");
        }
        if (root.getChildCount() == 0) {
            root.detach();
        }
        return newRoot;
    }
}

