/*
 * Decompiled with CFR 0.152.
 */
package org.brailleblaster.bbx.fixers.to3;

import jakarta.xml.bind.JAXBElement;
import java.lang.reflect.Field;
import java.util.EnumMap;
import java.util.Map;
import java.util.function.Consumer;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import nu.xom.Document;
import nu.xom.Element;
import nu.xom.Node;
import org.brailleblaster.bbx.BBX;
import org.brailleblaster.bbx.fixers.AbstractFixer;
import org.brailleblaster.bbx.utd.BBXDynamicOptionStyleMap;
import org.brailleblaster.bbx.utd.BBXStyleMap;
import org.brailleblaster.settings.UTDManager;
import org.brailleblaster.utd.ActionMap;
import org.brailleblaster.utd.IStyle;
import org.brailleblaster.utd.NamespaceMap;
import org.brailleblaster.utd.OverrideMap;
import org.brailleblaster.utd.Style;
import org.brailleblaster.utd.StyleMap;
import org.brailleblaster.utd.actions.IAction;
import org.brailleblaster.utd.config.DocumentUTDConfig;
import org.brailleblaster.utd.config.StyleDefinitions;
import org.brailleblaster.utd.config.UTDConfig;
import org.brailleblaster.utd.matchers.INodeMatcher;
import org.brailleblaster.utils.xom.NodeUtilsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \u00122\u00020\u0001:\u0002\u0011\u0012B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0010\u0010\b\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0002J\u0010\u0010\t\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0002J&\u0010\n\u001a\u00020\u00052\u0006\u0010\u000b\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\r2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000fH\u0002\u00a8\u0006\u0013"}, d2={"Lorg/brailleblaster/bbx/fixers/to3/DocumentMapImportFixer;", "Lorg/brailleblaster/bbx/fixers/AbstractFixer;", "<init>", "()V", "fix", "", "matchedNode", "Lnu/xom/Node;", "processStyleMap", "processActionMap", "recursiveMatch", "root", "matcher", "Lorg/brailleblaster/utd/matchers/INodeMatcher;", "onMatch", "Ljava/util/function/Consumer;", "Lnu/xom/Element;", "Matcher", "Companion", "brailleblaster-core"})
public final class DocumentMapImportFixer
extends AbstractFixer {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final StyleDefinitions STYLE_DEFS = UTDManager.Companion.loadStyleDefinitions(UTDManager.Companion.getPreferredFormatStandard());
    @NotNull
    private static final BBX.StringAttribute ATTRIB_OVERRIDE_ID_ACTION = new BBX.StringAttribute("overrideActionId", "utd", "http://brailleblaster.org/ns/utd");
    @NotNull
    private static final BBX.StringAttribute ATTRIB_OVERRIDE_ID_STYLE = new BBX.StringAttribute("overrideStyleId", "utd", "http://brailleblaster.org/ns/utd");

    @Override
    public void fix(@NotNull Node matchedNode) {
        Intrinsics.checkNotNullParameter((Object)matchedNode, (String)"matchedNode");
        this.processStyleMap(matchedNode);
        this.processActionMap(matchedNode);
    }

    private final void processStyleMap(Node matchedNode) {
        Document document = matchedNode.getDocument();
        Intrinsics.checkNotNullExpressionValue((Object)document, (String)"getDocument(...)");
        StyleMap styleMap2 = DocumentUTDConfig.NIMAS.loadStyle(document, STYLE_DEFS);
        if (styleMap2 == null) {
            return;
        }
        StyleMap documentStyleMap = styleMap2;
        for (Map.Entry entry : ((Map)documentStyleMap).entrySet()) {
            Style actualBaseStyle;
            Style curDocumentStyle;
            Style curBaseStyle;
            INodeMatcher curMatcher = (INodeMatcher)entry.getKey();
            IStyle value1 = (IStyle)entry.getValue();
            Intrinsics.checkNotNull((Object)value1, (String)"null cannot be cast to non-null type org.brailleblaster.utd.Style");
            Map styleValues = new EnumMap(Style.StyleOption.class);
            for (curBaseStyle = curDocumentStyle = (Style)value1; curBaseStyle != null; curBaseStyle = curBaseStyle.getBaseStyle()) {
                String string = curBaseStyle.getName();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
                if (!StringsKt.startsWith$default((String)string, (String)"bbs-", (boolean)false, (int)2, null)) break;
                for (Map.Entry entry2 : UTDConfig.STYLE_OPTION_FIELDS.entrySet()) {
                    JAXBElement jAXBElement;
                    Style.StyleOption curOption = (Style.StyleOption)entry2.getKey();
                    Field curOptionField = (Field)entry2.getValue();
                    if (styleValues.containsKey(curOption)) continue;
                    try {
                        jAXBElement = (JAXBElement)curOptionField.get(curBaseStyle);
                    }
                    catch (Exception e) {
                        throw new RuntimeException("Unable to get field " + curOption + " from " + curBaseStyle, e);
                    }
                    JAXBElement curValue = jAXBElement;
                    if (curValue == null) continue;
                    styleValues.put(curOption, curValue.getValue());
                }
            }
            Intrinsics.checkNotNull((Object)curBaseStyle);
            Document document2 = matchedNode.getDocument();
            Intrinsics.checkNotNullExpressionValue((Object)document2, (String)"getDocument(...)");
            this.recursiveMatch((Node)document2, curMatcher, arg_0 -> DocumentMapImportFixer.processStyleMap$lambda$0(actualBaseStyle, styleValues, arg_0));
        }
        Element element = Companion.getStyleMapElement(matchedNode);
        Intrinsics.checkNotNull((Object)element);
        element.detach();
    }

    private final void processActionMap(Node matchedNode) {
        Document document = matchedNode.getDocument();
        Intrinsics.checkNotNullExpressionValue((Object)document, (String)"getDocument(...)");
        ActionMap actionMap2 = DocumentUTDConfig.NIMAS.loadActions(document);
        if (actionMap2 == null) {
            return;
        }
        ActionMap documentActionMap = actionMap2;
        for (Map.Entry entry : ((Map)documentActionMap).entrySet()) {
            INodeMatcher matcher = (INodeMatcher)entry.getKey();
            IAction curAction = (IAction)entry.getValue();
            Document document2 = matchedNode.getDocument();
            Intrinsics.checkNotNullExpressionValue((Object)document2, (String)"getDocument(...)");
            this.recursiveMatch((Node)document2, matcher, arg_0 -> DocumentMapImportFixer.processActionMap$lambda$0(curAction, arg_0));
        }
    }

    private final void recursiveMatch(Node root, INodeMatcher matcher, Consumer<Element> onMatch) {
        for (Node curNode : NodeUtilsKt.getChildNodes((Node)root)) {
            if (matcher.isMatch(curNode, BBXStyleMap.Companion.getBASIC_NAMESPACE_MAP())) {
                Intrinsics.checkNotNull((Object)curNode, (String)"null cannot be cast to non-null type nu.xom.Element");
                onMatch.accept((Element)curNode);
            }
            this.recursiveMatch(curNode, matcher, onMatch);
        }
    }

    private static final void processStyleMap$lambda$0(Style $actualBaseStyle, Map $styleValues, Element matchedElement) {
        Intrinsics.checkNotNullParameter((Object)matchedElement, (String)"matchedElement");
        ATTRIB_OVERRIDE_ID_STYLE.detach(matchedElement);
        BBX._ATTRIB_OVERRIDE_STYLE.set(matchedElement, $actualBaseStyle.getName());
        for (Map.Entry entry : $styleValues.entrySet()) {
            Style.StyleOption curOption = (Style.StyleOption)entry.getKey();
            Object value = entry.getValue();
            BBXDynamicOptionStyleMap.Companion.setStyleOptionAttrib(matchedElement, curOption, value);
        }
    }

    private static final void processActionMap$lambda$0(IAction $curAction, Element matchedElement) {
        ATTRIB_OVERRIDE_ID_ACTION.detach(matchedElement);
        BBX._ATTRIB_OVERRIDE_ACTION.set(matchedElement, OverrideMap.INSTANCE.getActionClassName($curAction));
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\f\u001a\u0004\u0018\u00010\r2\u0006\u0010\u000e\u001a\u00020\u000fJ\u0010\u0010\u0010\u001a\u0004\u0018\u00010\r2\u0006\u0010\u000e\u001a\u00020\u000fR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\n\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\t\u00a8\u0006\u0011"}, d2={"Lorg/brailleblaster/bbx/fixers/to3/DocumentMapImportFixer$Companion;", "", "<init>", "()V", "STYLE_DEFS", "Lorg/brailleblaster/utd/config/StyleDefinitions;", "ATTRIB_OVERRIDE_ID_ACTION", "Lorg/brailleblaster/bbx/BBX$StringAttribute;", "getATTRIB_OVERRIDE_ID_ACTION", "()Lorg/brailleblaster/bbx/BBX$StringAttribute;", "ATTRIB_OVERRIDE_ID_STYLE", "getATTRIB_OVERRIDE_ID_STYLE", "getStyleMapElement", "Lnu/xom/Element;", "node", "Lnu/xom/Node;", "getActionMapElement", "brailleblaster-core"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final BBX.StringAttribute getATTRIB_OVERRIDE_ID_ACTION() {
            return ATTRIB_OVERRIDE_ID_ACTION;
        }

        @NotNull
        public final BBX.StringAttribute getATTRIB_OVERRIDE_ID_STYLE() {
            return ATTRIB_OVERRIDE_ID_STYLE;
        }

        @Nullable
        public final Element getStyleMapElement(@NotNull Node node) {
            Intrinsics.checkNotNullParameter((Object)node, (String)"node");
            Document document = node.getDocument();
            Intrinsics.checkNotNullExpressionValue((Object)document, (String)"getDocument(...)");
            return DocumentUTDConfig.NIMAS.getConfigElement(document, StyleMap.class);
        }

        @Nullable
        public final Element getActionMapElement(@NotNull Node node) {
            Intrinsics.checkNotNullParameter((Object)node, (String)"node");
            Document document = node.getDocument();
            Intrinsics.checkNotNullExpressionValue((Object)document, (String)"getDocument(...)");
            return DocumentUTDConfig.NIMAS.getConfigElement(document, ActionMap.class);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016\u00a8\u0006\n"}, d2={"Lorg/brailleblaster/bbx/fixers/to3/DocumentMapImportFixer$Matcher;", "Lorg/brailleblaster/utd/matchers/INodeMatcher;", "<init>", "()V", "isMatch", "", "node", "Lnu/xom/Node;", "namespaces", "Lorg/brailleblaster/utd/NamespaceMap;", "brailleblaster-core"})
    public static final class Matcher
    implements INodeMatcher {
        public boolean isMatch(@NotNull Node node, @NotNull NamespaceMap namespaces) {
            Intrinsics.checkNotNullParameter((Object)node, (String)"node");
            Intrinsics.checkNotNullParameter((Object)namespaces, (String)"namespaces");
            return Companion.getStyleMapElement(node) != null || Companion.getActionMapElement(node) != null;
        }
    }
}

