/*
 * Decompiled with CFR 0.152.
 */
package org.brailleblaster.bbx.fixers2;

import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Function;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.FunctionAdapter;
import kotlin.jvm.internal.FunctionReferenceImpl;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import nu.xom.Attribute;
import nu.xom.Element;
import nu.xom.Node;
import nu.xom.Text;
import org.brailleblaster.bbx.BBX;
import org.brailleblaster.bbx.fixers2.ImportFixerCommon;
import org.brailleblaster.utd.internal.xml.FastXPath;
import org.brailleblaster.utd.internal.xml.XMLHandler;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0007J,\u0010\n\u001a\u00020\u00072\u0006\u0010\u000b\u001a\u00020\t2\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\r2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00100\rH\u0002J,\u0010\u0011\u001a\u00020\u00072\u0006\u0010\u000b\u001a\u00020\t2\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\r2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00100\rH\u0002J,\u0010\u0012\u001a\u00020\u00072\u0006\u0010\u000b\u001a\u00020\t2\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\r2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00100\rH\u0002J,\u0010\u0013\u001a\u00020\u00072\u0006\u0010\u000b\u001a\u00020\t2\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\u00142\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00100\u0014H\u0002J\u0010\u0010\u0015\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lorg/brailleblaster/bbx/fixers2/LiveFixer;", "", "<init>", "()V", "NEWPAGE_PLACEHOLDER_ATTRIB", "", "fix", "", "root", "Lnu/xom/Element;", "detachEmptyBlocks", "block", "descendantTextNodes", "", "Lnu/xom/Text;", "nodesToDetach", "Lnu/xom/Node;", "trimBlockText", "detachEmptyTextNodes", "cleanupNewPagePlaceholder", "", "removeEmptyContainers", "brailleblaster-core"})
@SourceDebugExtension(value={"SMAP\nLiveFixer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LiveFixer.kt\norg/brailleblaster/bbx/fixers2/LiveFixer\n+ 2 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n*L\n1#1,151:1\n1276#2,2:152\n*S KotlinDebug\n*F\n+ 1 LiveFixer.kt\norg/brailleblaster/bbx/fixers2/LiveFixer\n*L\n58#1:152,2\n*E\n"})
public final class LiveFixer {
    @NotNull
    public static final LiveFixer INSTANCE = new LiveFixer();
    @NotNull
    public static final String NEWPAGE_PLACEHOLDER_ATTRIB = "newPagePlaceholder";

    private LiveFixer() {
    }

    @JvmStatic
    public static final void fix(@NotNull Element root) {
        Intrinsics.checkNotNullParameter((Object)root, (String)"root");
        ImportFixerCommon.ApplyToDescendantBlocks[] applyToDescendantBlocksArray = new ImportFixerCommon.ApplyToDescendantBlocks[4];
        LiveFixer liveFixer = INSTANCE;
        applyToDescendantBlocksArray[0] = new ImportFixerCommon.ApplyToDescendantBlocks(liveFixer){
            final /* synthetic */ LiveFixer $tmp0;
            {
                this.$tmp0 = $tmp0;
            }

            public final void onBlock(Element p0, List<Text> p1, List<Node> p2) {
                Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                Intrinsics.checkNotNullParameter(p1, (String)"p1");
                Intrinsics.checkNotNullParameter(p2, (String)"p2");
                LiveFixer.access$detachEmptyBlocks(this.$tmp0, p0, p1, p2);
            }

            public final Function<?> getFunctionDelegate() {
                return (Function)new FunctionReferenceImpl(3, (Object)this.$tmp0, LiveFixer.class, "detachEmptyBlocks", "detachEmptyBlocks(Lnu/xom/Element;Ljava/util/List;Ljava/util/List;)V", 0);
            }

            public final boolean equals(Object other) {
                return other instanceof ImportFixerCommon.ApplyToDescendantBlocks ? (other instanceof FunctionAdapter ? Intrinsics.areEqual((Object)((FunctionAdapter)this).getFunctionDelegate(), (Object)((FunctionAdapter)other).getFunctionDelegate()) : false) : false;
            }

            public final int hashCode() {
                return ((FunctionAdapter)this).getFunctionDelegate().hashCode();
            }
        };
        liveFixer = INSTANCE;
        applyToDescendantBlocksArray[1] = new ImportFixerCommon.ApplyToDescendantBlocks(liveFixer){
            final /* synthetic */ LiveFixer $tmp0;
            {
                this.$tmp0 = $tmp0;
            }

            public final void onBlock(Element p0, List<Text> p1, List<Node> p2) {
                Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                Intrinsics.checkNotNullParameter(p1, (String)"p1");
                Intrinsics.checkNotNullParameter(p2, (String)"p2");
                LiveFixer.access$trimBlockText(this.$tmp0, p0, p1, p2);
            }

            public final Function<?> getFunctionDelegate() {
                return (Function)new FunctionReferenceImpl(3, (Object)this.$tmp0, LiveFixer.class, "trimBlockText", "trimBlockText(Lnu/xom/Element;Ljava/util/List;Ljava/util/List;)V", 0);
            }

            public final boolean equals(Object other) {
                return other instanceof ImportFixerCommon.ApplyToDescendantBlocks ? (other instanceof FunctionAdapter ? Intrinsics.areEqual((Object)((FunctionAdapter)this).getFunctionDelegate(), (Object)((FunctionAdapter)other).getFunctionDelegate()) : false) : false;
            }

            public final int hashCode() {
                return ((FunctionAdapter)this).getFunctionDelegate().hashCode();
            }
        };
        liveFixer = INSTANCE;
        applyToDescendantBlocksArray[2] = new ImportFixerCommon.ApplyToDescendantBlocks(liveFixer){
            final /* synthetic */ LiveFixer $tmp0;
            {
                this.$tmp0 = $tmp0;
            }

            public final void onBlock(Element p0, List<? extends Text> p1, List<? extends Node> p2) {
                Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                Intrinsics.checkNotNullParameter(p1, (String)"p1");
                Intrinsics.checkNotNullParameter(p2, (String)"p2");
                LiveFixer.access$cleanupNewPagePlaceholder(this.$tmp0, p0, p1, p2);
            }

            public final Function<?> getFunctionDelegate() {
                return (Function)new FunctionReferenceImpl(3, (Object)this.$tmp0, LiveFixer.class, "cleanupNewPagePlaceholder", "cleanupNewPagePlaceholder(Lnu/xom/Element;Ljava/util/List;Ljava/util/List;)V", 0);
            }

            public final boolean equals(Object other) {
                return other instanceof ImportFixerCommon.ApplyToDescendantBlocks ? (other instanceof FunctionAdapter ? Intrinsics.areEqual((Object)((FunctionAdapter)this).getFunctionDelegate(), (Object)((FunctionAdapter)other).getFunctionDelegate()) : false) : false;
            }

            public final int hashCode() {
                return ((FunctionAdapter)this).getFunctionDelegate().hashCode();
            }
        };
        liveFixer = INSTANCE;
        applyToDescendantBlocksArray[3] = new ImportFixerCommon.ApplyToDescendantBlocks(liveFixer){
            final /* synthetic */ LiveFixer $tmp0;
            {
                this.$tmp0 = $tmp0;
            }

            public final void onBlock(Element p0, List<Text> p1, List<Node> p2) {
                Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                Intrinsics.checkNotNullParameter(p1, (String)"p1");
                Intrinsics.checkNotNullParameter(p2, (String)"p2");
                LiveFixer.access$detachEmptyTextNodes(this.$tmp0, p0, p1, p2);
            }

            public final Function<?> getFunctionDelegate() {
                return (Function)new FunctionReferenceImpl(3, (Object)this.$tmp0, LiveFixer.class, "detachEmptyTextNodes", "detachEmptyTextNodes(Lnu/xom/Element;Ljava/util/List;Ljava/util/List;)V", 0);
            }

            public final boolean equals(Object other) {
                return other instanceof ImportFixerCommon.ApplyToDescendantBlocks ? (other instanceof FunctionAdapter ? Intrinsics.areEqual((Object)((FunctionAdapter)this).getFunctionDelegate(), (Object)((FunctionAdapter)other).getFunctionDelegate()) : false) : false;
            }

            public final int hashCode() {
                return ((FunctionAdapter)this).getFunctionDelegate().hashCode();
            }
        };
        ImportFixerCommon.INSTANCE.applyToDescendantBlocks(root, applyToDescendantBlocksArray);
        INSTANCE.removeEmptyContainers(root);
    }

    private final void detachEmptyBlocks(Element block, List<Text> descendantTextNodes, List<Node> nodesToDetach) {
        boolean bl;
        block3: {
            for (Text text : descendantTextNodes) {
                CharSequence charSequence = text.getValue();
                if (charSequence == null || StringsKt.isBlank((CharSequence)charSequence)) continue;
                return;
            }
            if (BBX.BLOCK.IMAGE_PLACEHOLDER.isA((Node)block) || BBX.BLOCK.TABLE_CELL.isA((Node)block) || BBX.BLOCK.PAGE_NUM.isA((Node)block)) {
                return;
            }
            Sequence $this$any$iv = FastXPath.descendant((Node)((Node)block));
            boolean $i$f$any = false;
            for (Object element$iv : $this$any$iv) {
                Node node = (Node)element$iv;
                boolean bl2 = false;
                if (!BBX.SPAN.IMAGE.isA(node)) continue;
                bl = true;
                break block3;
            }
            bl = false;
        }
        boolean bl3 = bl ? nodesToDetach.addAll((Collection<Node>)descendantTextNodes) : nodesToDetach.add((Node)block);
        descendantTextNodes.clear();
    }

    private final void trimBlockText(Element block, List<Text> descendantTextNodes, List<Node> nodesToDetach) {
        CharSequence newValue;
        Text textNode;
        if (descendantTextNodes.isEmpty()) {
            return;
        }
        while (!((Collection)descendantTextNodes).isEmpty()) {
            textNode = descendantTextNodes.remove(0);
            String string = textNode.getValue();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getValue(...)");
            if (StringsKt.isBlank((CharSequence)string)) {
                nodesToDetach.add((Node)textNode);
                continue;
            }
            String string2 = textNode.getValue();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getValue(...)");
            newValue = ((Object)StringsKt.trimStart((CharSequence)string2)).toString();
            if (!Intrinsics.areEqual((Object)newValue, (Object)textNode.getValue())) {
                textNode.setValue((String)newValue);
            }
            descendantTextNodes.add(0, textNode);
            break;
        }
        while (!((Collection)descendantTextNodes).isEmpty()) {
            textNode = descendantTextNodes.remove(descendantTextNodes.size() - 1);
            newValue = textNode.getValue();
            if ((newValue == null || StringsKt.isBlank((CharSequence)newValue)) && XMLHandler.Companion.ancestorElementNot((Node)textNode, LiveFixer::trimBlockText$lambda$0)) {
                nodesToDetach.add((Node)textNode);
                continue;
            }
            String string = textNode.getValue();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getValue(...)");
            newValue = ((Object)StringsKt.trimEnd((CharSequence)string)).toString();
            if (!Intrinsics.areEqual((Object)newValue, (Object)textNode.getValue())) {
                textNode.setValue((String)newValue);
            }
            descendantTextNodes.add(textNode);
            break;
        }
    }

    private final void detachEmptyTextNodes(Element block, List<Text> descendantTextNodes, List<Node> nodesToDetach) {
        Iterator<Text> itr = descendantTextNodes.iterator();
        while (itr.hasNext()) {
            Text next = itr.next();
            String string = next.getValue();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getValue(...)");
            if (!(((CharSequence)string).length() == 0)) continue;
            itr.remove();
            nodesToDetach.add((Node)next);
        }
    }

    private final void cleanupNewPagePlaceholder(Element block, List<? extends Text> descendantTextNodes, List<? extends Node> nodesToDetach) {
        Attribute attribute = block.getAttribute(NEWPAGE_PLACEHOLDER_ATTRIB);
        if (attribute == null) {
            return;
        }
        Attribute attrib = attribute;
        boolean stripped = false;
        for (Text text : descendantTextNodes) {
            String value = text.getValue();
            if (value.length() <= 1) continue;
            String string = value;
            Intrinsics.checkNotNull((Object)string);
            if (!StringsKt.contains$default((CharSequence)string, (CharSequence)"\u00b6", (boolean)false, (int)2, null)) continue;
            string = value;
            Intrinsics.checkNotNull((Object)string);
            value = StringsKt.replace$default((String)string, (String)"\u00b6", (String)"", (boolean)false, (int)4, null);
            text.setValue(value);
            stripped = true;
        }
        if (stripped) {
            attrib.detach();
        }
    }

    private final void removeEmptyContainers(Element root) {
        Sequence toDetach = SequencesKt.filter((Sequence)SequencesKt.filter((Sequence)SequencesKt.filter((Sequence)FastXPath.descendant((Node)((Node)root)), LiveFixer::removeEmptyContainers$lambda$0), LiveFixer::removeEmptyContainers$lambda$1), LiveFixer::removeEmptyContainers$lambda$2);
        for (Node node : toDetach) {
            node.detach();
        }
    }

    private static final boolean trimBlockText$lambda$0(Element node) {
        return BBX.BLOCK.TABLE_CELL.isA((Node)node);
    }

    private static final boolean removeEmptyContainers$lambda$0(Node node) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        return BBX.CONTAINER.isA(node);
    }

    private static final boolean removeEmptyContainers$lambda$1(Node container) {
        Intrinsics.checkNotNullParameter((Object)container, (String)"container");
        return !BBX.CONTAINER.IMAGE.isA(container) && !BBX.CONTAINER.TPAGE_SECTION.isA(container);
    }

    private static final boolean removeEmptyContainers$lambda$2(Node container) {
        Intrinsics.checkNotNullParameter((Object)container, (String)"container");
        return container.getChildCount() == 0;
    }

    public static final /* synthetic */ void access$detachEmptyBlocks(LiveFixer $this, Element block, List descendantTextNodes, List nodesToDetach) {
        $this.detachEmptyBlocks(block, descendantTextNodes, nodesToDetach);
    }

    public static final /* synthetic */ void access$trimBlockText(LiveFixer $this, Element block, List descendantTextNodes, List nodesToDetach) {
        $this.trimBlockText(block, descendantTextNodes, nodesToDetach);
    }

    public static final /* synthetic */ void access$cleanupNewPagePlaceholder(LiveFixer $this, Element block, List descendantTextNodes, List nodesToDetach) {
        $this.cleanupNewPagePlaceholder(block, descendantTextNodes, nodesToDetach);
    }

    public static final /* synthetic */ void access$detachEmptyTextNodes(LiveFixer $this, Element block, List descendantTextNodes, List nodesToDetach) {
        $this.detachEmptyTextNodes(block, descendantTextNodes, nodesToDetach);
    }
}

