/*
 * Decompiled with CFR 0.152.
 */
package org.brailleblaster.bbx.parsers;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import nu.xom.Comment;
import nu.xom.Element;
import nu.xom.Node;
import nu.xom.ParentNode;
import nu.xom.Text;
import org.brailleblaster.bbx.BBX;
import org.brailleblaster.bbx.parsers.ImportParser;
import org.brailleblaster.bbx.parsers.ImportParserUtils;
import org.brailleblaster.utd.exceptions.NodeException;
import org.brailleblaster.utils.xom.NodeUtilsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016\u00a8\u0006\n"}, d2={"Lorg/brailleblaster/bbx/parsers/HeadImportParser;", "Lorg/brailleblaster/bbx/parsers/ImportParser;", "<init>", "()V", "parseToBBX", "Lorg/brailleblaster/bbx/parsers/ImportParser$OldDocumentAction;", "oldNode", "Lnu/xom/Node;", "bbxCursor", "Lnu/xom/Element;", "brailleblaster-core"})
public final class HeadImportParser
implements ImportParser {
    @Override
    @NotNull
    public ImportParser.OldDocumentAction parseToBBX(@NotNull Node oldNode, @NotNull Element bbxCursor) {
        Intrinsics.checkNotNullParameter((Object)oldNode, (String)"oldNode");
        Intrinsics.checkNotNullParameter((Object)bbxCursor, (String)"bbxCursor");
        Element oldHead = ImportParserUtils.failIfNotElement(oldNode);
        Element newhead = BBX.getHead(bbxCursor.getDocument());
        Intrinsics.checkNotNull((Object)newhead);
        ImportParserUtils.initNewElementAttributes(oldHead, newhead);
        for (Node curOldHeadChild : NodeUtilsKt.getChildNodes((ParentNode)((ParentNode)oldHead))) {
            if (curOldHeadChild instanceof Comment) {
                newhead.appendChild((Node)new Comment((Comment)curOldHeadChild));
                continue;
            }
            if (curOldHeadChild instanceof Text) {
                String string = ((Text)curOldHeadChild).getValue();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getValue(...)");
                if (StringsKt.isBlank((CharSequence)string)) continue;
            }
            if (!(curOldHeadChild instanceof Element)) {
                throw new NodeException("Unexpected non-element in head", curOldHeadChild, null, 4, null);
            }
            Element newElem = new Element((Element)curOldHeadChild);
            newhead.appendChild((Node)newElem);
        }
        return ImportParser.OldDocumentAction.NEXT_SIBLING;
    }
}

