/*
 * Decompiled with CFR 0.152.
 */
package org.brailleblaster.bbx.parsers;

import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import nu.xom.Element;
import nu.xom.Node;
import org.brailleblaster.bbx.BBX;
import org.brailleblaster.bbx.parsers.ImportParser;
import org.brailleblaster.math.mathml.MathModuleUtils;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \n2\u00020\u0001:\u0001\nB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016\u00a8\u0006\u000b"}, d2={"Lorg/brailleblaster/bbx/parsers/MathMLImportParser;", "Lorg/brailleblaster/bbx/parsers/ImportParser;", "<init>", "()V", "parseToBBX", "Lorg/brailleblaster/bbx/parsers/ImportParser$OldDocumentAction;", "oldNode", "Lnu/xom/Node;", "bbxCursor", "Lnu/xom/Element;", "Companion", "brailleblaster-core"})
public final class MathMLImportParser
implements ImportParser {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final Logger logger;

    @Override
    @NotNull
    public ImportParser.OldDocumentAction parseToBBX(@NotNull Node oldNode, @NotNull Element bbxCursor) {
        Intrinsics.checkNotNullParameter((Object)oldNode, (String)"oldNode");
        Intrinsics.checkNotNullParameter((Object)bbxCursor, (String)"bbxCursor");
        Element mathMLContainer = BBX.INLINE.MATHML.create();
        if (oldNode instanceof Element) {
            Element newMathML = ((Element)oldNode).copy();
            try {
                Intrinsics.checkNotNull((Object)newMathML);
                MathModuleUtils.INSTANCE.setASCIIText(newMathML);
            }
            catch (Exception e) {
                logger.error("Problem generating ASCIIMath", (Throwable)e);
            }
            mathMLContainer.appendChild((Node)newMathML);
            bbxCursor.appendChild((Node)mathMLContainer);
        } else {
            logger.error("Not importing node " + oldNode.toXML() + " as not an Element");
        }
        return ImportParser.OldDocumentAction.NEXT_SIBLING;
    }

    static {
        Logger logger = LoggerFactory.getLogger(MathMLImportParser.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getLogger(...)");
        MathMLImportParser.logger = logger;
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lorg/brailleblaster/bbx/parsers/MathMLImportParser$Companion;", "", "<init>", "()V", "logger", "Lorg/slf4j/Logger;", "brailleblaster-core"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

