/*
 * Decompiled with CFR 0.152.
 */
package org.brailleblaster.embossers;

import java.io.Closeable;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.IntPredicate;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import javax.print.PrintService;
import javax.print.StreamPrintService;
import javax.print.StreamPrintServiceFactory;
import javax.print.attribute.Attribute;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Charsets;
import kotlinx.serialization.SerializationStrategy;
import kotlinx.serialization.json.Json;
import nu.xom.Document;
import org.brailleblaster.BBIni;
import org.brailleblaster.document.BBDocument;
import org.brailleblaster.embossers.EmbossDialog;
import org.brailleblaster.embossers.EmbosserConfig;
import org.brailleblaster.embossers.EmbossingUtils;
import org.brailleblaster.libembosser.embossing.attribute.BrailleCellType;
import org.brailleblaster.libembosser.embossing.attribute.Copies;
import org.brailleblaster.libembosser.embossing.attribute.PageRanges;
import org.brailleblaster.libembosser.embossing.attribute.PaperLayout;
import org.brailleblaster.libembosser.embossing.attribute.PaperMargins;
import org.brailleblaster.libembosser.embossing.attribute.PaperSize;
import org.brailleblaster.libembosser.spi.BrlCell;
import org.brailleblaster.libembosser.spi.Embosser;
import org.brailleblaster.libembosser.spi.EmbossingAttributeSet;
import org.brailleblaster.libembosser.spi.Layout;
import org.brailleblaster.libembosser.spi.Margins;
import org.brailleblaster.libembosser.spi.Notification;
import org.brailleblaster.libembosser.spi.Rectangle;
import org.brailleblaster.utd.ITranslationEngine;
import org.brailleblaster.utd.PageSettings;
import org.brailleblaster.utd.UTDTranslationEngine;
import org.brailleblaster.utd.utils.BBX2PEFConverterKt;
import org.brailleblaster.util.Notify;
import org.brailleblaster.utils.LengthUtils;
import org.brailleblaster.utils.PageFilterInputStream;
import org.brailleblaster.utils.localization.LocaleHandler;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Shell;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000p\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0003'()B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J4\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\b\b\u0002\u0010\u0014\u001a\u00020\u00152\u0010\b\u0002\u0010\u0016\u001a\n\u0012\u0004\u0012\u00020\u0015\u0018\u00010\u0017H\u0007J\u0010\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001bH\u0002JB\u0010\u001c\u001a\u00020\u000f2\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\u001e2\u0006\u0010 \u001a\u00020!2\u0006\u0010\u0012\u001a\u00020\"2\b\b\u0002\u0010\u0014\u001a\u00020\u00152\u0010\b\u0002\u0010\u0016\u001a\n\u0012\u0004\u0012\u00020\u0015\u0018\u00010\u0017J$\u0010#\u001a\u00020\u00192\u0006\u0010\u0014\u001a\u00020\u00152\u0012\u0010$\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020&0%H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0007\u001a\n \t*\u0004\u0018\u00010\b0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\n\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\r\u00a8\u0006*"}, d2={"Lorg/brailleblaster/embossers/EmbossingUtils;", "", "<init>", "()V", "EMBOSSER_OUTPUT_ENTRY", "", "EMBOSSER_CONFIG_ENTRY", "logger", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "embossersFile", "Ljava/io/File;", "getEmbossersFile", "()Ljava/io/File;", "emboss", "", "document", "Lorg/brailleblaster/document/BBDocument;", "engine", "Lorg/brailleblaster/utd/UTDTranslationEngine;", "parent", "Lorg/eclipse/swt/widgets/Shell;", "openSettings", "Ljava/util/function/Consumer;", "embosserPrerequisitesMet", "", "driver", "Lorg/brailleblaster/libembosser/spi/Embosser;", "embossBrf", "brfMinHeight", "Ljava/math/BigDecimal;", "brfMinWidth", "brfPath", "Ljava/nio/file/Path;", "Lorg/brailleblaster/utd/ITranslationEngine;", "embossToFile", "zipEntryFunctions", "", "Lorg/brailleblaster/embossers/EmbossingUtils$OutputToStreamFunction;", "OutputToStreamFunction", "EmbossToStreamFunction", "EmbosserConfigToStreamFunction", "brailleblaster-core"})
public final class EmbossingUtils {
    @NotNull
    public static final EmbossingUtils INSTANCE = new EmbossingUtils();
    @NotNull
    private static final String EMBOSSER_OUTPUT_ENTRY = "embosser_output.dat";
    @NotNull
    private static final String EMBOSSER_CONFIG_ENTRY = "embosser_config.json";
    private static final Logger logger = LoggerFactory.getLogger(EmbossingUtils.class);
    @NotNull
    private static final File embossersFile;

    private EmbossingUtils() {
    }

    @NotNull
    public final File getEmbossersFile() {
        return embossersFile;
    }

    /*
     * WARNING - void declaration
     */
    @JvmStatic
    @JvmOverloads
    public static final int emboss(@NotNull BBDocument document, @NotNull UTDTranslationEngine engine, @NotNull Shell parent, @Nullable Consumer<Shell> openSettings) {
        int n;
        Intrinsics.checkNotNullParameter((Object)document, (String)"document");
        Intrinsics.checkNotNullParameter((Object)engine, (String)"engine");
        Intrinsics.checkNotNullParameter((Object)parent, (String)"parent");
        EmbossDialog embosser = new EmbossDialog(Display.getCurrent().getActiveShell(), openSettings);
        if (!embosser.ensureEmbossersAvailable(parent)) {
            return -1;
        }
        PageSettings pageSettings = engine.getPageSettings();
        EmbosserConfig data = null;
        boolean continueEmboss = false;
        do {
            Rectangle paperSize;
            Embosser driver2;
            continueEmboss = true;
            int result = embosser.open();
            if (result != 0) {
                return -1;
            }
            data = embosser.getEmbosser();
            Intrinsics.checkNotNull((Object)Optional.ofNullable(data).map(arg_0 -> EmbossingUtils.emboss$lambda$0((Function1)emboss.driver.1.INSTANCE, arg_0)).orElseThrow(EmbossingUtils::emboss$lambda$1));
            if (!INSTANCE.embosserPrerequisitesMet(driver2)) {
                return -1;
            }
            BigDecimal docWidth = BigDecimal.valueOf(pageSettings.getPaperWidth()).setScale(2, RoundingMode.HALF_UP);
            BigDecimal docHeight = BigDecimal.valueOf(pageSettings.getPaperHeight()).setScale(2, RoundingMode.HALF_UP);
            Intrinsics.checkNotNullExpressionValue((Object)driver2.getMaximumPaper(), (String)"getMaximumPaper(...)");
            if (paperSize.getWidth().compareTo(docWidth) >= 0 && paperSize.getHeight().compareTo(docHeight) >= 0) continue;
            continueEmboss = MessageDialog.openQuestion((Shell)parent, (String)LocaleHandler.Companion.getDefault$default((LocaleHandler.Companion)LocaleHandler.Companion, null, (int)1, null).get("EmbossersManager.msgboxTitleDocumentTooLarge"), (String)LocaleHandler.Companion.getDefault$default((LocaleHandler.Companion)LocaleHandler.Companion, null, (int)1, null).get("EmbossersManager.msgboxMessageDocumentTooLarge"));
        } while (!continueEmboss);
        EmbosserConfig config = data;
        int start = embosser.getStartPage();
        int end = embosser.getEndPage();
        int scope = embosser.getScope();
        int copies = embosser.getCopies();
        try {
            EmbossingAttributeSet attributes = new EmbossingAttributeSet();
            BigDecimal leftMargin = LengthUtils.toLengthBigDecimal((double)pageSettings.getLeftMargin());
            BigDecimal rightMargin = LengthUtils.toLengthBigDecimal((double)pageSettings.getRightMargin());
            BigDecimal topMargin = LengthUtils.toLengthBigDecimal((double)pageSettings.getTopMargin());
            BigDecimal bottomMargin = LengthUtils.toLengthBigDecimal((double)pageSettings.getBottomMargin());
            attributes.add((Attribute)new PaperMargins(new Margins(leftMargin, rightMargin, topMargin, bottomMargin)));
            BigDecimal pageWidth = LengthUtils.toLengthBigDecimal((double)pageSettings.getPaperWidth());
            BigDecimal pageHeight = LengthUtils.toLengthBigDecimal((double)pageSettings.getPaperHeight());
            attributes.add((Attribute)new PaperSize(new Rectangle(pageWidth, pageHeight)));
            Layout sides = pageSettings.getInterpoint() ? Layout.INTERPOINT : Layout.P1ONLY;
            attributes.add((Attribute)new PaperLayout(sides));
            attributes.add((Attribute)new Copies(copies));
            attributes.add((Attribute)new BrailleCellType(BrlCell.NLS));
            PageRanges pages = scope == 1 ? new PageRanges(start, end) : new PageRanges();
            attributes.add((Attribute)pages);
            org.w3c.dom.Document pef = BBX2PEFConverterKt.convertBBX2PEF((Document)document.doc, (String)"EmbossJob", (ITranslationEngine)((ITranslationEngine)engine), (IntPredicate)BBX2PEFConverterKt.ALL_VOLUMES);
            if (embosser.isCreateDebugFile()) {
                void $this$emboss_u24lambda_u242;
                Map map;
                Map map2 = map = MapsKt.createMapBuilder();
                Shell shell = parent;
                EmbossingUtils embossingUtils = INSTANCE;
                boolean bl = false;
                $this$emboss_u24lambda_u242.put(EMBOSSER_CONFIG_ENTRY, new EmbosserConfigToStreamFunction(config));
                EmbosserConfig embosserConfig = config;
                Intrinsics.checkNotNull((Object)embosserConfig);
                Object object = embosserConfig.getEmbosserDriver();
                if (object != null && (object = object.getStreamPrintServiceFactory()) != null) {
                    ((Optional)object).ifPresent(arg_0 -> EmbossingUtils.emboss$lambda$2$1(arg_0 -> EmbossingUtils.emboss$lambda$2$0((Map)$this$emboss_u24lambda_u242, config, pef, attributes, arg_0), arg_0));
                }
                Unit unit = Unit.INSTANCE;
                v2 = embossingUtils.embossToFile(shell, MapsKt.build((Map)map));
            } else {
                EmbosserConfig embosserConfig = config;
                Intrinsics.checkNotNull((Object)embosserConfig);
                v2 = embosserConfig.embossPef(pef, attributes);
            }
            n = pef.getElementsByTagNameNS("http://www.daisy.org/ns/2008/pef", "page").getLength();
        }
        catch (Exception e) {
            Map args = new HashMap();
            EmbosserConfig embosserConfig = data;
            Intrinsics.checkNotNull((Object)embosserConfig);
            args.put("embosser", embosserConfig.getName());
            args.put("error", e.getMessage());
            Notify.INSTANCE.notify(LocaleHandler.Companion.getDefault$default((LocaleHandler.Companion)LocaleHandler.Companion, null, (int)1, null).format("cannotEmboss", args), Notify.EXCEPTION_SHELL_NAME, false);
            logger.error("Print Exception", (Throwable)e);
            n = -1;
        }
        return n;
    }

    public static /* synthetic */ int emboss$default(BBDocument bBDocument, UTDTranslationEngine uTDTranslationEngine, Shell shell, Consumer consumer, int n, Object object) {
        if ((n & 4) != 0) {
            Shell shell2 = Display.getCurrent().getActiveShell();
            Intrinsics.checkNotNullExpressionValue((Object)shell2, (String)"getActiveShell(...)");
            shell = shell2;
        }
        if ((n & 8) != 0) {
            consumer = null;
        }
        return EmbossingUtils.emboss(bBDocument, uTDTranslationEngine, shell, consumer);
    }

    private final boolean embosserPrerequisitesMet(Embosser driver2) {
        List<Object> prerequisiteWarnings = driver2.checkPrerequisites().filter(arg_0 -> EmbossingUtils.embosserPrerequisitesMet$lambda$1(EmbossingUtils::embosserPrerequisitesMet$lambda$0, arg_0)).toList();
        boolean noWarnings = prerequisiteWarnings.isEmpty();
        if (!noWarnings) {
            Intrinsics.checkNotNull(prerequisiteWarnings);
            Iterable iterable = prerequisiteWarnings;
            CharSequence charSequence = "\n";
            String string = "%s%n%n";
            Object[] objectArray = new Object[]{LocaleHandler.Companion.getDefault$default((LocaleHandler.Companion)LocaleHandler.Companion, null, (int)1, null).get("EmbossersManager.prerequisitesNotMet")};
            String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(...)");
            String warningMsg = CollectionsKt.joinToString$default((Iterable)iterable, (CharSequence)charSequence, (CharSequence)string2, null, (int)0, null, EmbossingUtils::embosserPrerequisitesMet$lambda$2, (int)28, null);
            Notify.showMessage(warningMsg, new Object[0]);
        }
        return noWarnings;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public final int embossBrf(@NotNull BigDecimal brfMinHeight, @NotNull BigDecimal brfMinWidth, @NotNull Path brfPath, @NotNull ITranslationEngine engine, @NotNull Shell parent, @Nullable Consumer<Shell> openSettings) {
        int n;
        Intrinsics.checkNotNullParameter((Object)brfMinHeight, (String)"brfMinHeight");
        Intrinsics.checkNotNullParameter((Object)brfMinWidth, (String)"brfMinWidth");
        Intrinsics.checkNotNullParameter((Object)brfPath, (String)"brfPath");
        Intrinsics.checkNotNullParameter((Object)engine, (String)"engine");
        Intrinsics.checkNotNullParameter((Object)parent, (String)"parent");
        EmbossDialog embosser = new EmbossDialog(Display.getCurrent().getActiveShell(), openSettings);
        if (!embosser.ensureEmbossersAvailable(parent)) {
            return -1;
        }
        int result = embosser.open();
        int start = embosser.getStartPage();
        int end = embosser.getEndPage();
        int scope = embosser.getScope();
        int copies = embosser.getCopies();
        if (result != 0) {
            return -1;
        }
        EmbosserConfig data = embosser.getEmbosser();
        EmbosserConfig embosserConfig = data;
        if (embosserConfig == null || (embosserConfig = embosserConfig.getEmbosserDriver()) == null) {
            throw new NoSuchElementException("Config does not contain embosser driver, this should not happen");
        }
        EmbosserConfig driver2 = embosserConfig;
        if (!this.embosserPrerequisitesMet((Embosser)driver2)) {
            return -1;
        }
        if (!(driver2.getMaximumPaper().getWidth().compareTo(brfMinWidth) >= 0 && driver2.getMaximumPaper().getHeight().compareTo(brfMinHeight) >= 0 || MessageDialog.openQuestion((Shell)parent, (String)LocaleHandler.Companion.getDefault$default((LocaleHandler.Companion)LocaleHandler.Companion, null, (int)1, null).get("EmbossersManager.msgboxTitleDocumentTooLarge"), (String)LocaleHandler.Companion.getDefault$default((LocaleHandler.Companion)LocaleHandler.Companion, null, (int)1, null).get("EmbossersManager.msgboxMessageDocumentTooLarge")))) {
            return -1;
        }
        try {
            int inputStream22;
            InputStream inputStream = Files.newInputStream(brfPath, new OpenOption[0]);
            Intrinsics.checkNotNullExpressionValue((Object)inputStream, (String)"newInputStream(...)");
            Closeable closeable = (Closeable)new PageFilterInputStream(inputStream);
            Throwable throwable = null;
            try {
                PageFilterInputStream inputStream22 = (PageFilterInputStream)closeable;
                boolean bl = false;
                PageSettings pageSettings = engine.getPageSettings();
                EmbossingAttributeSet attributes = new EmbossingAttributeSet();
                BigDecimal leftMargin = LengthUtils.toLengthBigDecimal((double)pageSettings.getLeftMargin());
                BigDecimal topMargin = LengthUtils.toLengthBigDecimal((double)pageSettings.getTopMargin());
                BigDecimal rightMargin = LengthUtils.toLengthBigDecimal((double)pageSettings.getRightMargin());
                BigDecimal bottomMargin = LengthUtils.toLengthBigDecimal((double)pageSettings.getBottomMargin());
                attributes.add((Attribute)new PaperMargins(new Margins(leftMargin, rightMargin, topMargin, bottomMargin)));
                BigDecimal paperWidth = LengthUtils.toLengthBigDecimal((double)pageSettings.getPaperWidth());
                BigDecimal paperHeight = LengthUtils.toLengthBigDecimal((double)pageSettings.getPaperHeight());
                attributes.add((Attribute)new PaperSize(new Rectangle(paperWidth, paperHeight)));
                attributes.add((Attribute)new Copies(copies));
                attributes.add((Attribute)new BrailleCellType(BrlCell.NLS));
                Layout pageLayout = pageSettings.getInterpoint() ? Layout.INTERPOINT : Layout.P1ONLY;
                attributes.add((Attribute)new PaperLayout(pageLayout));
                PageRanges pages = scope == 1 ? new PageRanges(start, end) : new PageRanges();
                attributes.add((Attribute)pages);
                if (embosser.isCreateDebugFile()) {
                    void $this$embossBrf_u24lambda_u240_u240;
                    Map map;
                    Map map2 = map = MapsKt.createMapBuilder();
                    Shell shell = parent;
                    EmbossingUtils embossingUtils = INSTANCE;
                    boolean bl2 = false;
                    $this$embossBrf_u24lambda_u240_u240.put(EMBOSSER_CONFIG_ENTRY, new EmbosserConfigToStreamFunction(data));
                    Optional.of(driver2).flatMap(arg_0 -> EmbossingUtils.embossBrf$lambda$0$0$1(EmbossingUtils::embossBrf$lambda$0$0$0, arg_0)).ifPresent(arg_0 -> EmbossingUtils.embossBrf$lambda$0$0$3(arg_0 -> EmbossingUtils.embossBrf$lambda$0$0$2((Map)$this$embossBrf_u24lambda_u240_u240, data, inputStream22, attributes, arg_0), arg_0));
                    Unit unit = Unit.INSTANCE;
                    v2 = embossingUtils.embossToFile(shell, MapsKt.build((Map)map));
                } else {
                    v2 = data.embossBrf((InputStream)inputStream22, attributes);
                }
                inputStream22 = inputStream22.getPageNumber();
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
            n = inputStream22;
        }
        catch (Exception e) {
            Object[] objectArray = new Pair[]{TuplesKt.to((Object)"embosser", (Object)data.getName()), TuplesKt.to((Object)"error", (Object)e.getMessage())};
            Map args = MapsKt.mapOf((Pair[])objectArray);
            objectArray = new Object[]{args};
            Notify.INSTANCE.notify(LocaleHandler.Companion.getDefault$default((LocaleHandler.Companion)LocaleHandler.Companion, null, (int)1, null).format("cannotEmboss", objectArray), Notify.EXCEPTION_SHELL_NAME, false);
            logger.error("Print Exception", (Throwable)e);
            n = -1;
        }
        return n;
    }

    public static /* synthetic */ int embossBrf$default(EmbossingUtils embossingUtils, BigDecimal bigDecimal, BigDecimal bigDecimal2, Path path, ITranslationEngine iTranslationEngine, Shell shell, Consumer consumer, int n, Object object) {
        if ((n & 0x10) != 0) {
            Shell shell2 = Display.getCurrent().getActiveShell();
            Intrinsics.checkNotNullExpressionValue((Object)shell2, (String)"getActiveShell(...)");
            shell = shell2;
        }
        if ((n & 0x20) != 0) {
            consumer = null;
        }
        return embossingUtils.embossBrf(bigDecimal, bigDecimal2, path, iTranslationEngine, shell, consumer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean embossToFile(Shell parent, Map<String, ? extends OutputToStreamFunction> zipEntryFunctions) {
        if (!(!parent.isDisposed())) {
            boolean $i$a$-require-EmbossingUtils$embossToFile$22 = false;
            String $i$a$-require-EmbossingUtils$embossToFile$22 = "Shell has been disposed, this manager is no longer valid for use.";
            throw new IllegalArgumentException($i$a$-require-EmbossingUtils$embossToFile$22.toString());
        }
        FileDialog saveDialog = new FileDialog(parent, 8192);
        String[] $i$a$-require-EmbossingUtils$embossToFile$22 = new String[]{LocaleHandler.Companion.getDefault$default((LocaleHandler.Companion)LocaleHandler.Companion, null, (int)1, null).get("EmbossersManager.zipFiles")};
        saveDialog.setFilterNames($i$a$-require-EmbossingUtils$embossToFile$22);
        $i$a$-require-EmbossingUtils$embossToFile$22 = new String[]{"*.zip"};
        saveDialog.setFilterExtensions($i$a$-require-EmbossingUtils$embossToFile$22);
        saveDialog.setOverwrite(true);
        String fileName = saveDialog.open();
        if (fileName == null) {
            MessageDialog.openInformation((Shell)parent, (String)LocaleHandler.Companion.getDefault$default((LocaleHandler.Companion)LocaleHandler.Companion, null, (int)1, null).get("EmbossersManager.embossingCancelled"), (String)LocaleHandler.Companion.getDefault$default((LocaleHandler.Companion)LocaleHandler.Companion, null, (int)1, null).get("EmbossersManager.embossingCancelledMsg"));
            return true;
        }
        File outputFile = new File(fileName);
        boolean result = false;
        try {
            Closeable closeable = new ZipOutputStream(new FileOutputStream(outputFile));
            Throwable throwable = null;
            try {
                ZipOutputStream zos = (ZipOutputStream)closeable;
                boolean bl = false;
                for (Map.Entry<String, ? extends OutputToStreamFunction> entry : zipEntryFunctions.entrySet()) {
                    String key = entry.getKey();
                    OutputToStreamFunction value = entry.getValue();
                    ZipEntry ze = new ZipEntry(key);
                    zos.putNextEntry(ze);
                    value.consume(zos);
                    zos.closeEntry();
                }
                result = true;
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
        }
        catch (FileNotFoundException e) {
            logger.error("Problem embossing to file", (Throwable)e);
            MessageDialog.openError((Shell)parent, (String)LocaleHandler.Companion.getDefault$default((LocaleHandler.Companion)LocaleHandler.Companion, null, (int)1, null).get("EmbossersManager.fileNotFound"), (String)LocaleHandler.Companion.getDefault$default((LocaleHandler.Companion)LocaleHandler.Companion, null, (int)1, null).get("EmbossersManager.fileNotFoundMsg"));
        }
        catch (IOException e) {
            logger.error("Problem writing to file when embossing", (Throwable)e);
            MessageDialog.openError((Shell)parent, (String)LocaleHandler.Companion.getDefault$default((LocaleHandler.Companion)LocaleHandler.Companion, null, (int)1, null).get("EmbossersManager.embossToFileError"), (String)LocaleHandler.Companion.getDefault$default((LocaleHandler.Companion)LocaleHandler.Companion, null, (int)1, null).get("Embossersmanager.embossToFileErrorMsg"));
        }
        return result;
    }

    @JvmStatic
    @JvmOverloads
    public static final int emboss(@NotNull BBDocument document, @NotNull UTDTranslationEngine engine, @NotNull Shell parent) {
        Intrinsics.checkNotNullParameter((Object)document, (String)"document");
        Intrinsics.checkNotNullParameter((Object)engine, (String)"engine");
        Intrinsics.checkNotNullParameter((Object)parent, (String)"parent");
        return EmbossingUtils.emboss$default(document, engine, parent, null, 8, null);
    }

    @JvmStatic
    @JvmOverloads
    public static final int emboss(@NotNull BBDocument document, @NotNull UTDTranslationEngine engine) {
        Intrinsics.checkNotNullParameter((Object)document, (String)"document");
        Intrinsics.checkNotNullParameter((Object)engine, (String)"engine");
        return EmbossingUtils.emboss$default(document, engine, null, null, 12, null);
    }

    private static final Boolean emboss$lambda$2$0$0(EmbosserConfig $config, org.w3c.dom.Document $pef, EmbossingAttributeSet $attributes, PrintService ps) {
        PrintService printService = ps;
        Intrinsics.checkNotNull((Object)printService);
        return $config.embossPef($pef, $attributes, printService);
    }

    private static final Unit emboss$lambda$2$0(Map $this_buildMap, EmbosserConfig $config, org.w3c.dom.Document $pef, EmbossingAttributeSet $attributes, StreamPrintServiceFactory f) {
        Intrinsics.checkNotNullParameter((Object)f, (String)"f");
        $this_buildMap.put(EMBOSSER_OUTPUT_ENTRY, new EmbossToStreamFunction(f, arg_0 -> EmbossingUtils.emboss$lambda$2$0$0($config, $pef, $attributes, arg_0)));
        return Unit.INSTANCE;
    }

    private static final void emboss$lambda$2$1(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }

    private static final Embosser emboss$lambda$0(Function1 $tmp0, Object p0) {
        return (Embosser)$tmp0.invoke(p0);
    }

    private static final NoSuchElementException emboss$lambda$1() {
        return new NoSuchElementException("Config selected has no embosser driver, this should not be possible");
    }

    private static final boolean embosserPrerequisitesMet$lambda$0(Notification n) {
        Intrinsics.checkNotNullParameter((Object)n, (String)"n");
        return Notification.NotificationType.WARNING.compareTo((Enum)n.getNotificationType()) >= 0;
    }

    private static final boolean embosserPrerequisitesMet$lambda$1(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final CharSequence embosserPrerequisitesMet$lambda$2(Notification n) {
        Intrinsics.checkNotNullParameter((Object)n, (String)"n");
        String string = n.getMessage(LocaleHandler.Companion.getDefault$default((LocaleHandler.Companion)LocaleHandler.Companion, null, (int)1, null).getLocale());
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getMessage(...)");
        return string;
    }

    private static final Boolean embossBrf$lambda$0$0$2$0(EmbosserConfig $data, PageFilterInputStream $inputStream, EmbossingAttributeSet $attributes, PrintService ps) {
        InputStream inputStream = (InputStream)$inputStream;
        PrintService printService = ps;
        Intrinsics.checkNotNull((Object)printService);
        return $data.embossBrf(inputStream, $attributes, printService);
    }

    private static final Optional embossBrf$lambda$0$0$0(Embosser obj) {
        Intrinsics.checkNotNullParameter((Object)obj, (String)"obj");
        return obj.getStreamPrintServiceFactory();
    }

    private static final Optional embossBrf$lambda$0$0$1(Function1 $tmp0, Object p0) {
        return (Optional)$tmp0.invoke(p0);
    }

    private static final Unit embossBrf$lambda$0$0$2(Map $this_buildMap, EmbosserConfig $data, PageFilterInputStream $inputStream, EmbossingAttributeSet $attributes, StreamPrintServiceFactory f) {
        Intrinsics.checkNotNullParameter((Object)f, (String)"f");
        $this_buildMap.put(EMBOSSER_OUTPUT_ENTRY, new EmbossToStreamFunction(f, arg_0 -> EmbossingUtils.embossBrf$lambda$0$0$2$0($data, $inputStream, $attributes, arg_0)));
        return Unit.INSTANCE;
    }

    private static final void embossBrf$lambda$0$0$3(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }

    static {
        String[] stringArray = new String[]{"settings/embossers.json"};
        embossersFile = BBIni.INSTANCE.getUserProgramDataFile(stringArray);
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0014\u0010\u0004\u001a\u0010\u0012\u0006\u0012\u0004\u0018\u00010\u0006\u0012\u0004\u0012\u00020\u00070\u0005\u00a2\u0006\u0004\b\b\u0010\tJ\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0004\u001a\u0010\u0012\u0006\u0012\u0004\u0018\u00010\u0006\u0012\u0004\u0012\u00020\u00070\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lorg/brailleblaster/embossers/EmbossingUtils$EmbossToStreamFunction;", "Lorg/brailleblaster/embossers/EmbossingUtils$OutputToStreamFunction;", "serviceFactory", "Ljavax/print/StreamPrintServiceFactory;", "embossFunction", "Ljava/util/function/Function;", "Ljavax/print/PrintService;", "", "<init>", "(Ljavax/print/StreamPrintServiceFactory;Ljava/util/function/Function;)V", "consume", "", "os", "Ljava/io/OutputStream;", "brailleblaster-core"})
    private static final class EmbossToStreamFunction
    implements OutputToStreamFunction {
        @NotNull
        private final StreamPrintServiceFactory serviceFactory;
        @NotNull
        private final Function<PrintService, Boolean> embossFunction;

        public EmbossToStreamFunction(@NotNull StreamPrintServiceFactory serviceFactory, @NotNull Function<PrintService, Boolean> embossFunction) {
            Intrinsics.checkNotNullParameter((Object)serviceFactory, (String)"serviceFactory");
            Intrinsics.checkNotNullParameter(embossFunction, (String)"embossFunction");
            this.serviceFactory = serviceFactory;
            this.embossFunction = embossFunction;
        }

        @Override
        public void consume(@NotNull OutputStream os) {
            Intrinsics.checkNotNullParameter((Object)os, (String)"os");
            StreamPrintService service = this.serviceFactory.getPrintService(os);
            if (!this.embossFunction.apply(service).booleanValue()) {
                throw new RuntimeException("Unknown error whilst embossing to stream");
            }
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u0011\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lorg/brailleblaster/embossers/EmbossingUtils$EmbosserConfigToStreamFunction;", "Lorg/brailleblaster/embossers/EmbossingUtils$OutputToStreamFunction;", "config", "Lorg/brailleblaster/embossers/EmbosserConfig;", "<init>", "(Lorg/brailleblaster/embossers/EmbosserConfig;)V", "consume", "", "os", "Ljava/io/OutputStream;", "brailleblaster-core"})
    @SourceDebugExtension(value={"SMAP\nEmbossingUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 EmbossingUtils.kt\norg/brailleblaster/embossers/EmbossingUtils$EmbosserConfigToStreamFunction\n+ 2 Json.kt\nkotlinx/serialization/json/Json\n*L\n1#1,336:1\n205#2:337\n*S KotlinDebug\n*F\n+ 1 EmbossingUtils.kt\norg/brailleblaster/embossers/EmbossingUtils$EmbosserConfigToStreamFunction\n*L\n331#1:337\n*E\n"})
    private static final class EmbosserConfigToStreamFunction
    implements OutputToStreamFunction {
        @NotNull
        private final EmbosserConfig config;

        public EmbosserConfigToStreamFunction(@Nullable EmbosserConfig config) {
            EmbosserConfig embosserConfig = config;
            if (embosserConfig == null) {
                String string = "Required value was null.";
                throw new IllegalArgumentException(string.toString());
            }
            this.config = embosserConfig;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public void consume(@NotNull OutputStream os) throws IOException {
            void this_$iv;
            Intrinsics.checkNotNullParameter((Object)os, (String)"os");
            Json json = (Json)Json.Default;
            EmbosserConfig value$iv = this.config;
            boolean $i$f$encodeToString = false;
            this_$iv.getSerializersModule();
            String configStr = this_$iv.encodeToString((SerializationStrategy)EmbosserConfig.Companion.serializer(), (Object)value$iv);
            byte[] byArray = configStr.getBytes(Charsets.UTF_8);
            Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getBytes(...)");
            os.write(byArray);
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00e2\u0080\u0001\u0018\u00002\u00020\u0001J\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H&\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\u0006\u00c0\u0006\u0001"}, d2={"Lorg/brailleblaster/embossers/EmbossingUtils$OutputToStreamFunction;", "", "consume", "", "os", "Ljava/io/OutputStream;", "brailleblaster-core"})
    private static interface OutputToStreamFunction {
        public void consume(@NotNull OutputStream var1) throws IOException;
    }
}

