/*
 * Decompiled with CFR 0.152.
 */
package org.brailleblaster.frontmatter;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import org.brailleblaster.frontmatter.SpecialSymbols;
import org.brailleblaster.settings.UTDManager;
import org.brailleblaster.utils.swt.ButtonBuilder1;
import org.brailleblaster.utils.swt.CompositeBuilder;
import org.brailleblaster.utils.swt.EasyListeners;
import org.brailleblaster.utils.swt.EasySWT;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;

public class SpecialSymbolEditor {
    private final int BUTTON_WIDTH = 100;
    private final int TEXT_WIDTH = 400;
    private final int MAX_SHELL_WIDTH = 700;
    private final int MAX_PADDING = 100;
    private final int SHELL_WIDTH;

    public SpecialSymbolEditor() {
        this.SHELL_WIDTH = Math.min(Display.getCurrent().getBounds().width - 100, 700);
    }

    public void open(Shell parent, UTDManager m) {
        List<SpecialSymbols.Symbol> symbols = SpecialSymbols.getSymbols();
        this.createDialog(parent, symbols);
    }

    private void createDialog(Shell parent, List<SpecialSymbols.Symbol> map) {
        Shell dialog = new Shell(parent, 67680);
        dialog.setLayout((Layout)new GridLayout(1, false));
        dialog.setText("Special Symbols");
        EasySWT.makeLabel((Composite)dialog, (String)"", (int)this.SHELL_WIDTH, (int)1);
        Composite tableCont = EasySWT.makeComposite((Composite)dialog, (int)1);
        Table symbolsTable = new Table(tableCont, 268503044);
        symbolsTable.setLinesVisible(true);
        symbolsTable.setHeaderVisible(true);
        EasySWT.buildGridData().setHint(Integer.valueOf(this.SHELL_WIDTH), Integer.valueOf(400)).applyTo((Control)symbolsTable);
        TableColumn symbolColumn = new TableColumn(symbolsTable, 0);
        symbolColumn.setWidth(100);
        symbolColumn.setText("Symbol");
        TableColumn descColumn = new TableColumn(symbolsTable, 0);
        descColumn.setWidth((this.SHELL_WIDTH - 100) / 2);
        descColumn.setText("Description");
        TableColumn rulesColumn = new TableColumn(symbolsTable, 0);
        rulesColumn.setText("Rules");
        CompositeBuilder compositeBuilder = EasySWT.buildComposite((Composite)dialog);
        compositeBuilder.setColumns(Integer.valueOf(3));
        compositeBuilder.setEqualColumnWidth(true);
        compositeBuilder.addButton("Add...", 100, 1, i -> new SymbolDialog(dialog, symbolsTable).open(null));
        compositeBuilder.addButton("Edit...", 100, 1, i -> {
            if (symbolsTable.getSelection().length > 0) {
                new SymbolDialog(dialog, symbolsTable).open(symbolsTable.getSelection()[0]);
            }
        });
        compositeBuilder.addButton("Delete", 100, 1, i -> {
            if (symbolsTable.getSelection().length > 0) {
                symbolsTable.remove(symbolsTable.getSelectionIndex());
            }
        });
        compositeBuilder.build();
        compositeBuilder = EasySWT.buildComposite((Composite)dialog);
        compositeBuilder.setColumns(Integer.valueOf(3));
        compositeBuilder.setEqualColumnWidth(true);
        compositeBuilder.addButton("Save", 100, 1, i -> {
            SpecialSymbols.saveChanges(this.pullListFromTable(symbolsTable));
            dialog.close();
        });
        compositeBuilder.addButton("Cancel", 100, 1, i -> dialog.close());
        compositeBuilder.addButton("Restore Default", 100, 1, i -> {
            if (EasySWT.makeEasyYesNoDialog((String)"Confirmation", (String)"This will delete all custom special symbols. Are you sure?", (Shell)dialog)) {
                SpecialSymbols.restoreDefault();
                symbolsTable.removeAll();
                this.fillTable(symbolsTable, SpecialSymbols.getSymbols());
            }
        });
        compositeBuilder.build();
        this.fillTable(symbolsTable, map);
        dialog.pack();
        dialog.open();
    }

    private void resizeRulesColumn(TableColumn rulesColumn) {
        Table symbolsTable = rulesColumn.getParent();
        int longestRulesCol = (this.SHELL_WIDTH - 100) / 2;
        GC gc = new GC((Drawable)symbolsTable);
        for (int i = 0; i < symbolsTable.getItemCount(); ++i) {
            TableItem item = symbolsTable.getItem(i);
            longestRulesCol = Math.max(gc.textExtent((String)item.getText((int)2)).x + 15, longestRulesCol);
        }
        rulesColumn.setWidth(longestRulesCol);
    }

    private void fillTable(Table symbolsTable, List<SpecialSymbols.Symbol> symbols) {
        for (SpecialSymbols.Symbol symbol : symbols) {
            String desc = symbol.getDesc();
            if (desc == null) continue;
            TableItem newItem = new TableItem(symbolsTable, 0);
            newItem.setText(new String[]{symbol.getSymbol(), symbol.getDesc(), SpecialSymbols.rulesToString(symbol.getRules())});
        }
        this.resizeRulesColumn(symbolsTable.getColumn(2));
    }

    private List<SpecialSymbols.Symbol> pullListFromTable(Table symbolsTable) {
        ArrayList<SpecialSymbols.Symbol> list = new ArrayList<SpecialSymbols.Symbol>();
        for (int i = 0; i < symbolsTable.getItemCount(); ++i) {
            TableItem curItem = symbolsTable.getItem(i);
            list.add(new SpecialSymbols.Symbol(curItem.getText(0), curItem.getText(1), SpecialSymbols.stringToRules(curItem.getText(2))));
        }
        return list;
    }

    private class SymbolDialog {
        final Shell parent;
        final Table symbolsTable;

        public SymbolDialog(Shell parent, Table symbolsTable) {
            this.parent = parent;
            this.symbolsTable = symbolsTable;
        }

        void open(TableItem existingItem) {
            boolean editing = existingItem != null;
            Shell addDialog = new Shell(this.parent, 67696);
            addDialog.setLayout((Layout)new RowLayout(512));
            Composite container = EasySWT.makeComposite((Composite)addDialog, (int)2);
            EasySWT.makeLabel((Composite)container, (String)"Symbol:", (int)1);
            Text symbolText = EasySWT.makeText((Composite)container, (int)400, (int)1);
            if (editing) {
                symbolText.setText(existingItem.getText(0));
            }
            EasySWT.makeLabel((Composite)container, (String)"Description:", (int)1);
            Text descText = EasySWT.makeText((Composite)container, (int)400, (int)1);
            if (editing) {
                descText.setText(existingItem.getText(1));
            }
            Button editRulesButton = EasySWT.makePushButton((Composite)container, (String)"Edit rules", (int)100, (int)1, null);
            Label rulesLabel = EasySWT.makeLabel((Composite)container, (String)("Rules: " + (existingItem == null || existingItem.getText(2).isEmpty() ? "None" : existingItem.getText(2))), (int)1);
            EasyListeners.selection((Button)editRulesButton, e -> new EditRulesDialog(SpecialSymbolEditor.this).open(rulesLabel.getText().replaceAll("Rules: ", "").replaceAll("None", "").replaceAll(System.lineSeparator(), ""), s -> {
                rulesLabel.setText("Rules: " + (s.isEmpty() ? "None" : s));
                rulesLabel.pack();
                EasySWT.setLabelSizeToFit((Label)rulesLabel, (int)400);
                addDialog.layout(true);
                addDialog.pack(true);
            }));
            EasySWT.buildGridData().setAlign(Integer.valueOf(-1), Integer.valueOf(0x1000000)).applyTo((Control)rulesLabel);
            EasySWT.makePushButton((Composite)container, (String)(editing ? "Save" : "Add"), (int)100, (int)1, e -> {
                this.addSymbol(existingItem, symbolText.getText(), descText.getText(), rulesLabel.getText().replace("Rules: ", "").replace("None", "").replaceAll(System.lineSeparator(), ""));
                addDialog.close();
            });
            EasyListeners.keyPress((Control)descText, e -> {
                if (e.keyCode == 13 || e.keyCode == 0x1000050) {
                    this.addSymbol(existingItem, symbolText.getText(), descText.getText(), rulesLabel.getText().replace("Rules: ", "").replace("None", "").replaceAll(System.lineSeparator(), ""));
                    addDialog.close();
                }
            });
            EasySWT.makePushButton((Composite)container, (String)"Cancel", (int)100, (int)1, e -> addDialog.close());
            addDialog.pack();
            addDialog.open();
        }

        private void addSymbol(TableItem existingItem, String symbol, String desc, String rules) {
            TableItem newItem = existingItem == null ? new TableItem(this.symbolsTable, 0) : existingItem;
            newItem.setText(new String[]{symbol, desc, rules});
            SpecialSymbolEditor.this.resizeRulesColumn(this.symbolsTable.getColumn(2));
        }
    }

    private class EditRulesDialog {
        Shell parent;
        Shell dialog;

        public EditRulesDialog(SpecialSymbolEditor specialSymbolEditor) {
        }

        void open(String existingRules, Consumer<String> callback) {
            ArrayList<SpecialSymbols.DetectionRule> ruleList = existingRules == null || existingRules.isEmpty() ? new ArrayList() : SpecialSymbols.stringToRules(existingRules);
            this.dialog = new Shell(this.parent, 67680);
            this.dialog.setText("Edit Special Symbols Rules");
            this.dialog.setLayout((Layout)new GridLayout(1, false));
            Composite container = EasySWT.makeComposite((Composite)this.dialog, (int)3);
            Composite buttonPanel = EasySWT.makeComposite((Composite)this.dialog, (int)2);
            Button okButton = EasySWT.makePushButton((Composite)buttonPanel, (String)"Ok", (int)100, (int)1, e -> {
                callback.accept(SpecialSymbols.rulesToString(ruleList));
                this.dialog.close();
            });
            EasySWT.makePushButton((Composite)buttonPanel, (String)"Cancel", (int)100, (int)1, e -> this.dialog.close());
            this.buildRuleView(container, ruleList, okButton);
            this.dialog.pack();
            this.dialog.open();
        }

        private void buildRuleView(Composite container, List<SpecialSymbols.DetectionRule> ruleList, Button okButton) {
            int i;
            for (i = container.getChildren().length - 1; i >= 0; --i) {
                container.getChildren()[i].dispose();
            }
            for (i = 0; i < ruleList.size(); ++i) {
                this.displayRule(container, ruleList, i, okButton);
            }
            this.addRuleButton(container, ruleList, okButton);
            container.pack();
            this.dialog.pack();
        }

        private void displayRule(Composite container, List<SpecialSymbols.DetectionRule> ruleList, int index, Button okButton) {
            SpecialSymbols.DetectionRule rule = ruleList.get(index);
            Button deleteButton = EasySWT.makePushButton((Composite)container, (String)"Delete", (int)1, e -> {
                ruleList.remove(index);
                this.buildRuleView(container, ruleList, okButton);
            });
            EasySWT.buildGridData().setAlign(Integer.valueOf(16384), Integer.valueOf(0x1000000)).applyTo((Control)deleteButton);
            Label nameLabel = EasySWT.makeLabel((Composite)container, (String)(rule.getRuleName() + (String)(rule instanceof SpecialSymbols.AdvancedDetectionRule ? " " + ((SpecialSymbols.AdvancedDetectionRule)rule).getOption() : "")), (int)1);
            EasySWT.buildGridData().setAlign(Integer.valueOf(16384), Integer.valueOf(0x1000000)).applyTo((Control)nameLabel);
            Label alwaysLabel = EasySWT.makeLabel((Composite)container, (String)("   Always? " + (rule.getAlways() ? "Yes" : "No")), (int)1);
            EasySWT.buildGridData().setAlign(Integer.valueOf(16384), Integer.valueOf(0x1000000)).applyTo((Control)alwaysLabel);
        }

        private void addRuleButton(Composite container, List<SpecialSymbols.DetectionRule> ruleList, Button okButton) {
            Composite newRuleContainer = EasySWT.makeComposite((Composite)container, (int)5);
            EasySWT.buildGridData().setColumns(3).applyTo((Control)newRuleContainer);
            EasySWT.makePushButton((Composite)newRuleContainer, (String)"Add new rule", (int)1, e -> {
                e.widget.dispose();
                Combo newCombo = new Combo(newRuleContainer, 12);
                newCombo.setItems(SpecialSymbols.RULES);
                newCombo.select(0);
                EasySWT.makeLabel((Composite)newRuleContainer, (String)"Option:", (int)1);
                Text optionText = EasySWT.makeText((Composite)newRuleContainer, (int)1);
                optionText.setEnabled(false);
                EasyListeners.selection((Combo)newCombo, f -> optionText.setEnabled(this.isAdvancedRule(newCombo)));
                ButtonBuilder1 buttonBuilder = EasySWT.buildPushButton((Composite)newRuleContainer);
                buttonBuilder.text = "Always";
                buttonBuilder.setSwtOptions(32);
                Button alwaysCheck = buttonBuilder.build();
                EasySWT.makePushButton((Composite)newRuleContainer, (String)"Add", (int)1, v -> {
                    if (newCombo.getSelectionIndex() != 0) {
                        if (this.isAdvancedRule(newCombo) && optionText.getText().isEmpty()) {
                            optionText.setFocus();
                            return;
                        }
                        SpecialSymbols.DetectionRule newRule = SpecialSymbols.getEquivalentRule(newCombo.getText(), alwaysCheck.getSelection());
                        if (newRule instanceof SpecialSymbols.AdvancedDetectionRule) {
                            ((SpecialSymbols.AdvancedDetectionRule)newRule).setOption(optionText.getText());
                        }
                        ruleList.add(newRule);
                    }
                    okButton.setEnabled(true);
                    this.buildRuleView(container, ruleList, okButton);
                });
                okButton.setEnabled(false);
                this.dialog.pack(true);
                container.layout(true);
                newRuleContainer.layout(true);
            });
        }

        private boolean isAdvancedRule(Combo combo) {
            return combo.getSelectionIndex() >= combo.getItemCount() - 4;
        }
    }
}

