/*
 * Decompiled with CFR 0.152.
 */
package org.brailleblaster.frontmatter;

import com.google.common.collect.Iterators;
import com.google.common.collect.PeekingIterator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import nu.xom.Attribute;
import nu.xom.Document;
import nu.xom.Element;
import nu.xom.Node;
import nu.xom.Nodes;
import nu.xom.ParentNode;
import org.brailleblaster.BBIni;
import org.brailleblaster.abstractClasses.BBEditorView;
import org.brailleblaster.bbx.BBX;
import org.brailleblaster.bbx.BBXUtils;
import org.brailleblaster.bbx.BBXUtilsKt;
import org.brailleblaster.exceptions.BBNotifyException;
import org.brailleblaster.frontmatter.TOCBuilderBBX$applyTOCPage$;
import org.brailleblaster.frontmatter.TOCBuilderBBX$isSkippableTOCBlock$;
import org.brailleblaster.frontmatter.TOCBuilderBBX$isValidToMakePage$;
import org.brailleblaster.frontmatter.TOCBuilderBBX$unwrapPage$;
import org.brailleblaster.frontmatter.VolumeUtils;
import org.brailleblaster.math.mathml.MathModuleUtils;
import org.brailleblaster.perspectives.braille.Manager;
import org.brailleblaster.perspectives.braille.messages.Sender;
import org.brailleblaster.perspectives.braille.searcher.Searcher;
import org.brailleblaster.perspectives.braille.toolbar.CustomToolBarBuilder;
import org.brailleblaster.perspectives.mvc.SimpleEvent;
import org.brailleblaster.perspectives.mvc.XMLSelection;
import org.brailleblaster.perspectives.mvc.XMLTextCaret;
import org.brailleblaster.perspectives.mvc.events.BBViewListener;
import org.brailleblaster.perspectives.mvc.events.BuildMenuEvent;
import org.brailleblaster.perspectives.mvc.events.BuildToolBarEvent;
import org.brailleblaster.perspectives.mvc.menu.BBSelectionData;
import org.brailleblaster.perspectives.mvc.menu.MenuManager;
import org.brailleblaster.perspectives.mvc.menu.TopMenu;
import org.brailleblaster.perspectives.mvc.modules.views.DebugModule;
import org.brailleblaster.settings.UTDManager;
import org.brailleblaster.tools.CheckMenuTool;
import org.brailleblaster.tools.MenuToolModule;
import org.brailleblaster.utd.IStyle;
import org.brailleblaster.utd.Style;
import org.brailleblaster.utd.exceptions.NodeException;
import org.brailleblaster.utd.internal.xml.FastXPath;
import org.brailleblaster.utd.internal.xml.XMLHandler;
import org.brailleblaster.utd.internal.xml.XMLHandlerKt;
import org.brailleblaster.utd.toc.TOCAttributes;
import org.brailleblaster.utd.utils.UTDHelper;
import org.brailleblaster.util.Notify;
import org.brailleblaster.utils.PropertyFileManager;
import org.brailleblaster.utils.swt.ButtonBuilder;
import org.brailleblaster.utils.swt.ComboBuilder;
import org.brailleblaster.utils.swt.EasySWT;
import org.brailleblaster.utils.swt.TextBuilder;
import org.brailleblaster.utils.xom.NodeUtilsKt;
import org.brailleblaster.wordprocessor.WPManager;
import org.eclipse.swt.custom.VerifyKeyListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u00a6\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u000f\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\f\u0018\u0000 f2\u00020\u00012\u00020\u00022\u00020\u00032\u00020\u0004:\u0001fB\u000f\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0010\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020$H\u0016J\u0010\u0010%\u001a\u00020\"2\u0006\u0010&\u001a\u00020'H\u0016J\u0010\u0010(\u001a\u00020\"2\u0006\u0010)\u001a\u00020*H\u0002J\u0010\u0010+\u001a\u00020\"2\u0006\u0010&\u001a\u00020,H\u0016J\u0010\u0010-\u001a\u00020\"2\u0006\u0010.\u001a\u00020/H\u0016J\u0010\u00100\u001a\u00020\"2\u0006\u0010.\u001a\u00020/H\u0016J\b\u0010=\u001a\u00020\"H\u0002J\u0012\u0010>\u001a\u00020\"2\b\u0010?\u001a\u0004\u0018\u00010\u001aH\u0002J\b\u0010@\u001a\u00020\"H\u0002J\u001a\u0010A\u001a\u0004\u0018\u00010B2\u0006\u0010C\u001a\u00020D2\u0006\u0010E\u001a\u00020\nH\u0002J\u0010\u0010F\u001a\u00020\n2\u0006\u0010G\u001a\u00020DH\u0002J\u000e\u0010H\u001a\u00020\n2\u0006\u0010I\u001a\u00020BJ.\u0010J\u001a\u00020\"2\u0006\u0010K\u001a\u00020B2\u0006\u0010L\u001a\u00020\u001a2\u0006\u0010M\u001a\u00020N2\f\u0010O\u001a\b\u0012\u0004\u0012\u00020D0PH\u0002J&\u0010Q\u001a\u00020\"2\u0006\u0010K\u001a\u00020B2\f\u0010O\u001a\b\u0012\u0004\u0012\u00020D0P2\u0006\u0010M\u001a\u00020NH\u0002J\u0010\u0010R\u001a\u0002022\u0006\u0010S\u001a\u00020\u001aH\u0002J\u0012\u0010T\u001a\u0004\u0018\u00010\u001a2\u0006\u0010U\u001a\u00020\u001aH\u0002J\u001e\u0010V\u001a\u00020\"2\u0006\u0010W\u001a\u00020D2\f\u0010O\u001a\b\u0012\u0004\u0012\u00020D0PH\u0002J\u0006\u0010X\u001a\u00020\"J\u0010\u0010Y\u001a\u00020\"2\u0006\u0010Z\u001a\u00020[H\u0002J$\u0010\\\u001a\u0004\u0018\u00010B2\u0006\u0010]\u001a\u00020B2\u0006\u0010^\u001a\u00020B2\b\u0010_\u001a\u0004\u0018\u00010BH\u0002J\b\u0010c\u001a\u00020\"H\u0002J\u0012\u0010d\u001a\u0004\u0018\u00010\u001a2\u0006\u0010e\u001a\u00020\u001aH\u0002R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\t\u001a\u00020\nX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000eR\u0010\u0010\u000f\u001a\u0004\u0018\u00010\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0011\u001a\u0004\u0018\u00010\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0012\u001a\u0004\u0018\u00010\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0013\u001a\u0004\u0018\u00010\u0014X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0015\u001a\u0004\u0018\u00010\u0014X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0016\u001a\u0004\u0018\u00010\u0017X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0019\u001a\u00020\u001a8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001b\u0010\u001cR\u0014\u0010\u001d\u001a\u00020\u001e8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001f\u0010 R\u0014\u00101\u001a\u0002028BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b3\u00104R\u0014\u00105\u001a\u0002028BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b6\u00104R\u0014\u00107\u001a\u00020\n8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b7\u0010\fR\u0014\u00108\u001a\u00020\n8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b8\u0010\fR\u0014\u00109\u001a\u00020\u001a8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b:\u0010\u001cR\u0014\u0010;\u001a\u00020\u001a8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b<\u0010\u001cR\u0014\u0010`\u001a\u00020N8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\ba\u0010b\u00a8\u0006g"}, d2={"Lorg/brailleblaster/frontmatter/TOCBuilderBBX;", "Lorg/brailleblaster/tools/CheckMenuTool;", "Lorg/brailleblaster/tools/MenuToolModule;", "Lorg/brailleblaster/perspectives/mvc/events/BBViewListener;", "Lorg/eclipse/swt/custom/VerifyKeyListener;", "manager", "Lorg/brailleblaster/perspectives/braille/Manager;", "<init>", "(Lorg/brailleblaster/perspectives/braille/Manager;)V", "active", "", "getActive", "()Z", "setActive", "(Z)V", "indentText", "Lorg/eclipse/swt/widgets/Text;", "runoverText", "pageNumberPrefix", "overrideLevel", "Lorg/eclipse/swt/widgets/Button;", "findPageCheck", "headerCombo", "Lorg/eclipse/swt/widgets/Combo;", "enableChanged", "title", "", "getTitle", "()Ljava/lang/String;", "topMenu", "Lorg/brailleblaster/perspectives/mvc/menu/TopMenu;", "getTopMenu", "()Lorg/brailleblaster/perspectives/mvc/menu/TopMenu;", "onRun", "", "bbData", "Lorg/brailleblaster/perspectives/mvc/menu/BBSelectionData;", "onEvent", "event", "Lorg/brailleblaster/perspectives/mvc/SimpleEvent;", "buildToolbar", "parent", "Lorg/eclipse/swt/widgets/Composite;", "verifyKey", "Lorg/eclipse/swt/events/VerifyEvent;", "initializeListener", "view", "Lorg/brailleblaster/abstractClasses/BBEditorView;", "removeListener", "indent", "", "getIndent", "()I", "runover", "getRunover", "isOverrideLevelEnabled", "isFindPageEnabled", "findPagePrefixOrException", "getFindPagePrefixOrException", "findPagePrefix", "getFindPagePrefix", "pressedApplyTitle", "pressedApplyHeading", "style", "pressedApplyPage", "isValidToMakePage", "Lnu/xom/Element;", "node", "Lnu/xom/Node;", "isFullySelected", "unwrapPage", "cursor", "isSkippableTOCBlock", "curBlock", "applyTOC", "block", "type", "utdMan", "Lorg/brailleblaster/settings/UTDManager;", "modifiedNodes", "", "applyTOCPage", "indexOfPage", "rawText", "parsePageNumber", "input", "pageNumStripPrecedingText", "pageNum", "pressedInsertVolumeSplit", "regenerateAllTOC", "doc", "Lnu/xom/Document;", "findAndAppendPrecedingPageNumber", "tocEntry", "tocContainer", "previousPageNum", "uTDManager", "getUTDManager", "()Lorg/brailleblaster/settings/UTDManager;", "close", "getHeadingText", "headingText", "Companion", "brailleblaster-core"})
@SourceDebugExtension(value={"SMAP\nTOCBuilderBBX.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TOCBuilderBBX.kt\norg/brailleblaster/frontmatter/TOCBuilderBBX\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 5 Strings.kt\nkotlin/text/StringsKt__StringsKt\n*L\n1#1,1327:1\n1#2:1328\n1342#3,2:1329\n479#3:1341\n2296#3,2:1342\n479#3:1344\n184#3,2:1345\n479#3:1347\n479#3:1348\n1276#3,2:1349\n479#3:1351\n321#3,7:1352\n479#3:1359\n321#3,7:1360\n1297#3,3:1471\n777#4:1331\n873#4,2:1332\n1586#4:1334\n1661#4,3:1335\n777#4:1338\n873#4,2:1339\n812#4,12:1459\n777#4:1474\n873#4,2:1475\n777#4:1477\n873#4,2:1478\n106#5:1367\n78#5,22:1368\n106#5:1390\n78#5,22:1391\n106#5:1413\n78#5,22:1414\n106#5:1436\n78#5,22:1437\n*S KotlinDebug\n*F\n+ 1 TOCBuilderBBX.kt\norg/brailleblaster/frontmatter/TOCBuilderBBX\n*L\n449#1:1329,2\n715#1:1341\n716#1:1342,2\n736#1:1344\n737#1:1345,2\n754#1:1347\n786#1:1348\n787#1:1349,2\n793#1:1351\n794#1:1352,7\n814#1:1359\n814#1:1360,7\n1041#1:1471,3\n694#1:1331\n694#1:1332,2\n695#1:1334\n695#1:1335,3\n711#1:1338\n711#1:1339,2\n983#1:1459,12\n1120#1:1474\n1120#1:1475,2\n1165#1:1477\n1165#1:1478,2\n845#1:1367\n845#1:1368,22\n847#1:1390\n847#1:1391,22\n853#1:1413\n853#1:1414,22\n854#1:1436\n854#1:1437,22\n*E\n"})
public final class TOCBuilderBBX
implements CheckMenuTool,
MenuToolModule,
BBViewListener,
VerifyKeyListener {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private Manager manager;
    private boolean active;
    @Nullable
    private Text indentText;
    @Nullable
    private Text runoverText;
    @Nullable
    private Text pageNumberPrefix;
    @Nullable
    private Button overrideLevel;
    @Nullable
    private Button findPageCheck;
    @Nullable
    private Combo headerCombo;
    private boolean enableChanged;
    @NotNull
    public static final String SETTING_OVERRIDE_LEVEL = "tocBuilderBBX.overrideLevelEnabled";
    @NotNull
    public static final String SETTING_PAGE_PREFIX_ENABLED = "tocBuilderBBX.pagePrefixEnabled";
    @NotNull
    public static final String SETTING_PAGE_PREFIX = "tocBuilderBBX.pagePrefix";
    @NotNull
    public static final String SETTING_ENABLED = "tocBuilderBBX.enabled";
    @NotNull
    public static final String SWTBOT_TOC_ENTRY_BUTTON = "tocBuilderBBX.tocEntry";
    @NotNull
    public static final String SWTBOT_PAGE_NUM_BUTTON = "tocBuilderBBX.pageNum";
    @NotNull
    public static final String SWTBOT_PAGE_PREFIX_CHECK = "tocBuilderBBX.pagePrefixCheck";
    @NotNull
    public static final String SWTBOT_PAGE_PREFIX_TEXT = "tocBuilderBBX.pagePrefix";
    @NotNull
    public static final String SWTBOT_OVERRIDE_LEVEL = "tocBuilderBBX.overrideLevel";
    @NotNull
    public static final String SWTBOT_INDENT_TEXT = "tocBuilderBBX.indent";
    @NotNull
    public static final String SWTBOT_RUNOVER_TEXT = "tocBuilderBBX.runover";
    @NotNull
    public static final String SWTBOT_HEADING_COMBO = "tocBuilderBBX.headingCombo";
    @NotNull
    public static final String SWTBOT_VOLUME_SPLIT_BUTTON = "tocBuilderBBX.volumeSplit";
    @NotNull
    public static final String SWTBOT_DISPERSE_VOLUMES_BUTTON = "tocBuilderBBX.regenerateVolumes";
    @NotNull
    public static final String SWTBOT_HEADING_BUTTON = "tocBuilerBBX.headingButton";
    @NotNull
    private static final Logger log;
    @NotNull
    private static final Pattern MATCH_ROMAN_NUMERALS;
    private static final int CUR_INDENT = 1;
    private static final int CUR_RUNOVER = 3;
    @JvmField
    public static boolean test_diffTOCSplitsThanVolumes;

    public TOCBuilderBBX(@NotNull Manager manager) {
        Intrinsics.checkNotNullParameter((Object)manager, (String)"manager");
        this.manager = manager;
        this.active = BBIni.getPropertyFileManager().getPropertyAsBoolean(SETTING_ENABLED, false);
    }

    @Override
    public boolean getActive() {
        return this.active;
    }

    public void setActive(boolean bl) {
        this.active = bl;
    }

    @Override
    @NotNull
    public String getTitle() {
        return "TOC Builder";
    }

    @Override
    @NotNull
    public TopMenu getTopMenu() {
        return TopMenu.DEBUG;
    }

    @Override
    public void onRun(@NotNull BBSelectionData bbData) {
        Intrinsics.checkNotNullParameter((Object)bbData, (String)"bbData");
        this.setActive(!this.getActive());
        BBIni.getPropertyFileManager().saveAsBoolean(SETTING_ENABLED, this.getActive());
        this.enableChanged = true;
        WPManager.Companion.getInstance().buildToolBar();
    }

    @Override
    public void onEvent(@NotNull SimpleEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        if (event instanceof BuildMenuEvent && DebugModule.enabled) {
            this.manager = event.getManager().getManager();
            MenuManager.INSTANCE.add(this);
        }
        if (event instanceof BuildToolBarEvent && this.getActive()) {
            WPManager.Companion.getInstance().getCurrentPerspective().addToToolBar(CustomToolBarBuilder.Companion.userDefined(arg_0 -> TOCBuilderBBX.onEvent$lambda$0(this, arg_0)));
        }
    }

    private final void buildToolbar(Composite parent) {
        Intrinsics.checkNotNull((Object)parent.getLayout(), (String)"null cannot be cast to non-null type org.eclipse.swt.layout.GridLayout");
        ((GridLayout)parent.getLayout()).numColumns = 99;
        ButtonBuilder entryButton = ((ButtonBuilder)EasySWT.INSTANCE.makeButton(parent, 8).text("TOC Entry (F4)").swtBotId(SWTBOT_TOC_ENTRY_BUTTON)).onSelection(arg_0 -> TOCBuilderBBX.buildToolbar$lambda$0(this, arg_0));
        this.overrideLevel = (Button)((ButtonBuilder)EasySWT.INSTANCE.makeCheckbox(parent).text("Override Margin:").onSelection(arg_0 -> TOCBuilderBBX.buildToolbar$lambda$1(this, arg_0)).selected(this.isOverrideLevelEnabled()).swtBotId(SWTBOT_OVERRIDE_LEVEL)).get();
        this.indentText = (Text)((TextBuilder)((TextBuilder)EasySWT.INSTANCE.makeTextBuilder(parent, 2052).text("1").swtBotId(SWTBOT_INDENT_TEXT)).gridDataWidth(EasySWT.getWidthOfText((String)"WW"))).get();
        EasySWT.INSTANCE.newLabel(parent, "-");
        this.runoverText = (Text)((TextBuilder)((TextBuilder)EasySWT.INSTANCE.makeTextBuilder(parent, 2052).text("3").swtBotId(SWTBOT_RUNOVER_TEXT)).gridDataWidth(EasySWT.getWidthOfText((String)"WW"))).get();
        this.findPageCheck = (Button)((ButtonBuilder)EasySWT.INSTANCE.makeCheckbox(parent).text("Find Page | Page Prefix").onSelection(arg_0 -> TOCBuilderBBX.buildToolbar$lambda$2(this, arg_0)).selected(this.isFindPageEnabled()).swtBotId(SWTBOT_PAGE_PREFIX_CHECK)).get();
        this.pageNumberPrefix = (Text)((TextBuilder)((TextBuilder)EasySWT.INSTANCE.makeTextBuilder(parent, 2052).text(this.getFindPagePrefix()).onModify(arg_0 -> TOCBuilderBBX.buildToolbar$lambda$3(this, arg_0)).swtBotId("tocBuilderBBX.pagePrefix")).gridDataWidth(EasySWT.getWidthOfText((String)"WW"))).get();
        EasySWT.INSTANCE.newLabel(parent, "|");
        this.headerCombo = (Combo)((ComboBuilder)EasySWT.makeComboDropdown((Composite)parent).add("Headings...").add("Centered").add("Centered NB").add("Cell 5").add("Cell 7").select(0).swtBotId(SWTBOT_HEADING_COMBO)).get();
        EasySWT.INSTANCE.makeButton(parent, 8).text("Apply Heading").onSelection(arg_0 -> TOCBuilderBBX.buildToolbar$lambda$4(this, arg_0)).swtBotId(SWTBOT_HEADING_BUTTON);
        EasySWT.INSTANCE.newLabel(parent, "|");
        EasySWT.INSTANCE.makeButton(parent, 8).text("Page Number").onSelection(arg_0 -> TOCBuilderBBX.buildToolbar$lambda$5(this, arg_0)).swtBotId(SWTBOT_PAGE_NUM_BUTTON);
        EasySWT.INSTANCE.newLabel(parent, "|");
        EasySWT.INSTANCE.makeButton(parent, 8).text("Volume Split").onSelection(arg_0 -> TOCBuilderBBX.buildToolbar$lambda$6(this, arg_0)).swtBotId(SWTBOT_VOLUME_SPLIT_BUTTON);
        EasySWT.INSTANCE.makeButton(parent, 8).text("Disperse to Volumes").onSelection(arg_0 -> TOCBuilderBBX.buildToolbar$lambda$7(this, arg_0)).swtBotId(SWTBOT_DISPERSE_VOLUMES_BUTTON);
        ((ButtonBuilder)EasySWT.INSTANCE.makeButton(parent, 8).text("X").setAccessibleName("Close TOC Builder")).onSelection(arg_0 -> TOCBuilderBBX.buildToolbar$lambda$8(this, arg_0));
        if (this.enableChanged) {
            ((Button)entryButton.get()).setFocus();
            this.enableChanged = false;
        }
    }

    public void verifyKey(@NotNull VerifyEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        if (!this.getActive()) {
            return;
        }
        log.debug("event {} widget is text view {}", (Object)event, (Object)(event.getSource() == this.manager.getTextView() ? 1 : 0));
        if (event.keyCode == 0x100000D) {
            this.pressedApplyTitle();
            event.doit = false;
        } else if (event.character == '+' || event.character == '=') {
            if (event.stateMask == 65536) {
                int indent = this.getIndent();
                log.debug("running, old indent {}", (Object)indent);
                Text text = this.indentText;
                Intrinsics.checkNotNull((Object)text);
                text.setText("" + (indent + 2));
                event.doit = false;
            } else if (event.stateMask == 196608) {
                int runover = this.getRunover();
                log.debug("running, old runover {}", (Object)runover);
                Text text = this.runoverText;
                Intrinsics.checkNotNull((Object)text);
                text.setText("" + (runover + 2));
                event.doit = false;
            }
        } else if (event.character == '-') {
            if (event.stateMask == 65536) {
                int indent = this.getIndent();
                log.debug("running, old indent {}", (Object)indent);
                Text text = this.indentText;
                Intrinsics.checkNotNull((Object)text);
                text.setText("" + (indent - 2));
                event.doit = false;
            } else if (event.stateMask == 196608) {
                int runover = this.getRunover();
                log.debug("running, old runover {}", (Object)runover);
                Text text = this.runoverText;
                Intrinsics.checkNotNull((Object)text);
                text.setText("" + (runover - 2));
                event.doit = false;
            }
        } else if (event.keyCode == 27) {
            this.close();
        }
    }

    @Override
    public void initializeListener(@NotNull BBEditorView view) {
        Intrinsics.checkNotNullParameter((Object)view, (String)"view");
        if (view.getView() != this.manager.getBrailleView()) {
            view.getView().addVerifyKeyListener((VerifyKeyListener)this);
        }
    }

    @Override
    public void removeListener(@NotNull BBEditorView view) {
        Intrinsics.checkNotNullParameter((Object)view, (String)"view");
        if (view.getView() != this.manager.getBrailleView()) {
            view.getView().removeVerifyKeyListener((VerifyKeyListener)this);
        }
    }

    private final int getIndent() {
        int indent = 0;
        try {
            Text text = this.indentText;
            Intrinsics.checkNotNull((Object)text);
            String string = text.getText();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
            indent = Integer.parseInt(string);
        }
        catch (NumberFormatException e) {
            throw new BBNotifyException("Indent is not a number", (Throwable)e);
        }
        if (indent % 2 != 1) {
            throw new BBNotifyException("Invalid indent");
        }
        return indent;
    }

    private final int getRunover() {
        int runover = 0;
        try {
            Text text = this.runoverText;
            Intrinsics.checkNotNull((Object)text);
            String string = text.getText();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
            runover = Integer.parseInt(string);
        }
        catch (NumberFormatException e) {
            throw new BBNotifyException("Runover is not a number", (Throwable)e);
        }
        if (runover % 2 != 1) {
            throw new BBNotifyException("Invalid runover");
        }
        return runover;
    }

    private final boolean isOverrideLevelEnabled() {
        return Intrinsics.areEqual((Object)BBIni.getPropertyFileManager().getProperty(SETTING_OVERRIDE_LEVEL, "true"), (Object)"true");
    }

    private final boolean isFindPageEnabled() {
        return Intrinsics.areEqual((Object)BBIni.getPropertyFileManager().getProperty(SETTING_PAGE_PREFIX_ENABLED, "true"), (Object)"true");
    }

    private final String getFindPagePrefixOrException() {
        if (!this.isFindPageEnabled()) {
            boolean bl = false;
            String string = "Attempting to use findPagePrefix but findPage is disabled";
            throw new IllegalStateException(string.toString());
        }
        return this.getFindPagePrefix();
    }

    private final String getFindPagePrefix() {
        return BBIni.getPropertyFileManager().getProperty("tocBuilderBBX.pagePrefix", "");
    }

    /*
     * WARNING - void declaration
     */
    private final void pressedApplyTitle() {
        this.manager.stopFormatting();
        int indentTarget = BBXUtils.INSTANCE.indentToLevel(this.getIndent());
        int runoverTarget = BBXUtils.INSTANCE.runoverToLevel(this.getRunover());
        if (indentTarget > runoverTarget) {
            throw new BBNotifyException("Indent cannot be larger than runover");
        }
        log.debug("set indent {} runover {}", (Object)indentTarget, (Object)runoverTarget);
        List modifiedNodes = new ArrayList();
        for (Element curBlock : this.manager.getSimpleManager().getCurrentSelection().getSelectedBlocks()) {
            if (!MathModuleUtils.blockContainsMath((Node)curBlock)) continue;
            Notify.notify$default(Notify.INSTANCE, "Cannot make TOC from math", "Error", false, 4, null);
            return;
        }
        for (Element curBlock : this.manager.getSimpleManager().getCurrentSelection().getSelectedBlocks()) {
            Element ancestorList;
            if (curBlock.getDocument() == null || BBXUtilsKt.isPageNumEffectively((Node)curBlock)) continue;
            log.debug("ToXML {}", (Object)curBlock.toXML());
            if (this.isSkippableTOCBlock(curBlock)) continue;
            Integer indentBlock = null;
            Integer runoverBlock = null;
            if (BBX.BLOCK.LIST_ITEM.isA((Node)curBlock)) {
                indentBlock = (Integer)BBX.BLOCK.LIST_ITEM.ATTRIB_ITEM_LEVEL.get(curBlock);
                runoverBlock = BBXUtilsKt.getAncestorListLevel((Node)curBlock);
            } else if (BBX.BLOCK.MARGIN.isA((Node)curBlock)) {
                indentBlock = (Integer)BBX.BLOCK.MARGIN.ATTRIB_INDENT.get(curBlock);
                runoverBlock = (Integer)BBX.BLOCK.MARGIN.ATTRIB_RUNOVER.get(curBlock);
            } else {
                IStyle style = this.manager.getStyle((Node)curBlock);
                if (style != null) {
                    String string = style.getName();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
                    BBXUtils.ListStyleData listStyle = BBXUtils.INSTANCE.parseListStyle(string);
                    if (listStyle != null) {
                        indentBlock = BBXUtils.INSTANCE.indentToLevel(listStyle.getIndent());
                        runoverBlock = BBXUtils.INSTANCE.runoverToLevel(listStyle.getRunover());
                    }
                }
            }
            Object object = this.manager.getDocument().getSettingsManager().getEngine().getStyleMap().findValueOrDefault((Node)curBlock);
            Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type org.brailleblaster.utd.Style");
            Style blockStyle = (Style)object;
            String tocStyleName = "TOC " + blockStyle.getName();
            if (!this.isOverrideLevelEnabled() && UTDManager.Companion.isStyle(blockStyle, "Heading") && this.manager.getDocument().getSettingsManager().getEngine().getStyleDefinitions().getStyleByName(tocStyleName) != null) {
                this.applyTOC(curBlock, "heading", this.getUTDManager(), modifiedNodes);
                BBX._ATTRIB_OVERRIDE_STYLE.set(curBlock, tocStyleName);
                continue;
            }
            this.applyTOC(curBlock, "title", this.getUTDManager(), modifiedNodes);
            if (!this.isOverrideLevelEnabled() && indentBlock != null) {
                BBX.BLOCK.MARGIN.ATTRIB_INDENT.set(curBlock, indentBlock);
                BBX.BLOCK.MARGIN.ATTRIB_RUNOVER.set(curBlock, runoverBlock);
            } else {
                BBX.BLOCK.MARGIN.ATTRIB_INDENT.set(curBlock, indentTarget);
                BBX.BLOCK.MARGIN.ATTRIB_RUNOVER.set(curBlock, runoverTarget);
            }
            if (this.isOverrideLevelEnabled() && indentBlock != null && (ancestorList = XMLHandler.Companion.ancestorVisitorElement((Node)curBlock, TOCBuilderBBX::pressedApplyTitle$lambda$0)) != null) {
                void $this$forEach$iv;
                if (((Number)BBX.CONTAINER.LIST.ATTRIB_LIST_LEVEL.get(ancestorList)).intValue() < runoverTarget) {
                    BBX.CONTAINER.LIST.ATTRIB_LIST_LEVEL.set(ancestorList, runoverTarget);
                    modifiedNodes.add(ancestorList);
                }
                Sequence sequence = SequencesKt.onEach((Sequence)SequencesKt.filter((Sequence)FastXPath.descendant((Node)((Node)ancestorList)), arg_0 -> TOCBuilderBBX.pressedApplyTitle$lambda$1(runoverTarget, arg_0)), arg_0 -> TOCBuilderBBX.pressedApplyTitle$lambda$2(modifiedNodes, arg_0));
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    Node node = (Node)element$iv;
                    boolean bl = false;
                    BBX.BLOCK.MARGIN.ATTRIB_RUNOVER.set((Element)node, runoverTarget);
                }
            }
            log.debug("updated margins of {}", (Object)curBlock.toXML());
            BBX.transform(curBlock, BBX.BLOCK.MARGIN);
            BBX.BLOCK.MARGIN.ATTRIB_MARGIN_TYPE.set(curBlock, BBX.MarginType.TOC);
        }
        this.manager.getSimpleManager().dispatchEvent(new org.brailleblaster.perspectives.mvc.events.ModifyEvent(Sender.TOC, modifiedNodes, true));
    }

    private final void pressedApplyHeading(String style) {
        if (style == null) {
            throw new BBNotifyException("No heading was selected.");
        }
        this.manager.stopFormatting();
        List modifiedNodes = new ArrayList();
        for (Element curBlock : this.manager.getSimpleManager().getCurrentSelection().getSelectedBlocks()) {
            if (this.isSkippableTOCBlock(curBlock)) continue;
            this.applyTOC(curBlock, "heading", this.getUTDManager(), modifiedNodes);
            BBX.transform(curBlock, BBX.BLOCK.STYLE);
            BBX._ATTRIB_OVERRIDE_STYLE.set(curBlock, style);
        }
        this.manager.getSimpleManager().dispatchEvent(new org.brailleblaster.perspectives.mvc.events.ModifyEvent(Sender.TOC, modifiedNodes, true));
        Combo combo = this.headerCombo;
        Intrinsics.checkNotNull((Object)combo);
        combo.select(0);
    }

    private final void pressedApplyPage() {
        this.manager.stopFormatting();
        Element pageWrapElem = null;
        Element previousTitleBlock = null;
        List modifiedNodes = new ArrayList();
        XMLSelection currentSelection = this.manager.getSimpleManager().getCurrentSelection();
        if (currentSelection.start == currentSelection.end) {
            Element element;
            if (currentSelection.start.getNode() instanceof Element) {
                Node node = currentSelection.start.getNode();
                Intrinsics.checkNotNull((Object)node, (String)"null cannot be cast to non-null type nu.xom.Element");
                element = (Element)node;
            } else {
                element = BBXUtilsKt.findBlock(currentSelection.start.getNode());
            }
            pageWrapElem = element;
            log.debug("initial {}", (Object)pageWrapElem.toXML());
            previousTitleBlock = this.isValidToMakePage((Node)pageWrapElem, true);
            Element parentBlock = BBXUtilsKt.findBlock((Node)pageWrapElem);
            UTDHelper.stripUTDRecursive((Element)parentBlock);
            modifiedNodes.add(parentBlock);
            if (this.unwrapPage((Node)pageWrapElem)) {
                this.manager.getSimpleManager().dispatchEvent(new org.brailleblaster.perspectives.mvc.events.ModifyEvent(Sender.TOC, modifiedNodes, true));
                return;
            }
        } else {
            if (!(currentSelection.start instanceof XMLTextCaret) || !(currentSelection.end instanceof XMLTextCaret)) {
                throw new BBNotifyException("Can only select text");
            }
            if (((XMLTextCaret)currentSelection.start).getNode() != ((XMLTextCaret)currentSelection.end).getNode()) {
                throw new BBNotifyException("Selecting multiple pieces of text for page number is unsupported");
            }
            XMLTextCaret selectionStart = (XMLTextCaret)currentSelection.start;
            XMLTextCaret selectionEnd = (XMLTextCaret)currentSelection.end;
            nu.xom.Text textNode = selectionEnd.getNode();
            Element parentBlock = BBXUtilsKt.findBlock((Node)textNode);
            if (this.unwrapPage((Node)textNode)) {
                UTDHelper.stripUTDRecursive((Element)parentBlock);
                modifiedNodes.add(parentBlock);
                this.manager.getSimpleManager().dispatchEvent(new org.brailleblaster.perspectives.mvc.events.ModifyEvent(Sender.TOC, modifiedNodes, true));
                return;
            }
            boolean isFullySelected = selectionStart.getOffset() == 0 && selectionEnd.getOffset() >= selectionEnd.getNode().getValue().length();
            previousTitleBlock = this.isValidToMakePage((Node)textNode, isFullySelected);
            Element parentTitle = XMLHandler.Companion.ancestorVisitorElement((Node)textNode, TOCBuilderBBX::pressedApplyPage$lambda$0);
            Element existingPage = parentTitle == null ? null : XMLHandler.Companion.childrenRecursiveVisitor(parentTitle, TOCBuilderBBX::pressedApplyPage$lambda$1);
            modifiedNodes.add(parentBlock);
            UTDHelper.stripUTDRecursive((Element)parentBlock);
            if (isFullySelected) {
                ParentNode parentNode = textNode.getParent();
                Intrinsics.checkNotNull((Object)parentNode, (String)"null cannot be cast to non-null type nu.xom.Element");
                pageWrapElem = (Element)parentNode;
            } else {
                nu.xom.Text textNodeToWrap = null;
                if (selectionStart.getOffset() == 0) {
                    var14_13 = new int[]{selectionEnd.getOffset()};
                    splitTextNodes = XMLHandlerKt.splitNode((nu.xom.Text)textNode, (int[])var14_13);
                    textNodeToWrap = (nu.xom.Text)splitTextNodes.get(0);
                } else {
                    var14_13 = new int[]{selectionStart.getOffset(), selectionEnd.getOffset()};
                    splitTextNodes = XMLHandlerKt.splitNode((nu.xom.Text)textNode, (int[])var14_13);
                    textNodeToWrap = (nu.xom.Text)splitTextNodes.get(1);
                }
                if (existingPage != null) {
                    UTDHelper.stripUTDRecursive((Element)existingPage);
                    pageWrapElem = existingPage;
                    textNodeToWrap.detach();
                    String string = textNodeToWrap.getValue();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getValue(...)");
                    Object text = string;
                    if (((String)text).charAt(((String)text).length() - 1) != ' ') {
                        text = (String)text + " ";
                    }
                    String string2 = UTDHelper.getTextChild((Element)pageWrapElem).getValue();
                    Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getValue(...)");
                    if (((CharSequence)string2).length() == 0) {
                        textNodeToWrap.setValue((String)text);
                        pageWrapElem.insertChild((Node)textNodeToWrap, 0);
                    } else {
                        text = (String)text + pageWrapElem.removeChild((Node)UTDHelper.getTextChild((Element)pageWrapElem)).getValue();
                        textNodeToWrap.setValue((String)text);
                        pageWrapElem.appendChild((Node)textNodeToWrap);
                    }
                } else {
                    Element element = BBX.SPAN.OTHER.create();
                    Intrinsics.checkNotNullExpressionValue((Object)element, (String)"create(...)");
                    pageWrapElem = element;
                    textNodeToWrap.getParent().insertChild((Node)pageWrapElem, textNodeToWrap.getParent().indexOf((Node)textNodeToWrap));
                    textNodeToWrap.detach();
                    pageWrapElem.appendChild((Node)textNodeToWrap);
                }
            }
        }
        log.info("Page wrap elem {}", (Object)pageWrapElem.toXML());
        if (BBX.SECTION.isA((Node)pageWrapElem) || BBX.CONTAINER.isA((Node)pageWrapElem)) {
            throw new BBNotifyException("Cannot select sections or containers");
        }
        if (BBX.BLOCK.isA((Node)pageWrapElem)) {
            Element element = BBX.SPAN.OTHER.create();
            Intrinsics.checkNotNullExpressionValue((Object)element, (String)"create(...)");
            spanWrapper = element;
            while (pageWrapElem.getChildCount() != 0) {
                Node curChild;
                Intrinsics.checkNotNullExpressionValue((Object)pageWrapElem.getChild(0), (String)"getChild(...)");
                curChild.detach();
                spanWrapper.appendChild(curChild);
            }
            pageWrapElem.appendChild((Node)spanWrapper);
            pageWrapElem = spanWrapper;
        } else if (BBX.INLINE.isA((Node)pageWrapElem)) {
            Element element = BBX.SPAN.OTHER.create();
            Intrinsics.checkNotNullExpressionValue((Object)element, (String)"create(...)");
            spanWrapper = element;
            pageWrapElem.getParent().replaceChild((Node)pageWrapElem, (Node)spanWrapper);
            spanWrapper.appendChild((Node)pageWrapElem);
            pageWrapElem = spanWrapper;
        }
        TOCBuilderBBX.Companion.setTOCType(pageWrapElem, "page", this.getUTDManager());
        if (previousTitleBlock != null) {
            pageWrapElem.detach();
            previousTitleBlock.appendChild((Node)pageWrapElem);
        }
        modifiedNodes.add(BBXUtilsKt.findBlock((Node)pageWrapElem));
        this.pageNumStripPrecedingText((Node)pageWrapElem, modifiedNodes);
        this.manager.getSimpleManager().dispatchEvent(new org.brailleblaster.perspectives.mvc.events.ModifyEvent(Sender.TOC, modifiedNodes, true));
    }

    /*
     * WARNING - void declaration
     */
    private final Element isValidToMakePage(Node node, boolean isFullySelected) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Node node2;
        void $this$filterTo$iv$iv;
        Iterable $this$filter$iv;
        Node node3 = node;
        if (BBXUtils.isPageNumAncestor(node3)) {
            throw new BBNotifyException("Cannot convert print page num to TOC page number");
        }
        if (isFullySelected) {
            node3 = (Node)BBXUtilsKt.findBlock(node3);
        }
        Element ancestorTitle = XMLHandler.Companion.ancestorVisitorElement(node3, TOCBuilderBBX::isValidToMakePage$lambda$0);
        Iterable iterable = FastXPath.INSTANCE.preceding(node3);
        boolean $i$f$filter = false;
        void var8_9 = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            node2 = (Node)element$iv$iv;
            boolean bl = false;
            if (!BBX.BLOCK.isA(node2)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filter$iv = (List)destination$iv$iv;
        boolean $i$f$map2 = false;
        $this$filterTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            node2 = (Node)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(Searcher.Mappers.toElement(node2));
        }
        Element previousBlock = (Element)CollectionsKt.firstOrNull((List)((List)destination$iv$iv));
        if (ancestorTitle != null) {
            boolean titleIsFullySelected;
            boolean bl = titleIsFullySelected = ancestorTitle == node3 && isFullySelected;
            if (titleIsFullySelected) {
                void $this$filterTo$iv$iv2;
                Sequence $this$filter$iv2;
                Iterable $i$f$map2 = NodeUtilsKt.getChildNodes((ParentNode)((ParentNode)ancestorTitle));
                boolean $i$f$filter2 = false;
                destination$iv$iv = $this$filter$iv2;
                Collection destination$iv$iv2 = new ArrayList();
                boolean $i$f$filterTo2 = false;
                for (Object element$iv$iv : $this$filterTo$iv$iv2) {
                    Node node4 = (Node)element$iv$iv;
                    boolean bl2 = false;
                    if (!Searcher.Filters.noUTDAncestor(node4)) continue;
                    destination$iv$iv2.add(element$iv$iv);
                }
                if (((List)destination$iv$iv2).size() <= 1) {
                    if (previousBlock != null && previousBlock.getChildCount() <= 1) {
                        boolean bl3;
                        block12: {
                            void $this$none$iv;
                            Sequence $this$filterIsInstance$iv;
                            $this$filter$iv2 = FastXPath.descendant((Node)((Node)previousBlock));
                            boolean $i$f$filterIsInstance = false;
                            Sequence sequence = SequencesKt.filter((Sequence)$this$filterIsInstance$iv, (Function1)isValidToMakePage$$inlined$filterIsInstance$1.INSTANCE);
                            Intrinsics.checkNotNull((Object)sequence, (String)"null cannot be cast to non-null type kotlin.sequences.Sequence<R of kotlin.sequences.SequencesKt___SequencesKt.filterIsInstance>");
                            $this$filterIsInstance$iv = sequence;
                            boolean $i$f$none = false;
                            for (Object element$iv : $this$none$iv) {
                                Element elem = (Element)element$iv;
                                boolean bl4 = false;
                                if (!(TOCAttributes.TYPE.inElement(elem) && Intrinsics.areEqual((Object)TOCAttributes.TYPE.getValue(elem), (Object)"page"))) continue;
                                bl3 = false;
                                break block12;
                            }
                            bl3 = true;
                        }
                        if (bl3) {
                            return previousBlock;
                        }
                    }
                    throw new BBNotifyException("Cannot convert entire title to TOC page number " + isFullySelected);
                }
            }
            return null;
        }
        if (previousBlock == null || !TOCAttributes.TYPE.inElement(previousBlock)) {
            throw new BBNotifyException("Cannot make TOC page without previous title");
        }
        return previousBlock;
    }

    private final boolean unwrapPage(Node cursor) {
        Object v1;
        block2: {
            Sequence $this$filterIsInstance$iv = FastXPath.ancestorOrSelf((Node)cursor);
            boolean $i$f$filterIsInstance = false;
            Sequence sequence = SequencesKt.filter((Sequence)$this$filterIsInstance$iv, (Function1)unwrapPage$$inlined$filterIsInstance$1.INSTANCE);
            Intrinsics.checkNotNull((Object)sequence, (String)"null cannot be cast to non-null type kotlin.sequences.Sequence<R of kotlin.sequences.SequencesKt___SequencesKt.filterIsInstance>");
            Sequence $this$firstOrNull$iv = sequence;
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                Element elem = (Element)element$iv;
                boolean bl = false;
                if (!(TOCAttributes.TYPE.inElement(elem) && Intrinsics.areEqual((Object)TOCAttributes.TYPE.getValue(elem), (Object)"page"))) continue;
                v1 = element$iv;
                break block2;
            }
            v1 = null;
        }
        Element ancestorPageNum = v1;
        if (ancestorPageNum == null) {
            return false;
        }
        TOCAttributes.Companion.removeAll(ancestorPageNum);
        return true;
    }

    public final boolean isSkippableTOCBlock(@NotNull Element curBlock) {
        Intrinsics.checkNotNullParameter((Object)curBlock, (String)"curBlock");
        if (curBlock.getDocument() == null || BBXUtils.isPageNumAncestor((Node)curBlock)) {
            return true;
        }
        Sequence $this$filterIsInstance$iv = FastXPath.descendant((Node)((Node)curBlock));
        boolean $i$f$filterIsInstance = false;
        Sequence sequence = SequencesKt.filter((Sequence)$this$filterIsInstance$iv, (Function1)isSkippableTOCBlock$$inlined$filterIsInstance$1.INSTANCE);
        Intrinsics.checkNotNull((Object)sequence, (String)"null cannot be cast to non-null type kotlin.sequences.Sequence<R of kotlin.sequences.SequencesKt___SequencesKt.filterIsInstance>");
        Sequence textNodes = sequence;
        if (SequencesKt.none((Sequence)textNodes)) {
            return true;
        }
        if (SequencesKt.count((Sequence)textNodes) > 1) {
            return false;
        }
        return BBXUtils.isPageNumAncestor((Node)SequencesKt.first((Sequence)textNodes));
    }

    private final void applyTOC(Element block, String type, UTDManager utdMan, List<Node> modifiedNodes) {
        modifiedNodes.add((Node)block);
        if (this.isFindPageEnabled()) {
            this.applyTOCPage(block, modifiedNodes, utdMan);
        }
        TOCBuilderBBX.Companion.setTOCType(block, type, utdMan);
    }

    /*
     * WARNING - void declaration
     */
    private final void applyTOCPage(Element block, List<Node> modifiedNodes, UTDManager utdMan) {
        Node nextSiblingNode;
        void $this$lastOrNull$iv;
        boolean bl;
        Sequence $this$any$iv;
        Sequence $this$filterIsInstance$iv;
        boolean $i$f$filterIsInstance;
        nu.xom.Text lastTextNode;
        Element moveableBlock;
        int pageStart;
        block36: {
            pageStart = 0;
            moveableBlock = null;
            lastTextNode = null;
            log.debug("curBlock {}", (Object)block.toXML());
            UTDHelper.stripUTDRecursive((Element)block);
            modifiedNodes.add((Node)block);
            Sequence sequence = FastXPath.descendant((Node)((Node)block));
            $i$f$filterIsInstance = false;
            Sequence sequence2 = SequencesKt.filter((Sequence)$this$filterIsInstance$iv, (Function1)applyTOCPage$$inlined$filterIsInstance$1.INSTANCE);
            Intrinsics.checkNotNull((Object)sequence2, (String)"null cannot be cast to non-null type kotlin.sequences.Sequence<R of kotlin.sequences.SequencesKt___SequencesKt.filterIsInstance>");
            $this$filterIsInstance$iv = sequence2;
            boolean $i$f$any = false;
            for (Object element$iv : $this$any$iv) {
                Element elem = (Element)element$iv;
                boolean bl2 = false;
                if (!(TOCAttributes.TYPE.inElement(elem) && Intrinsics.areEqual((Object)TOCAttributes.TYPE.getValue(elem), (Object)"page"))) continue;
                bl = true;
                break block36;
            }
            bl = false;
        }
        if (bl) {
            return;
        }
        $this$any$iv = FastXPath.descendant((Node)((Node)block));
        $i$f$filterIsInstance = false;
        Sequence sequence = SequencesKt.filter((Sequence)$this$filterIsInstance$iv, (Function1)applyTOCPage$$inlined$filterIsInstance$2.INSTANCE);
        Intrinsics.checkNotNull((Object)sequence, (String)"null cannot be cast to non-null type kotlin.sequences.Sequence<R of kotlin.sequences.SequencesKt___SequencesKt.filterIsInstance>");
        $this$filterIsInstance$iv = sequence;
        boolean $i$f$lastOrNull = false;
        Sequence last$iv = null;
        for (Object element$iv : $this$lastOrNull$iv) {
            nu.xom.Text node = (nu.xom.Text)element$iv;
            boolean bl3 = false;
            if (!(!BBXUtils.isPageNumAncestor((Node)node))) continue;
            last$iv = (Sequence)element$iv;
        }
        lastTextNode = (nu.xom.Text)last$iv;
        log.debug("last Text node: {}", (Object)lastTextNode);
        if (lastTextNode == null) {
            return;
        }
        String string = lastTextNode.getValue();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getValue(...)");
        pageStart = this.indexOfPage(string);
        log.debug("pageStart {}", (Object)pageStart);
        if (pageStart == -1 && (nextSiblingNode = XMLHandler.Companion.nextSiblingNode((Node)block)) != null && BBX.BLOCK.isA(nextSiblingNode) && !BBXUtils.isPageNumAncestor(nextSiblingNode)) {
            String $this$lastOrNull$iv2;
            Sequence $this$filterIsInstance$iv2;
            Element nextSibling = (Element)nextSiblingNode;
            UTDHelper.stripUTDRecursive((Element)nextSibling);
            modifiedNodes.add((Node)nextSibling);
            last$iv = FastXPath.descendant((Node)((Node)nextSibling));
            boolean $i$f$filterIsInstance2 = false;
            Sequence sequence3 = SequencesKt.filter((Sequence)$this$filterIsInstance$iv2, (Function1)applyTOCPage$$inlined$filterIsInstance$3.INSTANCE);
            Intrinsics.checkNotNull((Object)sequence3, (String)"null cannot be cast to non-null type kotlin.sequences.Sequence<R of kotlin.sequences.SequencesKt___SequencesKt.filterIsInstance>");
            $this$filterIsInstance$iv2 = sequence3;
            int $i$f$lastOrNull2 = 0;
            Object last$iv2 = null;
            Iterator node = $this$lastOrNull$iv2.iterator();
            while (node.hasNext()) {
                Object element$iv = node.next();
                nu.xom.Text node2 = (nu.xom.Text)element$iv;
                boolean bl4 = false;
                if (!(!BBXUtils.isPageNumAncestor((Node)node2))) continue;
                last$iv2 = element$iv;
            }
            lastTextNode = last$iv2;
            if (lastTextNode == null) {
                return;
            }
            moveableBlock = Companion.isPageMovable((Node)lastTextNode);
            if (moveableBlock == null) {
                return;
            }
            String string2 = lastTextNode.getValue();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getValue(...)");
            pageStart = this.indexOfPage(string2);
            if (pageStart != -1) {
                String string3 = lastTextNode.getValue();
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"getValue(...)");
                $this$lastOrNull$iv2 = string3;
                $i$f$lastOrNull2 = 0;
                String string4 = $this$lastOrNull$iv2.substring($i$f$lastOrNull2, pageStart);
                Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"substring(...)");
                if (!StringsKt.isBlank((CharSequence)string4)) {
                    log.debug("ignoring as most likely found another toc entry");
                    return;
                }
            }
        }
        log.debug("Parsed page result: {}", (Object)pageStart);
        if (pageStart == -1) {
            log.debug("page not found");
            return;
        }
        nu.xom.Text nodeToWrap = null;
        if (pageStart != 0) {
            boolean match$iv$iv;
            char it;
            int index$iv$iv;
            String string5 = lastTextNode.getValue();
            Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"getValue(...)");
            String nextSibling = string5;
            int $this$lastOrNull$iv2 = 0;
            String string6 = nextSibling.substring($this$lastOrNull$iv2, pageStart);
            Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"substring(...)");
            String $this$trim$iv = string6;
            boolean $i$f$trim = false;
            CharSequence $this$trim$iv$iv = $this$trim$iv;
            boolean $i$f$trim2 = false;
            int startIndex$iv$iv = 0;
            int endIndex$iv$iv = $this$trim$iv$iv.length() - 1;
            boolean startFound$iv$iv = false;
            while (startIndex$iv$iv <= endIndex$iv$iv) {
                index$iv$iv = !startFound$iv$iv ? startIndex$iv$iv : endIndex$iv$iv;
                it = $this$trim$iv$iv.charAt(index$iv$iv);
                boolean bl5 = false;
                boolean bl6 = match$iv$iv = Intrinsics.compare((int)it, (int)32) <= 0;
                if (!startFound$iv$iv) {
                    if (!match$iv$iv) {
                        startFound$iv$iv = true;
                        continue;
                    }
                    ++startIndex$iv$iv;
                    continue;
                }
                if (!match$iv$iv) break;
                --endIndex$iv$iv;
            }
            if (((CharSequence)((Object)$this$trim$iv$iv.subSequence(startIndex$iv$iv, endIndex$iv$iv + 1)).toString()).length() == 0) {
                String string7 = lastTextNode.getValue();
                Intrinsics.checkNotNullExpressionValue((Object)string7, (String)"getValue(...)");
                $this$trim$iv = string7;
                nu.xom.Text text = lastTextNode;
                $i$f$trim = false;
                $this$trim$iv$iv = $this$trim$iv;
                $i$f$trim2 = false;
                startIndex$iv$iv = 0;
                endIndex$iv$iv = $this$trim$iv$iv.length() - 1;
                startFound$iv$iv = false;
                while (startIndex$iv$iv <= endIndex$iv$iv) {
                    index$iv$iv = !startFound$iv$iv ? startIndex$iv$iv : endIndex$iv$iv;
                    it = $this$trim$iv$iv.charAt(index$iv$iv);
                    boolean bl7 = false;
                    boolean bl8 = match$iv$iv = Intrinsics.compare((int)it, (int)32) <= 0;
                    if (!startFound$iv$iv) {
                        if (!match$iv$iv) {
                            startFound$iv$iv = true;
                            continue;
                        }
                        ++startIndex$iv$iv;
                        continue;
                    }
                    if (!match$iv$iv) break;
                    --endIndex$iv$iv;
                }
                text.setValue(((Object)$this$trim$iv$iv.subSequence(startIndex$iv$iv, endIndex$iv$iv + 1)).toString());
                nodeToWrap = lastTextNode;
            } else {
                void $this$trim$iv2;
                void $this$trim$iv3;
                String string8 = lastTextNode.getValue();
                Intrinsics.checkNotNullExpressionValue((Object)string8, (String)"getValue(...)");
                String $i$f$trim3 = string8;
                int $this$trim$iv$iv2 = 0;
                String string9 = $i$f$trim3.substring($this$trim$iv$iv2, pageStart);
                Intrinsics.checkNotNullExpressionValue((Object)string9, (String)"substring(...)");
                $i$f$trim3 = string9;
                boolean $i$f$trim222 = false;
                CharSequence $this$trim$iv$iv3 = (CharSequence)$this$trim$iv3;
                boolean $i$f$trim4 = false;
                int startIndex$iv$iv2 = 0;
                int endIndex$iv$iv2 = $this$trim$iv$iv3.length() - 1;
                boolean startFound$iv$iv2 = false;
                while (startIndex$iv$iv2 <= endIndex$iv$iv2) {
                    boolean match$iv$iv2;
                    int index$iv$iv2 = !startFound$iv$iv2 ? startIndex$iv$iv2 : endIndex$iv$iv2;
                    char it2 = $this$trim$iv$iv3.charAt(index$iv$iv2);
                    boolean bl9 = false;
                    boolean bl10 = match$iv$iv2 = Intrinsics.compare((int)it2, (int)32) <= 0;
                    if (!startFound$iv$iv2) {
                        if (!match$iv$iv2) {
                            startFound$iv$iv2 = true;
                            continue;
                        }
                        ++startIndex$iv$iv2;
                        continue;
                    }
                    if (!match$iv$iv2) break;
                    --endIndex$iv$iv2;
                }
                String title = ((Object)$this$trim$iv$iv3.subSequence(startIndex$iv$iv2, endIndex$iv$iv2 + 1)).toString();
                String string10 = lastTextNode.getValue();
                Intrinsics.checkNotNullExpressionValue((Object)string10, (String)"getValue(...)");
                String string11 = string10.substring(pageStart);
                Intrinsics.checkNotNullExpressionValue((Object)string11, (String)"substring(...)");
                String $i$f$trim222 = string11;
                $i$f$trim = false;
                CharSequence $this$trim$iv$iv4 = (CharSequence)$this$trim$iv2;
                boolean $i$f$trim5 = false;
                int startIndex$iv$iv3 = 0;
                int endIndex$iv$iv3 = $this$trim$iv$iv4.length() - 1;
                boolean startFound$iv$iv3 = false;
                while (startIndex$iv$iv3 <= endIndex$iv$iv3) {
                    boolean match$iv$iv3;
                    int index$iv$iv3 = !startFound$iv$iv3 ? startIndex$iv$iv3 : endIndex$iv$iv3;
                    char it3 = $this$trim$iv$iv4.charAt(index$iv$iv3);
                    boolean bl11 = false;
                    boolean bl12 = match$iv$iv3 = Intrinsics.compare((int)it3, (int)32) <= 0;
                    if (!startFound$iv$iv3) {
                        if (!match$iv$iv3) {
                            startFound$iv$iv3 = true;
                            continue;
                        }
                        ++startIndex$iv$iv3;
                        continue;
                    }
                    if (!match$iv$iv3) break;
                    --endIndex$iv$iv3;
                }
                String page = ((Object)$this$trim$iv$iv4.subSequence(startIndex$iv$iv3, endIndex$iv$iv3 + 1)).toString();
                lastTextNode.setValue(title);
                nodeToWrap = new nu.xom.Text(page);
                lastTextNode.getParent().insertChild((Node)nodeToWrap, lastTextNode.getParent().indexOf((Node)lastTextNode) + 1);
                String string12 = lastTextNode.getValue();
                Intrinsics.checkNotNullExpressionValue((Object)string12, (String)"getValue(...)");
                if (StringsKt.isBlank((CharSequence)string12)) {
                    throw new RuntimeException("page still surrounded by spaces?");
                }
            }
        } else {
            nodeToWrap = lastTextNode;
            if (BBXUtilsKt.findBlock((Node)nodeToWrap).getChildCount() == 1 && moveableBlock == null) {
                return;
            }
        }
        Element newPageWrapper = null;
        ParentNode parent = nodeToWrap.getParent();
        int $this$trim$iv2 = parent.getChildCount();
        if ($this$trim$iv2 == 1 && BBX.SPAN.isA((Node)parent)) {
            Intrinsics.checkNotNull((Object)parent, (String)"null cannot be cast to non-null type nu.xom.Element");
            newPageWrapper = (Element)parent;
        } else if ($this$trim$iv2 == 1 && BBX.INLINE.isA((Node)parent)) {
            Element element = BBX.SPAN.OTHER.create();
            Intrinsics.checkNotNullExpressionValue((Object)element, (String)"create(...)");
            newPageWrapper = element;
            Intrinsics.checkNotNull((Object)parent);
            XMLHandler.Companion.wrapNodeWithElement((Node)parent, newPageWrapper);
        } else {
            Element element = BBX.SPAN.OTHER.create();
            Intrinsics.checkNotNullExpressionValue((Object)element, (String)"create(...)");
            newPageWrapper = element;
            XMLHandler.Companion.wrapNodeWithElement((Node)nodeToWrap, newPageWrapper);
            log.trace("Wrapped with element in {}", (Object)newPageWrapper.getParent().toXML());
        }
        log.trace("Applying page attrib to {}", (Object)newPageWrapper.toXML());
        TOCBuilderBBX.Companion.setTOCType(newPageWrapper, "page", utdMan);
        if (newPageWrapper.getDocument() == null) {
            throw new NodeException("Node not attached to document", (Node)newPageWrapper, null, 4, null);
        }
        BBX.SPAN.assertIsA((Node)newPageWrapper);
        if (moveableBlock != null) {
            Node node = moveableBlock.getChild(0);
            Intrinsics.checkNotNullExpressionValue((Object)node, (String)"getChild(...)");
            Node movableChild = node;
            movableChild.detach();
            block.appendChild(movableChild);
            moveableBlock.detach();
            modifiedNodes.remove(moveableBlock);
        }
        if (newPageWrapper.getDocument() == null) {
            throw new NodeException("Node not attached to document " + newPageWrapper.toXML(), (Node)block, null, 4, null);
        }
        this.pageNumStripPrecedingText((Node)newPageWrapper, modifiedNodes);
    }

    private final int indexOfPage(String rawText) {
        String result;
        if (StringsKt.isBlank((CharSequence)rawText)) {
            return -1;
        }
        int start = StringsKt.contains$default((CharSequence)rawText, (CharSequence)" ", (boolean)false, (int)2, null) ? StringsKt.lastIndexOf$default((CharSequence)rawText, (char)' ', (int)0, (boolean)false, (int)6, null) + 1 : 0;
        int end = StringsKt.indexOf$default((CharSequence)rawText, (char)' ', (int)start, (boolean)false, (int)4, null);
        if (end == -1) {
            end = rawText.length();
        }
        String string = rawText.substring(start, end);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
        String lastWord = string;
        String pagePrefix = this.getFindPagePrefixOrException();
        if (((CharSequence)pagePrefix).length() == 0) {
            v1 = this.parsePageNumber(lastWord);
        } else {
            char[] cArray = pagePrefix.toCharArray();
            Intrinsics.checkNotNullExpressionValue((Object)cArray, (String)"toCharArray(...)");
            char[] cArray2 = cArray;
            String textToParse = StringsKt.trimStart((String)lastWord, (char[])Arrays.copyOf(cArray2, cArray2.length));
            v1 = result = Intrinsics.areEqual((Object)textToParse, (Object)lastWord) ? this.parsePageNumber(rawText) : this.parsePageNumber(textToParse);
        }
        if (result == null) {
            return -1;
        }
        return start;
    }

    private final String parsePageNumber(String input) {
        try {
            return "" + Integer.parseInt(input);
        }
        catch (NumberFormatException numberFormatException) {
            Matcher matcher = MATCH_ROMAN_NUMERALS.matcher(input);
            Intrinsics.checkNotNullExpressionValue((Object)matcher, (String)"matcher(...)");
            Matcher matcher2 = matcher;
            boolean found = matcher2.find();
            Object[] objectArray = new Object[]{input, matcher2, found};
            log.debug("Input '{}' Matcher {} matched {}", objectArray);
            if (found) {
                return matcher2.group();
            }
            return null;
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void pageNumStripPrecedingText(Node pageNum, List<Node> modifiedNodes) {
        void $this$filterIsInstanceTo$iv$iv;
        if (pageNum.getDocument() == null) {
            throw new NodeException("Node not attached to doc", pageNum, null, 4, null);
        }
        Iterable $this$filterIsInstance$iv = FastXPath.INSTANCE.preceding(pageNum);
        boolean $i$f$filterIsInstance = false;
        Iterable iterable = $this$filterIsInstance$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterIsInstanceTo = false;
        for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
            if (!(element$iv$iv instanceof nu.xom.Text)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        nu.xom.Text precedingText = (nu.xom.Text)CollectionsKt.first((List)((List)destination$iv$iv));
        String string = precedingText.getValue();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getValue(...)");
        if (StringsKt.endsWith$default((String)string, (String)" ", (boolean)false, (int)2, null)) {
            String string2 = precedingText.getValue();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getValue(...)");
            precedingText.setValue(((Object)StringsKt.trimEnd((CharSequence)string2)).toString());
            String string3 = precedingText.getValue();
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"getValue(...)");
            if (((CharSequence)string3).length() == 0) {
                precedingText.detach();
            } else {
                modifiedNodes.add((Node)precedingText);
            }
        }
    }

    public final void pressedInsertVolumeSplit() {
        this.manager.stopFormatting();
        List modifiedNodes = new ArrayList();
        modifiedNodes.add(TOCBuilderBBX.Companion.insertVolumeSplitBeforeParentBlock(this.manager.getSimpleManager().getCurrentCaret().getNode()));
        Document document = this.manager.getDoc();
        Intrinsics.checkNotNullExpressionValue((Object)document, (String)"<get-doc>(...)");
        Node node = Objects.requireNonNull(FastXPath.INSTANCE.descendantFindFirst((Node)document, TOCBuilderBBX::pressedInsertVolumeSplit$lambda$0));
        Intrinsics.checkNotNull((Object)node, (String)"null cannot be cast to non-null type nu.xom.Element");
        Element firstTOCNode = (Element)node;
        if (TOCAttributes.TYPE.getAttribute(firstTOCNode) != null) {
            log.debug("firstTOCNode: {}", (Object)firstTOCNode.toXML());
            modifiedNodes.add(TOCBuilderBBX.Companion.insertVolumeSplitBeforeParentBlock((Node)firstTOCNode));
        }
        this.manager.getSimpleManager().dispatchEvent(new org.brailleblaster.perspectives.mvc.events.ModifyEvent(Sender.TOC, modifiedNodes, true));
    }

    /*
     * WARNING - void declaration
     */
    private final void regenerateAllTOC(Document doc) {
        Element tocContainer;
        Element node;
        void $this$filterTo$iv$iv;
        void $this$filter$iv;
        void $this$count$iv;
        this.manager.stopFormatting();
        List<Element> volumes = VolumeUtils.getVolumeElements(doc);
        if (volumes.isEmpty()) {
            throw new BBNotifyException("Must create volumes first");
        }
        Sequence sequence = FastXPath.descendant((Node)((Node)doc));
        boolean $i$f$count = false;
        int count$iv = 0;
        for (Object element$iv : $this$count$iv) {
            Node node2 = (Node)element$iv;
            boolean bl = false;
            boolean bl2 = BBX.BLOCK.TOC_VOLUME_SPLIT.isA(node2) && XMLHandler.Companion.ancestorElementNot(node2, TOCBuilderBBX::regenerateAllTOC$lambda$0$0);
            if (!bl2 || ++count$iv >= 0) continue;
            CollectionsKt.throwCountOverflow();
        }
        int volumeSplitsNum = count$iv;
        if (volumeSplitsNum == 0) {
            throw new BBNotifyException("No TOC Volume Splits defined");
        }
        if (volumeSplitsNum != volumes.size()) {
            if (BBIni.getDebugging()) {
                test_diffTOCSplitsThanVolumes = true;
                log.warn("More TOC Volumes than actual volumes");
            } else if (!EasySWT.makeEasyYesNoDialog((String)"TOC Warning", (String)("Defined " + volumeSplitsNum + " TOC Volumes but document has " + volumes.size() + " actual volumes." + (volumeSplitsNum > volumes.size() ? " Additional TOC volumes will be added to last available volume." : "") + " Are you sure you want to disperse TOC entries?"), (Shell)this.manager.getWpManager().getShell())) {
                return;
            }
        }
        List modifiedElements = new ArrayList();
        List volumeTocContainers = new ArrayList();
        for (Element curVolume : CollectionsKt.dropLast(volumes, (int)1)) {
            Element tocContainer2 = VolumeUtils.getOrCreateTOC(curVolume);
            tocContainer2.removeChildren();
            log.debug("toc container: {}", (Object)XMLHandler.Companion.toXMLSimple((Node)tocContainer2));
            volumeTocContainers.add(tocContainer2);
        }
        List<VolumeUtils.VolumeData> volumeData = VolumeUtils.INSTANCE.getVolumeNames(volumes);
        Iterator<VolumeUtils.VolumeData> volumeDataItr = volumeData.iterator();
        List tocElements = FastXPath.INSTANCE.descendantFindList((Node)doc, (arg_0, arg_1) -> TOCBuilderBBX.regenerateAllTOC$lambda$1(volumeDataItr, modifiedElements, arg_0, arg_1));
        tocElements.forEach(TOCBuilderBBX::regenerateAllTOC$lambda$2);
        Iterable bl = tocElements;
        List list = tocElements;
        List list2 = tocElements;
        int $i$f$filter = 0;
        void var12_19 = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            node = (Element)element$iv$iv;
            boolean bl3 = false;
            if (!BBX.BLOCK.TOC_VOLUME_SPLIT.isA((Node)node)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List list3 = (List)destination$iv$iv;
        Element element = (Element)CollectionsKt.firstOrNull((List)CollectionsKt.drop((Iterable)list3, (int)1));
        if (element == null) {
            element = (Element)tocElements.get(0);
        }
        tocElements = list2.subList(list.indexOf(element), tocElements.size());
        tocElements.forEach(TOCBuilderBBX::regenerateAllTOC$lambda$4);
        PeekingIterator peekingIterator = Iterators.peekingIterator(tocElements.iterator());
        Intrinsics.checkNotNullExpressionValue((Object)peekingIterator, (String)"peekingIterator(...)");
        PeekingIterator tocItr = peekingIterator;
        $i$f$filter = ((Collection)volumes).size();
        for (int i = 0; i < $i$f$filter && tocItr.hasNext(); ++i) {
            tocContainer = (Element)volumeTocContainers.get(i);
            modifiedElements.add(tocContainer);
            tocContainer.removeChildren();
            log.info("toc {}", (Object)tocContainer.toXML());
            Object object = tocItr.peek();
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"peek(...)");
            Element previousPageNum = this.findAndAppendPrecedingPageNumber((Element)object, tocContainer, null);
            TOCBuilderBBX $this$regenerateAllTOC_u24lambda_u245 = this;
            boolean bl4 = false;
            Object object2 = tocItr.next();
            Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"next(...)");
            Element volumeSplit = (Element)object2;
            if (!BBX.BLOCK.TOC_VOLUME_SPLIT.isA((Node)volumeSplit)) {
                tocContainer.appendChild((Node)volumeSplit.copy());
            }
            while (tocItr.hasNext() && !BBX.BLOCK.TOC_VOLUME_SPLIT.isA((Node)tocItr.peek())) {
                Element nextTOCEntry;
                Object object3 = tocItr.peek();
                Intrinsics.checkNotNullExpressionValue((Object)object3, (String)"peek(...)");
                previousPageNum = this.findAndAppendPrecedingPageNumber((Element)object3, tocContainer, previousPageNum);
                Intrinsics.checkNotNullExpressionValue((Object)((Element)tocItr.next()).copy(), (String)"copy(...)");
                tocContainer.appendChild((Node)nextTOCEntry);
            }
        }
        Iterable i = tocElements;
        list2 = modifiedElements;
        $i$f$filter = 0;
        tocContainer = $this$filter$iv;
        destination$iv$iv = new ArrayList();
        $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            node = (Element)element$iv$iv;
            boolean bl5 = false;
            if (!BBX.BLOCK.TOC_VOLUME_SPLIT.isA((Node)node)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        list2.addAll((List)destination$iv$iv);
        this.manager.getSimpleManager().dispatchEvent(new org.brailleblaster.perspectives.mvc.events.ModifyEvent(Sender.TOC, modifiedElements, true));
    }

    private final Element findAndAppendPrecedingPageNumber(Element tocEntry, Element tocContainer, Element previousPageNum) {
        Object[] objectArray = new Object[]{BBX._ATTRIB_TYPE.nsPrefix, BBX._ATTRIB_TYPE.name, BBX.SPAN.PAGE_NUM.name};
        Nodes previousPageNumQuery = XMLHandler.Companion.query((Node)tocEntry, "preceding::*[@{}:{}='{}'][1]", objectArray);
        if (previousPageNumQuery.size() != 0) {
            Node node = previousPageNumQuery.get(0);
            Intrinsics.checkNotNull((Object)node, (String)"null cannot be cast to non-null type nu.xom.Element");
            Element pageNumElem = (Element)node;
            if (pageNumElem == previousPageNum) {
                return previousPageNum;
            }
            Element element = pageNumElem.copy();
            Intrinsics.checkNotNullExpressionValue((Object)element, (String)"copy(...)");
            Element pageNumToAppend = element;
            if (BBX.SPAN.PAGE_NUM.isA((Node)pageNumElem)) {
                BBX.transform(pageNumToAppend, BBX.BLOCK.PAGE_NUM);
            }
            tocContainer.appendChild((Node)pageNumToAppend);
            return pageNumElem;
        }
        return previousPageNum;
    }

    private final UTDManager getUTDManager() {
        return this.manager.getDocument().getSettingsManager();
    }

    private final void close() {
        this.setActive(false);
        BBIni.getPropertyFileManager().saveAsBoolean(SETTING_ENABLED, this.getActive());
        WPManager.Companion.getInstance().buildToolBar();
    }

    private final String getHeadingText(String headingText) {
        return switch (headingText) {
            case "Centered" -> "TOC Centered Heading";
            case "Centered NB" -> "TOC Centered Heading NB";
            case "Cell 5" -> "TOC Cell 5 Heading";
            case "Cell 7" -> "TOC Cell 7 Heading";
            default -> null;
        };
    }

    private static final void onEvent$lambda$0(TOCBuilderBBX this$0, Composite parent) {
        Intrinsics.checkNotNullParameter((Object)parent, (String)"parent");
        this$0.buildToolbar(parent);
    }

    private static final void buildToolbar$lambda$0(TOCBuilderBBX this$0, SelectionEvent it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        this$0.pressedApplyTitle();
    }

    private static final void buildToolbar$lambda$1(TOCBuilderBBX this$0, SelectionEvent it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        Button button = this$0.overrideLevel;
        Intrinsics.checkNotNull((Object)button);
        boolean isSelected = button.getSelection();
        BBIni.getPropertyFileManager().save(SETTING_OVERRIDE_LEVEL, isSelected ? "true" : "false");
        Text text = this$0.indentText;
        Intrinsics.checkNotNull((Object)text);
        text.setEnabled(isSelected);
        Text text2 = this$0.runoverText;
        Intrinsics.checkNotNull((Object)text2);
        text2.setEnabled(isSelected);
    }

    private static final void buildToolbar$lambda$2(TOCBuilderBBX this$0, SelectionEvent it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        Button button = this$0.findPageCheck;
        Intrinsics.checkNotNull((Object)button);
        boolean isSelected = button.getSelection();
        BBIni.getPropertyFileManager().save(SETTING_PAGE_PREFIX_ENABLED, isSelected ? "true" : "false");
        Text text = this$0.pageNumberPrefix;
        Intrinsics.checkNotNull((Object)text);
        text.setEnabled(isSelected);
    }

    private static final void buildToolbar$lambda$3(TOCBuilderBBX this$0, ModifyEvent it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        PropertyFileManager propertyFileManager = BBIni.getPropertyFileManager();
        Text text = this$0.pageNumberPrefix;
        Intrinsics.checkNotNull((Object)text);
        String string = text.getText();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
        propertyFileManager.save("tocBuilderBBX.pagePrefix", string);
    }

    private static final void buildToolbar$lambda$4(TOCBuilderBBX this$0, SelectionEvent it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        Combo combo = this$0.headerCombo;
        Intrinsics.checkNotNull((Object)combo);
        String string = combo.getText();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
        String string2 = this$0.getHeadingText(string);
        Intrinsics.checkNotNull((Object)string2);
        this$0.pressedApplyHeading(string2);
    }

    private static final void buildToolbar$lambda$5(TOCBuilderBBX this$0, SelectionEvent it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        this$0.pressedApplyPage();
    }

    private static final void buildToolbar$lambda$6(TOCBuilderBBX this$0, SelectionEvent it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        this$0.pressedInsertVolumeSplit();
    }

    private static final void buildToolbar$lambda$7(TOCBuilderBBX this$0, SelectionEvent it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        Document document = this$0.manager.getDoc();
        Intrinsics.checkNotNullExpressionValue((Object)document, (String)"<get-doc>(...)");
        this$0.regenerateAllTOC(document);
    }

    private static final void buildToolbar$lambda$8(TOCBuilderBBX this$0, SelectionEvent it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        this$0.close();
    }

    private static final boolean pressedApplyTitle$lambda$0(Element node) {
        return BBX.CONTAINER.LIST.isA((Node)node);
    }

    private static final boolean pressedApplyTitle$lambda$1(int $runoverTarget, Node node) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        return BBX.BLOCK.MARGIN.isA(node) && ((Number)BBX.BLOCK.MARGIN.ATTRIB_RUNOVER.get((Element)node)).intValue() < $runoverTarget;
    }

    private static final Unit pressedApplyTitle$lambda$2(List $modifiedNodes, Node e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        $modifiedNodes.add(e);
        return Unit.INSTANCE;
    }

    private static final boolean pressedApplyPage$lambda$0(Element curNode) {
        Intrinsics.checkNotNullParameter((Object)curNode, (String)"curNode");
        return TOCBuilderBBX.Companion.isTocTitle((Node)curNode);
    }

    private static final boolean pressedApplyPage$lambda$1(Element curNode) {
        Intrinsics.checkNotNullParameter((Object)curNode, (String)"curNode");
        return TOCBuilderBBX.Companion.isTocPage((Node)curNode);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final boolean isValidToMakePage$lambda$0(Element curAncestor) {
        if (!BBX.BLOCK.isA((Node)curAncestor)) return false;
        Element element = curAncestor;
        Intrinsics.checkNotNull((Object)element);
        if (!TOCAttributes.TYPE.inElement(element)) return false;
        return true;
    }

    private static final boolean pressedInsertVolumeSplit$lambda$0(Node curNode) {
        if (!(curNode instanceof Element)) {
            return true;
        }
        Element curElem = (Element)curNode;
        if (BBX.BLOCK.TOC_VOLUME_SPLIT.isA((Node)curElem)) {
            return false;
        }
        Attribute attribute = TOCAttributes.TYPE.getAttribute(curElem);
        return attribute == null;
    }

    private static final boolean regenerateAllTOC$lambda$0$0(Element node) {
        return BBX.CONTAINER.VOLUME_TOC.isA((Node)node);
    }

    private static final boolean regenerateAllTOC$lambda$1$0(List $results, Element o) {
        Intrinsics.checkNotNullParameter((Object)o, (String)"o");
        return $results.contains(o);
    }

    private static final boolean regenerateAllTOC$lambda$1(Iterator $volumeDataItr, List $modifiedElements, List results, Node curNode) {
        Intrinsics.checkNotNullParameter((Object)results, (String)"results");
        if (!(curNode instanceof Element)) {
            return false;
        }
        Element curElem = (Element)curNode;
        if (BBX.BLOCK.TOC_VOLUME_SPLIT.isA((Node)curElem)) {
            if (!$volumeDataItr.hasNext()) {
                return false;
            }
            curElem.removeChildren();
            curElem.appendChild((Node)BBXUtils.INSTANCE.wrapAsTransNote(((VolumeUtils.VolumeData)$volumeDataItr.next()).nameLong));
            $modifiedElements.add(curElem);
            return true;
        }
        if (TOCAttributes.TYPE.getAttribute(curElem) == null) {
            return false;
        }
        return !XMLHandler.Companion.ancestorElementIs((Node)curElem, arg_0 -> TOCBuilderBBX.regenerateAllTOC$lambda$1$0(results, arg_0));
    }

    private static final void regenerateAllTOC$lambda$2(Element tocElement) {
        Intrinsics.checkNotNullParameter((Object)tocElement, (String)"tocElement");
        log.info("before toc element: {}", (Object)tocElement.toXML());
    }

    private static final void regenerateAllTOC$lambda$4(Element tocElement) {
        Intrinsics.checkNotNullParameter((Object)tocElement, (String)"tocElement");
        log.info("Registered toc element: {}", (Object)tocElement.toXML());
    }

    @JvmStatic
    @Nullable
    public static final Element isPageMovable(@NotNull Node input) {
        return Companion.isPageMovable(input);
    }

    @JvmStatic
    public static final boolean isEnabled(@NotNull Manager m) {
        return Companion.isEnabled(m);
    }

    static {
        Logger logger = LoggerFactory.getLogger(TOCBuilderBBX.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getLogger(...)");
        log = logger;
        Pattern pattern = Pattern.compile("(?i)^M{0,4}(CM|CD|D?C{0,3})(XC|XL|L?X{0,3})(IX|IV|V?I{0,3})$", 2);
        Intrinsics.checkNotNullExpressionValue((Object)pattern, (String)"compile(...)");
        MATCH_ROMAN_NUMERALS = pattern;
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u000f\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0012\u0010\u001f\u001a\u0004\u0018\u00010 2\u0006\u0010!\u001a\u00020\"H\u0007J\u0010\u0010#\u001a\u00020 2\u0006\u0010$\u001a\u00020\"H\u0002J \u0010%\u001a\u00020&2\u0006\u0010'\u001a\u00020 2\u0006\u0010(\u001a\u00020\u00052\u0006\u0010)\u001a\u00020*H\u0002J\u0010\u0010+\u001a\u00020\u001e2\u0006\u0010,\u001a\u00020-H\u0007J\u0010\u0010.\u001a\u00020\u001e2\u0006\u0010/\u001a\u00020\"H\u0002J\u0010\u00100\u001a\u00020\u001e2\u0006\u0010/\u001a\u00020\"H\u0002J\u0018\u00101\u001a\u00020\u001e2\u0006\u0010/\u001a\u00020\"2\u0006\u00102\u001a\u00020\u0005H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0016\u001a\u00020\u0017\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019R\u000e\u0010\u001a\u001a\u00020\u001bX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001c\u001a\u00020\u001bX\u0082T\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u001d\u001a\u00020\u001e8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u00063"}, d2={"Lorg/brailleblaster/frontmatter/TOCBuilderBBX$Companion;", "", "<init>", "()V", "SETTING_OVERRIDE_LEVEL", "", "SETTING_PAGE_PREFIX_ENABLED", "SETTING_PAGE_PREFIX", "SETTING_ENABLED", "SWTBOT_TOC_ENTRY_BUTTON", "SWTBOT_PAGE_NUM_BUTTON", "SWTBOT_PAGE_PREFIX_CHECK", "SWTBOT_PAGE_PREFIX_TEXT", "SWTBOT_OVERRIDE_LEVEL", "SWTBOT_INDENT_TEXT", "SWTBOT_RUNOVER_TEXT", "SWTBOT_HEADING_COMBO", "SWTBOT_VOLUME_SPLIT_BUTTON", "SWTBOT_DISPERSE_VOLUMES_BUTTON", "SWTBOT_HEADING_BUTTON", "log", "Lorg/slf4j/Logger;", "MATCH_ROMAN_NUMERALS", "Ljava/util/regex/Pattern;", "getMATCH_ROMAN_NUMERALS", "()Ljava/util/regex/Pattern;", "CUR_INDENT", "", "CUR_RUNOVER", "test_diffTOCSplitsThanVolumes", "", "isPageMovable", "Lnu/xom/Element;", "input", "Lnu/xom/Node;", "insertVolumeSplitBeforeParentBlock", "someNode", "setTOCType", "", "elem", "type", "utdMan", "Lorg/brailleblaster/settings/UTDManager;", "isEnabled", "m", "Lorg/brailleblaster/perspectives/braille/Manager;", "isTocTitle", "curNode", "isTocPage", "isTocElement", "key", "brailleblaster-core"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Pattern getMATCH_ROMAN_NUMERALS() {
            return MATCH_ROMAN_NUMERALS;
        }

        @JvmStatic
        @Nullable
        public final Element isPageMovable(@NotNull Node input) {
            Intrinsics.checkNotNullParameter((Object)input, (String)"input");
            if (input.getDocument() == null) {
                throw new NodeException("Node not attached to document", input, null, 4, null);
            }
            ParentNode parentNode = input.getParent();
            Intrinsics.checkNotNull((Object)parentNode, (String)"null cannot be cast to non-null type nu.xom.Element");
            Element curParent = (Element)parentNode;
            boolean isMovable = true;
            Element movableBlock = null;
            while (true) {
                if (curParent.getChildCount() != 1) {
                    isMovable = false;
                }
                if (BBX.BLOCK.isA((Node)curParent)) {
                    movableBlock = curParent;
                    break;
                }
                if (curParent == input.getDocument().getRootElement()) break;
                ParentNode parentNode2 = curParent.getParent();
                Intrinsics.checkNotNull((Object)parentNode2, (String)"null cannot be cast to non-null type nu.xom.Element");
                curParent = (Element)parentNode2;
            }
            if (!isMovable) {
                return null;
            }
            BBX.BLOCK.assertIsA((Node)movableBlock);
            return movableBlock;
        }

        private final Element insertVolumeSplitBeforeParentBlock(Node someNode) {
            Element element = XMLHandler.Companion.ancestorVisitorElement(someNode, Companion::insertVolumeSplitBeforeParentBlock$lambda$0);
            Intrinsics.checkNotNull((Object)element);
            Element block = element;
            Element element2 = BBX.BLOCK.TOC_VOLUME_SPLIT.create();
            Intrinsics.checkNotNullExpressionValue((Object)element2, (String)"create(...)");
            Element split = element2;
            split.appendChild("TOC Volume split placeholder");
            ParentNode parentNode = block.getParent();
            Intrinsics.checkNotNullExpressionValue((Object)parentNode, (String)"getParent(...)");
            ParentNode blockParent = parentNode;
            blockParent.insertChild((Node)split, blockParent.indexOf((Node)block));
            return split;
        }

        private final void setTOCType(Element elem, String type, UTDManager utdMan) {
            Attribute attribute = TOCAttributes.TYPE.getAttribute(elem);
            if (attribute != null) {
                attribute.detach();
            }
            BBXUtils.INSTANCE.stripStyle(elem, utdMan);
            TOCAttributes.TYPE.add(elem, type);
        }

        @JvmStatic
        public final boolean isEnabled(@NotNull Manager m) {
            Intrinsics.checkNotNullParameter((Object)m, (String)"m");
            TOCBuilderBBX tOCBuilderBBX = m.getSimpleManager().getModule(TOCBuilderBBX.class);
            Intrinsics.checkNotNull((Object)tOCBuilderBBX);
            return tOCBuilderBBX.getEnabled();
        }

        private final boolean isTocTitle(Node curNode) {
            return this.isTocElement(curNode, "title");
        }

        private final boolean isTocPage(Node curNode) {
            return this.isTocElement(curNode, "page");
        }

        private final boolean isTocElement(Node curNode, String key) {
            if (!(curNode instanceof Element)) {
                return false;
            }
            Attribute tocTypeAttrib = TOCAttributes.TYPE.getAttribute((Element)curNode);
            return tocTypeAttrib != null && Intrinsics.areEqual((Object)tocTypeAttrib.getValue(), (Object)key);
        }

        private static final boolean insertVolumeSplitBeforeParentBlock$lambda$0(Element node) {
            return BBX.BLOCK.isA((Node)node);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

