/*
 * Decompiled with CFR 0.152.
 */
package org.brailleblaster.frontmatter;

import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.List;
import java.util.function.Predicate;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import nu.xom.Document;
import nu.xom.Element;
import nu.xom.Elements;
import nu.xom.Node;
import nu.xom.Text;
import org.brailleblaster.bbx.BBX;
import org.brailleblaster.perspectives.braille.Manager;
import org.brailleblaster.perspectives.braille.mapping.elements.TextMapElement;
import org.brailleblaster.utd.exceptions.NodeException;
import org.brailleblaster.utd.internal.xml.FastXPath;
import org.brailleblaster.utd.internal.xml.XMLHandler;
import org.brailleblaster.utd.properties.EmphasisType;
import org.brailleblaster.utils.swt.EasySWT;
import org.eclipse.swt.custom.StyledText;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001%B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b2\b\u0010\n\u001a\u0004\u0018\u00010\u000bH\u0007J\u0018\u0010\f\u001a\b\u0012\u0004\u0012\u00020\t0\b2\b\u0010\n\u001a\u0004\u0018\u00010\u000bH\u0007J\u0012\u0010\r\u001a\u00020\t2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000fH\u0007J\u0010\u0010\u0010\u001a\u0004\u0018\u00010\t2\u0006\u0010\u0011\u001a\u00020\tJ\u0010\u0010\u0012\u001a\u00020\t2\u0006\u0010\u0011\u001a\u00020\tH\u0007J\u0010\u0010\u0013\u001a\u00020\t2\u0006\u0010\u0011\u001a\u00020\tH\u0002J\u0010\u0010\u0014\u001a\u00020\t2\u0006\u0010\u0011\u001a\u00020\tH\u0007J\u0018\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\t0\b2\b\u0010\n\u001a\u0004\u0018\u00010\u000bH\u0007J \u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0011\u001a\u00020\t2\u000e\b\u0002\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\t0\bH\u0007J\u001c\u0010\u0018\u001a\u00020\u00192\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\t0\b2\u0006\u0010\u001a\u001a\u00020\tJ\u001a\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u001c0\b2\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\t0\bJ\u001c\u0010\u001d\u001a\u00020\u001c2\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\t0\b2\u0006\u0010\u001a\u001a\u00020\tJ\u0016\u0010\u001e\u001a\u00020\u00192\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\u0019J\u0018\u0010\"\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010#\u001a\u00020$H\u0007R\u0016\u0010\u0004\u001a\n \u0006*\u0004\u0018\u00010\u00050\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006&"}, d2={"Lorg/brailleblaster/frontmatter/VolumeUtils;", "", "<init>", "()V", "log", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "getVolumeElements", "", "Lnu/xom/Element;", "doc", "Lnu/xom/Document;", "getVolumeElementsFatal", "newVolumeElement", "type", "Lorg/brailleblaster/bbx/BBX$VolumeType;", "getOrCreateVolumeEnd", "volumeElement", "getOrCreateTPage", "createTPage", "getOrCreateTOC", "updateEndOfVolume", "", "volumes", "getVolumeNumber", "", "needleVolume", "getVolumeNames", "Lorg/brailleblaster/frontmatter/VolumeUtils$VolumeData;", "getVolumeName", "scrollToVolume", "manager", "Lorg/brailleblaster/perspectives/braille/Manager;", "volumeNum", "getVolumeAfterNode", "caretNode", "Lnu/xom/Node;", "VolumeData", "brailleblaster-core"})
@SourceDebugExtension(value={"SMAP\nVolumeUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 VolumeUtils.kt\norg/brailleblaster/frontmatter/VolumeUtils\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,267:1\n812#2,12:268\n777#2:280\n873#2,2:281\n531#2,7:283\n*S KotlinDebug\n*F\n+ 1 VolumeUtils.kt\norg/brailleblaster/frontmatter/VolumeUtils\n*L\n42#1:268,12\n43#1:280\n43#1:281,2\n81#1:283,7\n*E\n"})
public final class VolumeUtils {
    @NotNull
    public static final VolumeUtils INSTANCE = new VolumeUtils();
    private static final Logger log = LoggerFactory.getLogger(VolumeUtils.class);

    private VolumeUtils() {
    }

    /*
     * WARNING - void declaration
     */
    @JvmStatic
    @NotNull
    public static final List<Element> getVolumeElements(@Nullable Document doc) {
        void $this$filterTo$iv$iv;
        Iterable $this$filterIsInstanceTo$iv$iv;
        Iterable $this$filterIsInstance$iv = SequencesKt.toList((Sequence)FastXPath.descendant((Node)((Node)doc)));
        boolean $i$f$filterIsInstance = false;
        Iterable iterable = $this$filterIsInstance$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterIsInstanceTo = false;
        for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
            if (!(element$iv$iv instanceof Element)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$filter$iv = (List)destination$iv$iv;
        boolean $i$f$filter = false;
        $this$filterIsInstanceTo$iv$iv = $this$filter$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            Element node = (Element)element$iv$iv;
            boolean bl = false;
            if (!BBX.CONTAINER.VOLUME.isA((Node)node)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    @JvmStatic
    @NotNull
    public static final List<Element> getVolumeElementsFatal(@Nullable Document doc) {
        List<Element> volumes = VolumeUtils.getVolumeElements(doc);
        if (volumes.isEmpty()) {
            throw new RuntimeException("Must create volumes first");
        }
        return volumes;
    }

    @JvmStatic
    @NotNull
    public static final Element newVolumeElement(@Nullable BBX.VolumeType type) {
        log.debug("Adding new volume");
        Element volumeElement = BBX.CONTAINER.VOLUME.create(type);
        Intrinsics.checkNotNull((Object)volumeElement);
        INSTANCE.getOrCreateVolumeEnd(volumeElement);
        return volumeElement;
    }

    @Nullable
    public final Element getOrCreateVolumeEnd(@NotNull Element volumeElement) {
        Intrinsics.checkNotNullParameter((Object)volumeElement, (String)"volumeElement");
        Element volumeEnd = null;
        Iterator iterator = volumeElement.getChildElements().iterator();
        Intrinsics.checkNotNullExpressionValue((Object)iterator, (String)"iterator(...)");
        Iterator iterator2 = iterator;
        while (iterator2.hasNext()) {
            Element curChild = (Element)iterator2.next();
            if (!BBX.BLOCK.VOLUME_END.isA((Node)curChild)) continue;
            volumeEnd = curChild;
        }
        if (volumeEnd == null) {
            volumeEnd = BBX.BLOCK.VOLUME_END.create();
            volumeEnd.appendChild("New Volume Placeholder");
            volumeElement.insertChild((Node)volumeEnd, 0);
        }
        return volumeEnd;
    }

    /*
     * WARNING - void declaration
     */
    @JvmStatic
    @NotNull
    public static final Element getOrCreateTPage(@NotNull Element volumeElement) {
        void var3_3;
        Intrinsics.checkNotNullParameter((Object)volumeElement, (String)"volumeElement");
        Elements elements = volumeElement.getChildElements();
        Intrinsics.checkNotNullExpressionValue((Object)elements, (String)"getChildElements(...)");
        Iterable $this$lastOrNull$iv = (Iterable)elements;
        boolean $i$f$lastOrNull = false;
        Object last$iv = null;
        for (Object element$iv : $this$lastOrNull$iv) {
            Element it = (Element)element$iv;
            boolean bl = false;
            if (!BBX.CONTAINER.TPAGE.isA((Node)it)) continue;
            last$iv = element$iv;
        }
        Element element = (Element)var3_3;
        if (element == null) {
            element = INSTANCE.createTPage(volumeElement);
        }
        return element;
    }

    private final Element createTPage(Element volumeElement) {
        Element volumeEnd;
        Element result = BBX.CONTAINER.TPAGE.create();
        Element element = volumeEnd = this.getOrCreateVolumeEnd(volumeElement);
        Intrinsics.checkNotNull((Object)element);
        element.getParent().insertChild((Node)result, volumeEnd.getParent().indexOf((Node)volumeEnd) + 1);
        Intrinsics.checkNotNull((Object)result);
        return result;
    }

    @JvmStatic
    @NotNull
    public static final Element getOrCreateTOC(@NotNull Element volumeElement) {
        Intrinsics.checkNotNullParameter((Object)volumeElement, (String)"volumeElement");
        Element tocContainer = null;
        Iterator iterator = volumeElement.getChildElements().iterator();
        Intrinsics.checkNotNullExpressionValue((Object)iterator, (String)"iterator(...)");
        Iterator iterator2 = iterator;
        while (iterator2.hasNext()) {
            Element curChild = (Element)iterator2.next();
            if (!BBX.CONTAINER.VOLUME_TOC.isA((Node)curChild)) continue;
            tocContainer = curChild;
        }
        Element element = tocContainer;
        if (element == null) {
            Element element2;
            Element it = element2 = BBX.CONTAINER.VOLUME_TOC.create();
            boolean bl = false;
            volumeElement.appendChild((Node)it);
            Element element3 = element2;
            element = element3;
            Intrinsics.checkNotNullExpressionValue((Object)element3, (String)"also(...)");
        }
        return element;
    }

    @JvmStatic
    @NotNull
    public static final List<Element> updateEndOfVolume(@Nullable Document doc) {
        List<Element> volumes = VolumeUtils.getVolumeElementsFatal(doc);
        for (Element curVolume : volumes) {
            INSTANCE.updateEndOfVolume(curVolume, volumes);
        }
        return volumes;
    }

    @JvmOverloads
    public final void updateEndOfVolume(@NotNull Element volumeElement, @NotNull List<? extends Element> volumes) {
        Element volumeEnd;
        Intrinsics.checkNotNullParameter((Object)volumeElement, (String)"volumeElement");
        Intrinsics.checkNotNullParameter(volumes, (String)"volumes");
        BBX.CONTAINER.VOLUME.assertIsA((Node)volumeElement);
        int volumeNum = volumes.indexOf(volumeElement);
        if (volumeNum == -1) {
            throw new NodeException("Volume doesn't exist in volumes list?", (Node)volumeElement, null, 4, null);
        }
        Element element = volumeEnd = this.getOrCreateVolumeEnd(volumeElement);
        Intrinsics.checkNotNull((Object)element);
        element.removeChildren();
        Element span = BBX.INLINE.EMPHASIS.create(EnumSet.of((Enum)EmphasisType.TRANS_NOTE));
        if (CollectionsKt.last(volumes) == volumeElement) {
            span.appendChild("THE END");
        } else {
            span.appendChild("End of " + ((BBX.VolumeType)((Object)BBX.CONTAINER.VOLUME.ATTRIB_TYPE.get((Element)volumeElement))).volumeName + " " + this.getVolumeNumber(volumes, volumeElement));
        }
        volumeEnd.appendChild((Node)span);
    }

    public static /* synthetic */ void updateEndOfVolume$default(VolumeUtils volumeUtils, Element element, List list, int n, Object object) {
        if ((n & 2) != 0) {
            list = VolumeUtils.getVolumeElementsFatal(element.getDocument());
        }
        volumeUtils.updateEndOfVolume(element, list);
    }

    public final int getVolumeNumber(@NotNull List<? extends Element> volumes, @NotNull Element needleVolume) {
        Intrinsics.checkNotNullParameter(volumes, (String)"volumes");
        Intrinsics.checkNotNullParameter((Object)needleVolume, (String)"needleVolume");
        BBX.CONTAINER.VOLUME.assertIsA((Node)needleVolume);
        BBX.VolumeType needleVolumeType = (BBX.VolumeType)((Object)BBX.CONTAINER.VOLUME.ATTRIB_TYPE.get(needleVolume));
        int counter = 0;
        for (Element element : volumes) {
            BBX.VolumeType curVolumeType = (BBX.VolumeType)((Object)BBX.CONTAINER.VOLUME.ATTRIB_TYPE.get(element));
            if (element == needleVolume) break;
            if (curVolumeType != needleVolumeType) continue;
            ++counter;
        }
        return ++counter;
    }

    @NotNull
    public final List<VolumeData> getVolumeNames(@NotNull List<? extends Element> volumes) {
        Intrinsics.checkNotNullParameter(volumes, (String)"volumes");
        List result = new ArrayList();
        for (Element element : volumes) {
            BBX.VolumeType type = (BBX.VolumeType)((Object)BBX.CONTAINER.VOLUME.ATTRIB_TYPE.get(element));
            int volumeTypeIndex = this.getVolumeNumber(volumes, element);
            Intrinsics.checkNotNull((Object)((Object)type));
            result.add(new VolumeData(element, type, type.volumeNameShort + " " + volumeTypeIndex, volumeTypeIndex));
        }
        return result;
    }

    @NotNull
    public final VolumeData getVolumeName(@NotNull List<? extends Element> volumes, @NotNull Element needleVolume) {
        Intrinsics.checkNotNullParameter(volumes, (String)"volumes");
        Intrinsics.checkNotNullParameter((Object)needleVolume, (String)"needleVolume");
        for (Element element : volumes) {
            if (element != needleVolume) continue;
            BBX.VolumeType type = (BBX.VolumeType)((Object)BBX.CONTAINER.VOLUME.ATTRIB_TYPE.get(element));
            int volumeTypeIndex = this.getVolumeNumber(volumes, element);
            Intrinsics.checkNotNull((Object)((Object)type));
            return new VolumeData(element, type, type.volumeNameShort + " " + volumeTypeIndex, volumeTypeIndex);
        }
        throw new NodeException("Volume not found", (Node)needleVolume, null, 4, null);
    }

    public final int scrollToVolume(@NotNull Manager manager, int volumeNum) {
        Intrinsics.checkNotNullParameter((Object)manager, (String)"manager");
        Element volumeElement = VolumeUtils.getVolumeElementsFatal(manager.getDoc()).get(volumeNum);
        log.debug("Scrolling to volume " + volumeNum);
        manager.getText().setListenerLock(true);
        StyledText textView = manager.getText().getView();
        Text text = XMLHandler.Companion.findFirstText(volumeElement);
        log.debug("scrolling to text " + text.getValue());
        Integer nodeSection = (Integer)manager.getNodeIndexAllSections((Node)text).getFirst();
        int currentSection = manager.getFirstSection();
        log.debug("Current section {} found section {}", (Object)currentSection, (Object)nodeSection);
        Integer n = nodeSection;
        int n2 = currentSection;
        if (n == null || n != n2) {
            Intrinsics.checkNotNull((Object)nodeSection);
            manager.resetSection(nodeSection);
        }
        List<TextMapElement> findNodeText = manager.findNodeText((Node)text);
        int offset = findNodeText.get(0).getStart(manager.getMapList());
        log.debug("Scrolling to offset {}", (Object)offset);
        textView.setCaretOffset(offset);
        EasySWT.INSTANCE.scrollViewToCursor(textView);
        manager.getText().setListenerLock(false);
        textView.setFocus();
        return offset;
    }

    @JvmStatic
    @NotNull
    public static final Element getVolumeAfterNode(@NotNull Document doc, @NotNull Node caretNode) {
        Intrinsics.checkNotNullParameter((Object)doc, (String)"doc");
        Intrinsics.checkNotNullParameter((Object)caretNode, (String)"caretNode");
        Node node = FastXPath.INSTANCE.descendantFindFirst((Node)doc, (Predicate)new Predicate<Node>(caretNode){
            private boolean foundNode;
            final /* synthetic */ Node $caretNode;
            {
                this.$caretNode = $caretNode;
            }

            public final boolean getFoundNode() {
                return this.foundNode;
            }

            public final void setFoundNode(boolean bl) {
                this.foundNode = bl;
            }

            public boolean test(Node t) {
                Intrinsics.checkNotNullParameter((Object)t, (String)"t");
                if (!this.foundNode) {
                    if (t == this.$caretNode) {
                        this.foundNode = true;
                    }
                    return true;
                }
                return !BBX.CONTAINER.VOLUME.isA(t);
            }
        });
        Intrinsics.checkNotNull((Object)node, (String)"null cannot be cast to non-null type nu.xom.Element");
        return (Element)node;
    }

    @JvmOverloads
    public final void updateEndOfVolume(@NotNull Element volumeElement) {
        Intrinsics.checkNotNullParameter((Object)volumeElement, (String)"volumeElement");
        VolumeUtils.updateEndOfVolume$default(this, volumeElement, null, 2, null);
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\u0018\u00002\u00020\u0001B'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0004\b\n\u0010\u000bR\u0010\u0010\u0002\u001a\u00020\u00038\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0004\u001a\u00020\u00058\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u00020\u00078\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\b\u001a\u00020\t8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lorg/brailleblaster/frontmatter/VolumeUtils$VolumeData;", "", "element", "Lnu/xom/Element;", "type", "Lorg/brailleblaster/bbx/BBX$VolumeType;", "nameLong", "", "volumeTypeIndex", "", "<init>", "(Lnu/xom/Element;Lorg/brailleblaster/bbx/BBX$VolumeType;Ljava/lang/String;I)V", "brailleblaster-core"})
    public static final class VolumeData {
        @JvmField
        @NotNull
        public final Element element;
        @JvmField
        @NotNull
        public final BBX.VolumeType type;
        @JvmField
        @NotNull
        public final String nameLong;
        @JvmField
        public final int volumeTypeIndex;

        public VolumeData(@NotNull Element element, @NotNull BBX.VolumeType type, @NotNull String nameLong, int volumeTypeIndex) {
            Intrinsics.checkNotNullParameter((Object)element, (String)"element");
            Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
            Intrinsics.checkNotNullParameter((Object)nameLong, (String)"nameLong");
            this.element = element;
            this.type = type;
            this.nameLong = nameLong;
            this.volumeTypeIndex = volumeTypeIndex;
        }
    }
}

