/*
 * Decompiled with CFR 0.152.
 */
package org.brailleblaster.logging;

import ch.qos.logback.classic.Level;
import java.io.File;
import java.util.Arrays;
import kotlin.Metadata;
import kotlin.jvm.JvmName;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.Intrinsics;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.brailleblaster.BBIni;
import org.brailleblaster.util.Utils;
import org.brailleblaster.utils.PropertyFileManager;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={2, 3, 0}, k=2, xi=48, d1={"\u0000>\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0011\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0003\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\u001a\u000e\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005\u001a;\u0010\u0006\u001a\u00020\u00032\f\u0010\u0007\u001a\b\u0012\u0002\b\u0003\u0018\u00010\b2\b\u0010\t\u001a\u0004\u0018\u00010\n2\u0016\u0010\u000b\u001a\f\u0012\b\b\u0001\u0012\u0004\u0018\u00010\r0\f\"\u0004\u0018\u00010\r\u00a2\u0006\u0002\u0010\u000e\u001aC\u0010\u000f\u001a\u00020\u00032\f\u0010\u0007\u001a\b\u0012\u0002\b\u0003\u0018\u00010\b2\b\u0010\t\u001a\u0004\u0018\u00010\n2\u0006\u0010\u0010\u001a\u00020\u00112\u0016\u0010\u000b\u001a\f\u0012\b\b\u0001\u0012\u0004\u0018\u00010\r0\f\"\u0004\u0018\u00010\r\u00a2\u0006\u0002\u0010\u0012\u001a\u0012\u0010\u0014\u001a\u00020\u00152\b\b\u0002\u0010\u0016\u001a\u00020\nH\u0007\u001a\u001c\u0010\u0017\u001a\u00020\u00032\b\u0010\u0018\u001a\u0004\u0018\u00010\u00152\b\b\u0002\u0010\u0016\u001a\u00020\nH\u0007\u001a\u0006\u0010\u0019\u001a\u00020\u0003\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082\u000e\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0013\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"loggingInitted", "", "initLogback", "", "logbackConf", "Ljava/io/File;", "preLog", "clazz", "Ljava/lang/Class;", "message", "", "args", "", "", "(Ljava/lang/Class;Ljava/lang/String;[Ljava/lang/Object;)V", "preLogException", "e", "", "(Ljava/lang/Class;Ljava/lang/String;Ljava/lang/Throwable;[Ljava/lang/Object;)V", "USER_SETTINGS_LEVEL", "getLogLevel", "Lch/qos/logback/classic/Level;", "loggerName", "setLogLevel", "level", "updateLogSettings", "brailleblaster-core"})
@JvmName(name="LogUtils")
public final class LogUtils {
    private static boolean loggingInitted;
    @NotNull
    private static String USER_SETTINGS_LEVEL;

    public static final void initLogback(@NotNull File logbackConf) {
        Intrinsics.checkNotNullParameter((Object)logbackConf, (String)"logbackConf");
        String configFile = System.getProperty("logback.configurationFile");
        if (configFile == null) {
            System.setProperty("logback.configurationFile", logbackConf.getPath());
        }
        loggingInitted = true;
    }

    public static final void preLog(@Nullable Class<?> clazz, @Nullable String message, Object ... args) {
        Intrinsics.checkNotNullParameter((Object)args, (String)"args");
        if (loggingInitted) {
            LoggerFactory.getLogger(clazz).debug(message, Arrays.copyOf(args, args.length));
        } else {
            String string = Utils.formatMessage(message, Arrays.copyOf(args, args.length));
            System.out.println((Object)string);
        }
    }

    public static final void preLogException(@Nullable Class<?> clazz, @Nullable String message, @NotNull Throwable e, Object ... args) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        Intrinsics.checkNotNullParameter((Object)args, (String)"args");
        if (loggingInitted) {
            LoggerFactory.getLogger(clazz).debug(message, Arrays.copyOf(args, args.length));
        } else {
            String string = Utils.formatMessage(message, Arrays.copyOf(args, args.length)) + ExceptionUtils.getThrowableCount((Throwable)e);
            System.out.println((Object)string);
        }
    }

    @JvmOverloads
    @NotNull
    public static final Level getLogLevel(@NotNull String loggerName) {
        Intrinsics.checkNotNullParameter((Object)loggerName, (String)"loggerName");
        Logger logger = LoggerFactory.getLogger((String)loggerName);
        Intrinsics.checkNotNull((Object)logger, (String)"null cannot be cast to non-null type ch.qos.logback.classic.Logger");
        ch.qos.logback.classic.Logger logger2 = (ch.qos.logback.classic.Logger)logger;
        Level level = logger2.getLevel();
        Intrinsics.checkNotNullExpressionValue((Object)level, (String)"getLevel(...)");
        return level;
    }

    public static /* synthetic */ Level getLogLevel$default(String string, int n, Object object) {
        if ((n & 1) != 0) {
            string = "ROOT";
        }
        return LogUtils.getLogLevel(string);
    }

    @JvmOverloads
    public static final void setLogLevel(@Nullable Level level, @NotNull String loggerName) {
        Intrinsics.checkNotNullParameter((Object)loggerName, (String)"loggerName");
        Logger logger = LoggerFactory.getLogger((String)loggerName);
        Intrinsics.checkNotNull((Object)logger, (String)"null cannot be cast to non-null type ch.qos.logback.classic.Logger");
        ch.qos.logback.classic.Logger logger2 = (ch.qos.logback.classic.Logger)logger;
        logger2.setLevel(level);
    }

    public static /* synthetic */ void setLogLevel$default(Level level, String string, int n, Object object) {
        if ((n & 2) != 0) {
            string = "ROOT";
        }
        LogUtils.setLogLevel(level, string);
    }

    public static final void updateLogSettings() {
        Logger logger = LoggerFactory.getLogger((String)"ROOT");
        Intrinsics.checkNotNull((Object)logger, (String)"null cannot be cast to non-null type ch.qos.logback.classic.Logger");
        ch.qos.logback.classic.Logger rootLogger = (ch.qos.logback.classic.Logger)logger;
        Level level = rootLogger.getLevel();
        PropertyFileManager propertyFileManager = BBIni.getPropertyFileManager();
        String string = level.levelStr;
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"levelStr");
        propertyFileManager.save(USER_SETTINGS_LEVEL, string);
    }

    @JvmOverloads
    @NotNull
    public static final Level getLogLevel() {
        return LogUtils.getLogLevel$default(null, 1, null);
    }

    @JvmOverloads
    public static final void setLogLevel(@Nullable Level level) {
        LogUtils.setLogLevel$default(level, null, 2, null);
    }

    static {
        USER_SETTINGS_LEVEL = "loglevel";
    }
}

