/*
 * Decompiled with CFR 0.152.
 */
package org.brailleblaster.math.mathml;

import java.io.File;
import java.io.IOException;
import java.io.StringReader;
import java.io.StringWriter;
import java.nio.file.FileSystems;
import java.nio.file.Paths;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.sourceforge.jeuclid.LayoutContext;
import net.sourceforge.jeuclid.MutableLayoutContext;
import net.sourceforge.jeuclid.context.LayoutContextImpl;
import net.sourceforge.jeuclid.context.Parameter;
import nu.xom.Node;
import org.brailleblaster.BBIni;
import org.brailleblaster.math.ascii.ASCII2MathML;
import org.brailleblaster.math.ascii.ASCIIMathEditorDialog;
import org.brailleblaster.math.mathml.MathRenderer;
import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Shell;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\"\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015J(\u0010\u0019\u001a\u00020\u000f2\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u00152\u0006\u0010\u001f\u001a\u00020\u0015H\u0002J\u0018\u0010 \u001a\u00020!2\b\u0010\"\u001a\u0004\u0018\u00010#2\u0006\u0010$\u001a\u00020\u0007J\u0012\u0010%\u001a\u00020\u00072\b\u0010&\u001a\u0004\u0018\u00010'H\u0002J\u0018\u0010(\u001a\u00020\u000f2\u0006\u0010\u001e\u001a\u00020\u00152\u0006\u0010\u001f\u001a\u00020\u0015H\u0002J(\u0010)\u001a\u00020#2\b\u0010*\u001a\u0004\u0018\u00010+2\u0006\u0010$\u001a\u00020\u00072\u0006\u0010\u001e\u001a\u00020\u00152\u0006\u0010\u001f\u001a\u00020\u0015R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0016\u001a\u00020\u00078BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u0018\u00a8\u0006,"}, d2={"Lorg/brailleblaster/math/mathml/ImageCreator;", "", "<init>", "()V", "logger", "Lorg/slf4j/Logger;", "MATHJAX_PATH_BEG", "", "MATHJAX_PATH_END", "HTML_HEAD_BEG", "HTML_HEAD_END", "HTML_TAIL", "HTML_HEAD", "HTML_PLACEHOLDER", "createImage", "Lorg/eclipse/swt/graphics/Image;", "d", "Lorg/eclipse/swt/widgets/Display;", "e", "Lnu/xom/Element;", "fontHeight", "", "hTMLHead", "getHTMLHead", "()Ljava/lang/String;", "makeImage", "shell", "Lorg/eclipse/swt/widgets/Shell;", "translate", "Lnu/xom/Node;", "imageWidth", "imageHeight", "updateBrowser", "", "browser", "Lorg/eclipse/swt/browser/Browser;", "mmlString", "getHTMLString", "math", "Lorg/w3c/dom/Element;", "makeImageSpacing", "makeBrowserView", "rightPanel", "Lorg/eclipse/swt/widgets/Group;", "brailleblaster-core"})
public final class ImageCreator {
    @NotNull
    public static final ImageCreator INSTANCE = new ImageCreator();
    @NotNull
    private static final Logger logger;
    @NotNull
    private static final String MATHJAX_PATH_BEG;
    @NotNull
    private static final String MATHJAX_PATH_END = "MathJax.js?config=TeX-MML-AM_CHTML";
    @NotNull
    private static final String HTML_HEAD_BEG = "<!doctype html><html><head><script type='text/javascript' async src='";
    @NotNull
    private static final String HTML_HEAD_END = "'></script></head><body>";
    @NotNull
    private static final String HTML_TAIL = "</body></html>";
    @NotNull
    private static final String HTML_HEAD = "<!doctype html><html><head></head><body>";
    @NotNull
    private static final String HTML_PLACEHOLDER;

    private ImageCreator() {
    }

    @Nullable
    public final Image createImage(@Nullable Display d, @NotNull nu.xom.Element e, int fontHeight) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        MathRenderer mr = MathRenderer.INSTANCE;
        DocumentBuilderFactory dbFactory = DocumentBuilderFactory.newInstance();
        try {
            DocumentBuilder dBuilder = dbFactory.newDocumentBuilder();
            Document document = dBuilder.parse(new InputSource(new StringReader(e.toXML())));
            Intrinsics.checkNotNullExpressionValue((Object)document, (String)"parse(...)");
            org.w3c.dom.Node n = document;
            MutableLayoutContext params = (MutableLayoutContext)new LayoutContextImpl(LayoutContextImpl.getDefaultLayoutContext());
            params.setParameter(Parameter.MATHSIZE, (Object)fontHeight);
            ImageData imageData = mr.render(n, (LayoutContext)params);
            return new Image((Device)d, imageData);
        }
        catch (ParserConfigurationException e1) {
            logger.error("Parser Config Error", (Throwable)e1);
        }
        catch (SAXException e1) {
            logger.error("Sax Error", (Throwable)e1);
        }
        catch (IOException e1) {
            logger.error("IOException Error", (Throwable)e1);
        }
        return null;
    }

    private final String getHTMLHead() {
        String s;
        File withVersion;
        File[] files;
        File mj = new File(MATHJAX_PATH_BEG);
        if (mj.exists() && (files = mj.listFiles()) != null && !(files.length == 0) && (withVersion = new File(mj, s = files[0].getName())).exists()) {
            return HTML_HEAD_BEG + MATHJAX_PATH_BEG + FileSystems.getDefault().getSeparator() + s + FileSystems.getDefault().getSeparator() + "MathJax.js?config=TeX-MML-AM_CHTML'></script></head><body>";
        }
        return HTML_HEAD;
    }

    private final Image makeImage(Shell shell, Node translate, int imageWidth, int imageHeight) {
        Display display = shell.getDisplay();
        Intrinsics.checkNotNull((Object)translate, (String)"null cannot be cast to non-null type nu.xom.Element");
        Image image = this.createImage(display, (nu.xom.Element)translate, 50);
        Intrinsics.checkNotNull((Object)image);
        Image image2 = image;
        if (image2.getBounds().width > imageWidth) {
            image2 = new Image((Device)Display.getCurrent(), image2.getImageData().scaledTo(imageWidth, imageHeight));
        }
        Image im = new Image((Device)Display.getCurrent(), imageWidth, imageHeight);
        GC g = new GC((Drawable)im);
        g.drawImage(image2, 0, 0, image2.getBounds().width, image2.getBounds().height, 0, 0, image2.getBounds().width, image2.getBounds().height);
        g.dispose();
        image2 = im;
        return image2;
    }

    public final void updateBrowser(@Nullable Browser browser, @NotNull String mmlString) {
        Intrinsics.checkNotNullParameter((Object)mmlString, (String)"mmlString");
        if (((CharSequence)mmlString).length() == 0) {
            Browser browser2 = browser;
            Intrinsics.checkNotNull((Object)browser2);
            browser2.setText(HTML_HEAD + HTML_PLACEHOLDER + HTML_TAIL);
        } else {
            Element math = ASCII2MathML.translateUseHTML(mmlString);
            String str = this.getHTMLString(math);
            if (browser != null && !browser.isDisposed()) {
                browser.setText(this.getHTMLHead() + str + HTML_TAIL);
            }
        }
    }

    private final String getHTMLString(Element math) {
        TransformerFactory transFactory = TransformerFactory.newInstance();
        try {
            Transformer transformer = transFactory.newTransformer();
            StringWriter buffer = new StringWriter();
            transformer.setOutputProperty("omit-xml-declaration", "yes");
            transformer.transform(new DOMSource(math), new StreamResult(buffer));
            String string = buffer.toString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
            return string;
        }
        catch (TransformerConfigurationException e1) {
            logger.error("Exception whilst creating transformer", (Throwable)e1);
            throw new RuntimeException("Problem creating transformer when getting HTML string.", e1);
        }
        catch (TransformerException e) {
            logger.error("Exception whilst transforming", (Throwable)e);
            throw new RuntimeException("Problem transforming to HTML string.", e);
        }
    }

    private final Image makeImageSpacing(int imageWidth, int imageHeight) {
        Image im = new Image((Device)Display.getCurrent(), imageWidth, imageHeight);
        GC g = new GC((Drawable)im);
        g.drawText(ASCIIMathEditorDialog.Companion.getPLACEHOLDER(), 0, 0);
        return im;
    }

    @NotNull
    public final Browser makeBrowserView(@Nullable Group rightPanel, @NotNull String mmlString, int imageWidth, int imageHeight) {
        String string;
        GridData gridData;
        Browser browser;
        Intrinsics.checkNotNullParameter((Object)mmlString, (String)"mmlString");
        Browser $this$makeBrowserView_u24lambda_u240 = browser = new Browser((Composite)rightPanel, 0);
        boolean bl = false;
        GridData gridData2 = gridData = new GridData(4, 4, true, true);
        Browser browser2 = $this$makeBrowserView_u24lambda_u240;
        boolean bl2 = false;
        $this$makeBrowserView_u24lambda_u240_u240.widthHint = imageWidth;
        $this$makeBrowserView_u24lambda_u240_u240.heightHint = imageHeight;
        browser2.setLayoutData((Object)gridData);
        $this$makeBrowserView_u24lambda_u240.setJavascriptEnabled(true);
        if (((CharSequence)mmlString).length() == 0) {
            string = HTML_PLACEHOLDER;
        } else {
            Element math = ASCII2MathML.translateUseHTML(mmlString);
            string = INSTANCE.getHTMLString(math);
        }
        $this$makeBrowserView_u24lambda_u240.setText(HTML_HEAD + string + HTML_TAIL);
        return browser;
    }

    static {
        Logger logger = LoggerFactory.getLogger(ImageCreator.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getLogger(...)");
        ImageCreator.logger = logger;
        String[] stringArray = new String[]{"META-INF", "resources", "webjars", "MathJax"};
        MATHJAX_PATH_BEG = ((Object)BBIni.INSTANCE.getBbDistPath().resolve(Paths.get("lib", stringArray))).toString();
        HTML_PLACEHOLDER = "<p>" + ASCIIMathEditorDialog.Companion.getPLACEHOLDER() + "</p>";
    }
}

