/*
 * Decompiled with CFR 0.152.
 */
package org.brailleblaster.math.mathml;

import java.io.File;
import java.io.IOException;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import nu.xom.Builder;
import nu.xom.Document;
import nu.xom.Element;
import nu.xom.Node;
import nu.xom.Nodes;
import nu.xom.ParentNode;
import nu.xom.ParsingException;
import nu.xom.Text;
import org.brailleblaster.BBIni;
import org.brailleblaster.bbx.BBX;
import org.brailleblaster.bbx.BBXUtils;
import org.brailleblaster.bbx.BBXUtilsKt;
import org.brailleblaster.math.ascii.ASCII2MathML;
import org.brailleblaster.math.mathml.GetMathNode;
import org.brailleblaster.math.mathml.ImageCreator;
import org.brailleblaster.math.mathml.MathAction;
import org.brailleblaster.math.mathml.MathMLElement;
import org.brailleblaster.math.mathml.MathModuleUtils;
import org.brailleblaster.math.mathml.MathSubject;
import org.brailleblaster.math.mathml.MathUtils$nextTextIsMathButNotSameMathRoot$;
import org.brailleblaster.math.mathml.MathVerb;
import org.brailleblaster.perspectives.braille.Manager;
import org.brailleblaster.perspectives.braille.mapping.elements.TextMapElement;
import org.brailleblaster.perspectives.braille.mapping.elements.WhiteSpaceElement;
import org.brailleblaster.perspectives.braille.messages.Sender;
import org.brailleblaster.perspectives.mvc.events.ModifyEvent;
import org.brailleblaster.perspectives.mvc.modules.views.TextViewModule;
import org.brailleblaster.utd.internal.xml.FastXPath;
import org.brailleblaster.utd.internal.xml.XMLHandler;
import org.brailleblaster.utd.properties.UTDElements;
import org.brailleblaster.utd.utils.UTDHelper;
import org.brailleblaster.util.Utils;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0082\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u00018B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tJ \u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011J.\u0010\n\u001a\u0012\u0012\u0004\u0012\u00020\u00130\u0012j\b\u0012\u0004\u0012\u00020\u0013`\u00142\u0006\u0010\u0015\u001a\u00020\u00112\u0006\u0010\u0016\u001a\u00020\u00112\u0006\u0010\u0017\u001a\u00020\rJ0\u0010\n\u001a\u0012\u0012\u0004\u0012\u00020\u00130\u0012j\b\u0012\u0004\u0012\u00020\u0013`\u00142\u0006\u0010\u0018\u001a\u00020\r2\b\u0010\f\u001a\u0004\u0018\u00010\u00192\u0006\u0010\u001a\u001a\u00020\rJ8\u0010\n\u001a\u00020\u00072\u0006\u0010\u0018\u001a\u00020\r2\u0006\u0010\u001b\u001a\u00020\u001c2\b\u0010\u001d\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u001a\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011J\u001a\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u00070\u001f2\f\u0010 \u001a\b\u0012\u0004\u0012\u00020!0\u001fJ\u0010\u0010\"\u001a\u00020\u000b2\u0006\u0010#\u001a\u00020$H\u0007J\u000e\u0010%\u001a\u00020\u000b2\u0006\u0010#\u001a\u00020$J(\u0010&\u001a\u00020\u000b2\u0006\u0010#\u001a\u00020$2\u0006\u0010'\u001a\u00020(2\u0006\u0010)\u001a\u00020\u00112\u0006\u0010*\u001a\u00020\u0011H\u0007J\u001a\u0010+\u001a\u0004\u0018\u00010\u00072\b\u0010,\u001a\u0004\u0018\u00010\u00072\u0006\u0010#\u001a\u00020$J\u001a\u0010-\u001a\u0004\u0018\u00010\u00072\b\u0010,\u001a\u0004\u0018\u00010\u00072\u0006\u0010#\u001a\u00020$J\u0010\u0010.\u001a\u0004\u0018\u00010/2\u0006\u00100\u001a\u00020\rJ\u0010\u00101\u001a\u0004\u0018\u00010\u00072\u0006\u00102\u001a\u00020\u0007J\u0010\u00103\u001a\u0002042\b\u00105\u001a\u0004\u0018\u00010\u0007J\u0010\u00106\u001a\u00020\u000b2\b\u00107\u001a\u0004\u0018\u00010\u0007\u00a8\u00069"}, d2={"Lorg/brailleblaster/math/mathml/MathUtils;", "", "<init>", "()V", "nextTextIsMathButNotSameMathRoot", "", "node", "Lnu/xom/Node;", "mathParent", "Lnu/xom/Element;", "wrapInMath", "", "math", "", "block", "Lnu/xom/ParentNode;", "index", "", "Ljava/util/ArrayList;", "Lorg/brailleblaster/math/mathml/MathAction;", "Lkotlin/collections/ArrayList;", "i", "j", "s", "before", "Lorg/brailleblaster/math/mathml/MathSubject;", "after", "getNode", "Lorg/brailleblaster/math/mathml/GetMathNode;", "o", "getBlocksFromTextMapElements", "", "mapElements", "Lorg/brailleblaster/perspectives/braille/mapping/elements/TextMapElement;", "removeMathInSelectedRange", "m", "Lorg/brailleblaster/perspectives/braille/Manager;", "deleteMathInSelectedRange", "deleteMathFromSelectionHandlerEvent", "mapElement", "Lorg/brailleblaster/math/mathml/MathMLElement;", "start", "end", "previous", "startNode", "next", "getImageFromMMLDoc", "Lorg/eclipse/swt/graphics/Image;", "exampleName", "removeAllBBMarkupFromMathML", "bbNode", "queryForMathNodes", "Lnu/xom/Nodes;", "root", "removeAltText", "mathNode", "MixedMathNonMathString", "brailleblaster-core"})
@SourceDebugExtension(value={"SMAP\nMathUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MathUtils.kt\norg/brailleblaster/math/mathml/MathUtils\n+ 2 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,279:1\n479#2:280\n1586#3:281\n1661#3,3:282\n*S KotlinDebug\n*F\n+ 1 MathUtils.kt\norg/brailleblaster/math/mathml/MathUtils\n*L\n42#1:280\n113#1:281\n113#1:282,3\n*E\n"})
public final class MathUtils {
    @NotNull
    public static final MathUtils INSTANCE = new MathUtils();

    private MathUtils() {
    }

    public final boolean nextTextIsMathButNotSameMathRoot(@NotNull Node node, @NotNull Element mathParent) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        Intrinsics.checkNotNullParameter((Object)mathParent, (String)"mathParent");
        Sequence $this$filterIsInstance$iv = FastXPath.following((Node)node);
        boolean $i$f$filterIsInstance = false;
        Sequence sequence = SequencesKt.filter((Sequence)$this$filterIsInstance$iv, (Function1)nextTextIsMathButNotSameMathRoot$$inlined$filterIsInstance$1.INSTANCE);
        Intrinsics.checkNotNull((Object)sequence, (String)"null cannot be cast to non-null type kotlin.sequences.Sequence<R of kotlin.sequences.SequencesKt___SequencesKt.filterIsInstance>");
        Sequence nextText = sequence;
        for (Text text : nextText) {
            if (XMLHandler.Companion.ancestorElementIs((Node)text, MathUtils::nextTextIsMathButNotSameMathRoot$lambda$0)) continue;
            Node thisMathParent = MathModuleUtils.INSTANCE.getMathParentOrNull((Node)text);
            if (thisMathParent == null) {
                return false;
            }
            if (Intrinsics.areEqual((Object)thisMathParent, (Object)mathParent)) continue;
            return true;
        }
        return false;
    }

    public final void wrapInMath(@Nullable String math, @NotNull ParentNode block, int index) {
        Intrinsics.checkNotNullParameter((Object)block, (String)"block");
        String string = math;
        Intrinsics.checkNotNull((Object)string);
        Node mathNode = ASCII2MathML.translate(string);
        Utils.insertChildCountSafe(block, mathNode, index);
        Element element = BBX.INLINE.MATHML.create();
        Intrinsics.checkNotNullExpressionValue((Object)element, (String)"create(...)");
        XMLHandler.Companion.wrapNodeWithElement(mathNode, element);
    }

    @NotNull
    public final ArrayList<MathAction> wrapInMath(int i, int j, @NotNull String s) {
        Intrinsics.checkNotNullParameter((Object)s, (String)"s");
        CharSequence charSequence = StringsKt.take((String)s, (int)i);
        Object object = new Regex("\n");
        CharSequence charSequence2 = "";
        charSequence = object.replace(charSequence, charSequence2);
        object = new Regex("\r");
        charSequence2 = "";
        String before = object.replace(charSequence, charSequence2);
        String string = s.substring(i, j);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
        object = string;
        charSequence2 = new Regex("\n");
        String string2 = "";
        object = charSequence2.replace((CharSequence)object, string2);
        charSequence2 = new Regex("\r");
        string2 = "";
        String math = charSequence2.replace((CharSequence)object, string2);
        String string3 = s.substring(j);
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"substring(...)");
        charSequence2 = string3;
        string2 = new Regex("\n");
        String string4 = "";
        charSequence2 = string2.replace(charSequence2, string4);
        string2 = new Regex("\r");
        string4 = "";
        String after = string2.replace(charSequence2, string4);
        return this.wrapInMath(before, new MathSubject(math), after);
    }

    @NotNull
    public final ArrayList<MathAction> wrapInMath(@NotNull String before, @Nullable MathSubject math, @NotNull String after) {
        Intrinsics.checkNotNullParameter((Object)before, (String)"before");
        Intrinsics.checkNotNullParameter((Object)after, (String)"after");
        ArrayList<MathAction> array = new ArrayList<MathAction>();
        if (((CharSequence)before).length() > 0) {
            array.add(new MathAction(new MathSubject(before), MathVerb.Verb.WrapInText));
        }
        MathSubject mathSubject = math;
        Intrinsics.checkNotNull((Object)mathSubject);
        array.add(new MathAction(mathSubject, MathVerb.Verb.MakeMath));
        if (((CharSequence)after).length() > 0) {
            array.add(new MathAction(new MathSubject(after), MathVerb.Verb.WrapInText));
        }
        return array;
    }

    @NotNull
    public final Node wrapInMath(@NotNull String before, @NotNull GetMathNode getNode, @Nullable Object o, @NotNull String after, @NotNull ParentNode block, int index) {
        Intrinsics.checkNotNullParameter((Object)before, (String)"before");
        Intrinsics.checkNotNullParameter((Object)getNode, (String)"getNode");
        Intrinsics.checkNotNullParameter((Object)after, (String)"after");
        Intrinsics.checkNotNullParameter((Object)block, (String)"block");
        int curIndex = index;
        if (((CharSequence)before).length() > 0) {
            Utils.insertChildCountSafe(block, (Node)new Text(before), curIndex++);
        }
        Object object = o;
        Intrinsics.checkNotNull((Object)object);
        Node mathNode = getNode.getNode(object);
        Utils.insertChildCountSafe(block, mathNode, curIndex++);
        Element element = BBX.INLINE.MATHML.create();
        Intrinsics.checkNotNullExpressionValue((Object)element, (String)"create(...)");
        XMLHandler.Companion.wrapNodeWithElement(mathNode, element);
        if (((CharSequence)after).length() > 0) {
            Utils.insertChildCountSafe(block, (Node)new Text(after), curIndex);
        }
        return mathNode;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<Node> getBlocksFromTextMapElements(@NotNull List<? extends TextMapElement> mapElements) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter(mapElements, (String)"mapElements");
        Iterable $this$map$iv = mapElements;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            TextMapElement textMapElement = (TextMapElement)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            Node node = it.getNode();
            Intrinsics.checkNotNullExpressionValue((Object)node, (String)"getNode(...)");
            collection.add(BBXUtilsKt.findBlock(node));
        }
        return CollectionsKt.distinct((Iterable)((List)destination$iv$iv));
    }

    @JvmStatic
    public static final void removeMathInSelectedRange(@NotNull Manager m) {
        Intrinsics.checkNotNullParameter((Object)m, (String)"m");
        TextMapElement[] timmies = TextViewModule.Companion.getAllTextMapElementsInSelectedRange(m);
        ArrayList<ParentNode> blocks = new ArrayList<ParentNode>();
        for (TextMapElement mapElement : timmies) {
            if (!(mapElement instanceof MathMLElement) || ((MathMLElement)mapElement).getNode().getDocument() == null) continue;
            Node node = ((MathMLElement)mapElement).getNode();
            Intrinsics.checkNotNullExpressionValue((Object)node, (String)"getNode(...)");
            ParentNode block = (ParentNode)BBXUtilsKt.findBlock(node);
            if (!blocks.contains(block)) {
                blocks.add(block);
            }
            Node node2 = ((MathMLElement)mapElement).getNode();
            Intrinsics.checkNotNullExpressionValue((Object)node2, (String)"getNode(...)");
            int index = BBXUtils.INSTANCE.getIndexInBlock(node2);
            Node parent = block.getChild(index);
            String mathText = ((MathMLElement)mapElement).getText();
            Text textNode = new Text(mathText);
            block.replaceChild(parent, (Node)textNode);
        }
        if (!((Collection)blocks).isEmpty()) {
            m.getSimpleManager().dispatchEvent(new ModifyEvent(Sender.MATH, (List<? extends Node>)blocks, true));
        }
    }

    public final void deleteMathInSelectedRange(@NotNull Manager m) {
        Intrinsics.checkNotNullParameter((Object)m, (String)"m");
        TextMapElement[] timmies = TextViewModule.Companion.getAllTextMapElementsInSelectedRange(m);
        List blocks = new ArrayList();
        for (TextMapElement mapElement : timmies) {
            if (!(mapElement instanceof MathMLElement) || ((MathMLElement)mapElement).getNode().getDocument() == null) continue;
            Node node = ((MathMLElement)mapElement).getNode();
            Intrinsics.checkNotNullExpressionValue((Object)node, (String)"getNode(...)");
            Node block = (Node)BBXUtilsKt.findBlock(node);
            if (!blocks.contains(block)) {
                blocks.add(block);
            }
            mapElement.getNodeParent().detach();
        }
        if (!((Collection)blocks).isEmpty()) {
            m.getSimpleManager().dispatchEvent(new ModifyEvent(Sender.MATH, blocks, true));
        }
    }

    @JvmStatic
    public static final void deleteMathFromSelectionHandlerEvent(@NotNull Manager m, @NotNull MathMLElement mapElement, int start, int end) {
        Intrinsics.checkNotNullParameter((Object)m, (String)"m");
        Intrinsics.checkNotNullParameter((Object)mapElement, (String)"mapElement");
        int end2 = end;
        Node node = mapElement.getNode();
        Intrinsics.checkNotNullExpressionValue((Object)node, (String)"getNode(...)");
        ParentNode block = (ParentNode)BBXUtilsKt.findBlock(node);
        Node node2 = mapElement.getNode();
        Intrinsics.checkNotNullExpressionValue((Object)node2, (String)"getNode(...)");
        int index = BBXUtils.INSTANCE.getIndexInBlock(node2);
        String s = mapElement.getText();
        end2 -= mapElement.getStart(m.getMapList());
        int offset = start > mapElement.getStart(m.getMapList()) ? start - mapElement.getStart(m.getMapList()) : 0;
        int mathEnd = offset + mapElement.getText().length();
        StringBuilder one = new StringBuilder();
        StringBuilder two = new StringBuilder();
        int n = ((CharSequence)s).length();
        for (int i = 0; i < n; ++i) {
            if (i < offset) {
                one.append(s.charAt(i));
                continue;
            }
            boolean bl = end2 + 1 <= i ? i < mathEnd : false;
            if (!bl) continue;
            two.append(s.charAt(i));
        }
        block.getChild(index).detach();
        m.getMapList().remove(mapElement);
        if (((CharSequence)one).length() > 0) {
            INSTANCE.wrapInMath(one.toString(), block, index);
            ++index;
        }
        if (((CharSequence)two).length() > 0) {
            INSTANCE.wrapInMath(two.toString(), block, index);
        }
    }

    @Nullable
    public final Node previous(@Nullable Node startNode, @NotNull Manager m) {
        Intrinsics.checkNotNullParameter((Object)m, (String)"m");
        Node startNode2 = startNode;
        if (startNode2 == null || startNode2.getDocument() == null) {
            TextMapElement textMapElement = m.getMapList().getCurrent();
            Intrinsics.checkNotNullExpressionValue((Object)textMapElement, (String)"getCurrent(...)");
            TextMapElement tme = textMapElement;
            startNode2 = tme instanceof WhiteSpaceElement ? m.getMapList().getCurrentNonWhitespace(m.getMapList().getCurrentIndex()).getNode() : tme.getNode();
        }
        Node node = startNode2;
        Intrinsics.checkNotNull((Object)node);
        Nodes nodes = node.query("preceding::*[local-name()='math']");
        return nodes.size() > 0 ? nodes.get(nodes.size() - 1) : null;
    }

    @Nullable
    public final Node next(@Nullable Node startNode, @NotNull Manager m) {
        Intrinsics.checkNotNullParameter((Object)m, (String)"m");
        Node startNode2 = startNode;
        if (startNode2 == null || startNode2.getDocument() == null) {
            TextMapElement textMapElement = m.getMapList().getCurrent();
            Intrinsics.checkNotNullExpressionValue((Object)textMapElement, (String)"getCurrent(...)");
            TextMapElement tme = textMapElement;
            startNode2 = tme instanceof WhiteSpaceElement ? m.getMapList().getCurrentNonWhitespace(m.getMapList().getCurrentIndex()).getNode() : tme.getNode();
        }
        Node node = startNode2;
        Intrinsics.checkNotNull((Object)node);
        Nodes nodes = node.query("following::*[local-name()='math' ]");
        return nodes.size() > 0 ? nodes.get(0) : null;
    }

    @Nullable
    public final Image getImageFromMMLDoc(@NotNull String exampleName) {
        Intrinsics.checkNotNullParameter((Object)exampleName, (String)"exampleName");
        String[] stringArray = new String[]{"MathMLExamples.xml"};
        File file = BBIni.getProgramDataPath().resolve(Paths.get("settings", stringArray)).toFile();
        try {
            Document doc = new Builder().build(file);
            Nodes nodes = doc.query("//*[local-name()='math' and @example='" + exampleName + "']");
            if (nodes.size() > 0) {
                Display display = Display.getCurrent();
                Node node = nodes.get(0);
                Intrinsics.checkNotNull((Object)node, (String)"null cannot be cast to non-null type nu.xom.Element");
                return ImageCreator.INSTANCE.createImage(display, (Element)node, 30);
            }
        }
        catch (ParsingException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return null;
    }

    @Nullable
    public final Node removeAllBBMarkupFromMathML(@NotNull Node bbNode) {
        Intrinsics.checkNotNullParameter((Object)bbNode, (String)"bbNode");
        Node mathNode = null;
        if (MathModuleUtils.isMath(bbNode)) {
            UTDHelper.stripUTDRecursive((Element)((Element)bbNode));
            mathNode = (Node)((Element)bbNode).copy();
            this.removeAltText(mathNode);
        }
        return mathNode;
    }

    @NotNull
    public final Nodes queryForMathNodes(@Nullable Node root) {
        Nodes nodes;
        if (root == null) {
            nodes = new Nodes();
        } else {
            Nodes nodes2 = root.query("//*[local-name()='math']");
            nodes = nodes2;
            Intrinsics.checkNotNullExpressionValue((Object)nodes2, (String)"query(...)");
        }
        return nodes;
    }

    public final void removeAltText(@Nullable Node mathNode) {
        if (mathNode == null) {
            return;
        }
        if (!(mathNode instanceof Element)) {
            return;
        }
        if (((Element)mathNode).getAttributeValue("alttext") != null) {
            ((Element)mathNode).removeAttribute(((Element)mathNode).getAttribute("alttext"));
        }
    }

    private static final boolean nextTextIsMathButNotSameMathRoot$lambda$0(Element n) {
        Intrinsics.checkNotNullParameter((Object)n, (String)"n");
        return UTDElements.BRL.isA((Node)n);
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\n\u0018\u00002\u00020\u0001B\t\b\u0016\u00a2\u0006\u0004\b\u0002\u0010\u0003B\u0019\b\u0016\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\u0002\u0010\bR\u001a\u0010\u0004\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\t\u0010\n\"\u0004\b\u000b\u0010\fR\u001a\u0010\u0006\u001a\u00020\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\u000e\"\u0004\b\u000f\u0010\u0010\u00a8\u0006\u0011"}, d2={"Lorg/brailleblaster/math/mathml/MathUtils$MixedMathNonMathString;", "", "<init>", "()V", "math", "", "text", "", "(ZLjava/lang/String;)V", "getMath", "()Z", "setMath", "(Z)V", "getText", "()Ljava/lang/String;", "setText", "(Ljava/lang/String;)V", "brailleblaster-core"})
    public static final class MixedMathNonMathString {
        private boolean math;
        @NotNull
        private String text;

        public MixedMathNonMathString() {
            this.text = "";
        }

        public MixedMathNonMathString(boolean math, @NotNull String text) {
            Intrinsics.checkNotNullParameter((Object)text, (String)"text");
            this.text = "";
            this.math = math;
            this.text = text;
        }

        public final boolean getMath() {
            return this.math;
        }

        public final void setMath(boolean bl) {
            this.math = bl;
        }

        @NotNull
        public final String getText() {
            return this.text;
        }

        public final void setText(@NotNull String string) {
            Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
            this.text = string;
        }
    }
}

