/*
 * Decompiled with CFR 0.152.
 */
package org.brailleblaster.math.numberLine;

import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.apache.commons.lang3.math.Fraction;
import org.brailleblaster.math.spatial.MathFormattingException;
import org.brailleblaster.math.spatial.SpatialMathEnum;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0010\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0003\u0018\u00002\u00020\u0001:\u0001&B/\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0011\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020\u0000H\u0086\u0002R\u001a\u0010\u0002\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\t\u0010\n\"\u0004\b\u000b\u0010\fR\u001a\u0010\u0004\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\n\"\u0004\b\u000e\u0010\fR\u001a\u0010\u0005\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000f\u0010\n\"\u0004\b\u0010\u0010\fR\u001a\u0010\u0006\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\n\"\u0004\b\u0012\u0010\fR\u001a\u0010\u0013\u001a\u00020\u0014X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0013\u0010\u0015\"\u0004\b\u0016\u0010\u0017R\u001a\u0010\u0018\u001a\u00020\u0019X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001a\u0010\u001b\"\u0004\b\u001c\u0010\u001dR\u0011\u0010\u001e\u001a\u00020\u00148F\u00a2\u0006\u0006\u001a\u0004\b\u001e\u0010\u0015R\u0011\u0010\u001f\u001a\u00020 8F\u00a2\u0006\u0006\u001a\u0004\b!\u0010\"\u00a8\u0006'"}, d2={"Lorg/brailleblaster/math/numberLine/NumberLineComponent;", "", "whole", "", "decimal", "numerator", "denominator", "<init>", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;)V", "getWhole", "()Ljava/lang/String;", "setWhole", "(Ljava/lang/String;)V", "getDecimal", "setDecimal", "getNumerator", "setNumerator", "getDenominator", "setDenominator", "isMinus", "", "()Z", "setMinus", "(Z)V", "intervalType", "Lorg/brailleblaster/math/spatial/SpatialMathEnum$IntervalType;", "getIntervalType", "()Lorg/brailleblaster/math/spatial/SpatialMathEnum$IntervalType;", "setIntervalType", "(Lorg/brailleblaster/math/spatial/SpatialMathEnum$IntervalType;)V", "isEmpty", "fraction", "Lorg/apache/commons/lang3/math/Fraction;", "getFraction", "()Lorg/apache/commons/lang3/math/Fraction;", "compareTo", "", "o", "NumberLineComponentBuilder", "brailleblaster-core"})
public final class NumberLineComponent {
    @NotNull
    private String whole;
    @NotNull
    private String decimal;
    @NotNull
    private String numerator;
    @NotNull
    private String denominator;
    private boolean isMinus;
    @NotNull
    private SpatialMathEnum.IntervalType intervalType;

    public NumberLineComponent(@NotNull String whole, @NotNull String decimal, @NotNull String numerator, @NotNull String denominator) {
        int integer;
        String d;
        int integer2;
        Object n;
        int integer3;
        String dec;
        int integer4;
        Intrinsics.checkNotNullParameter((Object)whole, (String)"whole");
        Intrinsics.checkNotNullParameter((Object)decimal, (String)"decimal");
        Intrinsics.checkNotNullParameter((Object)numerator, (String)"numerator");
        Intrinsics.checkNotNullParameter((Object)denominator, (String)"denominator");
        this.whole = "";
        this.decimal = "";
        this.numerator = "";
        this.denominator = "";
        this.intervalType = SpatialMathEnum.IntervalType.WHOLE;
        Object w = whole;
        if (((CharSequence)w).length() > 0 && (integer4 = Integer.parseInt((String)w)) < 0) {
            this.isMinus = true;
            w = String.valueOf(Math.abs(integer4));
        }
        if (((CharSequence)(dec = decimal)).length() > 0 && (integer3 = Integer.parseInt(dec)) < 0) {
            this.isMinus = true;
            dec = String.valueOf(Math.abs(integer3));
        }
        if (((CharSequence)(n = numerator)).length() > 0 && (integer2 = Integer.parseInt((String)n)) < 0) {
            this.isMinus = true;
            n = String.valueOf(Math.abs(integer2));
        }
        if (((CharSequence)(d = denominator)).length() > 0 && (integer = Integer.parseInt(d)) < 0) {
            this.isMinus = true;
            d = String.valueOf(Math.abs(integer));
        }
        if (this.isMinus && ((CharSequence)w).length() == 0 && ((CharSequence)n).length() > 0) {
            n = "-" + (String)n;
        } else if (this.isMinus) {
            w = "-" + (String)w;
        }
        this.whole = w;
        this.decimal = dec;
        this.numerator = n;
        this.denominator = d;
    }

    public /* synthetic */ NumberLineComponent(String string, String string2, String string3, String string4, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            string = "";
        }
        if ((n & 2) != 0) {
            string2 = "";
        }
        if ((n & 4) != 0) {
            string3 = "";
        }
        if ((n & 8) != 0) {
            string4 = "";
        }
        this(string, string2, string3, string4);
    }

    @NotNull
    public final String getWhole() {
        return this.whole;
    }

    public final void setWhole(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
        this.whole = string;
    }

    @NotNull
    public final String getDecimal() {
        return this.decimal;
    }

    public final void setDecimal(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
        this.decimal = string;
    }

    @NotNull
    public final String getNumerator() {
        return this.numerator;
    }

    public final void setNumerator(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
        this.numerator = string;
    }

    @NotNull
    public final String getDenominator() {
        return this.denominator;
    }

    public final void setDenominator(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
        this.denominator = string;
    }

    public final boolean isMinus() {
        return this.isMinus;
    }

    public final void setMinus(boolean bl) {
        this.isMinus = bl;
    }

    @NotNull
    public final SpatialMathEnum.IntervalType getIntervalType() {
        return this.intervalType;
    }

    public final void setIntervalType(@NotNull SpatialMathEnum.IntervalType intervalType) {
        Intrinsics.checkNotNullParameter((Object)((Object)intervalType), (String)"<set-?>");
        this.intervalType = intervalType;
    }

    public final boolean isEmpty() {
        return ((CharSequence)this.whole).length() == 0 && ((CharSequence)this.decimal).length() == 0 && ((CharSequence)this.numerator).length() == 0 && ((CharSequence)this.denominator).length() == 0;
    }

    @NotNull
    public final Fraction getFraction() throws MathFormattingException {
        Fraction fraction;
        try {
            fraction = !StringsKt.isBlank((CharSequence)this.numerator) ? (!StringsKt.isBlank((CharSequence)this.whole) ? Fraction.getFraction((int)Integer.parseInt(this.whole), (int)Integer.parseInt(this.numerator), (int)Integer.parseInt(this.denominator)) : Fraction.getFraction((int)Integer.parseInt(this.numerator), (int)Integer.parseInt(this.denominator))) : (!StringsKt.isBlank((CharSequence)this.decimal) ? Fraction.getFraction((String)(this.whole + "." + this.decimal)) : Fraction.getFraction((String)this.whole));
            Intrinsics.checkNotNull((Object)fraction);
        }
        catch (Exception e) {
            throw new MathFormattingException("Exception parsing fraction from components", e);
        }
        return fraction;
    }

    public final int compareTo(@NotNull NumberLineComponent o) throws MathFormattingException {
        Intrinsics.checkNotNullParameter((Object)o, (String)"o");
        Fraction thisFraction = this.getFraction();
        Fraction thatFraction = o.getFraction();
        return thisFraction.compareTo(thatFraction);
    }

    public NumberLineComponent() {
        this(null, null, null, null, 15, null);
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u000f\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\u00020\u00002\u0006\u0010\u0013\u001a\u00020\u0005J\u000e\u0010\n\u001a\u00020\u00002\u0006\u0010\u0013\u001a\u00020\u0005J\u000e\u0010\r\u001a\u00020\u00002\u0006\u0010\u0013\u001a\u00020\u0005J\u000e\u0010\u0010\u001a\u00020\u00002\u0006\u0010\u0013\u001a\u00020\u0005J\u0006\u0010\u0014\u001a\u00020\u0015R\u001a\u0010\u0004\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\tR\u001a\u0010\n\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\u0007\"\u0004\b\f\u0010\tR\u001a\u0010\r\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\u0007\"\u0004\b\u000f\u0010\tR\u001a\u0010\u0010\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\u0007\"\u0004\b\u0012\u0010\t\u00a8\u0006\u0016"}, d2={"Lorg/brailleblaster/math/numberLine/NumberLineComponent$NumberLineComponentBuilder;", "", "<init>", "()V", "whole", "", "getWhole", "()Ljava/lang/String;", "setWhole", "(Ljava/lang/String;)V", "decimal", "getDecimal", "setDecimal", "numerator", "getNumerator", "setNumerator", "denominator", "getDenominator", "setDenominator", "s", "build", "Lorg/brailleblaster/math/numberLine/NumberLineComponent;", "brailleblaster-core"})
    public static final class NumberLineComponentBuilder {
        @NotNull
        private String whole = "";
        @NotNull
        private String decimal = "";
        @NotNull
        private String numerator = "";
        @NotNull
        private String denominator = "";

        @NotNull
        public final String getWhole() {
            return this.whole;
        }

        public final void setWhole(@NotNull String string) {
            Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
            this.whole = string;
        }

        @NotNull
        public final String getDecimal() {
            return this.decimal;
        }

        public final void setDecimal(@NotNull String string) {
            Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
            this.decimal = string;
        }

        @NotNull
        public final String getNumerator() {
            return this.numerator;
        }

        public final void setNumerator(@NotNull String string) {
            Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
            this.numerator = string;
        }

        @NotNull
        public final String getDenominator() {
            return this.denominator;
        }

        public final void setDenominator(@NotNull String string) {
            Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
            this.denominator = string;
        }

        @NotNull
        public final NumberLineComponentBuilder whole(@NotNull String s) {
            Intrinsics.checkNotNullParameter((Object)s, (String)"s");
            this.whole = s;
            return this;
        }

        @NotNull
        public final NumberLineComponentBuilder decimal(@NotNull String s) {
            Intrinsics.checkNotNullParameter((Object)s, (String)"s");
            this.decimal = s;
            return this;
        }

        @NotNull
        public final NumberLineComponentBuilder numerator(@NotNull String s) {
            Intrinsics.checkNotNullParameter((Object)s, (String)"s");
            this.numerator = s;
            return this;
        }

        @NotNull
        public final NumberLineComponentBuilder denominator(@NotNull String s) {
            Intrinsics.checkNotNullParameter((Object)s, (String)"s");
            this.denominator = s;
            return this;
        }

        @NotNull
        public final NumberLineComponent build() {
            return new NumberLineComponent(this.whole, this.decimal, this.numerator, this.denominator);
        }
    }
}

