/*
 * Decompiled with CFR 0.152.
 */
package org.brailleblaster.math.numberLine;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.brailleblaster.math.mathml.MathModuleUtils;
import org.brailleblaster.math.numberLine.NemethNumberLineFormatter;
import org.brailleblaster.math.numberLine.NemethUserDefinedFormatter;
import org.brailleblaster.math.numberLine.NumberLine;
import org.brailleblaster.math.numberLine.NumberLineInterval;
import org.brailleblaster.math.numberLine.NumberLineLine;
import org.brailleblaster.math.numberLine.NumberLinePoint;
import org.brailleblaster.math.numberLine.NumberLineSegmentPoint;
import org.brailleblaster.math.numberLine.UebNumberLineFormatter;
import org.brailleblaster.math.numberLine.UebUserDefinedFormatter;
import org.brailleblaster.math.spatial.Line;
import org.brailleblaster.math.spatial.MathFormattingException;
import org.brailleblaster.math.spatial.MathText;
import org.brailleblaster.math.spatial.SpatialMathEnum;
import org.brailleblaster.settings.UTDManager;
import org.brailleblaster.wordprocessor.WPManager;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\u0018\u0000 \b2\u00020\u0001:\u0001\bB\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0006\u0010\u0006\u001a\u00020\u0007R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lorg/brailleblaster/math/numberLine/NumberLineFormatter;", "", "numberLine", "Lorg/brailleblaster/math/numberLine/NumberLine;", "<init>", "(Lorg/brailleblaster/math/numberLine/NumberLine;)V", "format", "", "Companion", "brailleblaster-core"})
public final class NumberLineFormatter {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final NumberLine numberLine;
    @NotNull
    private static final Logger log;

    public NumberLineFormatter(@NotNull NumberLine numberLine) {
        Intrinsics.checkNotNullParameter((Object)numberLine, (String)"numberLine");
        this.numberLine = numberLine;
    }

    public final boolean format() throws MathFormattingException {
        Companion.clearFormatting(this.numberLine);
        if (this.numberLine.getSettings().getSectionType() == SpatialMathEnum.NumberLineSection.SEGMENT && this.numberLine.getSettings().getType() == SpatialMathEnum.NumberLineType.AUTOMATIC_MATH) {
            this.numberLine.setSegmentIntervals();
        }
        return MathModuleUtils.isNemeth() ? (this.numberLine.getSettings().getType() == SpatialMathEnum.NumberLineType.USER_DEFINED ? NemethUserDefinedFormatter.INSTANCE.format(this.numberLine) : NemethNumberLineFormatter.Companion.format(this.numberLine)) : (this.numberLine.getSettings().getType() == SpatialMathEnum.NumberLineType.USER_DEFINED ? UebUserDefinedFormatter.INSTANCE.format(this.numberLine) : UebNumberLineFormatter.Companion.format(this.numberLine));
    }

    static {
        Logger logger = LoggerFactory.getLogger(NumberLineFormatter.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getLogger(...)");
        log = logger;
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bJ\u000e\u0010\f\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bJ\u000e\u0010\r\u001a\u00020\u000e2\u0006\u0010\n\u001a\u00020\u000bJ\u000e\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\n\u001a\u00020\u000bJ\u000e\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0010\u001a\u00020\u0011J\u000e\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u0010\u001a\u00020\u0011J\u000e\u0010\u0012\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bJ\u000e\u0010\u0013\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bJ\u000e\u0010\u0014\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bJ\u000e\u0010\u0015\u001a\u00020\u00162\u0006\u0010\n\u001a\u00020\u000bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0017"}, d2={"Lorg/brailleblaster/math/numberLine/NumberLineFormatter$Companion;", "", "<init>", "()V", "log", "Lorg/slf4j/Logger;", "getLog", "()Lorg/slf4j/Logger;", "dealWithBlanks", "", "numberLine", "Lorg/brailleblaster/math/numberLine/NumberLine;", "clearFormatting", "getSegmentBeginning", "", "getSegmentEnding", "point", "Lorg/brailleblaster/math/numberLine/NumberLineSegmentPoint;", "addLine", "verticallyAlignLabelsAndPoints", "addLabels", "addPoints", "", "brailleblaster-core"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Logger getLog() {
            return log;
        }

        public final void dealWithBlanks(@NotNull NumberLine numberLine) {
            Intrinsics.checkNotNullParameter((Object)numberLine, (String)"numberLine");
            ArrayList<NumberLinePoint> points = numberLine.getPoints();
            int n = ((Collection)numberLine.getSettings().getUserDefinedArray()).size();
            block5: for (int j = 0; j < n; ++j) {
                NumberLineInterval intervalPoint = numberLine.getSettings().getUserDefinedArray().get(j);
                switch (WhenMappings.$EnumSwitchMapping$0[intervalPoint.getBlankType().ordinal()]) {
                    case 1: {
                        if (points.size() <= j) continue block5;
                        NumberLinePoint newPoint = new NumberLinePoint(false, null, new MathText(" ", " ", false, 4, null), false, 11, null);
                        points.set(j, newPoint);
                        continue block5;
                    }
                    case 2: {
                        continue block5;
                    }
                    case 3: {
                        if (points.size() <= j) continue block5;
                        String omission = MathModuleUtils.isNemeth() ? "=" : "+";
                        NumberLinePoint newPoint = new NumberLinePoint(false, null, new MathText(omission, omission, false, 4, null), false, 11, null);
                        points.set(j, newPoint);
                        continue block5;
                    }
                    default: {
                        throw new NoWhenBranchMatchedException();
                    }
                }
            }
        }

        public final void clearFormatting(@NotNull NumberLine numberLine) {
            Intrinsics.checkNotNullParameter((Object)numberLine, (String)"numberLine");
            ((ArrayList)numberLine.getLines()).clear();
            numberLine.getPoints().clear();
            numberLine.getLine().clear();
        }

        @NotNull
        public final String getSegmentBeginning(@NotNull NumberLine numberLine) {
            Intrinsics.checkNotNullParameter((Object)numberLine, (String)"numberLine");
            return switch (WhenMappings.$EnumSwitchMapping$1[numberLine.getSegment().getStartSegmentCircle().ordinal()]) {
                case 1 -> {
                    if (MathModuleUtils.isNemeth()) {
                        yield "x";
                    }
                    yield "y";
                }
                case 2 -> {
                    if (MathModuleUtils.isNemeth()) {
                        yield "=";
                    }
                    yield "=";
                }
                default -> MathModuleUtils.isNemeth() ? "3" : "\"";
            };
        }

        @NotNull
        public final String getSegmentEnding(@NotNull NumberLine numberLine) {
            Intrinsics.checkNotNullParameter((Object)numberLine, (String)"numberLine");
            return switch (WhenMappings.$EnumSwitchMapping$1[numberLine.getSegment().getEndSegmentCircle().ordinal()]) {
                case 1 -> {
                    if (MathModuleUtils.isNemeth()) {
                        yield "x";
                    }
                    yield "y";
                }
                case 2 -> {
                    if (MathModuleUtils.isNemeth()) {
                        yield "=";
                    }
                    yield "=";
                }
                default -> MathModuleUtils.isNemeth() ? "3" : "3";
            };
        }

        @NotNull
        public final String getSegmentBeginning(@NotNull NumberLineSegmentPoint point) {
            Intrinsics.checkNotNullParameter((Object)point, (String)"point");
            return switch (WhenMappings.$EnumSwitchMapping$1[point.getCircle().ordinal()]) {
                case 1 -> {
                    if (MathModuleUtils.isNemeth()) {
                        yield "x";
                    }
                    yield "y";
                }
                case 2 -> {
                    if (MathModuleUtils.isNemeth()) {
                        yield "=";
                    }
                    yield "=";
                }
                default -> MathModuleUtils.isNemeth() ? "3" : "\"";
            };
        }

        @NotNull
        public final String getSegmentEnding(@NotNull NumberLineSegmentPoint point) {
            Intrinsics.checkNotNullParameter((Object)point, (String)"point");
            return switch (WhenMappings.$EnumSwitchMapping$1[point.getCircle().ordinal()]) {
                case 1 -> {
                    if (MathModuleUtils.isNemeth()) {
                        yield "x";
                    }
                    yield "y";
                }
                case 2 -> {
                    if (MathModuleUtils.isNemeth()) {
                        yield "=";
                    }
                    yield "=";
                }
                default -> MathModuleUtils.isNemeth() ? "3" : "3";
            };
        }

        public final void addLine(@NotNull NumberLine numberLine) {
            Intrinsics.checkNotNullParameter((Object)numberLine, (String)"numberLine");
            Line line = new Line();
            int n = ((Collection)numberLine.getLine()).size();
            for (int i = 0; i < n; ++i) {
                NumberLineLine l;
                Intrinsics.checkNotNullExpressionValue((Object)numberLine.getLine().get(i), (String)"get(...)");
                line.getElements().add(line.getTextSegment(StringsKt.repeat((CharSequence)NumberLineLine.LineChar.Companion.getString(l.getType()), (int)l.getLength())));
            }
            ((ArrayList)numberLine.getLines()).add(line);
        }

        public final void verticallyAlignLabelsAndPoints(@NotNull NumberLine numberLine) {
            int rightPoint;
            int leftPoint;
            int rightLabel;
            int leftLabel;
            int i;
            Intrinsics.checkNotNullParameter((Object)numberLine, (String)"numberLine");
            int widestLeft = 0;
            int widestRight = 0;
            int numIntervals = numberLine.getSettings().getUserDefinedArray().size();
            int numPoints = numberLine.getPoints().size();
            if (numIntervals != numPoints) {
                this.getLog().debug("Number of intervals and points do not match");
                return;
            }
            int numberChar = MathModuleUtils.isNemeth() ? 0 : 1;
            for (i = 0; i < numIntervals; ++i) {
                NumberLinePoint point;
                NumberLinePoint label = numberLine.getSettings().getUserDefinedArray().get(i).getLabelText();
                Intrinsics.checkNotNullExpressionValue((Object)numberLine.getPoints().get(i), (String)"get(...)");
                leftLabel = label.getLeftDec().length();
                rightLabel = label.getRightDec().length();
                leftPoint = point.getLeftDec().length();
                rightPoint = point.getRightDec().length() + numberChar;
                if (leftLabel > widestLeft) {
                    widestLeft = leftLabel;
                }
                if (rightLabel > widestRight) {
                    widestRight = rightLabel;
                }
                if (leftPoint > widestLeft) {
                    widestLeft = leftPoint;
                }
                if (rightPoint <= widestRight) continue;
                widestRight = rightPoint;
            }
            for (i = 0; i < numPoints; ++i) {
                NumberLinePoint point;
                Intrinsics.checkNotNullExpressionValue((Object)numberLine.getPoints().get(i), (String)"get(...)");
                NumberLinePoint label = numberLine.getSettings().getUserDefinedArray().get(i).getLabelText();
                leftLabel = label.getLeftDec().length();
                rightLabel = label.getRightDec().length();
                leftPoint = point.getLeftDec().length();
                rightPoint = point.getRightDec().length() + numberChar;
                int leftPaddingPoint = widestLeft - leftPoint;
                int rightPaddingPoint = widestRight - rightPoint;
                point.setLeftPadding(leftPaddingPoint);
                point.setRightPadding(rightPaddingPoint);
                int leftPaddingLabel = widestLeft - leftLabel;
                int rightPaddingLabel = widestRight - rightLabel;
                label.setLeftPadding(leftPaddingLabel);
                label.setRightPadding(rightPaddingLabel);
            }
        }

        public final void addLabels(@NotNull NumberLine numberLine) {
            Intrinsics.checkNotNullParameter((Object)numberLine, (String)"numberLine");
            int numIntervals = numberLine.getSettings().getUserDefinedArray().size();
            int numPoints = numberLine.getPoints().size();
            if (numIntervals != numPoints) {
                this.getLog().debug("Number of intervals and points do not match");
                return;
            }
            Line line = new Line();
            if (numberLine.getSettings().isStartOverflow()) {
                line.getElements().add(line.getWhitespaceSegment(MathModuleUtils.isNemeth() ? 2 : 2));
            } else if (numberLine.getSettings().isArrow()) {
                line.getElements().add(line.getWhitespaceSegment(MathModuleUtils.isNemeth() ? 1 : 2));
            }
            if (!MathModuleUtils.isNemeth()) {
                line.getElements().add(line.getWhitespaceSegment(1));
            }
            List<NumberLineInterval> points = numberLine.getSettings().getUserDefinedArray();
            int n = ((Collection)points).size();
            for (int i = 0; i < n; ++i) {
                NumberLinePoint mathText = points.get(i).getLabelText();
                if (i != 0) {
                    line.getElements().add(line.getWhitespaceSegment(mathText.getLeftPadding()));
                } else if (!mathText.isMinus()) {
                    line.getElements().add(line.getWhitespaceSegment(1));
                }
                line.getElements().add(line.getTextSegment(mathText.getMathText().braille));
                if (i == points.size() - 1) continue;
                line.getElements().add(line.getWhitespaceSegment(mathText.getRightPadding() + 1));
            }
            if (numberLine.getSettings().isEndOverflow()) {
                line.getElements().add(line.getWhitespaceSegment(MathModuleUtils.isNemeth() ? 2 : 2));
            } else if (numberLine.getSettings().isArrow()) {
                line.getElements().add(line.getWhitespaceSegment(MathModuleUtils.isNemeth() ? 1 : 2));
            }
            if (numberLine.getSettings().getLabelPosition() == SpatialMathEnum.LabelPosition.TOP) {
                ((ArrayList)numberLine.getLines()).add(0, line);
            } else {
                ((ArrayList)numberLine.getLines()).add(line);
            }
        }

        public final boolean addPoints(@NotNull NumberLine numberLine) {
            Intrinsics.checkNotNullParameter((Object)numberLine, (String)"numberLine");
            Line line = new Line();
            int cellsPerLine = UTDManager.Companion.getCellsPerLine(WPManager.Companion.getInstance().getController());
            ArrayList<NumberLinePoint> points = numberLine.getPoints();
            if (numberLine.getSettings().isStartOverflow()) {
                line.getElements().add(line.getWhitespaceSegment(MathModuleUtils.isNemeth() ? 2 : 2));
            } else if (numberLine.getSettings().isArrow()) {
                line.getElements().add(line.getWhitespaceSegment(MathModuleUtils.isNemeth() ? 1 : 2));
            }
            if (!MathModuleUtils.isNemeth()) {
                line.getElements().add(line.getWhitespaceSegment(1));
            }
            int n = ((Collection)points).size();
            for (int i = 0; i < n; ++i) {
                NumberLinePoint mathText;
                Intrinsics.checkNotNullExpressionValue((Object)points.get(i), (String)"get(...)");
                if (i != 0) {
                    line.getElements().add(line.getWhitespaceSegment(mathText.getLeftPadding()));
                } else if (!mathText.isMinus()) {
                    line.getElements().add(line.getWhitespaceSegment(1));
                }
                line.getElements().add(line.getTextSegment(mathText.getMathText().braille));
                if (i == points.size() - 1) continue;
                line.getElements().add(line.getWhitespaceSegment(mathText.getRightPadding() + 1));
            }
            if (numberLine.getSettings().isEndOverflow()) {
                line.getElements().add(line.getWhitespaceSegment(MathModuleUtils.isNemeth() ? 2 : 2));
            } else if (numberLine.getSettings().isArrow()) {
                line.getElements().add(line.getWhitespaceSegment(MathModuleUtils.isNemeth() ? 1 : 2));
            }
            if (line.toString().length() > cellsPerLine) {
                this.getLog().error("Points are longer than cells per line, points are {}", (Object)line.toString().length());
                return false;
            }
            ((ArrayList)numberLine.getLines()).add(line);
            return true;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={2, 3, 0}, k=3, xi=48)
        public static final class WhenMappings {
            public static final /* synthetic */ int[] $EnumSwitchMapping$0;
            public static final /* synthetic */ int[] $EnumSwitchMapping$1;

            static {
                int[] nArray = new int[SpatialMathEnum.BlankOptions.values().length];
                try {
                    nArray[SpatialMathEnum.BlankOptions.BLANK.ordinal()] = 1;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[SpatialMathEnum.BlankOptions.NONE.ordinal()] = 2;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[SpatialMathEnum.BlankOptions.OMISSION.ordinal()] = 3;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                $EnumSwitchMapping$0 = nArray;
                nArray = new int[SpatialMathEnum.Fill.values().length];
                try {
                    nArray[SpatialMathEnum.Fill.EMPTY.ordinal()] = 1;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[SpatialMathEnum.Fill.FULL.ordinal()] = 2;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                $EnumSwitchMapping$1 = nArray;
            }
        }
    }
}

