/*
 * Decompiled with CFR 0.152.
 */
package org.brailleblaster.math.numberLine;

import java.util.Collection;
import java.util.List;
import java.util.ListIterator;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Regex;
import org.apache.commons.lang3.math.Fraction;
import org.brailleblaster.math.numberLine.NumberLine;
import org.brailleblaster.math.spatial.SpatialMathEnum;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tJ\u0016\u0010\n\u001a\u00020\t2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t\u00a8\u0006\u000b"}, d2={"Lorg/brailleblaster/math/numberLine/NumberLineMathUtils;", "", "<init>", "()V", "getFractionString", "", "numberLine", "Lorg/brailleblaster/math/numberLine/NumberLine;", "fraction", "Lorg/apache/commons/lang3/math/Fraction;", "unReduce", "brailleblaster-core"})
@SourceDebugExtension(value={"SMAP\nNumberLineMathUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 NumberLineMathUtils.kt\norg/brailleblaster/math/numberLine/NumberLineMathUtils\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,94:1\n742#2,9:95\n37#3,2:104\n*S KotlinDebug\n*F\n+ 1 NumberLineMathUtils.kt\norg/brailleblaster/math/numberLine/NumberLineMathUtils\n*L\n30#1:95,9\n30#1:104,2\n*E\n"})
public final class NumberLineMathUtils {
    @NotNull
    public static final NumberLineMathUtils INSTANCE = new NumberLineMathUtils();

    private NumberLineMathUtils() {
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final String getFractionString(@NotNull NumberLine numberLine, @NotNull Fraction fraction) {
        Intrinsics.checkNotNullParameter((Object)numberLine, (String)"numberLine");
        Intrinsics.checkNotNullParameter((Object)fraction, (String)"fraction");
        Fraction fraction2 = fraction;
        String string = null;
        if (numberLine.getSettings().getIntervalType() == SpatialMathEnum.IntervalType.WHOLE) {
            string = String.valueOf(fraction2.intValue());
        } else if (numberLine.getSettings().getIntervalType() == SpatialMathEnum.IntervalType.DECIMAL) {
            if (numberLine.getSettings().isRemoveLeadingZeros()) {
                void $this$toTypedArray$iv;
                List list;
                Collection $this$dropLastWhile$iv;
                string = String.valueOf(fraction2.doubleValue());
                Object object = string;
                Regex regex = new Regex("\\.");
                int n = 0;
                object = regex.split((CharSequence)object, n);
                boolean $i$f$dropLastWhile = false;
                if (!$this$dropLastWhile$iv.isEmpty()) {
                    ListIterator iterator$iv = $this$dropLastWhile$iv.listIterator($this$dropLastWhile$iv.size());
                    while (iterator$iv.hasPrevious()) {
                        String it = (String)iterator$iv.previous();
                        boolean bl = false;
                        if (((CharSequence)it).length() == 0) continue;
                        list = CollectionsKt.take((Iterable)$this$dropLastWhile$iv, (int)(iterator$iv.nextIndex() + 1));
                        break;
                    }
                } else {
                    list = CollectionsKt.emptyList();
                }
                $this$dropLastWhile$iv = list;
                boolean $i$f$toTypedArray = false;
                void thisCollection$iv = $this$toTypedArray$iv;
                String[] array = thisCollection$iv.toArray(new String[0]);
                if (array.length < 2) {
                    return string;
                }
                if (Integer.parseInt(array[0]) == 0) {
                    return "." + array[1];
                }
            } else {
                string = String.valueOf(fraction2.doubleValue());
            }
        } else if (numberLine.getSettings().getIntervalType() == SpatialMathEnum.IntervalType.MIXED) {
            if (numberLine.getSettings().isReduceFraction()) {
                String string2;
                if (fraction2.getProperWhole() == 0) {
                    var5_14 = fraction2.reduce().toString();
                    Intrinsics.checkNotNull((Object)var5_14);
                    string2 = var5_14;
                } else {
                    var5_14 = fraction2.reduce().toProperString();
                    Intrinsics.checkNotNull((Object)var5_14);
                    string2 = var5_14;
                }
                string = string2;
            } else {
                String string3;
                if ((fraction2 = this.unReduce(numberLine, fraction2)).getProperWhole() == 0) {
                    var5_15 = fraction2.toString();
                    Intrinsics.checkNotNull((Object)var5_15);
                    string3 = var5_15;
                } else {
                    var5_15 = fraction2.toProperString();
                    Intrinsics.checkNotNull((Object)var5_15);
                    string3 = var5_15;
                }
                string = string3;
            }
        } else if (numberLine.getSettings().isReduceFraction()) {
            String string4 = fraction2.reduce().toString();
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"toString(...)");
            string = string4;
        } else {
            fraction2 = this.unReduce(numberLine, fraction2);
            String string5 = fraction2.toString();
            Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"toString(...)");
            string = string5;
        }
        return string;
    }

    @NotNull
    public final Fraction unReduce(@NotNull NumberLine numberLine, @NotNull Fraction fraction) {
        Fraction fraction2;
        Intrinsics.checkNotNullParameter((Object)numberLine, (String)"numberLine");
        Intrinsics.checkNotNullParameter((Object)fraction, (String)"fraction");
        int denominatorInterval = Integer.parseInt(numberLine.getNumberLineText().getInterval().getDenominator());
        int thisDenominator = fraction.getDenominator();
        if (denominatorInterval == thisDenominator) {
            fraction2 = fraction;
        } else {
            Fraction fraction3;
            if (numberLine.getSettings().getIntervalType() == SpatialMathEnum.IntervalType.IMPROPER) {
                thisNumerator = fraction.getNumerator();
                factor = denominatorInterval / thisDenominator;
                newNumerator = thisNumerator * factor;
                fraction3 = Fraction.getFraction((int)newNumerator, (int)denominatorInterval);
            } else {
                thisNumerator = fraction.getProperNumerator();
                factor = denominatorInterval / thisDenominator;
                newNumerator = thisNumerator * factor;
                fraction3 = Fraction.getFraction((int)fraction.getProperWhole(), (int)newNumerator, (int)denominatorInterval);
            }
            Fraction fraction4 = fraction3;
            Intrinsics.checkNotNull((Object)fraction4);
            fraction2 = fraction4;
        }
        return fraction2;
    }
}

