/*
 * Decompiled with CFR 0.152.
 */
package org.brailleblaster.math.numberLine;

import java.util.Arrays;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Regex;
import org.apache.commons.lang3.math.Fraction;
import org.brailleblaster.math.numberLine.NumberLine;
import org.brailleblaster.math.numberLine.NumberLineComponent;
import org.brailleblaster.math.numberLine.NumberLineConstants;
import org.brailleblaster.math.numberLine.NumberLineMathUtils;
import org.brailleblaster.math.numberLine.NumberLineSegment;
import org.brailleblaster.math.numberLine.NumberLineSegmentPoint;
import org.brailleblaster.math.numberLine.NumberLineStringParser;
import org.brailleblaster.math.numberLine.NumberLineText;
import org.brailleblaster.math.numberLine.NumberLineWidget;
import org.brailleblaster.math.spatial.ISpatialMathContainer;
import org.brailleblaster.math.spatial.MathFormattingException;
import org.brailleblaster.math.spatial.SpatialMathDispatcher;
import org.brailleblaster.math.spatial.SpatialMathEnum;
import org.brailleblaster.perspectives.mvc.modules.views.DebugModule;
import org.brailleblaster.util.Notify;
import org.brailleblaster.utils.swt.EasySWT;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J \u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\u0005H\u0016J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J\b\u0010\u000e\u001a\u00020\u000bH\u0002J\b\u0010\u000f\u001a\u00020\u000bH\u0016J\b\u0010\u0010\u001a\u00020\u000bH\u0016J\u0018\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00122\u0006\u0010\u0014\u001a\u00020\rH\u0016J\u0010\u0010\u0015\u001a\u00020\u000b2\u0006\u0010\u0006\u001a\u00020\u0012H\u0002J\u0010\u0010\u0016\u001a\u00020\u000b2\u0006\u0010\u0017\u001a\u00020\u0012H\u0002J\u0010\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001bH\u0002J\u0010\u0010\u001c\u001a\u00020\u000b2\u0006\u0010\u001d\u001a\u00020\u0012H\u0002J\u0010\u0010\u001e\u001a\u00020\u000b2\u0006\u0010\u0006\u001a\u00020\u0012H\u0002J\u0010\u0010\u001f\u001a\u00020\u000b2\u0006\u0010\u0006\u001a\u00020\u0012H\u0002J\u0010\u0010 \u001a\u00020\u000b2\u0006\u0010\u0006\u001a\u00020\u0012H\u0002\u00a8\u0006!"}, d2={"Lorg/brailleblaster/math/numberLine/NumberLineWidgetAutomaticMath;", "Lorg/brailleblaster/math/numberLine/NumberLineWidget;", "<init>", "()V", "addMenuItems", "Lorg/eclipse/swt/widgets/Menu;", "shell", "Lorg/eclipse/swt/widgets/Shell;", "menu", "settingsMenu", "fillDebug", "", "t", "Lorg/brailleblaster/math/spatial/ISpatialMathContainer;", "defaultDebug", "onOpen", "extractText", "getWidget", "Lorg/eclipse/swt/widgets/Composite;", "parent", "container", "makePointsCombo", "makeStartSegmentGroup", "startSegmentGroup", "parseEntry", "", "s", "", "makeEndSegmentGroup", "endSegmentGroup", "makeStartLineGroup", "makeEndLineGroup", "intervalGroup", "brailleblaster-core"})
public final class NumberLineWidgetAutomaticMath
extends NumberLineWidget {
    @Override
    @NotNull
    public Menu addMenuItems(@NotNull Shell shell, @NotNull Menu menu, @NotNull Menu settingsMenu) {
        Intrinsics.checkNotNullParameter((Object)shell, (String)"shell");
        Intrinsics.checkNotNullParameter((Object)menu, (String)"menu");
        Intrinsics.checkNotNullParameter((Object)settingsMenu, (String)"settingsMenu");
        if (DebugModule.enabled) {
            this.addDebugMenu(shell, menu);
        }
        this.addNumberLineType(shell, menu);
        this.addOptionsMenu(shell, menu, settingsMenu);
        this.addSectionTypeMenu(shell, menu);
        if (SpatialMathEnum.NumberLineSection.SEGMENT == this.getNumberLine().getSettings().getSectionType()) {
            this.addStartSegmentType(shell, menu);
            this.addEndSegmentType(shell, menu);
        } else if (SpatialMathEnum.NumberLineSection.POINTS == this.getNumberLine().getSettings().getSectionType()) {
            this.addAdditionalSegmentDropDown(shell, menu);
            this.addPointsType(shell, menu);
        }
        return menu;
    }

    @Override
    public void fillDebug(@NotNull ISpatialMathContainer t) {
        Intrinsics.checkNotNullParameter((Object)t, (String)"t");
        this.setNumberLine((NumberLine)t);
        this.defaultDebug();
    }

    private final void defaultDebug() {
        switch (WhenMappings.$EnumSwitchMapping$0[this.getNumberLine().getSettings().getIntervalType().ordinal()]) {
            case 1: {
                NumberLineComponent numberLineComponent = new NumberLineComponent.NumberLineComponentBuilder().whole("1").build();
                NumberLineComponent numberLineComponent2 = new NumberLineComponent.NumberLineComponentBuilder().whole("4").build();
                NumberLineComponent numberLineComponent3 = new NumberLineComponent.NumberLineComponentBuilder().whole("1").build();
                NumberLineComponent numberLineComponent4 = new NumberLineComponent.NumberLineComponentBuilder().whole("3").build();
                NumberLineComponent numberLineComponent5 = new NumberLineComponent.NumberLineComponentBuilder().whole("1").build();
                NumberLineSegment numberLineSegment = new NumberLineSegment(null, null, numberLineComponent5, numberLineComponent4, 0, 0, 51, null);
                NumberLineText text = new NumberLineText(numberLineComponent, numberLineSegment, numberLineComponent3, numberLineComponent2, null, 16, null);
                this.getNumberLine().setNumberLineText(text);
                break;
            }
            case 2: {
                NumberLineComponent numberLineComponent = new NumberLineComponent.NumberLineComponentBuilder().whole("1").numerator("1").denominator("2").build();
                NumberLineComponent numberLineComponent6 = new NumberLineComponent.NumberLineComponentBuilder().whole("4").numerator("1").denominator("2").build();
                NumberLineComponent numberLineComponent7 = new NumberLineComponent.NumberLineComponentBuilder().whole("1").numerator("1").denominator("2").build();
                NumberLineComponent numberLineComponent8 = new NumberLineComponent.NumberLineComponentBuilder().whole("3").numerator("").denominator("").build();
                NumberLineComponent numberLineComponent9 = new NumberLineComponent.NumberLineComponentBuilder().whole("1").numerator("1").denominator("2").build();
                NumberLineSegment numberLineSegment = new NumberLineSegment(null, null, numberLineComponent9, numberLineComponent8, 0, 0, 51, null);
                NumberLineText text = new NumberLineText(numberLineComponent, numberLineSegment, numberLineComponent7, numberLineComponent6, null, 16, null);
                this.getNumberLine().setNumberLineText(text);
                break;
            }
            case 3: {
                NumberLineComponent numberLineComponent = new NumberLineComponent.NumberLineComponentBuilder().numerator("2").denominator("5").build();
                NumberLineComponent numberLineComponent10 = new NumberLineComponent.NumberLineComponentBuilder().numerator("6").denominator("5").build();
                NumberLineComponent numberLineComponent11 = new NumberLineComponent.NumberLineComponentBuilder().numerator("2").denominator("5").build();
                NumberLineComponent numberLineComponent12 = new NumberLineComponent.NumberLineComponentBuilder().numerator("4").denominator("5").build();
                NumberLineComponent numberLineComponent13 = new NumberLineComponent.NumberLineComponentBuilder().numerator("2").denominator("5").build();
                NumberLineSegment numberLineSegment = new NumberLineSegment(null, null, numberLineComponent13, numberLineComponent12, 0, 0, 51, null);
                NumberLineText text = new NumberLineText(numberLineComponent, numberLineSegment, numberLineComponent11, numberLineComponent10, null, 16, null);
                this.getNumberLine().setNumberLineText(text);
                break;
            }
            case 4: {
                NumberLineComponent numberLineComponent = new NumberLineComponent.NumberLineComponentBuilder().whole("1").decimal("2").build();
                NumberLineComponent numberLineComponent14 = new NumberLineComponent.NumberLineComponentBuilder().whole("3").decimal("6").build();
                NumberLineComponent numberLineComponent15 = new NumberLineComponent.NumberLineComponentBuilder().whole("1").decimal("2").build();
                NumberLineComponent numberLineComponent16 = new NumberLineComponent.NumberLineComponentBuilder().whole("2").decimal("4").build();
                NumberLineComponent numberLineComponent17 = new NumberLineComponent.NumberLineComponentBuilder().whole("1").decimal("2").build();
                NumberLineSegment numberLineSegment = new NumberLineSegment(null, null, numberLineComponent17, numberLineComponent16, 0, 0, 51, null);
                NumberLineText text = new NumberLineText(numberLineComponent, numberLineSegment, numberLineComponent15, numberLineComponent14, null, 16, null);
                this.getNumberLine().setNumberLineText(text);
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        this.getNumberLine().loadStringParser();
    }

    @Override
    public void onOpen() {
    }

    @Override
    public void extractText() {
    }

    @Override
    @NotNull
    public Composite getWidget(@NotNull Composite parent, @NotNull ISpatialMathContainer container) {
        Intrinsics.checkNotNullParameter((Object)parent, (String)"parent");
        Intrinsics.checkNotNullParameter((Object)container, (String)"container");
        this.setNumberLine((NumberLine)container);
        Group g = EasySWT.makeGroup((Composite)parent, (int)0, (int)2, (boolean)false);
        this.intervalGroup((Composite)g);
        this.makeStartLineGroup((Composite)g);
        this.makeEndLineGroup((Composite)g);
        if (SpatialMathEnum.NumberLineSection.SEGMENT == this.getNumberLine().getSettings().getSectionType()) {
            this.makeStartSegmentGroup((Composite)g);
            this.makeEndSegmentGroup((Composite)g);
        } else if (SpatialMathEnum.NumberLineSection.POINTS == this.getNumberLine().getSettings().getSectionType()) {
            this.getNumberLine().initializePoints();
            this.makePointsCombo((Composite)g);
        }
        this.addBlankAndLabels(parent);
        return parent;
    }

    private final void makePointsCombo(Composite shell) {
        Group g = EasySWT.makeGroup((Composite)shell, (int)0, (int)1, (boolean)true);
        g.setText(NumberLineConstants.POINT);
        int n = ((Collection)this.getNumberLine().getNumberLineText().getPoints()).size();
        for (int i = 0; i < n; ++i) {
            NumberLineSegmentPoint point = this.getNumberLine().getSegmentPoints().get(i);
            Combo combo = new Combo((Composite)g, 12);
            combo.addFocusListener(new FocusListener(this, combo){
                final /* synthetic */ NumberLineWidgetAutomaticMath this$0;
                final /* synthetic */ Combo $combo;
                {
                    this.this$0 = $receiver;
                    this.$combo = $combo;
                }

                public void focusGained(FocusEvent e) {
                    Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                    try {
                        this.this$0.getNumberLine().parse();
                        String[] stringArray = NumberLineSegmentPoint.Companion.getPotentialPointsStringArray(this.this$0.getNumberLine());
                        this.$combo.setItems(Arrays.copyOf(stringArray, stringArray.length));
                    }
                    catch (MathFormattingException ex) {
                        ex.printStackTrace();
                    }
                }

                public void focusLost(FocusEvent e) {
                    Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                }
            });
            combo.setData((Object)new GridData(4, 4, true, true));
            try {
                String[] stringArray = NumberLineSegmentPoint.Companion.getPotentialPointsStringArray(this.getNumberLine());
                combo.setItems(Arrays.copyOf(stringArray, stringArray.length));
            }
            catch (MathFormattingException mathFormattingException) {
                // empty catch block
            }
            EasySWT.INSTANCE.addSelectionListener(combo, arg_0 -> NumberLineWidgetAutomaticMath.makePointsCombo$lambda$0(this, combo, i, arg_0));
            if (point.getPoint().isEmpty()) continue;
            int index = 0;
            try {
                Fraction fraction = point.getPoint().getFraction();
                String pointString = NumberLineMathUtils.INSTANCE.getFractionString(this.getNumberLine(), fraction);
                index = combo.indexOf(pointString);
                if (index == -1) {
                    index = 0;
                }
            }
            catch (MathFormattingException mathFormattingException) {
                index = 0;
            }
            combo.select(index);
        }
    }

    private final void makeStartSegmentGroup(Composite startSegmentGroup) {
        EasySWT.makeLabel((Composite)startSegmentGroup, (String)NumberLineConstants.SEGMENT_START_LABEL, (int)1);
        Text whole = EasySWT.makeText((Composite)startSegmentGroup, (int)50, (int)1);
        EasySWT.INSTANCE.addModifyListener(whole, arg_0 -> NumberLineWidgetAutomaticMath.makeStartSegmentGroup$lambda$0(this, whole, arg_0));
        whole.setText(this.getNumberLine().getSettings().getStringParser().getSegmentStart());
    }

    private final boolean parseEntry(String s) {
        CharSequence charSequence = s;
        return new Regex("[0-9/.\\s\\-\\-]*").matches(charSequence);
    }

    private final void makeEndSegmentGroup(Composite endSegmentGroup) {
        EasySWT.makeLabel((Composite)endSegmentGroup, (String)NumberLineConstants.SEGMENT_END_LABEL, (int)1);
        Text whole = EasySWT.makeText((Composite)endSegmentGroup, (int)50, (int)1);
        EasySWT.INSTANCE.addModifyListener(whole, arg_0 -> NumberLineWidgetAutomaticMath.makeEndSegmentGroup$lambda$0(this, whole, arg_0));
        whole.setText(this.getNumberLine().getSettings().getStringParser().getSegmentEnd());
    }

    private final void makeStartLineGroup(Composite shell) {
        EasySWT.makeLabel((Composite)shell, (String)NumberLineConstants.LINE_START_LABEL, (int)1);
        Text whole = EasySWT.makeText((Composite)shell, (int)50, (int)1);
        EasySWT.INSTANCE.addModifyListener(whole, arg_0 -> NumberLineWidgetAutomaticMath.makeStartLineGroup$lambda$0(this, whole, arg_0));
        whole.setText(this.getNumberLine().getSettings().getStringParser().getLineStartString());
    }

    private final void makeEndLineGroup(Composite shell) {
        EasySWT.makeLabel((Composite)shell, (String)NumberLineConstants.LINE_END_LABEL, (int)1);
        Text whole = EasySWT.makeText((Composite)shell, (int)50, (int)1);
        EasySWT.INSTANCE.addModifyListener(whole, arg_0 -> NumberLineWidgetAutomaticMath.makeEndLineGroup$lambda$0(this, whole, arg_0));
        whole.setText(this.getNumberLine().getSettings().getStringParser().getLineEndString());
    }

    private final void intervalGroup(Composite shell) {
        EasySWT.makeLabel((Composite)shell, (String)NumberLineConstants.INTERVAL_LABEL, (int)1);
        Text whole = EasySWT.makeText((Composite)shell, (int)50, (int)1);
        EasySWT.INSTANCE.addModifyListener(whole, arg_0 -> NumberLineWidgetAutomaticMath.intervalGroup$lambda$0(this, whole, arg_0));
        whole.setText(this.getNumberLine().getSettings().getStringParser().getIntervalString());
    }

    private static final void makePointsCombo$lambda$0(NumberLineWidgetAutomaticMath this$0, Combo $combo, int $i, SelectionEvent it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        NumberLineSegmentPoint newPoint = null;
        try {
            NumberLineSegmentPoint numberLineSegmentPoint = NumberLineSegmentPoint.Companion.getPotentialPoints(this$0.getNumberLine()).get($combo.getSelectionIndex());
            Intrinsics.checkNotNullExpressionValue((Object)numberLineSegmentPoint, (String)"get(...)");
            newPoint = numberLineSegmentPoint;
            this$0.getNumberLine().getNumberLineText().getPoints().set($i, newPoint);
            SpatialMathDispatcher.INSTANCE.dispatch();
        }
        catch (MathFormattingException e1) {
            e1.printStackTrace();
        }
    }

    private static final void makeStartSegmentGroup$lambda$0(NumberLineWidgetAutomaticMath this$0, Text $whole, ModifyEvent it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        String string = $whole.getText();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
        if (!this$0.parseEntry(string)) {
            Notify.notify$default(Notify.INSTANCE, NumberLineConstants.NUMBER_LINE_ALLOWED_CHARS, Notify.ALERT_SHELL_NAME, false, 4, null);
            return;
        }
        NumberLineStringParser numberLineStringParser = this$0.getNumberLine().getSettings().getStringParser();
        String string2 = $whole.getText();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getText(...)");
        numberLineStringParser.setSegmentStart(string2);
    }

    private static final void makeEndSegmentGroup$lambda$0(NumberLineWidgetAutomaticMath this$0, Text $whole, ModifyEvent it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        String string = $whole.getText();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
        if (!this$0.parseEntry(string)) {
            Notify.notify$default(Notify.INSTANCE, NumberLineConstants.NUMBER_LINE_ALLOWED_CHARS, Notify.ALERT_SHELL_NAME, false, 4, null);
            return;
        }
        NumberLineStringParser numberLineStringParser = this$0.getNumberLine().getSettings().getStringParser();
        String string2 = $whole.getText();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getText(...)");
        numberLineStringParser.setSegmentEnd(string2);
    }

    private static final void makeStartLineGroup$lambda$0(NumberLineWidgetAutomaticMath this$0, Text $whole, ModifyEvent it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        String string = $whole.getText();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
        if (!this$0.parseEntry(string)) {
            Notify.notify$default(Notify.INSTANCE, NumberLineConstants.NUMBER_LINE_ALLOWED_CHARS, Notify.ALERT_SHELL_NAME, false, 4, null);
            return;
        }
        NumberLineStringParser numberLineStringParser = this$0.getNumberLine().getSettings().getStringParser();
        String string2 = $whole.getText();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getText(...)");
        numberLineStringParser.setLineStart(string2);
    }

    private static final void makeEndLineGroup$lambda$0(NumberLineWidgetAutomaticMath this$0, Text $whole, ModifyEvent it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        String string = $whole.getText();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
        if (!this$0.parseEntry(string)) {
            Notify.notify$default(Notify.INSTANCE, NumberLineConstants.NUMBER_LINE_ALLOWED_CHARS, Notify.ALERT_SHELL_NAME, false, 4, null);
            return;
        }
        NumberLineStringParser numberLineStringParser = this$0.getNumberLine().getSettings().getStringParser();
        String string2 = $whole.getText();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getText(...)");
        numberLineStringParser.setLineEnd(string2);
    }

    private static final void intervalGroup$lambda$0(NumberLineWidgetAutomaticMath this$0, Text $whole, ModifyEvent it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        String string = $whole.getText();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
        if (!this$0.parseEntry(string)) {
            Notify.notify$default(Notify.INSTANCE, NumberLineConstants.NUMBER_LINE_ALLOWED_CHARS, Notify.ALERT_SHELL_NAME, false, 4, null);
            return;
        }
        NumberLineStringParser numberLineStringParser = this$0.getNumberLine().getSettings().getStringParser();
        String string2 = $whole.getText();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getText(...)");
        numberLineStringParser.setIntervalString(string2);
    }

    @Metadata(mv={2, 3, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[SpatialMathEnum.IntervalType.values().length];
            try {
                nArray[SpatialMathEnum.IntervalType.WHOLE.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[SpatialMathEnum.IntervalType.MIXED.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[SpatialMathEnum.IntervalType.IMPROPER.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[SpatialMathEnum.IntervalType.DECIMAL.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

