/*
 * Decompiled with CFR 0.152.
 */
package org.brailleblaster.math.numberLine;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.ListIterator;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.apache.commons.lang3.math.Fraction;
import org.brailleblaster.math.mathml.MathModuleUtils;
import org.brailleblaster.math.numberLine.NumberLine;
import org.brailleblaster.math.numberLine.NumberLineFormatter;
import org.brailleblaster.math.numberLine.NumberLineLine;
import org.brailleblaster.math.numberLine.NumberLineMathUtils;
import org.brailleblaster.math.numberLine.NumberLinePoint;
import org.brailleblaster.math.numberLine.NumberLineSegmentPoint;
import org.brailleblaster.math.spatial.Line;
import org.brailleblaster.math.spatial.MathFormattingException;
import org.brailleblaster.math.spatial.MathText;
import org.brailleblaster.math.spatial.SpatialMathEnum;
import org.brailleblaster.settings.UTDManager;
import org.brailleblaster.utd.ITranslationEngine;
import org.brailleblaster.utd.utils.TextTranslator;
import org.brailleblaster.wordprocessor.WPManager;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0004\b\u0016\u0018\u0000 \u00042\u00020\u0001:\u0001\u0004B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003\u00a8\u0006\u0005"}, d2={"Lorg/brailleblaster/math/numberLine/UebNumberLineFormatter;", "", "<init>", "()V", "Companion", "brailleblaster-core"})
public class UebNumberLineFormatter {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final Logger log;

    static {
        Logger logger = LoggerFactory.getLogger(UebNumberLineFormatter.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getLogger(...)");
        log = logger;
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bJ\u000e\u0010\f\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bJ\u0018\u0010\r\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u000e\u001a\u00020\u000fH\u0004J\u0016\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u000e\u001a\u00020\u000fJ\u0016\u0010\u0011\u001a\u00020\u00122\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0013\u001a\u00020\u0014J\u0018\u0010\u0015\u001a\u00020\u00122\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J\u0018\u0010\u0016\u001a\u00020\u00122\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J\u000e\u0010\u0017\u001a\u00020\u00182\u0006\u0010\n\u001a\u00020\u000bJ\u000e\u0010\u0019\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bJ\u0018\u0010\u001a\u001a\u00020\u00122\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0013\u001a\u00020\u0014H\u0002R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u001b"}, d2={"Lorg/brailleblaster/math/numberLine/UebNumberLineFormatter$Companion;", "", "<init>", "()V", "log", "Lorg/slf4j/Logger;", "getLog", "()Lorg/slf4j/Logger;", "formatSegment", "", "numberLine", "Lorg/brailleblaster/math/numberLine/NumberLine;", "formatLine", "formatPoints", "cellsPerLine", "", "getStretchCells", "getFractionString", "", "fraction", "Lorg/apache/commons/lang3/math/Fraction;", "getBrailleFraction", "makeImproperFractionString", "format", "", "formatMultiplePoints", "makeMixedFractionString", "brailleblaster-core"})
    @SourceDebugExtension(value={"SMAP\nUebNumberLineFormatter.kt\nKotlin\n*S Kotlin\n*F\n+ 1 UebNumberLineFormatter.kt\norg/brailleblaster/math/numberLine/UebNumberLineFormatter$Companion\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,412:1\n742#2,9:413\n742#2,9:424\n37#3,2:422\n37#3,2:433\n*S KotlinDebug\n*F\n+ 1 UebNumberLineFormatter.kt\norg/brailleblaster/math/numberLine/UebNumberLineFormatter$Companion\n*L\n187#1:413,9\n236#1:424,9\n187#1:422,2\n236#1:433,2\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Logger getLog() {
            return log;
        }

        public final void formatSegment(@NotNull NumberLine numberLine) {
            Intrinsics.checkNotNullParameter((Object)numberLine, (String)"numberLine");
            int startInterval = numberLine.getSegment().getStartInterval();
            int endInterval = numberLine.getSegment().getEndInterval();
            int countOfIntervals = 0;
            boolean inSegment = false;
            Line line = new Line();
            int n = ((Collection)numberLine.getLine()).size();
            for (int i = 0; i < n; ++i) {
                boolean bl;
                NumberLineLine lineSegment;
                Intrinsics.checkNotNullExpressionValue((Object)numberLine.getLine().get(i), (String)"get(...)");
                NumberLineLine.LineChar c = lineSegment.getType();
                if (c == NumberLineLine.LineChar.INTERVAL) {
                    if (++countOfIntervals == startInterval) {
                        inSegment = true;
                        bl = line.getElements().add(line.getTextSegment(NumberLineFormatter.Companion.getSegmentBeginning(numberLine)));
                        continue;
                    }
                    if (countOfIntervals == endInterval) {
                        inSegment = false;
                        bl = line.getElements().add(line.getTextSegment(NumberLineFormatter.Companion.getSegmentEnding(numberLine)));
                        continue;
                    }
                    if (inSegment && !numberLine.getSegment().isPoint()) {
                        bl = line.getElements().add(line.getTextSegment("3"));
                        continue;
                    }
                    bl = line.getElements().add(line.getWhitespaceSegment(1));
                    continue;
                }
                bl = inSegment && !numberLine.getSegment().isPoint() ? line.getElements().add(line.getTextSegment(StringsKt.repeat((CharSequence)"3", (int)lineSegment.getLength()))) : line.getElements().add(line.getWhitespaceSegment(lineSegment.getTotalLength()));
            }
            ((ArrayList)numberLine.getLines()).add(0, line);
        }

        public final void formatLine(@NotNull NumberLine numberLine) {
            Intrinsics.checkNotNullParameter((Object)numberLine, (String)"numberLine");
            ArrayList<NumberLinePoint> array = numberLine.getPoints();
            ArrayList<NumberLineLine> lineChars = new ArrayList<NumberLineLine>();
            if (numberLine.getSettings().isArrow()) {
                lineChars.add(new NumberLineLine(NumberLineLine.LineChar.ARROW_START));
            }
            lineChars.add(new NumberLineLine(NumberLineLine.LineChar.HORIZONTAL_MODE));
            int n = ((Collection)array).size();
            for (int i = 0; i < n; ++i) {
                NumberLinePoint mathText;
                Intrinsics.checkNotNullExpressionValue((Object)array.get(i), (String)"get(...)");
                if (i != 0) {
                    v0 = lineChars.add(new NumberLineLine(NumberLineLine.LineChar.LINE_EMPTY, mathText.getLeftPadding() + mathText.getLeftDec().length()));
                } else {
                    int necessaryLeadingChars = mathText.isMinus() ? 2 : 1;
                    v0 = lineChars.add(new NumberLineLine(NumberLineLine.LineChar.LINE_EMPTY, necessaryLeadingChars));
                }
                lineChars.add(new NumberLineLine(NumberLineLine.LineChar.INTERVAL));
                boolean bl = i != array.size() - 1 ? lineChars.add(new NumberLineLine(NumberLineLine.LineChar.LINE_EMPTY, mathText.getRightPadding() + mathText.getRightDec().length() + 1)) : lineChars.add(new NumberLineLine(NumberLineLine.LineChar.LINE_EMPTY, numberLine.getLastIntervalLength()));
            }
            if (numberLine.getSettings().isArrow()) {
                lineChars.add(new NumberLineLine(NumberLineLine.LineChar.ARROW_END));
            }
            numberLine.setLine(lineChars);
        }

        protected final void formatPoints(@NotNull NumberLine numberLine, int cellsPerLine) throws MathFormattingException {
            int addedCells;
            Intrinsics.checkNotNullParameter((Object)numberLine, (String)"numberLine");
            ArrayList<NumberLinePoint> points = new ArrayList<NumberLinePoint>();
            Fraction interval = numberLine.getNumberLineText().getInterval().getFraction();
            Fraction lineStart = numberLine.getNumberLineText().getLineStart().getFraction();
            Fraction lineEnd = numberLine.getNumberLineText().getLineEnd().getFraction();
            int totalUnits = (int)lineEnd.subtract(lineStart).divideBy(interval).doubleValue() + 1;
            for (int i = 0; i < totalUnits; ++i) {
                Fraction fraction;
                if (i != 0) {
                    Fraction additionalUnits = interval.multiplyBy(Fraction.getFraction((double)i));
                    Fraction fraction2 = lineStart.add(additionalUnits);
                    Intrinsics.checkNotNull((Object)fraction2);
                    fraction = fraction2;
                } else {
                    fraction = lineStart;
                }
                Fraction fraction3 = fraction;
                String string = this.getFractionString(numberLine, fraction3);
                String braille = this.getBrailleFraction(numberLine, fraction3);
                MathText mathText = new MathText(string, braille, false, 4, null);
                boolean bl = fraction3.doubleValue() < 0.0;
                points.add(new NumberLinePoint(bl, fraction3, mathText, false, 8, null));
            }
            numberLine.setPoints(points);
            NumberLineFormatter.Companion.dealWithBlanks(numberLine);
            NumberLinePoint.Companion.makeColumnsEqualWidth(points);
            if (numberLine.getSettings().isStretch() && (addedCells = this.getStretchCells(numberLine, cellsPerLine)) > 0) {
                int n = ((Collection)numberLine.getPoints()).size();
                for (int i = 0; i < n; ++i) {
                    NumberLinePoint numberLinePoint = numberLine.getPoints().get(i);
                    numberLinePoint.setRightPadding(numberLinePoint.getRightPadding() + addedCells);
                }
            }
        }

        public final int getStretchCells(@NotNull NumberLine numberLine, int cellsPerLine) throws MathFormattingException {
            int addedCells;
            Intrinsics.checkNotNullParameter((Object)numberLine, (String)"numberLine");
            this.formatLine(numberLine);
            int necessaryCells = NumberLineLine.Companion.getLineLength(numberLine.getLine());
            int leftoverCells = cellsPerLine - necessaryCells;
            int intervals = (int)Math.floor(numberLine.getNumberLineText().getLineEnd().getFraction().subtract(numberLine.getNumberLineText().getLineStart().getFraction()).doubleValue());
            if (leftoverCells > intervals && (addedCells = leftoverCells / intervals) > 0) {
                return addedCells;
            }
            return 0;
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final String getFractionString(@NotNull NumberLine numberLine, @NotNull Fraction fraction) {
            Intrinsics.checkNotNullParameter((Object)numberLine, (String)"numberLine");
            Intrinsics.checkNotNullParameter((Object)fraction, (String)"fraction");
            Fraction fraction2 = fraction;
            String string = null;
            if (numberLine.getSettings().getIntervalType() == SpatialMathEnum.IntervalType.WHOLE) {
                string = String.valueOf(fraction2.intValue());
            } else if (numberLine.getSettings().getIntervalType() == SpatialMathEnum.IntervalType.DECIMAL) {
                if (numberLine.getSettings().isRemoveLeadingZeros()) {
                    void $this$toTypedArray$iv;
                    List list;
                    Collection $this$dropLastWhile$iv;
                    string = String.valueOf(fraction2.doubleValue());
                    Object object = string;
                    Regex regex = new Regex("\\.");
                    int n = 0;
                    object = regex.split((CharSequence)object, n);
                    boolean $i$f$dropLastWhile = false;
                    if (!$this$dropLastWhile$iv.isEmpty()) {
                        ListIterator iterator$iv = $this$dropLastWhile$iv.listIterator($this$dropLastWhile$iv.size());
                        while (iterator$iv.hasPrevious()) {
                            String it = (String)iterator$iv.previous();
                            boolean bl = false;
                            if (((CharSequence)it).length() == 0) continue;
                            list = CollectionsKt.take((Iterable)$this$dropLastWhile$iv, (int)(iterator$iv.nextIndex() + 1));
                            break;
                        }
                    } else {
                        list = CollectionsKt.emptyList();
                    }
                    $this$dropLastWhile$iv = list;
                    boolean $i$f$toTypedArray = false;
                    void thisCollection$iv = $this$toTypedArray$iv;
                    String[] array = thisCollection$iv.toArray(new String[0]);
                    if (array.length < 2) {
                        return string;
                    }
                    if (Integer.parseInt(array[0]) == 0) {
                        return "." + array[1];
                    }
                } else {
                    string = String.valueOf(fraction2.doubleValue());
                }
            } else if (numberLine.getSettings().getIntervalType() == SpatialMathEnum.IntervalType.MIXED) {
                if (numberLine.getSettings().isReduceFraction()) {
                    String string2;
                    if (fraction2.getProperWhole() == 0) {
                        var5_14 = fraction2.reduce().toString();
                        Intrinsics.checkNotNull((Object)var5_14);
                        string2 = var5_14;
                    } else {
                        var5_14 = fraction2.reduce().toProperString();
                        Intrinsics.checkNotNull((Object)var5_14);
                        string2 = var5_14;
                    }
                    string = string2;
                } else {
                    String string3;
                    if ((fraction2 = NumberLineMathUtils.INSTANCE.unReduce(numberLine, fraction2)).getProperWhole() == 0) {
                        var5_15 = fraction2.toString();
                        Intrinsics.checkNotNull((Object)var5_15);
                        string3 = var5_15;
                    } else {
                        var5_15 = fraction2.toProperString();
                        Intrinsics.checkNotNull((Object)var5_15);
                        string3 = var5_15;
                    }
                    string = string3;
                }
            } else if (numberLine.getSettings().isReduceFraction()) {
                String string4 = fraction2.reduce().toString();
                Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"toString(...)");
                string = string4;
            } else {
                fraction2 = NumberLineMathUtils.INSTANCE.unReduce(numberLine, fraction2);
                String string5 = fraction2.toString();
                Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"toString(...)");
                string = string5;
            }
            return string;
        }

        /*
         * WARNING - void declaration
         */
        private final String getBrailleFraction(NumberLine numberLine, Fraction fraction) {
            String string;
            Fraction fraction2 = fraction;
            Object string2 = null;
            if (numberLine.getSettings().getIntervalType() == SpatialMathEnum.IntervalType.WHOLE) {
                string2 = String.valueOf(fraction2.intValue());
                String ascii = MathModuleUtils.INSTANCE.translateAsciiMath((String)string2);
                if (numberLine.getSettings().getPassage() == SpatialMathEnum.Passage.NUMERIC) {
                    CharSequence charSequence = ascii;
                    Regex regex = new Regex("#");
                    String string3 = "";
                    string = regex.replace(charSequence, string3);
                } else {
                    string = ascii;
                }
            } else if (numberLine.getSettings().getIntervalType() == SpatialMathEnum.IntervalType.DECIMAL) {
                Object object;
                if (numberLine.getSettings().isRemoveLeadingZeros()) {
                    void $this$toTypedArray$iv;
                    List list;
                    Collection $this$dropLastWhile$iv;
                    string2 = String.valueOf(fraction2.doubleValue());
                    object = (CharSequence)string2;
                    Regex regex = new Regex("\\.");
                    int n = 0;
                    object = regex.split((CharSequence)object, n);
                    boolean $i$f$dropLastWhile = false;
                    if (!$this$dropLastWhile$iv.isEmpty()) {
                        ListIterator iterator$iv = $this$dropLastWhile$iv.listIterator($this$dropLastWhile$iv.size());
                        while (iterator$iv.hasPrevious()) {
                            String it = (String)iterator$iv.previous();
                            boolean bl = false;
                            if (((CharSequence)it).length() == 0) continue;
                            list = CollectionsKt.take((Iterable)$this$dropLastWhile$iv, (int)(iterator$iv.nextIndex() + 1));
                            break;
                        }
                    } else {
                        list = CollectionsKt.emptyList();
                    }
                    $this$dropLastWhile$iv = list;
                    boolean $i$f$toTypedArray = false;
                    void thisCollection$iv = $this$toTypedArray$iv;
                    String[] array = thisCollection$iv.toArray(new String[0]);
                    if (array.length > 1 && Integer.parseInt(array[0]) == 0) {
                        string2 = "." + array[1];
                    }
                } else {
                    string2 = String.valueOf(fraction2.doubleValue());
                }
                String ascii = MathModuleUtils.INSTANCE.translateAsciiMath((String)string2);
                if (numberLine.getSettings().getPassage() == SpatialMathEnum.Passage.NUMERIC) {
                    object = ascii;
                    Regex regex = new Regex("#");
                    String string4 = "";
                    string = regex.replace((CharSequence)object, string4);
                } else {
                    string = ascii;
                }
            } else if (numberLine.getSettings().getIntervalType() == SpatialMathEnum.IntervalType.MIXED) {
                Fraction fraction3;
                if (numberLine.getSettings().isReduceFraction()) {
                    Fraction fraction4 = fraction2.reduce();
                    Intrinsics.checkNotNull((Object)fraction4);
                    fraction3 = fraction4;
                } else {
                    fraction3 = NumberLineMathUtils.INSTANCE.unReduce(numberLine, fraction2);
                }
                fraction2 = fraction3;
                string = this.makeMixedFractionString(numberLine, fraction2);
            } else {
                Fraction fraction5;
                if (numberLine.getSettings().isReduceFraction()) {
                    Fraction fraction6 = fraction2.reduce();
                    Intrinsics.checkNotNull((Object)fraction6);
                    fraction5 = fraction6;
                } else {
                    fraction5 = NumberLineMathUtils.INSTANCE.unReduce(numberLine, fraction2);
                }
                fraction2 = fraction5;
                string = this.makeImproperFractionString(numberLine, fraction2);
            }
            return string;
        }

        private final String makeImproperFractionString(NumberLine numberLine, Fraction fraction) {
            Fraction numDenFrac;
            String string = null;
            CharSequence charSequence = TextTranslator.translateText$default((String)String.valueOf(fraction.getProperWhole()), (ITranslationEngine)((ITranslationEngine)WPManager.Companion.getInstance().getController().getDocument().getEngine()), (short)0, null, (int)12, null);
            Object object = new Regex("#");
            CharSequence charSequence2 = "";
            charSequence = object.replace(charSequence, charSequence2);
            object = new Regex("-");
            charSequence2 = "";
            String whole = object.replace(charSequence, charSequence2);
            object = TextTranslator.translateText$default((String)String.valueOf(fraction.getNumerator()), (ITranslationEngine)((ITranslationEngine)WPManager.Companion.getInstance().getController().getDocument().getEngine()), (short)0, null, (int)12, null);
            charSequence2 = new Regex("#");
            String string2 = "";
            object = charSequence2.replace((CharSequence)object, string2);
            charSequence2 = new Regex("-");
            string2 = "";
            String numerator = charSequence2.replace((CharSequence)object, string2);
            charSequence2 = TextTranslator.translateText$default((String)String.valueOf(fraction.getDenominator()), (ITranslationEngine)((ITranslationEngine)WPManager.Companion.getInstance().getController().getDocument().getEngine()), (short)0, null, (int)12, null);
            string2 = new Regex("#");
            String string3 = "";
            charSequence2 = string2.replace(charSequence2, string3);
            string2 = new Regex("-");
            string3 = "";
            String denominator = string2.replace(charSequence2, string3);
            String fractionString = numberLine.getSettings().isBeveledFraction() ? "_/" : "/";
            boolean canReduceToWhole = false;
            Fraction wholeFrac = Fraction.getFraction((double)fraction.getProperWhole());
            if (wholeFrac.compareTo(numDenFrac = Fraction.getFraction((String)(fraction.getNumerator() + "/" + fraction.getDenominator()))) == 0) {
                canReduceToWhole = true;
            }
            string = canReduceToWhole && numberLine.getSettings().isReduceFraction() ? (fraction.doubleValue() < 0.0 ? "\"\u2212" : "") + (numberLine.getSettings().getPassage() == SpatialMathEnum.Passage.NUMERIC ? "" : "#") + whole : (fraction.doubleValue() < 0.0 ? "\"\u2212" : "") + (numberLine.getSettings().getPassage() == SpatialMathEnum.Passage.NUMERIC ? "" : "#") + numerator + fractionString + denominator;
            return string;
        }

        public final boolean format(@NotNull NumberLine numberLine) throws MathFormattingException {
            Intrinsics.checkNotNullParameter((Object)numberLine, (String)"numberLine");
            int cellsPerLine = UTDManager.Companion.getCellsPerLine(WPManager.Companion.getInstance().getController());
            this.formatPoints(numberLine, cellsPerLine);
            NumberLineFormatter.Companion.verticallyAlignLabelsAndPoints(numberLine);
            this.formatLine(numberLine);
            NumberLineFormatter.Companion.addLine(numberLine);
            if (!NumberLineFormatter.Companion.addPoints(numberLine)) {
                return false;
            }
            if (numberLine.getSettings().getSectionType() == SpatialMathEnum.NumberLineSection.POINTS) {
                this.formatMultiplePoints(numberLine);
            } else if (numberLine.shouldFormatSegment()) {
                this.formatSegment(numberLine);
            }
            NumberLineFormatter.Companion.addLabels(numberLine);
            return true;
        }

        public final void formatMultiplePoints(@NotNull NumberLine numberLine) {
            Intrinsics.checkNotNullParameter((Object)numberLine, (String)"numberLine");
            int interval = 0;
            Line line = new Line();
            int n = ((Collection)numberLine.getLine()).size();
            for (int i = 0; i < n; ++i) {
                boolean bl;
                NumberLineLine lineSegment;
                Intrinsics.checkNotNullExpressionValue((Object)numberLine.getLine().get(i), (String)"get(...)");
                NumberLineLine.LineChar c = lineSegment.getType();
                if (c == NumberLineLine.LineChar.INTERVAL) {
                    if (NumberLineSegmentPoint.Companion.hasPoint(numberLine, ++interval)) {
                        ArrayList<Line.Segment> arrayList = line.getElements();
                        NumberLineSegmentPoint numberLineSegmentPoint = NumberLineSegmentPoint.Companion.getPointFromIndex(numberLine, interval);
                        Intrinsics.checkNotNull((Object)numberLineSegmentPoint);
                        bl = arrayList.add(line.getTextSegment(NumberLineFormatter.Companion.getSegmentBeginning(numberLineSegmentPoint)));
                        continue;
                    }
                    bl = line.getElements().add(line.getWhitespaceSegment(1));
                    continue;
                }
                bl = line.getElements().add(line.getWhitespaceSegment(lineSegment.getTotalLength()));
            }
            ((ArrayList)numberLine.getLines()).add(0, line);
        }

        private final String makeMixedFractionString(NumberLine numberLine, Fraction fraction) {
            Fraction numDenFrac;
            CharSequence charSequence = TextTranslator.translateText$default((String)String.valueOf(fraction.getProperWhole()), (ITranslationEngine)((ITranslationEngine)WPManager.Companion.getInstance().getController().getDocument().getEngine()), (short)0, null, (int)12, null);
            Object object = new Regex("#");
            CharSequence charSequence2 = "";
            charSequence = object.replace(charSequence, charSequence2);
            object = new Regex("-");
            charSequence2 = "";
            String whole = object.replace(charSequence, charSequence2);
            object = TextTranslator.translateText$default((String)String.valueOf(fraction.getProperNumerator()), (ITranslationEngine)((ITranslationEngine)WPManager.Companion.getInstance().getController().getDocument().getEngine()), (short)0, null, (int)12, null);
            charSequence2 = new Regex("#");
            String string = "";
            object = charSequence2.replace((CharSequence)object, string);
            charSequence2 = new Regex("-");
            string = "";
            String numerator = charSequence2.replace((CharSequence)object, string);
            charSequence2 = TextTranslator.translateText$default((String)String.valueOf(fraction.getDenominator()), (ITranslationEngine)((ITranslationEngine)WPManager.Companion.getInstance().getController().getDocument().getEngine()), (short)0, null, (int)12, null);
            string = new Regex("#");
            String string2 = "";
            charSequence2 = string.replace(charSequence2, string2);
            string = new Regex("-");
            string2 = "";
            String denominator = string.replace(charSequence2, string2);
            String fractionString = numberLine.getSettings().isBeveledFraction() ? "_/" : "/";
            boolean canReduceToWhole = false;
            Fraction wholeFrac = Fraction.getFraction((double)fraction.getProperWhole());
            if (wholeFrac.compareTo(numDenFrac = Fraction.getFraction((String)(fraction.getNumerator() + "/" + fraction.getDenominator()))) == 0) {
                canReduceToWhole = true;
            }
            String string3 = canReduceToWhole && numberLine.getSettings().isReduceFraction() ? (fraction.doubleValue() < 0.0 ? "\"\u2212" : "") + (numberLine.getSettings().getPassage() == SpatialMathEnum.Passage.NUMERIC ? "" : "#") + whole : (wholeFrac.getProperWhole() == 0 ? (fraction.doubleValue() < 0.0 ? "\"\u2212" : "") + (numberLine.getSettings().getPassage() == SpatialMathEnum.Passage.NUMERIC ? "" : "#") + numerator + fractionString + denominator : (fraction.doubleValue() < 0.0 ? "\"\u2212" : "") + (numberLine.getSettings().getPassage() == SpatialMathEnum.Passage.NUMERIC ? "" : "#") + whole + "#" + numerator + fractionString + denominator);
            return string3;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

