/*
 * Decompiled with CFR 0.152.
 */
package org.brailleblaster.math.spatial;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.ListIterator;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import nu.xom.Element;
import nu.xom.Node;
import org.brailleblaster.BBIni;
import org.brailleblaster.bbx.BBX;
import org.brailleblaster.math.spatial.ConnectingContainerJson;
import org.brailleblaster.math.spatial.ConnectingContainerSettings;
import org.brailleblaster.math.spatial.ConnectingContainerWidget;
import org.brailleblaster.math.spatial.Grid;
import org.brailleblaster.math.spatial.ISpatialMathContainer;
import org.brailleblaster.math.spatial.ISpatialMathContainerJson;
import org.brailleblaster.math.spatial.Line;
import org.brailleblaster.math.spatial.MathFormattingException;
import org.brailleblaster.math.spatial.MathText;
import org.brailleblaster.math.spatial.SpatialMathBlock;
import org.brailleblaster.math.spatial.SpatialMathEnum;
import org.brailleblaster.math.spatial.VersionConverter;
import org.brailleblaster.util.ConstantsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000h\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u0000 <2\u00020\u0001:\u0001<B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J(\u0010#\u001a\u00020$2\b\u0010%\u001a\u0004\u0018\u00010\u00012\u0006\u0010&\u001a\u00020'2\u0006\u0010(\u001a\u00020\u00182\u0006\u0010)\u001a\u00020\u0018J\b\u0010*\u001a\u00020$H\u0016J\b\u00101\u001a\u00020$H\u0016J\b\u00102\u001a\u00020$H\u0016J\b\u0010;\u001a\u00020\u001eH\u0016R\u001a\u0010\u0004\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\tR\u001a\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0014\u0010\u000f\u001a\u00020\u0010X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0014\u0010\u0013\u001a\u00020\u0014X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u001a\u0010\u0017\u001a\u00020\u0018X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0019\u0010\u001a\"\u0004\b\u001b\u0010\u001cR\u001a\u0010\u001d\u001a\u00020\u001eX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001f\u0010 \"\u0004\b!\u0010\"R\u0011\u0010+\u001a\u00020,8F\u00a2\u0006\u0006\u001a\u0004\b-\u0010.R\u0014\u0010/\u001a\u00020,8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b0\u0010.R\u0014\u00103\u001a\u000204X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b5\u00106R\u0014\u00107\u001a\u0002088VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b9\u0010:\u00a8\u0006="}, d2={"Lorg/brailleblaster/math/spatial/ConnectingContainer;", "Lorg/brailleblaster/math/spatial/ISpatialMathContainer;", "<init>", "()V", "text", "Lorg/brailleblaster/math/spatial/MathText;", "getText", "()Lorg/brailleblaster/math/spatial/MathText;", "setText", "(Lorg/brailleblaster/math/spatial/MathText;)V", "lines", "", "Lorg/brailleblaster/math/spatial/Line;", "getLines", "()Ljava/util/List;", "settings", "Lorg/brailleblaster/math/spatial/ConnectingContainerSettings;", "getSettings", "()Lorg/brailleblaster/math/spatial/ConnectingContainerSettings;", "widget", "Lorg/brailleblaster/math/spatial/ConnectingContainerWidget;", "getWidget", "()Lorg/brailleblaster/math/spatial/ConnectingContainerWidget;", "widestLine", "", "getWidestLine", "()I", "setWidestLine", "(I)V", "blank", "", "getBlank", "()Z", "setBlank", "(Z)V", "fillPageInfo", "", "spatialMathContainer", "page", "Lorg/brailleblaster/math/spatial/Grid;", "row", "col", "format", "printText", "", "getPrintText", "()Ljava/lang/String;", "brailleText", "getBrailleText", "saveSettings", "loadSettingsFromFile", "typeEnum", "Lorg/brailleblaster/math/spatial/SpatialMathEnum$SpatialMathContainers;", "getTypeEnum", "()Lorg/brailleblaster/math/spatial/SpatialMathEnum$SpatialMathContainers;", "json", "Lorg/brailleblaster/math/spatial/ISpatialMathContainerJson;", "getJson", "()Lorg/brailleblaster/math/spatial/ISpatialMathContainerJson;", "preFormatChecks", "Companion", "brailleblaster-core"})
@SourceDebugExtension(value={"SMAP\nConnectingContainer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ConnectingContainer.kt\norg/brailleblaster/math/spatial/ConnectingContainer\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,208:1\n742#2,9:209\n37#3,2:218\n*S KotlinDebug\n*F\n+ 1 ConnectingContainer.kt\norg/brailleblaster/math/spatial/ConnectingContainer\n*L\n43#1:209,9\n44#1:218,2\n*E\n"})
public final class ConnectingContainer
implements ISpatialMathContainer {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private MathText text = new MathText("", "", false);
    @NotNull
    private final List<Line> lines = new ArrayList();
    @NotNull
    private final ConnectingContainerSettings settings = new ConnectingContainerSettings();
    @NotNull
    private final ConnectingContainerWidget widget = new ConnectingContainerWidget();
    private int widestLine;
    private boolean blank;
    @NotNull
    private final SpatialMathEnum.SpatialMathContainers typeEnum = SpatialMathEnum.SpatialMathContainers.CONNECTING;
    @NotNull
    public static final String KEY = "connectingContainer";
    @NotNull
    private static final String USER_SETTINGS_VERTICAL = "cc.userSettingsVertical";
    @NotNull
    private static final String USER_SETTINGS_HORIZONTAL = "cc.userSettingsHorizontal";
    @NotNull
    private static final String USER_SETTINGS_TRANSLATE_AS_MATH = "cc.userSettingsMath";

    @NotNull
    public final MathText getText() {
        return this.text;
    }

    public final void setText(@NotNull MathText mathText) {
        Intrinsics.checkNotNullParameter((Object)mathText, (String)"<set-?>");
        this.text = mathText;
    }

    @Override
    @NotNull
    public List<Line> getLines() {
        return this.lines;
    }

    @Override
    @NotNull
    public ConnectingContainerSettings getSettings() {
        return this.settings;
    }

    @Override
    @NotNull
    public ConnectingContainerWidget getWidget() {
        return this.widget;
    }

    @Override
    public int getWidestLine() {
        return this.widestLine;
    }

    @Override
    public void setWidestLine(int n) {
        this.widestLine = n;
    }

    @Override
    public boolean getBlank() {
        return this.blank;
    }

    @Override
    public void setBlank(boolean bl) {
        this.blank = bl;
    }

    /*
     * WARNING - void declaration
     */
    public final void fillPageInfo(@Nullable ISpatialMathContainer spatialMathContainer, @NotNull Grid page, int row, int col) {
        void $this$toTypedArray$iv;
        List list;
        int n;
        Intrinsics.checkNotNullParameter((Object)page, (String)"page");
        this.getLines().clear();
        String text = this.getBrailleText();
        String[] stringArray = new String[]{ConstantsKt.getLINE_BREAK()};
        Collection $this$dropLastWhile$iv = StringsKt.split$default((CharSequence)text, (String[])stringArray, (boolean)false, (int)0, (int)6, null);
        boolean $i$f$dropLastWhile = false;
        if (!$this$dropLastWhile$iv.isEmpty()) {
            ListIterator iterator$iv = $this$dropLastWhile$iv.listIterator($this$dropLastWhile$iv.size());
            while (iterator$iv.hasPrevious()) {
                String it = (String)iterator$iv.previous();
                n = 0;
                if (((CharSequence)it).length() == 0) continue;
                list = CollectionsKt.take((Iterable)$this$dropLastWhile$iv, (int)(iterator$iv.nextIndex() + 1));
                break;
            }
        } else {
            list = CollectionsKt.emptyList();
        }
        $this$dropLastWhile$iv = list;
        boolean $i$f$toTypedArray = false;
        void thisCollection$iv = $this$toTypedArray$iv;
        String[] textLines = thisCollection$iv.toArray(new String[0]);
        int totalLines = page.getLinesForRow(row);
        List<String> linesWithNewLine = Companion.addNewLines(textLines, this, page);
        int topLines = 0;
        int bottomLines = 0;
        switch (WhenMappings.$EnumSwitchMapping$0[this.getSettings().getVertical().ordinal()]) {
            case 1: {
                bottomLines = totalLines - linesWithNewLine.size();
                break;
            }
            case 2: {
                int linesLeft = totalLines - linesWithNewLine.size();
                bottomLines = linesLeft / 2;
                topLines = linesLeft / 2;
                if (linesLeft % 2 == 0) break;
                ++bottomLines;
                break;
            }
            case 3: {
                topLines = totalLines - linesWithNewLine.size();
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        n = 0;
        while (n < topLines) {
            int it = n++;
            boolean bl = false;
            Line topLineBreakLine = new Line();
            topLineBreakLine.getElements().add(topLineBreakLine.getLineBreakSegment());
            this.getLines().add(topLineBreakLine);
        }
        int width = page.getWidestColumn(row);
        for (String s : linesWithNewLine) {
            Line line = new Line();
            int leftChars = 0;
            int rightChars = 0;
            switch (WhenMappings.$EnumSwitchMapping$1[this.getSettings().getHorizontal().ordinal()]) {
                case 1: {
                    rightChars = width - s.length();
                    break;
                }
                case 2: {
                    int linesLeft = width - s.length();
                    leftChars = linesLeft / 2;
                    rightChars = linesLeft / 2;
                    if (linesLeft % 2 == 0) break;
                    ++rightChars;
                    break;
                }
                case 3: {
                    leftChars = width - s.length();
                    break;
                }
                case 4: {
                    break;
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
            if (leftChars > 0) {
                line.getElements().add(line.getWhitespaceSegment(leftChars));
            }
            line.getElements().add(line.getTextSegment(s));
            if (rightChars > 0) {
                line.getElements().add(line.getWhitespaceSegment(rightChars));
            }
            this.getLines().add(line);
        }
        int n2 = 0;
        while (n2 < bottomLines) {
            int it = n2++;
            boolean bl = false;
            Line bottomLineBreakLine = new Line();
            bottomLineBreakLine.getElements().add(bottomLineBreakLine.getLineBreakSegment());
            this.getLines().add(bottomLineBreakLine);
        }
    }

    @Override
    public void format() {
        String text = this.getBrailleText();
        Line bottomLineBreakLine = new Line();
        bottomLineBreakLine.getElements().add(bottomLineBreakLine.getTextSegment(text));
        this.getLines().add(bottomLineBreakLine);
    }

    @NotNull
    public final String getPrintText() {
        return this.text.print;
    }

    private final String getBrailleText() {
        return this.text.braille;
    }

    @Override
    public void saveSettings() {
        BBIni.getPropertyFileManager().save(USER_SETTINGS_VERTICAL, this.getSettings().getVertical().name());
        BBIni.getPropertyFileManager().save(USER_SETTINGS_HORIZONTAL, this.getSettings().getHorizontal().name());
        BBIni.getPropertyFileManager().saveAsBoolean(USER_SETTINGS_TRANSLATE_AS_MATH, this.getSettings().isTranslateAsMath());
    }

    @Override
    public void loadSettingsFromFile() {
        String verticalString = BBIni.getPropertyFileManager().getProperty(USER_SETTINGS_VERTICAL, ConnectingContainerSettings.DEFAULT_VERTICAL.name());
        SpatialMathEnum.VerticalJustify vertical = SpatialMathEnum.VerticalJustify.valueOf(verticalString);
        this.getSettings().setVertical(vertical);
        String horizontalString = BBIni.getPropertyFileManager().getProperty(USER_SETTINGS_HORIZONTAL, ConnectingContainerSettings.DEFAULT_HORIZONTAL.name());
        SpatialMathEnum.HorizontalJustify horizontal = SpatialMathEnum.HorizontalJustify.valueOf(horizontalString);
        this.getSettings().setHorizontal(horizontal);
        String mathString = BBIni.getPropertyFileManager().getProperty(USER_SETTINGS_TRANSLATE_AS_MATH, "false");
        this.getSettings().setTranslateAsMath(Boolean.parseBoolean(mathString));
    }

    @Override
    @NotNull
    public SpatialMathEnum.SpatialMathContainers getTypeEnum() {
        return this.typeEnum;
    }

    @Override
    @NotNull
    public ISpatialMathContainerJson getJson() {
        return new ConnectingContainerJson().containerToJson(this);
    }

    @Override
    public boolean preFormatChecks() {
        return true;
    }

    @JvmStatic
    @NotNull
    public static final Element initialize(@NotNull Node n) {
        return Companion.initialize(n);
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010 \n\u0000\n\u0002\u0010\u0011\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J3\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00050\n2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00050\f2\b\u0010\r\u001a\u0004\u0018\u00010\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u0010\u00a2\u0006\u0002\u0010\u0011J\u0010\u0010\u0012\u001a\u00020\u000e2\b\u0010\u0013\u001a\u0004\u0018\u00010\u0014J\u0010\u0010\u0015\u001a\u00020\u00142\u0006\u0010\u0016\u001a\u00020\u0017H\u0007R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lorg/brailleblaster/math/spatial/ConnectingContainer$Companion;", "", "<init>", "()V", "KEY", "", "USER_SETTINGS_VERTICAL", "USER_SETTINGS_HORIZONTAL", "USER_SETTINGS_TRANSLATE_AS_MATH", "addNewLines", "", "textLines", "", "container", "Lorg/brailleblaster/math/spatial/ConnectingContainer;", "page", "Lorg/brailleblaster/math/spatial/Grid;", "([Ljava/lang/String;Lorg/brailleblaster/math/spatial/ConnectingContainer;Lorg/brailleblaster/math/spatial/Grid;)Ljava/util/List;", "getContainerFromElement", "origNode", "Lnu/xom/Element;", "initialize", "n", "Lnu/xom/Node;", "brailleblaster-core"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final List<String> addNewLines(@NotNull String[] textLines, @Nullable ConnectingContainer container, @Nullable Grid page) {
            Intrinsics.checkNotNullParameter((Object)textLines, (String)"textLines");
            return CollectionsKt.listOf((Object[])Arrays.copyOf(textLines, textLines.length));
        }

        @NotNull
        public final ConnectingContainer getContainerFromElement(@Nullable Element origNode) {
            Element node = origNode;
            ConnectingContainer container = new ConnectingContainer();
            if (BBX.CONTAINER.CONNECTING_CONTAINER.isA((Node)node)) {
                if (!BBX.CONTAINER.CONNECTING_CONTAINER.ATTRIB_VERSION.has((Node)node)) {
                    node = VersionConverter.convertConnectingContainer(node);
                }
                Object t = BBX.CONTAINER.CONNECTING_CONTAINER.JSON_CONNECTING_CONTAINER.get(node);
                Intrinsics.checkNotNull(t, (String)"null cannot be cast to non-null type org.brailleblaster.math.spatial.ConnectingContainerJson");
                ConnectingContainerJson json = (ConnectingContainerJson)t;
                ISpatialMathContainer iSpatialMathContainer = json.jsonToContainer();
                Intrinsics.checkNotNull((Object)iSpatialMathContainer, (String)"null cannot be cast to non-null type org.brailleblaster.math.spatial.ConnectingContainer");
                container = (ConnectingContainer)iSpatialMathContainer;
            }
            return container;
        }

        @JvmStatic
        @NotNull
        public final Element initialize(@NotNull Node n) {
            Intrinsics.checkNotNullParameter((Object)n, (String)"n");
            Element e = (Element)n;
            ConnectingContainer t = this.getContainerFromElement(e);
            t.format();
            Element newElement = BBX.CONTAINER.CONNECTING_CONTAINER.create(t);
            try {
                Intrinsics.checkNotNull((Object)newElement);
                SpatialMathBlock.INSTANCE.format(newElement, t.getLines());
            }
            catch (MathFormattingException mathFormattingException) {
                // empty catch block
            }
            e.getParent().replaceChild((Node)e, (Node)newElement);
            Intrinsics.checkNotNull((Object)newElement);
            return newElement;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 3, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;
        public static final /* synthetic */ int[] $EnumSwitchMapping$1;

        static {
            int[] nArray = new int[SpatialMathEnum.VerticalJustify.values().length];
            try {
                nArray[SpatialMathEnum.VerticalJustify.TOP.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[SpatialMathEnum.VerticalJustify.CENTER.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[SpatialMathEnum.VerticalJustify.BOTTOM.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
            nArray = new int[SpatialMathEnum.HorizontalJustify.values().length];
            try {
                nArray[SpatialMathEnum.HorizontalJustify.LEFT.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[SpatialMathEnum.HorizontalJustify.CENTER.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[SpatialMathEnum.HorizontalJustify.RIGHT.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[SpatialMathEnum.HorizontalJustify.TRIM.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$1 = nArray;
        }
    }
}

