/*
 * Decompiled with CFR 0.152.
 */
package org.brailleblaster.math.spatial;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import nu.xom.Element;
import nu.xom.Node;
import org.brailleblaster.BBIni;
import org.brailleblaster.bbx.BBX;
import org.brailleblaster.math.mathml.MathModuleUtils;
import org.brailleblaster.math.numberLine.NumberLine;
import org.brailleblaster.math.spatial.ConnectingContainer;
import org.brailleblaster.math.spatial.GridJson;
import org.brailleblaster.math.spatial.GridSettings;
import org.brailleblaster.math.spatial.ISpatialMathContainer;
import org.brailleblaster.math.spatial.ISpatialMathContainerJson;
import org.brailleblaster.math.spatial.ISpatialMathWidget;
import org.brailleblaster.math.spatial.Line;
import org.brailleblaster.math.spatial.MathFormattingException;
import org.brailleblaster.math.spatial.Matrix;
import org.brailleblaster.math.spatial.Passages;
import org.brailleblaster.math.spatial.SpatialMathBlock;
import org.brailleblaster.math.spatial.SpatialMathEnum;
import org.brailleblaster.math.spatial.SpatialMathUtils;
import org.brailleblaster.math.spatial.VersionConverter;
import org.brailleblaster.math.template.Template;
import org.brailleblaster.perspectives.braille.stylers.StyleHandler;
import org.brailleblaster.wordprocessor.WPManager;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u0000 ?2\u00020\u0001:\u0001?B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0019\u001a\u00020\u00142\u0006\u0010\u001a\u001a\u00020\u0001J\u0006\u0010\u001b\u001a\u00020\u001cJ\u0006\u0010\u001d\u001a\u00020\u0014J\b\u0010\u001e\u001a\u00020\u001cH\u0016J\u0010\u0010\u001f\u001a\u00020\u00142\u0006\u0010 \u001a\u00020\u0001H\u0002J\u000e\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020\"J\u000e\u0010$\u001a\u00020\"2\u0006\u0010#\u001a\u00020\"J\u0006\u0010%\u001a\u00020\u001cJ\u0006\u0010&\u001a\u00020\u001cJ\u000e\u0010'\u001a\u00020\u001c2\u0006\u0010#\u001a\u00020\"J\u000e\u0010(\u001a\u00020\u001c2\u0006\u0010)\u001a\u00020\"J\b\u0010*\u001a\u00020\u001cH\u0016J\b\u0010+\u001a\u00020\u001cH\u0016J\b\u0010=\u001a\u00020\u0014H\u0016J\u0006\u0010>\u001a\u00020\u0014R\u001a\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u001a\u0010\t\u001a\u00020\nX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000eR&\u0010\u000f\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00010\u00050\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010\b\"\u0004\b\u0011\u0010\u0012R\u001a\u0010\u0013\u001a\u00020\u0014X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0015\u0010\u0016\"\u0004\b\u0017\u0010\u0018R\u0014\u0010,\u001a\u00020-8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b.\u0010/R$\u00100\u001a\u00020\"2\u0006\u00100\u001a\u00020\"8V@VX\u0096\u000e\u00a2\u0006\f\u001a\u0004\b1\u00102\"\u0004\b3\u00104R\u0016\u00105\u001a\u0004\u0018\u0001068VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b7\u00108R\u0014\u00109\u001a\u00020:8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b;\u0010<\u00a8\u0006@"}, d2={"Lorg/brailleblaster/math/spatial/Grid;", "Lorg/brailleblaster/math/spatial/ISpatialMathContainer;", "<init>", "()V", "lines", "", "Lorg/brailleblaster/math/spatial/Line;", "getLines", "()Ljava/util/List;", "settings", "Lorg/brailleblaster/math/spatial/GridSettings;", "getSettings", "()Lorg/brailleblaster/math/spatial/GridSettings;", "setSettings", "(Lorg/brailleblaster/math/spatial/GridSettings;)V", "array", "getArray", "setArray", "(Ljava/util/List;)V", "blank", "", "getBlank", "()Z", "setBlank", "(Z)V", "isEmpty", "container", "buildArray", "", "hasMultiples", "format", "hasIndicator", "spatialMathContainer", "getLinesForRow", "", "row", "getWidestColumn", "addRow", "addCol", "deleteRow", "deleteCol", "col", "saveSettings", "loadSettingsFromFile", "typeEnum", "Lorg/brailleblaster/math/spatial/SpatialMathEnum$SpatialMathContainers;", "getTypeEnum", "()Lorg/brailleblaster/math/spatial/SpatialMathEnum$SpatialMathContainers;", "widestLine", "getWidestLine", "()I", "setWidestLine", "(I)V", "widget", "Lorg/brailleblaster/math/spatial/ISpatialMathWidget;", "getWidget", "()Lorg/brailleblaster/math/spatial/ISpatialMathWidget;", "json", "Lorg/brailleblaster/math/spatial/ISpatialMathContainerJson;", "getJson", "()Lorg/brailleblaster/math/spatial/ISpatialMathContainerJson;", "preFormatChecks", "hasTemplate", "Companion", "brailleblaster-core"})
public final class Grid
implements ISpatialMathContainer {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final List<Line> lines = new ArrayList();
    @NotNull
    private GridSettings settings = new GridSettings();
    @NotNull
    private List<List<ISpatialMathContainer>> array = new ArrayList();
    private boolean blank;
    @NotNull
    public static final String KEY = "Grid";
    @NotNull
    private static final String USER_SETTINGS_DEFAULT_CONTAINER = "spatialPageDefault";

    public Grid() {
        this.loadSettingsFromFile();
        this.buildArray();
    }

    @Override
    @NotNull
    public List<Line> getLines() {
        return this.lines;
    }

    @Override
    @NotNull
    public GridSettings getSettings() {
        return this.settings;
    }

    public void setSettings(@NotNull GridSettings gridSettings) {
        Intrinsics.checkNotNullParameter((Object)gridSettings, (String)"<set-?>");
        this.settings = gridSettings;
    }

    @NotNull
    public final List<List<ISpatialMathContainer>> getArray() {
        return this.array;
    }

    public final void setArray(@NotNull List<List<ISpatialMathContainer>> list) {
        Intrinsics.checkNotNullParameter(list, (String)"<set-?>");
        this.array = list;
    }

    @Override
    public boolean getBlank() {
        return this.blank;
    }

    @Override
    public void setBlank(boolean bl) {
        this.blank = bl;
    }

    public final boolean isEmpty(@NotNull ISpatialMathContainer container) {
        Intrinsics.checkNotNullParameter((Object)container, (String)"container");
        int n = ((Collection)container.getLines()).size();
        for (int i = 0; i < n; ++i) {
            if (!(!StringsKt.isBlank((CharSequence)container.getLines().get(i).toString()))) continue;
            return false;
        }
        return true;
    }

    public final void buildArray() {
        int i;
        this.loadSettingsFromFile();
        int n = this.getSettings().getRows();
        for (i = 0; i < n; ++i) {
            if (this.array.size() >= i + 1) continue;
            ArrayList row = new ArrayList();
            this.array.add(row);
        }
        n = this.getSettings().getRows();
        for (i = 0; i < n; ++i) {
            int n2 = this.getSettings().getCols();
            for (int j = 0; j < n2; ++j) {
                if (this.array.get(i).size() >= j + 1) continue;
                ISpatialMathContainer sm = new ConnectingContainer();
                switch (WhenMappings.$EnumSwitchMapping$0[this.getSettings().getDefaultType().ordinal()]) {
                    case 1: {
                        sm = new ConnectingContainer();
                        break;
                    }
                    case 2: {
                        sm = new Matrix();
                        break;
                    }
                    case 3: {
                        sm = new NumberLine();
                        break;
                    }
                    case 4: {
                        sm = new Template();
                    }
                }
                sm.loadSettingsFromFile();
                this.array.get(i).add(sm);
            }
        }
    }

    public final boolean hasMultiples() {
        return this.array.size() > 1 || this.array.size() == 1 && this.array.get(0).size() > 1;
    }

    @Override
    public void format() {
        int i;
        if (!MathModuleUtils.isNemeth()) {
            this.getSettings().setPassage(SpatialMathEnum.Passage.NONE);
        }
        int n = this.getSettings().getRows();
        for (i = 0; i < n; ++i) {
            int n2 = this.getSettings().getCols();
            for (int j = 0; j < n2; ++j) {
                ISpatialMathContainer container = this.array.get(i).get(j);
                int widestLine = 0;
                int n3 = ((Collection)container.getLines()).size();
                for (int k = 0; k < n3; ++k) {
                    int lineLength = container.getLines().get(k).toString().length();
                    if (lineLength <= widestLine) continue;
                    widestLine = lineLength;
                }
                container.setWidestLine(widestLine);
            }
        }
        n = this.getSettings().getRows();
        for (i = 0; i < n; ++i) {
            ArrayList<Line> newLines;
            block37: {
                boolean indicators;
                block36: {
                    int j;
                    ArrayList<ISpatialMathContainer> row = new ArrayList<ISpatialMathContainer>();
                    newLines = new ArrayList<Line>();
                    int n4 = this.getSettings().getCols();
                    for (j = 0; j < n4; ++j) {
                        ISpatialMathContainer container = this.array.get(i).get(j);
                        row.add(container);
                    }
                    if (this.getSettings().getCols() < 2) {
                        newLines.addAll((Collection)((ISpatialMathContainer)row.get(0)).getLines());
                    } else {
                        n4 = this.getSettings().getCols() - 1;
                        for (j = 0; j < n4; ++j) {
                            Object e = row.get(j);
                            Intrinsics.checkNotNullExpressionValue(e, (String)"get(...)");
                            ISpatialMathContainer left = (ISpatialMathContainer)e;
                            Object e2 = row.get(j + 1);
                            Intrinsics.checkNotNullExpressionValue(e2, (String)"get(...)");
                            ISpatialMathContainer right = (ISpatialMathContainer)e2;
                            int whitespace = 1;
                            if (right instanceof Template) {
                                boolean hasIdentifier;
                                boolean bl = hasIdentifier = ((CharSequence)((Template)right).getIdentifier().braille).length() > 0;
                                if (hasIdentifier) {
                                    whitespace = 3;
                                }
                            }
                            if (this.isEmpty(right) || this.isEmpty(left)) {
                                whitespace = 0;
                            }
                            int totalLines = (int)Math.max((double)right.getLines().size(), (double)left.getLines().size());
                            for (int k = 0; k < totalLines; ++k) {
                                Line newLine;
                                Line rightLine;
                                if (k < newLines.size() + 1) {
                                    Line l = new Line();
                                    newLines.add(l);
                                }
                                Intrinsics.checkNotNullExpressionValue((Object)newLines.get(k), (String)"get(...)");
                                Line leftLine = left.getLines().size() > k ? left.getLines().get(k) : null;
                                Line line = rightLine = right.getLines().size() > k ? right.getLines().get(k) : null;
                                if (j == 0) {
                                    boolean bl = leftLine == null ? newLine.getElements().add(newLine.getWhitespaceSegment(left.getWidestLine())) : (leftLine.getElements().get(0) instanceof Line.LineBreakSegment || left.getBlank() ? newLine.getElements().add(newLine.getWhitespaceSegment(left.getWidestLine())) : newLine.getElements().addAll((Collection<Line.Segment>)leftLine.getElements()));
                                }
                                newLine.getElements().add(newLine.getWhitespaceSegment(whitespace));
                                boolean bl = rightLine == null ? newLine.getElements().add(newLine.getWhitespaceSegment(right.getWidestLine())) : (rightLine.getElements().get(0) instanceof Line.LineBreakSegment || right.getBlank() ? newLine.getElements().add(newLine.getWhitespaceSegment(right.getWidestLine())) : newLine.getElements().addAll((Collection<Line.Segment>)rightLine.getElements()));
                            }
                        }
                    }
                    if (i != this.getSettings().getRows() - 1) {
                        Line emptyLine = new Line();
                        emptyLine.getElements().add(emptyLine.getLineBreakSegment());
                        newLines.add(emptyLine);
                    }
                    newLines.removeIf(arg_0 -> Grid.format$lambda$1(Grid::format$lambda$0, arg_0));
                    Object e = row.get(0);
                    Intrinsics.checkNotNullExpressionValue(e, (String)"get(...)");
                    indicators = this.hasIndicator((ISpatialMathContainer)e);
                    if (this.getSettings().getRows() != 1) break block36;
                    switch (WhenMappings.$EnumSwitchMapping$1[this.getSettings().getPassage().ordinal()]) {
                        case 1: {
                            Passages.INSTANCE.addNemethOneRow(newLines);
                            break block37;
                        }
                        case 2: {
                            Passages.INSTANCE.addNumericOneRow(newLines, indicators);
                            break block37;
                        }
                        case 3: {
                            Passages.INSTANCE.addGrade1OneRow(newLines);
                            break block37;
                        }
                        case 4: {
                            break block37;
                        }
                        default: {
                            throw new NoWhenBranchMatchedException();
                        }
                    }
                }
                if (i == 0) {
                    switch (WhenMappings.$EnumSwitchMapping$1[this.getSettings().getPassage().ordinal()]) {
                        case 1: {
                            Passages.INSTANCE.addNemethMultipleRows(newLines, false);
                            break;
                        }
                        case 2: {
                            Passages.INSTANCE.addNumericMultipleRows(newLines, indicators, false);
                            break;
                        }
                        case 3: {
                            Passages.INSTANCE.addGrade1MultipleRows(newLines, false);
                            break;
                        }
                        case 4: {
                            break;
                        }
                        default: {
                            throw new NoWhenBranchMatchedException();
                        }
                    }
                }
                if (i == this.getSettings().getRows() - 1) {
                    switch (WhenMappings.$EnumSwitchMapping$1[this.getSettings().getPassage().ordinal()]) {
                        case 1: {
                            Passages.INSTANCE.addNemethMultipleRows(newLines, true);
                            break;
                        }
                        case 2: {
                            Passages.INSTANCE.addNumericMultipleRows(newLines, indicators, true);
                            break;
                        }
                        case 3: {
                            Passages.INSTANCE.addGrade1MultipleRows(newLines, true);
                            break;
                        }
                        case 4: {
                            break;
                        }
                        default: {
                            throw new NoWhenBranchMatchedException();
                        }
                    }
                }
            }
            this.getLines().addAll((Collection<Line>)newLines);
        }
        SpatialMathUtils.print(this);
    }

    private final boolean hasIndicator(ISpatialMathContainer spatialMathContainer) {
        if (spatialMathContainer instanceof Template) {
            return !StringsKt.isBlank((CharSequence)((Template)spatialMathContainer).getIdentifier().braille);
        }
        return false;
    }

    public final int getLinesForRow(int row) {
        int lines = 0;
        int n = ((Collection)this.array.get(row)).size();
        for (int i = 0; i < n; ++i) {
            ISpatialMathContainer container = this.array.get(row).get(i);
            if (container.getLines().size() <= lines) continue;
            lines = container.getLines().size();
        }
        return lines;
    }

    public final int getWidestColumn(int row) {
        int lines = 0;
        int n = ((Collection)this.array.get(row)).size();
        for (int i = 0; i < n; ++i) {
            ISpatialMathContainer container = this.array.get(row).get(i);
            if (container.getWidestLine() <= lines) continue;
            lines = container.getWidestLine();
        }
        return lines;
    }

    public final void addRow() {
        GridSettings gridSettings = this.getSettings();
        gridSettings.setRows(gridSettings.getRows() + 1);
        this.buildArray();
    }

    public final void addCol() {
        GridSettings gridSettings = this.getSettings();
        gridSettings.setCols(gridSettings.getCols() + 1);
        this.buildArray();
    }

    public final void deleteRow(int row) {
        GridSettings gridSettings = this.getSettings();
        gridSettings.setRows(gridSettings.getRows() - 1);
        if (this.getSettings().getRowIndex() >= this.getSettings().getRows()) {
            gridSettings = this.getSettings();
            gridSettings.setRowIndex(gridSettings.getRowIndex() - 1);
        }
        this.array.remove(row);
        this.buildArray();
    }

    public final void deleteCol(int col) {
        GridSettings gridSettings = this.getSettings();
        gridSettings.setCols(gridSettings.getCols() - 1);
        if (this.getSettings().getColIndex() >= this.getSettings().getCols()) {
            gridSettings = this.getSettings();
            gridSettings.setColIndex(gridSettings.getColIndex() - 1);
        }
        int n = ((Collection)this.array).size();
        for (int i = 0; i < n; ++i) {
            this.array.get(i).remove(col);
        }
        this.buildArray();
    }

    @Override
    public void saveSettings() {
        BBIni.getPropertyFileManager().save(USER_SETTINGS_DEFAULT_CONTAINER, this.array.get(this.getSettings().getRowIndex()).get(this.getSettings().getColIndex()).getTypeEnum().name());
    }

    @Override
    public void loadSettingsFromFile() {
        String type = BBIni.getPropertyFileManager().getProperty(USER_SETTINGS_DEFAULT_CONTAINER, "CONNECTING");
        SpatialMathEnum.SpatialMathContainers container = SpatialMathEnum.SpatialMathContainers.valueOf(type);
        this.getSettings().setDefaultType(container);
    }

    @Override
    @NotNull
    public SpatialMathEnum.SpatialMathContainers getTypeEnum() {
        return SpatialMathEnum.SpatialMathContainers.GRID;
    }

    @Override
    public int getWidestLine() {
        return 0;
    }

    @Override
    public void setWidestLine(int widestLine) {
    }

    @Override
    @Nullable
    public ISpatialMathWidget getWidget() {
        return null;
    }

    @Override
    @NotNull
    public ISpatialMathContainerJson getJson() {
        return new GridJson().containerToJson(this);
    }

    @Override
    public boolean preFormatChecks() {
        return true;
    }

    public final boolean hasTemplate() {
        int n = ((Collection)this.array).size();
        for (int i = 0; i < n; ++i) {
            int n2 = ((Collection)this.array.get(i)).size();
            for (int j = 0; j < n2; ++j) {
                if (!(this.array.get(i).get(j) instanceof Template)) continue;
                return true;
            }
        }
        return false;
    }

    private static final boolean format$lambda$0(Line line) {
        Line line2 = line;
        Intrinsics.checkNotNull((Object)line2);
        return line2.getElements().isEmpty();
    }

    private static final boolean format$lambda$1(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }

    @JvmStatic
    @NotNull
    public static final Element initialize(@NotNull Node n) {
        return Companion.initialize(n);
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fJ\u0010\u0010\r\u001a\u00020\n2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000fJ\u0010\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\u0011\u001a\u00020\u0012H\u0007J\u000e\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u000fJ\u0018\u0010\u0016\u001a\u0004\u0018\u00010\u00172\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fJ\u001e\u0010\u0018\u001a\u00020\u00142\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0019\u001a\u00020\u0017R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lorg/brailleblaster/math/spatial/Grid$Companion;", "", "<init>", "()V", "KEY", "", "USER_SETTINGS_DEFAULT_CONTAINER", "gridContains", "", "grid", "Lorg/brailleblaster/math/spatial/Grid;", "container", "Lorg/brailleblaster/math/spatial/SpatialMathEnum$SpatialMathContainers;", "getPageFromElement", "currentElement", "Lnu/xom/Element;", "initialize", "n", "Lnu/xom/Node;", "addStylesToGridElement", "", "e", "extractCell", "Lorg/brailleblaster/math/spatial/ISpatialMathContainer;", "replaceCell", "newContainer", "brailleblaster-core"})
    public static final class Companion {
        private Companion() {
        }

        public final boolean gridContains(@NotNull Grid grid, @NotNull SpatialMathEnum.SpatialMathContainers container) {
            Intrinsics.checkNotNullParameter((Object)grid, (String)"grid");
            Intrinsics.checkNotNullParameter((Object)((Object)container), (String)"container");
            int n = ((Collection)grid.getArray()).size();
            for (int i = 0; i < n; ++i) {
                int n2 = ((Collection)grid.getArray().get(i)).size();
                for (int j = 0; j < n2; ++j) {
                    if (grid.getArray().get(i).get(j).getTypeEnum() != container) continue;
                    return true;
                }
            }
            return false;
        }

        @NotNull
        public final Grid getPageFromElement(@Nullable Element currentElement) {
            Grid grid;
            Element current = currentElement;
            if (BBX.CONTAINER.SPATIAL_GRID.isA((Node)current)) {
                if (!BBX.CONTAINER.SPATIAL_GRID.ATTRIB_VERSION.has((Node)current)) {
                    current = VersionConverter.convertGrid(current);
                }
                Object t = BBX.CONTAINER.SPATIAL_GRID.JSON_GRID.get(current);
                Intrinsics.checkNotNull(t, (String)"null cannot be cast to non-null type org.brailleblaster.math.spatial.GridJson");
                GridJson json = (GridJson)t;
                ISpatialMathContainer iSpatialMathContainer = json.jsonToContainer();
                Intrinsics.checkNotNull((Object)iSpatialMathContainer, (String)"null cannot be cast to non-null type org.brailleblaster.math.spatial.Grid");
                grid = (Grid)iSpatialMathContainer;
            } else {
                grid = new Grid();
            }
            return grid;
        }

        @JvmStatic
        @NotNull
        public final Element initialize(@NotNull Node n) {
            Intrinsics.checkNotNullParameter((Object)n, (String)"n");
            Element ele = (Element)n;
            Grid page = this.getPageFromElement(ele);
            int n2 = page.getSettings().getRows();
            for (int i = 0; i < n2; ++i) {
                int n3 = page.getSettings().getCols();
                for (int j = 0; j < n3; ++j) {
                    Element element;
                    ISpatialMathContainer t = page.getArray().get(i).get(j);
                    t.format();
                    ISpatialMathContainer iSpatialMathContainer = t;
                    if (iSpatialMathContainer instanceof Template) {
                        element = BBX.CONTAINER.TEMPLATE.create((Template)t);
                    } else if (iSpatialMathContainer instanceof Matrix) {
                        element = BBX.CONTAINER.MATRIX.create((Matrix)t);
                    } else if (iSpatialMathContainer instanceof NumberLine) {
                        element = BBX.CONTAINER.NUMBER_LINE.create((NumberLine)t);
                    } else {
                        BBX.ContainerElement.ConnectingContainerSubType connectingContainerSubType = BBX.CONTAINER.CONNECTING_CONTAINER;
                        Intrinsics.checkNotNull((Object)t, (String)"null cannot be cast to non-null type org.brailleblaster.math.spatial.ConnectingContainer");
                        element = connectingContainerSubType.create((ConnectingContainer)t);
                    }
                    Element e = element;
                    try {
                        Intrinsics.checkNotNull((Object)e);
                        SpatialMathBlock.INSTANCE.format(e, t.getLines());
                        continue;
                    }
                    catch (MathFormattingException mathFormattingException) {
                        // empty catch block
                    }
                }
            }
            page.format();
            Element newElement = BBX.CONTAINER.SPATIAL_GRID.create(page);
            try {
                Intrinsics.checkNotNull((Object)newElement);
                SpatialMathBlock.INSTANCE.format(newElement, page.getLines());
            }
            catch (MathFormattingException mathFormattingException) {
                // empty catch block
            }
            ele.getParent().replaceChild((Node)ele, (Node)newElement);
            Intrinsics.checkNotNull((Object)newElement);
            this.addStylesToGridElement(newElement);
            return newElement;
        }

        public final void addStylesToGridElement(@NotNull Element e) {
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            StyleHandler.Companion.addStyle(e, "Spatial Grid", WPManager.Companion.getInstance().getController());
            int n = e.getChildCount();
            for (int i = 0; i < n; ++i) {
                Node child = e.getChild(i);
                if (!(child instanceof Element) || ((Element)child).getAttributeValue("linesAfter") == null) continue;
                StyleHandler.Companion.addStyle((Element)child, "Spatial Math Line Break", WPManager.Companion.getInstance().getController());
            }
        }

        @Nullable
        public final ISpatialMathContainer extractCell(@NotNull Grid grid, @NotNull SpatialMathEnum.SpatialMathContainers container) {
            Intrinsics.checkNotNullParameter((Object)grid, (String)"grid");
            Intrinsics.checkNotNullParameter((Object)((Object)container), (String)"container");
            int n = ((Collection)grid.getArray()).size();
            for (int i = 0; i < n; ++i) {
                int n2 = ((Collection)grid.getArray().get(i)).size();
                for (int j = 0; j < n2; ++j) {
                    if (grid.getArray().get(i).get(j).getTypeEnum() != container) continue;
                    return grid.getArray().get(i).get(j);
                }
            }
            return null;
        }

        public final void replaceCell(@NotNull Grid grid, @NotNull SpatialMathEnum.SpatialMathContainers container, @NotNull ISpatialMathContainer newContainer) {
            Intrinsics.checkNotNullParameter((Object)grid, (String)"grid");
            Intrinsics.checkNotNullParameter((Object)((Object)container), (String)"container");
            Intrinsics.checkNotNullParameter((Object)newContainer, (String)"newContainer");
            int n = ((Collection)grid.getArray()).size();
            for (int i = 0; i < n; ++i) {
                int n2 = ((Collection)grid.getArray().get(i)).size();
                for (int j = 0; j < n2; ++j) {
                    if (grid.getArray().get(i).get(j).getTypeEnum() != container) continue;
                    grid.getArray().get(i).set(j, newContainer);
                    return;
                }
            }
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 3, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;
        public static final /* synthetic */ int[] $EnumSwitchMapping$1;

        static {
            int[] nArray = new int[SpatialMathEnum.SpatialMathContainers.values().length];
            try {
                nArray[SpatialMathEnum.SpatialMathContainers.CONNECTING.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[SpatialMathEnum.SpatialMathContainers.MATRIX.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[SpatialMathEnum.SpatialMathContainers.NUMBER_LINE.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[SpatialMathEnum.SpatialMathContainers.TEMPLATE.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
            nArray = new int[SpatialMathEnum.Passage.values().length];
            try {
                nArray[SpatialMathEnum.Passage.NEMETH.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[SpatialMathEnum.Passage.NUMERIC.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[SpatialMathEnum.Passage.GRADE1.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[SpatialMathEnum.Passage.NONE.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$1 = nArray;
        }
    }
}

