/*
 * Decompiled with CFR 0.152.
 */
package org.brailleblaster.math.spatial;

import java.lang.invoke.LambdaMetafactory;
import java.util.Collection;
import java.util.List;
import java.util.function.Consumer;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import nu.xom.Element;
import nu.xom.Node;
import nu.xom.ParentNode;
import org.brailleblaster.bbx.BBX;
import org.brailleblaster.bbx.BBXUtilsKt;
import org.brailleblaster.math.mathml.MathModuleUtils;
import org.brailleblaster.math.numberLine.NumberLine;
import org.brailleblaster.math.spatial.ConnectingContainer;
import org.brailleblaster.math.spatial.Grid;
import org.brailleblaster.math.spatial.GridSettings;
import org.brailleblaster.math.spatial.ISpatialMathContainer;
import org.brailleblaster.math.spatial.ISpatialMathDialog;
import org.brailleblaster.math.spatial.ISpatialMathWidget;
import org.brailleblaster.math.spatial.MathFormattingException;
import org.brailleblaster.math.spatial.MathText;
import org.brailleblaster.math.spatial.Matrix;
import org.brailleblaster.math.spatial.SpatialMathBlock;
import org.brailleblaster.math.spatial.SpatialMathDispatcher;
import org.brailleblaster.math.spatial.SpatialMathEnum;
import org.brailleblaster.math.spatial.SpatialMathUtils;
import org.brailleblaster.math.template.Template;
import org.brailleblaster.math.template.TemplateConstants;
import org.brailleblaster.perspectives.braille.messages.Sender;
import org.brailleblaster.perspectives.mvc.BBSimpleManager;
import org.brailleblaster.perspectives.mvc.XMLNodeCaret;
import org.brailleblaster.perspectives.mvc.events.ModifyEvent;
import org.brailleblaster.perspectives.mvc.events.XMLCaretEvent;
import org.brailleblaster.perspectives.mvc.modules.views.DebugModule;
import org.brailleblaster.utd.internal.xml.XMLHandler;
import org.brailleblaster.util.Utils;
import org.brailleblaster.utils.localization.LocaleHandler;
import org.brailleblaster.utils.swt.EasySWT;
import org.brailleblaster.wordprocessor.WPManager;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Decorations;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Shell;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\b\u0018\u0000 \"2\u00020\u0001:\u0001\"B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\n\u001a\u00020\u000bH\u0016J\n\u0010\f\u001a\u0004\u0018\u00010\u0007H\u0002J\u0010\u0010\r\u001a\u00020\t2\u0006\u0010\u0004\u001a\u00020\u0005H\u0016J\b\u0010\u000e\u001a\u00020\u000bH\u0002J\u0010\u0010\u000f\u001a\u00020\u000b2\u0006\u0010\u0010\u001a\u00020\tH\u0002J\u000e\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u0012H\u0002J\u0018\u0010\u0014\u001a\u00020\u000b2\u0006\u0010\u0015\u001a\u00020\u00052\u0006\u0010\u0010\u001a\u00020\tH\u0002J\b\u0010\u0016\u001a\u00020\u000bH\u0016J\b\u0010\u0017\u001a\u00020\u000bH\u0002J\b\u0010\u0018\u001a\u00020\u000bH\u0002J\b\u0010\u0019\u001a\u00020\u000bH\u0002J\b\u0010\u001a\u001a\u00020\u001bH\u0002J\b\u0010\u001c\u001a\u00020\u000bH\u0002J\b\u0010\u001d\u001a\u00020\u000bH\u0002J\b\u0010!\u001a\u00020\u000bH\u0016R\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082.\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001e\u001a\u00020\t8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001f\u0010 \u00a8\u0006#"}, d2={"Lorg/brailleblaster/math/spatial/GridEditor;", "Lorg/brailleblaster/math/spatial/ISpatialMathDialog;", "<init>", "()V", "shell", "Lorg/eclipse/swt/widgets/Shell;", "page", "Lorg/brailleblaster/math/spatial/Grid;", "_settingsMenu", "Lorg/eclipse/swt/widgets/Menu;", "register", "", "loadPage", "createMenu", "addIdentifierMenu", "addDebugMenu", "menu", "passagesClicked", "Ljava/util/function/Consumer;", "Lorg/brailleblaster/math/spatial/SpatialMathEnum$Passage;", "addContainerTypeMenu", "shell2", "open", "delete", "ok", "cancel", "checkPreFormat", "", "extractFromTextBoxes", "insertIntoDoc", "settingsMenu", "getSettingsMenu", "()Lorg/eclipse/swt/widgets/Menu;", "safeClose", "Companion", "brailleblaster-core"})
@SourceDebugExtension(value={"SMAP\nGridEditor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GridEditor.kt\norg/brailleblaster/math/spatial/GridEditor\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,565:1\n1915#2,2:566\n*S KotlinDebug\n*F\n+ 1 GridEditor.kt\norg/brailleblaster/math/spatial/GridEditor\n*L\n300#1:566,2\n*E\n"})
public final class GridEditor
implements ISpatialMathDialog {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private Shell shell;
    @Nullable
    private Grid page;
    private Menu _settingsMenu;
    @NotNull
    private static final LocaleHandler localeHandler = LocaleHandler.Companion.getDefault$default((LocaleHandler.Companion)LocaleHandler.Companion, null, (int)1, null);
    @JvmField
    @NotNull
    public static final String CONTAINER_TYPE_LABEL = localeHandler.get("containerType");
    @NotNull
    private static final String ROW_GROUP = localeHandler.get("rowGroup");
    @NotNull
    private static final String NEXT_ROW_LABEL = localeHandler.get("nextRow");
    @NotNull
    private static final String PREVIOUS_ROW_LABEL = localeHandler.get("previousRow");
    @NotNull
    private static final String NEXT_COL_LABEL = localeHandler.get("nextCol");
    @NotNull
    private static final String PREVIOUS_COL_LABEL = localeHandler.get("previousCol");
    @NotNull
    private static final String COL_LABEL = localeHandler.get("col");

    public GridEditor() {
        this.loadPage();
        this.open();
        this.register();
    }

    @Override
    public void register() {
        SpatialMathDispatcher.INSTANCE.register(this);
    }

    private final Grid loadPage() {
        if (SpatialMathUtils.currentIsSpatialGrid()) {
            Element current = XMLHandler.Companion.ancestorVisitorElement(WPManager.Companion.getInstance().getController().getSimpleManager().getCurrentCaret().getNode(), GridEditor::loadPage$lambda$0);
            this.page = Grid.Companion.getPageFromElement(current);
        } else if (Matrix.Companion.currentIsMatrix()) {
            Element current = XMLHandler.Companion.ancestorVisitorElement(WPManager.Companion.getInstance().getController().getSimpleManager().getCurrentCaret().getNode(), GridEditor::loadPage$lambda$1);
            Matrix matrix = Matrix.Companion.getContainerFromElement(current);
            Grid grid = this.page = new Grid();
            Intrinsics.checkNotNull((Object)grid);
            grid.getArray().get(0).set(0, matrix);
            Grid grid2 = this.page;
            Intrinsics.checkNotNull((Object)grid2);
            grid2.getSettings().setPassage(matrix.getSettings().getPassage());
        } else if (NumberLine.Companion.currentIsNumberLine()) {
            Element element = XMLHandler.Companion.ancestorVisitorElement(WPManager.Companion.getInstance().getController().getSimpleManager().getCurrentCaret().getNode(), GridEditor::loadPage$lambda$2);
            Intrinsics.checkNotNull((Object)element);
            Element current = element;
            NumberLine numberLine = NumberLine.Companion.getContainerFromElement((Node)current);
            Grid grid = this.page = new Grid();
            Intrinsics.checkNotNull((Object)grid);
            grid.getArray().get(0).set(0, numberLine);
            Grid grid3 = this.page;
            Intrinsics.checkNotNull((Object)grid3);
            grid3.getSettings().setPassage(numberLine.getSettings().getPassage());
        } else {
            this.page = new Grid();
        }
        return this.page;
    }

    @Override
    @NotNull
    public Menu createMenu(@NotNull Shell shell) {
        Menu menu;
        Intrinsics.checkNotNullParameter((Object)shell, (String)"shell");
        Menu menu2 = new Menu((Decorations)shell, 2);
        shell.setMenuBar(menu2);
        if (DebugModule.enabled) {
            this.addDebugMenu(menu2);
        }
        this._settingsMenu = this.createSettingsMenu(menu2, shell);
        if (MathModuleUtils.isNemeth()) {
            Grid grid = this.page;
            Intrinsics.checkNotNull((Object)grid);
            if (grid.hasTemplate()) {
                this.addIdentifierMenu();
            }
        }
        if ((menu = this._settingsMenu) == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"_settingsMenu");
            menu = null;
        }
        Grid grid = this.page;
        Intrinsics.checkNotNull((Object)grid);
        this.addPassages(shell, menu, grid.getSettings(), this.passagesClicked());
        this.addContainerTypeMenu(shell, menu2);
        return menu2;
    }

    private final void addIdentifierMenu() {
        Menu menu = this._settingsMenu;
        if (menu == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"_settingsMenu");
            menu = null;
        }
        MenuItem identifierTranslation = new MenuItem(menu, 64);
        identifierTranslation.setText(TemplateConstants.IDENTIFIER_TRANSLATION);
        Menu dropDownMenuBegin = new Menu((Decorations)this.shell, 4);
        identifierTranslation.setMenu(dropDownMenuBegin);
        MenuItem mathTranslation = new MenuItem(dropDownMenuBegin, 16);
        mathTranslation.setText(TemplateConstants.MATH_TRANSLATION);
        Grid grid = this.page;
        Intrinsics.checkNotNull((Object)grid);
        mathTranslation.setSelection(grid.getSettings().isTranslateIdentifierAsMath());
        mathTranslation.addListener(13, arg_0 -> GridEditor.addIdentifierMenu$lambda$0(mathTranslation, this, arg_0));
        MenuItem literaryTranslation = new MenuItem(dropDownMenuBegin, 16);
        literaryTranslation.setText(TemplateConstants.INSTANCE.getLITERARY_TRANSLATION());
        Grid grid2 = this.page;
        Intrinsics.checkNotNull((Object)grid2);
        literaryTranslation.setSelection(!grid2.getSettings().isTranslateIdentifierAsMath());
        literaryTranslation.addListener(13, arg_0 -> GridEditor.addIdentifierMenu$lambda$1(literaryTranslation, this, arg_0));
    }

    private final void addDebugMenu(Menu menu) {
        MenuItem cascadeMenu = new MenuItem(menu, 64);
        cascadeMenu.setText("Debug Spatial Math");
        Menu dropDownMenu = new Menu((Decorations)this.shell, 4);
        cascadeMenu.setMenu(dropDownMenu);
        MenuItem item1 = new MenuItem(dropDownMenu, 0);
        item1.setText("Fill All");
        item1.addListener(13, arg_0 -> GridEditor.addDebugMenu$lambda$0(this, arg_0));
    }

    private final Consumer<SpatialMathEnum.Passage> passagesClicked() {
        return arg_0 -> GridEditor.passagesClicked$lambda$0(this, arg_0);
    }

    private final void addContainerTypeMenu(Shell shell2, Menu menu) {
        int n;
        MenuItem cascadeMenu = new MenuItem(menu, 64);
        cascadeMenu.setText(CONTAINER_TYPE_LABEL);
        Menu dropDownMenu = new Menu((Decorations)this.shell, 4);
        cascadeMenu.setMenu(dropDownMenu);
        Grid grid = this.page;
        Intrinsics.checkNotNull((Object)grid);
        List<List<ISpatialMathContainer>> list = grid.getArray();
        Grid grid2 = this.page;
        Intrinsics.checkNotNull((Object)grid2);
        Grid grid3 = this.page;
        Intrinsics.checkNotNull((Object)grid3);
        if (list.get(grid2.getSettings().getRowIndex()).get(grid3.getSettings().getColIndex()) instanceof Matrix) {
            n = SpatialMathEnum.SpatialMathContainers.MATRIX.getId();
        } else {
            Grid grid4 = this.page;
            Intrinsics.checkNotNull((Object)grid4);
            List<List<ISpatialMathContainer>> list2 = grid4.getArray();
            Grid grid5 = this.page;
            Intrinsics.checkNotNull((Object)grid5);
            Grid grid6 = this.page;
            Intrinsics.checkNotNull((Object)grid6);
            if (list2.get(grid5.getSettings().getRowIndex()).get(grid6.getSettings().getColIndex()) instanceof Template) {
                n = SpatialMathEnum.SpatialMathContainers.TEMPLATE.getId();
            } else {
                Grid grid7 = this.page;
                Intrinsics.checkNotNull((Object)grid7);
                List<List<ISpatialMathContainer>> list3 = grid7.getArray();
                Grid grid8 = this.page;
                Intrinsics.checkNotNull((Object)grid8);
                Grid grid9 = this.page;
                Intrinsics.checkNotNull((Object)grid9);
                n = list3.get(grid8.getSettings().getRowIndex()).get(grid9.getSettings().getColIndex()) instanceof NumberLine ? SpatialMathEnum.SpatialMathContainers.NUMBER_LINE.getId() : SpatialMathEnum.SpatialMathContainers.CONNECTING.getId();
            }
        }
        int id = n;
        for (SpatialMathEnum.SpatialMathContainers s : SpatialMathEnum.SpatialMathContainers.getEntries()) {
            MenuItem blankBlock = new MenuItem(dropDownMenu, 16);
            blankBlock.setText(s.prettyName);
            blankBlock.setSelection(s.getId() == id);
            blankBlock.addListener(13, arg_0 -> GridEditor.addContainerTypeMenu$lambda$0(s, this, arg_0));
        }
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public void open() {
        m = WPManager.Companion.getInstance().getController();
        if (this.shell == null) ** GOTO lbl-1000
        v0 = this.shell;
        Intrinsics.checkNotNull((Object)v0);
        if (v0.isDisposed()) lbl-1000:
        // 2 sources

        {
            this.shell = new Shell(m.getDisplay().getActiveShell(), 67696);
        } else {
            v1 = this.shell;
            Intrinsics.checkNotNull((Object)v1);
            length = v1.getChildren().length;
            for (i = 0; i < length; ++i) {
                v2 = this.shell;
                Intrinsics.checkNotNull((Object)v2);
                v2.getChildren()[0].dispose();
            }
        }
        gl = new GridLayout(1, false);
        v3 = this.shell;
        Intrinsics.checkNotNull((Object)v3);
        v3.setText(MathModuleUtils.SPATIAL_COMBO);
        v4 = this.shell;
        Intrinsics.checkNotNull((Object)v4);
        v4.setLayout((Layout)gl);
        outerContainer = new Composite((Composite)this.shell, 0);
        outerContainer.setLayout((Layout)new GridLayout(1, false));
        outerContainer.setLayoutData((Object)new GridData(4, 4, true, true));
        sc = new ScrolledComposite(outerContainer, 2816);
        sc.setLayoutData((Object)new GridData(4, 4, true, true));
        sc.setExpandVertical(true);
        sc.setExpandHorizontal(true);
        innerContainer = new Composite((Composite)sc, 0);
        innerContainer.setLayout((Layout)new GridLayout(1, false));
        innerContainer.setLayoutData((Object)new GridData(4, 4, true, true));
        gridGroup = new Composite(innerContainer, 0);
        gridGroup.setLayout((Layout)new GridLayout(2, false));
        gridGroup.setLayoutData((Object)new GridData(0x1000000, 0x1000000, true, true));
        containerGroup = EasySWT.makeGroup((Composite)gridGroup, (int)0, (int)1, (boolean)true);
        v5 = this.page;
        Intrinsics.checkNotNull((Object)v5);
        v6 = v5.getSettings().getRowIndex() + 1;
        v7 = this.page;
        Intrinsics.checkNotNull((Object)v7);
        containerGroup.setText(GridEditor.ROW_GROUP + " " + v6 + " " + GridEditor.COL_LABEL + " " + (v7.getSettings().getColIndex() + 1));
        sc.setContent((Control)gridGroup);
        v8 = this.shell;
        Intrinsics.checkNotNull((Object)v8);
        menu = this.createMenu(v8);
        v9 = this.page;
        Intrinsics.checkNotNull((Object)v9);
        v10 = v9.getArray();
        v11 = this.page;
        Intrinsics.checkNotNull((Object)v11);
        v12 = this.page;
        Intrinsics.checkNotNull((Object)v12);
        cc = v10.get(v11.getSettings().getRowIndex()).get(v12.getSettings().getColIndex());
        v13 = cc.getWidget();
        if (v13 != null) {
            v13.getWidget((Composite)containerGroup, cc);
        }
        v14 = cc.getWidget();
        if (v14 != null) {
            v15 = this.shell;
            Intrinsics.checkNotNull((Object)v15);
            v16 = this._settingsMenu;
            if (v16 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"_settingsMenu");
                v16 = null;
            }
            v14.addMenuItems(v15, menu, v16);
        }
        v17 = this.page;
        Intrinsics.checkNotNull((Object)v17);
        v18 = v17.getArray();
        v19 = this.page;
        Intrinsics.checkNotNull((Object)v19);
        v20 = this.page;
        Intrinsics.checkNotNull((Object)v20);
        v18.get(v19.getSettings().getRowIndex()).set(v20.getSettings().getColIndex(), cc);
        commandsGroup = EasySWT.makeGroup((Composite)innerContainer, (int)0, (int)1, (boolean)false);
        v21 = (Composite)commandsGroup;
        v22 = this.page;
        Intrinsics.checkNotNull((Object)v22);
        v23 = this.shell;
        Intrinsics.checkNotNull((Object)v23);
        GridEditor.Companion.addCommands(v21, v22, v23, (Consumer<SelectionEvent>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)V, open$lambda$0(org.brailleblaster.math.spatial.GridEditor org.eclipse.swt.events.SelectionEvent ), (Lorg/eclipse/swt/events/SelectionEvent;)V)((GridEditor)this), (Consumer<SelectionEvent>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)V, open$lambda$1(org.brailleblaster.math.spatial.GridEditor org.eclipse.swt.events.SelectionEvent ), (Lorg/eclipse/swt/events/SelectionEvent;)V)((GridEditor)this), (Consumer<SelectionEvent>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)V, open$lambda$2(org.brailleblaster.math.spatial.GridEditor org.eclipse.swt.events.SelectionEvent ), (Lorg/eclipse/swt/events/SelectionEvent;)V)((GridEditor)this));
        v24 = this.shell;
        Intrinsics.checkNotNull((Object)v24);
        EasySWT.INSTANCE.addEscapeCloseListener(v24);
        sc.setContent((Control)innerContainer);
        sc.setMinSize(innerContainer.computeSize(-1, -1));
        v25 = this.shell;
        Intrinsics.checkNotNull((Object)v25);
        v25.pack();
        v26 = this.shell;
        Intrinsics.checkNotNull((Object)v26);
        v26.layout(true);
        v27 = this.shell;
        Intrinsics.checkNotNull((Object)v27);
        v27.open();
        v28 = this.page;
        Intrinsics.checkNotNull((Object)v28);
        v29 = v28.getArray();
        v30 = this.page;
        Intrinsics.checkNotNull((Object)v30);
        v31 = this.page;
        Intrinsics.checkNotNull((Object)v31);
        var11_13 = v29.get(v30.getSettings().getRowIndex()).get(v31.getSettings().getColIndex()).getWidget();
        if (var11_13 != null) {
            var11_13.onOpen();
        }
    }

    private final void delete() {
        if (SpatialMathUtils.currentIsSpatialGrid()) {
            Companion.deletePage();
            this.safeClose();
        } else if (Matrix.Companion.currentIsMatrix()) {
            Matrix.Companion.deleteMatrix();
            this.safeClose();
        } else if (NumberLine.Companion.currentIsNumberLine()) {
            NumberLine.Companion.deleteNumberLine();
            this.safeClose();
        }
    }

    private final void ok() {
        Grid grid = this.page;
        Intrinsics.checkNotNull((Object)grid);
        grid.getLines().clear();
        Grid grid2 = this.page;
        Intrinsics.checkNotNull((Object)grid2);
        Iterable $this$forEach$iv = CollectionsKt.flatten((Iterable)grid2.getArray());
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            ISpatialMathContainer it = (ISpatialMathContainer)element$iv;
            boolean bl = false;
            it.getLines().clear();
        }
        this.extractFromTextBoxes();
        if (!this.checkPreFormat()) {
            return;
        }
        Companion.formatGrid(this.page);
        this.insertIntoDoc();
    }

    private final void cancel() {
        this.safeClose();
    }

    private final boolean checkPreFormat() {
        Grid grid = this.page;
        Intrinsics.checkNotNull((Object)grid);
        int n = grid.getSettings().getRows();
        for (int k = 0; k < n; ++k) {
            Grid grid2 = this.page;
            Intrinsics.checkNotNull((Object)grid2);
            int n2 = grid2.getSettings().getCols();
            for (int h = 0; h < n2; ++h) {
                Grid grid3 = this.page;
                Intrinsics.checkNotNull((Object)grid3);
                ISpatialMathContainer container = grid3.getArray().get(k).get(h);
                if (container.preFormatChecks()) continue;
                return false;
            }
        }
        return true;
    }

    private final void extractFromTextBoxes() {
        Grid grid = this.page;
        Intrinsics.checkNotNull((Object)grid);
        List<List<ISpatialMathContainer>> list = grid.getArray();
        Grid grid2 = this.page;
        Intrinsics.checkNotNull((Object)grid2);
        Grid grid3 = this.page;
        Intrinsics.checkNotNull((Object)grid3);
        ISpatialMathWidget iSpatialMathWidget = list.get(grid2.getSettings().getRowIndex()).get(grid3.getSettings().getColIndex()).getWidget();
        if (iSpatialMathWidget != null) {
            iSpatialMathWidget.extractText();
        }
    }

    private final void insertIntoDoc() {
        Element gridElement = Companion.makeBBXGridElement(this.page);
        try {
            Grid grid = this.page;
            Intrinsics.checkNotNull((Object)grid);
            SpatialMathBlock.INSTANCE.format(gridElement, grid.getLines());
        }
        catch (MathFormattingException e) {
            e.printStackTrace();
            MathFormattingException.Companion.notifyLong();
            return;
        }
        ParentNode currentParent = null;
        if (SpatialMathUtils.currentIsSpatialGrid()) {
            Node node = current = XMLHandler.Companion.ancestorVisitorElement(WPManager.Companion.getInstance().getController().getSimpleManager().getCurrentCaret().getNode(), GridEditor::insertIntoDoc$lambda$0);
            Intrinsics.checkNotNull((Object)node);
            ParentNode parentNode = node.getParent();
            Intrinsics.checkNotNullExpressionValue((Object)parentNode, (String)"getParent(...)");
            currentParent = parentNode;
            currentParent.replaceChild(current, (Node)gridElement);
        } else {
            current = WPManager.Companion.getInstance().getController().getSimpleManager().getCurrentCaret().getNode();
            if (BBX.CONTAINER.isA(current)) {
                ParentNode parentNode = current.getParent();
                Intrinsics.checkNotNullExpressionValue((Object)parentNode, (String)"getParent(...)");
                currentParent = parentNode;
            } else {
                current = (Node)BBXUtilsKt.findBlock(current);
                ParentNode parentNode = ((Element)current).getParent();
                Intrinsics.checkNotNullExpressionValue((Object)parentNode, (String)"getParent(...)");
                currentParent = parentNode;
            }
            int index = currentParent.indexOf(current);
            while (!BBX.SECTION.isA((Node)currentParent)) {
                current = (Node)((Element)currentParent);
                Intrinsics.checkNotNullExpressionValue((Object)((Element)current).getParent(), (String)"getParent(...)");
                index = currentParent.indexOf(current);
            }
            ++index;
            if (BBX.CONTAINER.TABLE.isA(current)) {
                ++index;
            }
            Utils.insertChildCountSafe(currentParent, (Node)gridElement, index);
        }
        Grid.Companion.addStylesToGridElement(gridElement);
        Node[] nodeArray = new Node[]{currentParent};
        WPManager.Companion.getInstance().getController().getSimpleManager().dispatchEvent(new ModifyEvent(Sender.TEXT, true, nodeArray));
        this.safeClose();
    }

    @Override
    @NotNull
    public Menu getSettingsMenu() {
        Menu menu = this._settingsMenu;
        if (menu == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"_settingsMenu");
            menu = null;
        }
        return menu;
    }

    @Override
    public void safeClose() {
        Grid grid = this.page;
        Intrinsics.checkNotNull((Object)grid);
        int n = ((Collection)grid.getArray()).size();
        for (int i = 0; i < n; ++i) {
            Grid grid2 = this.page;
            Intrinsics.checkNotNull((Object)grid2);
            int n2 = ((Collection)grid2.getArray().get(i)).size();
            for (int j = 0; j < n2; ++j) {
                Grid grid3 = this.page;
                Intrinsics.checkNotNull((Object)grid3);
                grid3.getArray().get(i).get(j).saveSettings();
            }
        }
        Grid grid4 = this.page;
        Intrinsics.checkNotNull((Object)grid4);
        grid4.saveSettings();
        Shell shell = this.shell;
        Intrinsics.checkNotNull((Object)shell);
        shell.close();
    }

    private static final boolean loadPage$lambda$0(Element node) {
        return BBX.CONTAINER.SPATIAL_GRID.isA((Node)node);
    }

    private static final boolean loadPage$lambda$1(Element node) {
        return BBX.CONTAINER.MATRIX.isA((Node)node);
    }

    private static final boolean loadPage$lambda$2(Element node) {
        return BBX.CONTAINER.NUMBER_LINE.isA((Node)node);
    }

    private static final void addIdentifierMenu$lambda$0(MenuItem $mathTranslation, GridEditor this$0, Event it) {
        if (!$mathTranslation.getSelection()) {
            return;
        }
        Grid grid = this$0.page;
        Intrinsics.checkNotNull((Object)grid);
        grid.getSettings().setTranslateIdentifierAsMath(true);
        Grid grid2 = this$0.page;
        Intrinsics.checkNotNull((Object)grid2);
        int n = ((Collection)grid2.getArray()).size();
        for (int i = 0; i < n; ++i) {
            Grid grid3 = this$0.page;
            Intrinsics.checkNotNull((Object)grid3);
            int n2 = ((Collection)grid3.getArray().get(i)).size();
            for (int j = 0; j < n2; ++j) {
                Grid grid4 = this$0.page;
                Intrinsics.checkNotNull((Object)grid4);
                ISpatialMathContainer container = grid4.getArray().get(i).get(j);
                if (!(container instanceof Template)) continue;
                Grid grid5 = this$0.page;
                Intrinsics.checkNotNull((Object)grid5);
                ISpatialMathContainer iSpatialMathContainer = grid5.getArray().get(i).get(j);
                Intrinsics.checkNotNull((Object)iSpatialMathContainer, (String)"null cannot be cast to non-null type org.brailleblaster.math.template.Template");
                Template template = (Template)iSpatialMathContainer;
                template.getSettings().setTranslateIdentifierAsMath(true);
                template.setIdentifier(new MathText(template.getIdentifier().print, Template.Companion.translateIdentifier(template.getIdentifier().print, template), false, 4, null));
            }
        }
        Grid grid6 = this$0.page;
        Intrinsics.checkNotNull((Object)grid6);
        $mathTranslation.setSelection(grid6.getSettings().isTranslateIdentifierAsMath());
    }

    private static final void addIdentifierMenu$lambda$1(MenuItem $literaryTranslation, GridEditor this$0, Event it) {
        if (!$literaryTranslation.getSelection()) {
            return;
        }
        Grid grid = this$0.page;
        Intrinsics.checkNotNull((Object)grid);
        grid.getSettings().setTranslateIdentifierAsMath(false);
        Grid grid2 = this$0.page;
        Intrinsics.checkNotNull((Object)grid2);
        int n = ((Collection)grid2.getArray()).size();
        for (int i = 0; i < n; ++i) {
            Grid grid3 = this$0.page;
            Intrinsics.checkNotNull((Object)grid3);
            int n2 = ((Collection)grid3.getArray().get(i)).size();
            for (int j = 0; j < n2; ++j) {
                Grid grid4 = this$0.page;
                Intrinsics.checkNotNull((Object)grid4);
                ISpatialMathContainer container = grid4.getArray().get(i).get(j);
                if (!(container instanceof Template)) continue;
                Grid grid5 = this$0.page;
                Intrinsics.checkNotNull((Object)grid5);
                ISpatialMathContainer iSpatialMathContainer = grid5.getArray().get(i).get(j);
                Intrinsics.checkNotNull((Object)iSpatialMathContainer, (String)"null cannot be cast to non-null type org.brailleblaster.math.template.Template");
                Template template = (Template)iSpatialMathContainer;
                template.getSettings().setTranslateIdentifierAsMath(false);
                template.setIdentifier(new MathText(template.getIdentifier().print, Template.Companion.translateIdentifier(template.getIdentifier().print, template), false, 4, null));
            }
        }
        Grid grid6 = this$0.page;
        Intrinsics.checkNotNull((Object)grid6);
        $literaryTranslation.setSelection(!grid6.getSettings().isTranslateIdentifierAsMath());
    }

    private static final void addDebugMenu$lambda$0(GridEditor this$0, Event it) {
        Grid grid = this$0.page;
        Intrinsics.checkNotNull((Object)grid);
        int n = grid.getSettings().getRows();
        for (int k = 0; k < n; ++k) {
            Grid grid2 = this$0.page;
            Intrinsics.checkNotNull((Object)grid2);
            int n2 = grid2.getSettings().getCols();
            for (int h = 0; h < n2; ++h) {
                Grid grid3 = this$0.page;
                Intrinsics.checkNotNull((Object)grid3);
                ISpatialMathContainer t = grid3.getArray().get(k).get(h);
                ISpatialMathWidget iSpatialMathWidget = t.getWidget();
                if (iSpatialMathWidget == null) continue;
                iSpatialMathWidget.fillDebug(t);
            }
        }
        SpatialMathDispatcher.INSTANCE.dispatch();
    }

    private static final void passagesClicked$lambda$0(GridEditor this$0, SpatialMathEnum.Passage e) {
        Intrinsics.checkNotNullParameter((Object)((Object)e), (String)"e");
        Grid grid = this$0.page;
        Intrinsics.checkNotNull((Object)grid);
        grid.getSettings().setPassage(e);
        Grid grid2 = this$0.page;
        Intrinsics.checkNotNull((Object)grid2);
        int n = ((Collection)grid2.getArray()).size();
        for (int i = 0; i < n; ++i) {
            Grid grid3 = this$0.page;
            Intrinsics.checkNotNull((Object)grid3);
            int n2 = ((Collection)grid3.getArray().get(i)).size();
            for (int j = 0; j < n2; ++j) {
                Grid grid4 = this$0.page;
                Intrinsics.checkNotNull((Object)grid4);
                grid4.getArray().get(i).get(j).getSettings().setPassage(e);
            }
        }
    }

    private static final void addContainerTypeMenu$lambda$0(SpatialMathEnum.SpatialMathContainers $s, GridEditor this$0, Event it) {
        int n = $s.getId();
        if (n == SpatialMathEnum.SpatialMathContainers.NUMBER_LINE.getId()) {
            Grid grid = this$0.page;
            Intrinsics.checkNotNull((Object)grid);
            List<List<ISpatialMathContainer>> list = grid.getArray();
            Grid grid2 = this$0.page;
            Intrinsics.checkNotNull((Object)grid2);
            Grid grid3 = this$0.page;
            Intrinsics.checkNotNull((Object)grid3);
            list.get(grid2.getSettings().getRowIndex()).set(grid3.getSettings().getColIndex(), new NumberLine());
        } else if (n == SpatialMathEnum.SpatialMathContainers.MATRIX.getId()) {
            Grid grid = this$0.page;
            Intrinsics.checkNotNull((Object)grid);
            List<List<ISpatialMathContainer>> list = grid.getArray();
            Grid grid4 = this$0.page;
            Intrinsics.checkNotNull((Object)grid4);
            Grid grid5 = this$0.page;
            Intrinsics.checkNotNull((Object)grid5);
            list.get(grid4.getSettings().getRowIndex()).set(grid5.getSettings().getColIndex(), new Matrix());
        } else if (n == SpatialMathEnum.SpatialMathContainers.TEMPLATE.getId()) {
            Grid grid = this$0.page;
            Intrinsics.checkNotNull((Object)grid);
            List<List<ISpatialMathContainer>> list = grid.getArray();
            Grid grid6 = this$0.page;
            Intrinsics.checkNotNull((Object)grid6);
            Grid grid7 = this$0.page;
            Intrinsics.checkNotNull((Object)grid7);
            list.get(grid6.getSettings().getRowIndex()).set(grid7.getSettings().getColIndex(), new Template());
        } else {
            Grid grid = this$0.page;
            Intrinsics.checkNotNull((Object)grid);
            List<List<ISpatialMathContainer>> list = grid.getArray();
            Grid grid8 = this$0.page;
            Intrinsics.checkNotNull((Object)grid8);
            Grid grid9 = this$0.page;
            Intrinsics.checkNotNull((Object)grid9);
            list.get(grid8.getSettings().getRowIndex()).set(grid9.getSettings().getColIndex(), new ConnectingContainer());
        }
        SpatialMathDispatcher.INSTANCE.dispatch();
    }

    private static final void open$lambda$0(GridEditor this$0, SelectionEvent it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        this$0.delete();
    }

    private static final void open$lambda$1(GridEditor this$0, SelectionEvent it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        this$0.ok();
    }

    private static final void open$lambda$2(GridEditor this$0, SelectionEvent it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        this$0.cancel();
    }

    private static final boolean insertIntoDoc$lambda$0(Element node) {
        return BBX.CONTAINER.SPATIAL_GRID.isA((Node)node);
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u000e\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0006\u0010\u0015\u001a\u00020\u0016J\u0010\u0010\u0017\u001a\u00020\u00162\b\u0010\u0018\u001a\u0004\u0018\u00010\u0019J\u0010\u0010\u001a\u001a\u00020\u001b2\b\u0010\u0018\u001a\u0004\u0018\u00010\u0019JP\u0010\u001c\u001a\u00020\u00162\b\u0010\u001d\u001a\u0004\u0018\u00010\u001e2\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001f\u001a\u00020 2\u000e\u0010!\u001a\n\u0012\u0004\u0012\u00020#\u0018\u00010\"2\u000e\u0010$\u001a\n\u0012\u0004\u0012\u00020#\u0018\u00010\"2\u000e\u0010%\u001a\n\u0012\u0004\u0012\u00020#\u0018\u00010\"R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u00020\u00078\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\b\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u000b\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\nR\u0011\u0010\r\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\nR\u0011\u0010\u000f\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\nR\u0011\u0010\u0011\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\nR\u0011\u0010\u0013\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\n\u00a8\u0006&"}, d2={"Lorg/brailleblaster/math/spatial/GridEditor$Companion;", "", "<init>", "()V", "localeHandler", "Lorg/brailleblaster/utils/localization/LocaleHandler;", "CONTAINER_TYPE_LABEL", "", "ROW_GROUP", "getROW_GROUP", "()Ljava/lang/String;", "NEXT_ROW_LABEL", "getNEXT_ROW_LABEL", "PREVIOUS_ROW_LABEL", "getPREVIOUS_ROW_LABEL", "NEXT_COL_LABEL", "getNEXT_COL_LABEL", "PREVIOUS_COL_LABEL", "getPREVIOUS_COL_LABEL", "COL_LABEL", "getCOL_LABEL", "deletePage", "", "formatGrid", "page", "Lorg/brailleblaster/math/spatial/Grid;", "makeBBXGridElement", "Lnu/xom/Element;", "addCommands", "gridGroup", "Lorg/eclipse/swt/widgets/Composite;", "shell", "Lorg/eclipse/swt/widgets/Shell;", "onDelete", "Ljava/util/function/Consumer;", "Lorg/eclipse/swt/events/SelectionEvent;", "onOk", "onCancel", "brailleblaster-core"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final String getROW_GROUP() {
            return ROW_GROUP;
        }

        @NotNull
        public final String getNEXT_ROW_LABEL() {
            return NEXT_ROW_LABEL;
        }

        @NotNull
        public final String getPREVIOUS_ROW_LABEL() {
            return PREVIOUS_ROW_LABEL;
        }

        @NotNull
        public final String getNEXT_COL_LABEL() {
            return NEXT_COL_LABEL;
        }

        @NotNull
        public final String getPREVIOUS_COL_LABEL() {
            return PREVIOUS_COL_LABEL;
        }

        @NotNull
        public final String getCOL_LABEL() {
            return COL_LABEL;
        }

        public final void deletePage() {
            Element element = XMLHandler.Companion.ancestorVisitorElement(WPManager.Companion.getInstance().getController().getSimpleManager().getCurrentCaret().getNode(), Companion::deletePage$lambda$0);
            Intrinsics.checkNotNull((Object)element);
            Element current = element;
            Node previous = XMLHandler.Companion.previousSiblingNode((Node)current);
            ParentNode parent = current.getParent();
            parent.removeChild((Node)current);
            BBSimpleManager bBSimpleManager = WPManager.Companion.getInstance().getController().getSimpleManager();
            Node[] nodeArray = new Node[1];
            Intrinsics.checkNotNull((Object)parent);
            nodeArray[0] = parent;
            bBSimpleManager.dispatchEvent(new ModifyEvent(Sender.TEXT, true, nodeArray));
            if (previous != null) {
                WPManager.Companion.getInstance().getController().getSimpleManager().dispatchEvent(new XMLCaretEvent(Sender.TEXT, new XMLNodeCaret(previous, null, 2, null), null, 4, null));
            }
        }

        public final void formatGrid(@Nullable Grid page) {
            int h;
            int n;
            int k;
            Grid grid = page;
            Intrinsics.checkNotNull((Object)grid);
            int n2 = grid.getSettings().getRows();
            for (k = 0; k < n2; ++k) {
                n = page.getSettings().getCols();
                for (h = 0; h < n; ++h) {
                    page.getArray().get(k).get(h).getSettings().setPassage(page.getSettings().getPassage());
                    page.getArray().get(k).get(h).format();
                }
            }
            n2 = page.getSettings().getRows();
            for (k = 0; k < n2; ++k) {
                n = page.getSettings().getCols();
                for (h = 0; h < n; ++h) {
                    if (!(page.getArray().get(k).get(h) instanceof ConnectingContainer)) continue;
                    ISpatialMathContainer iSpatialMathContainer = page.getArray().get(k).get(h);
                    Intrinsics.checkNotNull((Object)iSpatialMathContainer, (String)"null cannot be cast to non-null type org.brailleblaster.math.spatial.ConnectingContainer");
                    ((ConnectingContainer)iSpatialMathContainer).fillPageInfo(page.getArray().get(k).get(h), page, k, h);
                }
            }
            page.format();
        }

        @NotNull
        public final Element makeBBXGridElement(@Nullable Grid page) {
            Grid grid = page;
            Intrinsics.checkNotNull((Object)grid);
            int n = grid.getSettings().getRows();
            for (int i = 0; i < n; ++i) {
                int n2 = page.getSettings().getCols();
                for (int j = 0; j < n2; ++j) {
                    Element element;
                    ISpatialMathContainer t = page.getArray().get(i).get(j);
                    ISpatialMathContainer iSpatialMathContainer = t;
                    if (iSpatialMathContainer instanceof Template) {
                        var9_10 = BBX.CONTAINER.TEMPLATE.create((Template)t);
                        Intrinsics.checkNotNull((Object)var9_10);
                        element = var9_10;
                    } else if (iSpatialMathContainer instanceof Matrix) {
                        var9_10 = BBX.CONTAINER.MATRIX.create((Matrix)t);
                        Intrinsics.checkNotNull((Object)var9_10);
                        element = var9_10;
                    } else if (iSpatialMathContainer instanceof NumberLine) {
                        var9_10 = BBX.CONTAINER.NUMBER_LINE.create((NumberLine)t);
                        Intrinsics.checkNotNull((Object)var9_10);
                        element = var9_10;
                    } else {
                        BBX.ContainerElement.ConnectingContainerSubType connectingContainerSubType = BBX.CONTAINER.CONNECTING_CONTAINER;
                        Intrinsics.checkNotNull((Object)t, (String)"null cannot be cast to non-null type org.brailleblaster.math.spatial.ConnectingContainer");
                        var9_10 = connectingContainerSubType.create((ConnectingContainer)t);
                        Intrinsics.checkNotNull((Object)var9_10);
                        element = var9_10;
                    }
                    Element e = element;
                    try {
                        SpatialMathBlock.INSTANCE.format(e, t.getLines());
                        continue;
                    }
                    catch (MathFormattingException e1) {
                        e1.printStackTrace();
                    }
                }
            }
            Element element = BBX.CONTAINER.SPATIAL_GRID.create(page);
            Intrinsics.checkNotNullExpressionValue((Object)element, (String)"create(...)");
            return element;
        }

        public final void addCommands(@Nullable Composite gridGroup, @NotNull Grid page, @NotNull Shell shell, @Nullable Consumer<SelectionEvent> onDelete, @Nullable Consumer<SelectionEvent> onOk, @Nullable Consumer<SelectionEvent> onCancel) {
            Intrinsics.checkNotNullParameter((Object)page, (String)"page");
            Intrinsics.checkNotNullParameter((Object)shell, (String)"shell");
            Group rowGroup = EasySWT.makeGroup((Composite)gridGroup, (int)0, (int)(page.getSettings().getRows() + 3), (boolean)false);
            rowGroup.setText(SpatialMathUtils.ROW_GROUP);
            EasySWT.INSTANCE.makeToggleButton((Composite)rowGroup, SpatialMathUtils.PREVIOUS_LABEL, 1, arg_0 -> Companion.addCommands$lambda$0(page, arg_0));
            int n = page.getSettings().getRows();
            for (int i = 0; i < n; ++i) {
                Button b = EasySWT.INSTANCE.makeToggleButton((Composite)rowGroup, String.valueOf(i + 1), 1, arg_0 -> Companion.addCommands$lambda$1(page, i, arg_0));
                b.setSelection(i == page.getSettings().getRowIndex());
            }
            EasySWT.INSTANCE.makeToggleButton((Composite)rowGroup, SpatialMathUtils.NEXT_LABEL, 1, arg_0 -> Companion.addCommands$lambda$2(page, arg_0));
            EasySWT.makePushButton((Composite)((Composite)rowGroup), (String)SpatialMathUtils.DELETE, (int)1, arg_0 -> Companion.addCommands$lambda$3(page, arg_0));
            Group colGroup = EasySWT.makeGroup((Composite)gridGroup, (int)0, (int)(page.getSettings().getCols() + 3), (boolean)false);
            colGroup.setText(SpatialMathUtils.COL_LABEL);
            EasySWT.INSTANCE.makeToggleButton((Composite)colGroup, SpatialMathUtils.PREVIOUS_LABEL, 1, arg_0 -> Companion.addCommands$lambda$4(page, arg_0));
            int n2 = page.getSettings().getCols();
            for (int i = 0; i < n2; ++i) {
                Button b = EasySWT.INSTANCE.makeToggleButton((Composite)colGroup, String.valueOf(i + 1), 1, arg_0 -> Companion.addCommands$lambda$5(page, i, arg_0));
                b.setSelection(i == page.getSettings().getColIndex());
            }
            EasySWT.INSTANCE.makeToggleButton((Composite)colGroup, SpatialMathUtils.NEXT_LABEL, 1, arg_0 -> Companion.addCommands$lambda$6(page, arg_0));
            EasySWT.makePushButton((Composite)((Composite)colGroup), (String)SpatialMathUtils.DELETE, (int)1, arg_0 -> Companion.addCommands$lambda$7(page, arg_0));
            Group actionsGroup = EasySWT.makeGroup((Composite)gridGroup, (int)0, (int)3, (boolean)false);
            EasySWT.makePushButton((Composite)((Composite)actionsGroup), (String)SpatialMathUtils.OK_LABEL, (int)1, onOk);
            EasySWT.makePushButton((Composite)((Composite)actionsGroup), (String)SpatialMathUtils.CANCEL_LABEL, (int)1, onCancel);
            if (MathModuleUtils.INSTANCE.currentIsSpatialMath()) {
                EasySWT.makePushButton((Composite)((Composite)actionsGroup), (String)SpatialMathUtils.DELETE_CONTAINER, (int)1, onDelete);
            }
        }

        private static final boolean deletePage$lambda$0(Element node) {
            Intrinsics.checkNotNullParameter((Object)node, (String)"node");
            return BBX.CONTAINER.SPATIAL_GRID.isA((Node)node);
        }

        private static final void addCommands$lambda$0(Grid $page, SelectionEvent it) {
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            if ($page.getSettings().getRowIndex() > 0) {
                Object object = $page.getArray().get($page.getSettings().getRowIndex()).get($page.getSettings().getColIndex()).getWidget();
                if (object != null) {
                    object.extractText();
                }
                object = $page.getSettings();
                ((GridSettings)object).setRowIndex(((GridSettings)object).getRowIndex() - 1);
                SpatialMathDispatcher.INSTANCE.dispatch();
            }
        }

        private static final void addCommands$lambda$1(Grid $page, int $i, SelectionEvent selectionEvent) {
            ISpatialMathWidget iSpatialMathWidget = $page.getArray().get($page.getSettings().getRowIndex()).get($page.getSettings().getColIndex()).getWidget();
            if (iSpatialMathWidget != null) {
                iSpatialMathWidget.extractText();
            }
            $page.getSettings().setRowIndex($i);
            SpatialMathDispatcher.INSTANCE.dispatch();
        }

        private static final void addCommands$lambda$2(Grid $page, SelectionEvent it) {
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            Object object = $page.getArray().get($page.getSettings().getRowIndex()).get($page.getSettings().getColIndex()).getWidget();
            if (object != null) {
                object.extractText();
            }
            $page.saveSettings();
            if ($page.getSettings().getRowIndex() + 2 > $page.getSettings().getRows()) {
                $page.addRow();
            }
            object = $page.getSettings();
            ((GridSettings)object).setRowIndex(((GridSettings)object).getRowIndex() + 1);
            SpatialMathDispatcher.INSTANCE.dispatch();
        }

        private static final void addCommands$lambda$3(Grid $page, SelectionEvent it) {
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            if ($page.getSettings().getRowIndex() > 0) {
                $page.deleteRow($page.getSettings().getRowIndex());
                SpatialMathDispatcher.INSTANCE.dispatch();
            }
        }

        private static final void addCommands$lambda$4(Grid $page, SelectionEvent it) {
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            if ($page.getSettings().getColIndex() > 0) {
                Object object = $page.getArray().get($page.getSettings().getRowIndex()).get($page.getSettings().getColIndex()).getWidget();
                if (object != null) {
                    object.extractText();
                }
                object = $page.getSettings();
                ((GridSettings)object).setColIndex(((GridSettings)object).getColIndex() - 1);
                SpatialMathDispatcher.INSTANCE.dispatch();
            }
        }

        private static final void addCommands$lambda$5(Grid $page, int $i, SelectionEvent selectionEvent) {
            ISpatialMathWidget iSpatialMathWidget = $page.getArray().get($page.getSettings().getRowIndex()).get($page.getSettings().getColIndex()).getWidget();
            if (iSpatialMathWidget != null) {
                iSpatialMathWidget.extractText();
            }
            $page.getSettings().setColIndex($i);
            SpatialMathDispatcher.INSTANCE.dispatch();
        }

        private static final void addCommands$lambda$6(Grid $page, SelectionEvent it) {
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            Object object = $page.getArray().get($page.getSettings().getRowIndex()).get($page.getSettings().getColIndex()).getWidget();
            if (object != null) {
                object.extractText();
            }
            $page.saveSettings();
            if ($page.getSettings().getColIndex() + 2 > $page.getSettings().getCols()) {
                $page.addCol();
            }
            object = $page.getSettings();
            ((GridSettings)object).setColIndex(((GridSettings)object).getColIndex() + 1);
            SpatialMathDispatcher.INSTANCE.dispatch();
        }

        private static final void addCommands$lambda$7(Grid $page, SelectionEvent it) {
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            if ($page.getSettings().getColIndex() > 0) {
                $page.deleteCol($page.getSettings().getColIndex());
                SpatialMathDispatcher.INSTANCE.dispatch();
            }
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

