/*
 * Decompiled with CFR 0.152.
 */
package org.brailleblaster.math.spatial;

import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.brailleblaster.math.spatial.ISpatialMathContainer;
import org.brailleblaster.math.spatial.ISpatialMathContainerJson;
import org.brailleblaster.math.spatial.Matrix;
import org.brailleblaster.math.spatial.MatrixCell;
import org.brailleblaster.math.spatial.MatrixConstants;
import org.brailleblaster.math.spatial.MatrixSettings;
import org.brailleblaster.math.spatial.SpatialMathEnum;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010$\u001a\u00020%H\u0016J\u0010\u0010&\u001a\u00020\u00012\u0006\u0010'\u001a\u00020%H\u0016R\u001a\u0010\u0004\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\tR\u001a\u0010\n\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\u0007\"\u0004\b\f\u0010\tR\u000e\u0010\r\u001a\u00020\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000f\u001a\u00020\u0010X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\u0012\"\u0004\b\u0013\u0010\u0014R\u001a\u0010\u0015\u001a\u00020\u0016X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0017\u0010\u0018\"\u0004\b\u0019\u0010\u001aR\u001c\u0010\u001b\u001a\u0004\u0018\u00010\u001cX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001d\u0010\u001e\"\u0004\b\u001f\u0010 R\u001a\u0010!\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020#0\"0\"X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006("}, d2={"Lorg/brailleblaster/math/spatial/MatrixJson;", "Lorg/brailleblaster/math/spatial/ISpatialMathContainerJson;", "<init>", "()V", "rows", "", "getRows", "()I", "setRows", "(I)V", "cols", "getCols", "setCols", "wideType", "Lorg/brailleblaster/math/spatial/MatrixConstants$Wide;", "bracket", "Lorg/brailleblaster/math/spatial/MatrixConstants$BracketType;", "getBracket", "()Lorg/brailleblaster/math/spatial/MatrixConstants$BracketType;", "setBracket", "(Lorg/brailleblaster/math/spatial/MatrixConstants$BracketType;)V", "passage", "Lorg/brailleblaster/math/spatial/SpatialMathEnum$Passage;", "getPassage", "()Lorg/brailleblaster/math/spatial/SpatialMathEnum$Passage;", "setPassage", "(Lorg/brailleblaster/math/spatial/SpatialMathEnum$Passage;)V", "translation", "Lorg/brailleblaster/math/spatial/SpatialMathEnum$Translation;", "getTranslation", "()Lorg/brailleblaster/math/spatial/SpatialMathEnum$Translation;", "setTranslation", "(Lorg/brailleblaster/math/spatial/SpatialMathEnum$Translation;)V", "matrixCells", "", "Lorg/brailleblaster/math/spatial/MatrixCell;", "jsonToContainer", "Lorg/brailleblaster/math/spatial/ISpatialMathContainer;", "containerToJson", "container", "brailleblaster-core"})
public final class MatrixJson
implements ISpatialMathContainerJson {
    private int rows;
    private int cols;
    @NotNull
    private MatrixConstants.Wide wideType = MatrixSettings.DEFAULT_WIDE;
    @NotNull
    private MatrixConstants.BracketType bracket = MatrixSettings.DEFAULT_BRACKET;
    @NotNull
    private SpatialMathEnum.Passage passage = SpatialMathEnum.Passage.NONE;
    @Nullable
    private SpatialMathEnum.Translation translation;
    @NotNull
    private List<List<MatrixCell>> matrixCells = new ArrayList();

    public final int getRows() {
        return this.rows;
    }

    public final void setRows(int n) {
        this.rows = n;
    }

    public final int getCols() {
        return this.cols;
    }

    public final void setCols(int n) {
        this.cols = n;
    }

    @NotNull
    public final MatrixConstants.BracketType getBracket() {
        return this.bracket;
    }

    public final void setBracket(@NotNull MatrixConstants.BracketType bracketType) {
        Intrinsics.checkNotNullParameter((Object)((Object)bracketType), (String)"<set-?>");
        this.bracket = bracketType;
    }

    @NotNull
    public final SpatialMathEnum.Passage getPassage() {
        return this.passage;
    }

    public final void setPassage(@NotNull SpatialMathEnum.Passage passage) {
        Intrinsics.checkNotNullParameter((Object)((Object)passage), (String)"<set-?>");
        this.passage = passage;
    }

    @Nullable
    public final SpatialMathEnum.Translation getTranslation() {
        return this.translation;
    }

    public final void setTranslation(@Nullable SpatialMathEnum.Translation translation) {
        this.translation = translation;
    }

    @Override
    @NotNull
    public ISpatialMathContainer jsonToContainer() {
        Matrix matrix = new Matrix();
        matrix.getSettings().setRows(this.rows);
        matrix.getSettings().setCols(this.cols);
        matrix.getSettings().setWideType(this.wideType);
        matrix.getSettings().setBracketType(this.bracket);
        matrix.getSettings().setPassage(this.passage);
        matrix.getSettings().setTranslation(this.translation);
        matrix.getSettings().setModel(this.matrixCells);
        return matrix;
    }

    @Override
    @NotNull
    public ISpatialMathContainerJson containerToJson(@NotNull ISpatialMathContainer container) {
        Intrinsics.checkNotNullParameter((Object)container, (String)"container");
        Matrix matrix = (Matrix)container;
        this.rows = matrix.getSettings().getRows();
        this.cols = matrix.getSettings().getCols();
        this.wideType = matrix.getSettings().getWideType();
        this.bracket = matrix.getSettings().getBracketType();
        this.passage = matrix.getSettings().getPassage();
        this.translation = matrix.getSettings().getTranslation();
        this.matrixCells = matrix.getSettings().getModel();
        return this;
    }
}

