/*
 * Decompiled with CFR 0.152.
 */
package org.brailleblaster.math.spatial;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.CharsKt;
import kotlin.text.StringsKt;
import nu.xom.Attribute;
import nu.xom.Element;
import nu.xom.Node;
import nu.xom.Text;
import org.brailleblaster.bbx.BBX;
import org.brailleblaster.math.spatial.Line;
import org.brailleblaster.math.spatial.MathFormattingException;
import org.brailleblaster.settings.UTDManager;
import org.brailleblaster.utd.properties.EmphasisType;
import org.brailleblaster.wordprocessor.WPManager;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001c\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tJ\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\nH\u0002J\u001c\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\n0\t2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\n0\tH\u0002J\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0002\u00a8\u0006\u0014"}, d2={"Lorg/brailleblaster/math/spatial/SpatialMathBlock;", "", "<init>", "()V", "format", "", "container", "Lnu/xom/Element;", "origLines", "", "Lorg/brailleblaster/math/spatial/Line;", "lineTooLong", "", "line", "clean", "lines", "getSpans", "", "string", "", "brailleblaster-core"})
@SourceDebugExtension(value={"SMAP\nSpatialMathBlock.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SpatialMathBlock.kt\norg/brailleblaster/math/spatial/SpatialMathBlock\n+ 2 _Strings.kt\nkotlin/text/StringsKt___StringsKt\n*L\n1#1,142:1\n654#2,5:143\n*S KotlinDebug\n*F\n+ 1 SpatialMathBlock.kt\norg/brailleblaster/math/spatial/SpatialMathBlock\n*L\n139#1:143,5\n*E\n"})
public final class SpatialMathBlock {
    @NotNull
    public static final SpatialMathBlock INSTANCE = new SpatialMathBlock();

    private SpatialMathBlock() {
    }

    public final void format(@NotNull Element container, @NotNull List<Line> origLines) throws MathFormattingException {
        Intrinsics.checkNotNullParameter((Object)container, (String)"container");
        Intrinsics.checkNotNullParameter(origLines, (String)"origLines");
        List<Line> lines = this.clean(origLines);
        Element lastBlock = null;
        Iterator iterator = ((Iterable)lines).iterator();
        int n = 0;
        while (iterator.hasNext()) {
            Iterator<Line.Segment> iterator2;
            int i = n++;
            Line line = (Line)iterator.next();
            if (this.lineTooLong(line)) {
                throw new MathFormattingException(StringsKt.trimIndent((String)("\n    Line " + (i + 1) + "\n    " + line + "\n    ")));
            }
            Element block = BBX.BLOCK.SPATIAL_MATH.create();
            int lineLength = 0;
            Intrinsics.checkNotNullExpressionValue(line.getElements().iterator(), (String)"iterator(...)");
            while (iterator2.hasNext()) {
                Line.Segment segment;
                Intrinsics.checkNotNullExpressionValue((Object)iterator2.next(), (String)"next(...)");
                Line.Segment segment2 = segment;
                if (segment2 instanceof Line.WhitespaceSegment) {
                    Element tab = BBX.SPAN.TAB.create();
                    int spans = this.getSpans(((Line.WhitespaceSegment)segment).toString());
                    Attribute attribute = BBX.SPAN.TAB.ATTRIB_VALUE.newAttribute((lineLength += spans) + 1);
                    tab.addAttribute(attribute);
                    block.appendChild((Node)tab);
                    continue;
                }
                if (segment2 instanceof Line.TextSegment) {
                    EmphasisType[] spans = new EmphasisType[]{EmphasisType.NO_TRANSLATE};
                    Element emphasis = BBX.INLINE.EMPHASIS.create(spans);
                    String string = ((Line.TextSegment)segment).toString();
                    lineLength += string.length();
                    emphasis.appendChild((Node)new Text(string));
                    block.appendChild((Node)emphasis);
                    continue;
                }
                if (!(segment2 instanceof Line.LineBreakSegment)) continue;
                Element element = lastBlock;
                if (element == null) continue;
                element.addAttribute(new Attribute("linesAfter", "2"));
            }
            if (block.getChildCount() <= 0) continue;
            container.appendChild((Node)block);
            lastBlock = block;
        }
    }

    private final boolean lineTooLong(Line line) {
        int cellsPerLine = UTDManager.Companion.getCellsPerLine(WPManager.Companion.getInstance().getController());
        return line.toString().length() > cellsPerLine;
    }

    private final List<Line> clean(List<Line> lines) {
        ArrayList<Line> newLines = new ArrayList<Line>();
        for (Line l : lines) {
            Iterator<Line.Segment> iterator;
            Line newLine = new Line();
            int whitespace = 0;
            StringBuilder text = new StringBuilder();
            Intrinsics.checkNotNullExpressionValue(l.getElements().iterator(), (String)"iterator(...)");
            while (iterator.hasNext()) {
                Line.Segment s;
                Intrinsics.checkNotNullExpressionValue((Object)iterator.next(), (String)"next(...)");
                Line.Segment segment = s;
                if (segment instanceof Line.WhitespaceSegment) {
                    if (((CharSequence)text).length() > 0) {
                        ArrayList<Line.Segment> arrayList = newLine.getElements();
                        String string = text.toString();
                        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
                        arrayList.add(newLine.getTextSegment(string));
                        text = new StringBuilder();
                    }
                    whitespace += ((Line.WhitespaceSegment)s).space;
                    continue;
                }
                if (segment instanceof Line.LineBreakSegment) {
                    newLine.getElements().add(s);
                    continue;
                }
                String temp = s.toString();
                int n = temp.length();
                for (int i = 0; i < n; ++i) {
                    Comparable<StringBuilder> comparable;
                    char element = temp.charAt(i);
                    if (Character.isWhitespace(element)) {
                        if (((CharSequence)text).length() > 0) {
                            ArrayList<Line.Segment> arrayList = newLine.getElements();
                            String string = text.toString();
                            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
                            arrayList.add(newLine.getTextSegment(string));
                            text = new StringBuilder();
                        }
                        comparable = whitespace++;
                        continue;
                    }
                    if (whitespace > 0) {
                        newLine.getElements().add(newLine.getWhitespaceSegment(whitespace));
                        whitespace = 0;
                    }
                    comparable = text.append(element);
                }
            }
            if (whitespace > 0) {
                newLine.getElements().add(newLine.getWhitespaceSegment(whitespace));
            } else if (((CharSequence)text).length() > 0) {
                ArrayList<Line.Segment> arrayList = newLine.getElements();
                String string = text.toString();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
                arrayList.add(newLine.getTextSegment(string));
            }
            newLines.add(newLine);
        }
        return newLines;
    }

    /*
     * WARNING - void declaration
     */
    private final int getSpans(String string) {
        String string2;
        block1: {
            void var2_2;
            String $this$takeWhile$iv = string;
            boolean $i$f$takeWhile = false;
            int n = $this$takeWhile$iv.length();
            for (int index$iv = 0; index$iv < n; ++index$iv) {
                char it = $this$takeWhile$iv.charAt(index$iv);
                boolean bl = false;
                if (CharsKt.isWhitespace((char)it)) continue;
                String string3 = $this$takeWhile$iv;
                int n2 = 0;
                String string4 = string3.substring(n2, index$iv);
                string2 = string4;
                Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"substring(...)");
                break block1;
            }
            string2 = var2_2;
        }
        return string2.length();
    }
}

