/*
 * Decompiled with CFR 0.152.
 */
package org.brailleblaster.math.template;

import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.brailleblaster.math.mathml.MathModuleUtils;
import org.brailleblaster.math.spatial.SpatialMathEnum;
import org.brailleblaster.math.template.Template;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u000e\n\u0002\u0010\b\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \"2\u00020\u0001:\u0002!\"B)\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\u0004\b\b\u0010\tJ\u0006\u0010\u001d\u001a\u00020\u0003J\u000e\u0010\u001e\u001a\u00020\u00032\u0006\u0010\u001f\u001a\u00020 R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\u000bR\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0007\u001a\u00020\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0007\u0010\r\"\u0004\b\u000e\u0010\u000fR\u001a\u0010\u0010\u001a\u00020\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010\r\"\u0004\b\u0011\u0010\u000fR\u001a\u0010\u0012\u001a\u00020\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0012\u0010\r\"\u0004\b\u0013\u0010\u000fR\u001a\u0010\u0014\u001a\u00020\u0015X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0016\u0010\u0017\"\u0004\b\u0018\u0010\u0019R\u001a\u0010\u001a\u001a\u00020\u0015X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001b\u0010\u0017\"\u0004\b\u001c\u0010\u0019\u00a8\u0006#"}, d2={"Lorg/brailleblaster/math/template/TemplateNumber;", "", "leftDec", "", "rightDec", "isDecimal", "", "isMinus", "<init>", "(Ljava/lang/String;Ljava/lang/String;ZZ)V", "getLeftDec", "()Ljava/lang/String;", "getRightDec", "()Z", "setMinus", "(Z)V", "isColumnHasDecimal", "setColumnHasDecimal", "isColumnHasMinus", "setColumnHasMinus", "leftPadding", "", "getLeftPadding", "()I", "setLeftPadding", "(I)V", "rightPadding", "getRightPadding", "setRightPadding", "toStringPart", "toStringWhole", "template", "Lorg/brailleblaster/math/template/Template;", "TemplateNumberBuilder", "Companion", "brailleblaster-core"})
public final class TemplateNumber {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String leftDec;
    @NotNull
    private final String rightDec;
    private final boolean isDecimal;
    private boolean isMinus;
    private boolean isColumnHasDecimal;
    private boolean isColumnHasMinus;
    private int leftPadding;
    private int rightPadding;

    private TemplateNumber(String leftDec, String rightDec, boolean isDecimal, boolean isMinus) {
        this.leftDec = leftDec;
        this.rightDec = rightDec;
        this.isDecimal = isDecimal;
        this.isMinus = isMinus;
    }

    @NotNull
    public final String getLeftDec() {
        return this.leftDec;
    }

    @NotNull
    public final String getRightDec() {
        return this.rightDec;
    }

    public final boolean isMinus() {
        return this.isMinus;
    }

    public final void setMinus(boolean bl) {
        this.isMinus = bl;
    }

    public final boolean isColumnHasDecimal() {
        return this.isColumnHasDecimal;
    }

    public final void setColumnHasDecimal(boolean bl) {
        this.isColumnHasDecimal = bl;
    }

    public final boolean isColumnHasMinus() {
        return this.isColumnHasMinus;
    }

    public final void setColumnHasMinus(boolean bl) {
        this.isColumnHasMinus = bl;
    }

    public final int getLeftPadding() {
        return this.leftPadding;
    }

    public final void setLeftPadding(int n) {
        this.leftPadding = n;
    }

    public final int getRightPadding() {
        return this.rightPadding;
    }

    public final void setRightPadding(int n) {
        this.rightPadding = n;
    }

    @NotNull
    public final String toStringPart() {
        return MathModuleUtils.isNemeth() ? StringsKt.repeat((CharSequence)" ", (int)this.leftPadding) + this.leftDec + (this.isDecimal ? "." : (this.isColumnHasDecimal ? " " : "")) + this.rightDec + StringsKt.repeat((CharSequence)" ", (int)this.rightPadding) : StringsKt.repeat((CharSequence)" ", (int)this.leftPadding) + this.leftDec + (this.isDecimal ? "4" : (this.isColumnHasDecimal ? " " : "")) + this.rightDec + StringsKt.repeat((CharSequence)" ", (int)this.rightPadding);
    }

    @NotNull
    public final String toStringWhole(@NotNull Template template) {
        Intrinsics.checkNotNullParameter((Object)template, (String)"template");
        return MathModuleUtils.isNemeth() ? (this.isMinus ? "\u2112" : (this.isColumnHasMinus ? StringsKt.repeat((CharSequence)" ", (int)1) : "")) + StringsKt.repeat((CharSequence)" ", (int)this.leftPadding) + this.leftDec + (this.isDecimal ? "." : (this.isColumnHasDecimal ? " " : "")) + this.rightDec + StringsKt.repeat((CharSequence)" ", (int)this.rightPadding) : (template.getSettings().getPassage() == SpatialMathEnum.Passage.NUMERIC ? (this.isMinus ? "\"\u2212" : (this.isColumnHasMinus ? StringsKt.repeat((CharSequence)" ", (int)2) : "")) + StringsKt.repeat((CharSequence)" ", (int)this.leftPadding) + this.leftDec + (this.isDecimal ? "4" : (this.isColumnHasDecimal ? " " : "")) + this.rightDec + StringsKt.repeat((CharSequence)" ", (int)this.rightPadding) : (this.isMinus ? "\"\u2212" : (this.isColumnHasMinus ? StringsKt.repeat((CharSequence)" ", (int)2) : "")) + "#" + StringsKt.repeat((CharSequence)" ", (int)this.leftPadding) + this.leftDec + (this.isDecimal ? "4" : (this.isColumnHasDecimal ? " " : "")) + this.rightDec + StringsKt.repeat((CharSequence)" ", (int)this.rightPadding));
    }

    public /* synthetic */ TemplateNumber(String leftDec, String rightDec, boolean isDecimal, boolean isMinus, DefaultConstructorMarker $constructor_marker) {
        this(leftDec, rightDec, isDecimal, isMinus);
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0014\u0010\u0004\u001a\u00020\u00052\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007J\u001a\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\b2\b\u0010\f\u001a\u0004\u0018\u00010\b\u00a8\u0006\r"}, d2={"Lorg/brailleblaster/math/template/TemplateNumber$Companion;", "", "<init>", "()V", "makeColumnsEqualWidth", "", "array", "", "Lorg/brailleblaster/math/template/TemplateNumber;", "equalsWithNullCheck", "", "tn1", "tn2", "brailleblaster-core"})
    public static final class Companion {
        private Companion() {
        }

        public final void makeColumnsEqualWidth(@NotNull List<TemplateNumber> array) {
            Intrinsics.checkNotNullParameter(array, (String)"array");
            int widestLeft = 0;
            int widestRight = 0;
            boolean columnHasDecimal = false;
            boolean columnHasMinus = false;
            for (TemplateNumber number : array) {
                if (number.isDecimal) {
                    columnHasDecimal = true;
                }
                if (number.isMinus()) {
                    columnHasMinus = true;
                }
                if (number.getLeftDec().length() > widestLeft) {
                    widestLeft = number.getLeftDec().length();
                }
                if (number.getRightDec().length() <= widestRight) continue;
                widestRight = number.getRightDec().length();
            }
            for (TemplateNumber number : array) {
                number.setColumnHasDecimal(columnHasDecimal);
                number.setColumnHasMinus(columnHasMinus);
                number.setLeftPadding(widestLeft - number.getLeftDec().length());
                number.setRightPadding(widestRight - number.getRightDec().length());
            }
        }

        public final boolean equalsWithNullCheck(@Nullable TemplateNumber tn1, @Nullable TemplateNumber tn2) {
            if (tn1 == null || tn2 == null) {
                return false;
            }
            return Intrinsics.areEqual((Object)tn1, (Object)tn2);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\u00020\u00002\u0006\u0010\u0004\u001a\u00020\u0005J\u000e\u0010\u0006\u001a\u00020\u00002\u0006\u0010\u0006\u001a\u00020\u0005J\u0006\u0010\n\u001a\u00020\u000bJ\u000e\u0010\f\u001a\u00020\u00002\u0006\u0010\r\u001a\u00020\u0005R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lorg/brailleblaster/math/template/TemplateNumber$TemplateNumberBuilder;", "", "<init>", "()V", "leftDec", "", "rightDec", "decimal", "", "minus", "build", "Lorg/brailleblaster/math/template/TemplateNumber;", "wholeNum", "string", "brailleblaster-core"})
    public static final class TemplateNumberBuilder {
        @NotNull
        private String leftDec = "";
        @NotNull
        private String rightDec = "";
        private boolean decimal;
        private boolean minus;

        @NotNull
        public final TemplateNumberBuilder leftDec(@NotNull String leftDec) {
            Intrinsics.checkNotNullParameter((Object)leftDec, (String)"leftDec");
            this.leftDec = leftDec;
            return this;
        }

        @NotNull
        public final TemplateNumberBuilder rightDec(@NotNull String rightDec) {
            Intrinsics.checkNotNullParameter((Object)rightDec, (String)"rightDec");
            this.rightDec = rightDec;
            return this;
        }

        @NotNull
        public final TemplateNumber build() {
            return new TemplateNumber(this.leftDec, this.rightDec, this.decimal, this.minus, null);
        }

        @NotNull
        public final TemplateNumberBuilder wholeNum(@NotNull String string) {
            Intrinsics.checkNotNullParameter((Object)string, (String)"string");
            String wholeString = string;
            CharSequence charSequence = wholeString;
            Regex regex = new Regex("#");
            String string2 = "";
            wholeString = regex.replace(charSequence, string2);
            String decimal = MathModuleUtils.isNemeth() ? "." : "4";
            int split = StringsKt.indexOf$default((CharSequence)wholeString, (String)decimal, (int)0, (boolean)false, (int)6, null);
            if (split != -1) {
                int minusSplit;
                this.leftDec = StringsKt.take((String)wholeString, (int)split);
                this.rightDec = StringsKt.drop((String)wholeString, (int)(split + 1));
                this.decimal = true;
                int n = minusSplit = MathModuleUtils.isNemeth() ? StringsKt.indexOf$default((CharSequence)this.leftDec, (String)"\u2112", (int)0, (boolean)false, (int)6, null) : StringsKt.indexOf$default((CharSequence)this.leftDec, (String)"-", (int)0, (boolean)false, (int)6, null);
                if (minusSplit != -1) {
                    this.minus = true;
                    if (!MathModuleUtils.isNemeth()) {
                        String string3 = this.leftDec.substring(minusSplit + 1);
                        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"substring(...)");
                        this.leftDec = string3;
                    }
                }
            } else {
                int minusSplit;
                this.leftDec = wholeString;
                int n = minusSplit = MathModuleUtils.isNemeth() ? StringsKt.indexOf$default((CharSequence)this.leftDec, (String)"\u2112", (int)0, (boolean)false, (int)6, null) : StringsKt.indexOf$default((CharSequence)this.leftDec, (String)"-", (int)0, (boolean)false, (int)6, null);
                if (minusSplit != -1) {
                    this.minus = true;
                    if (!MathModuleUtils.isNemeth()) {
                        String string4 = this.leftDec.substring(minusSplit + 1);
                        Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"substring(...)");
                        this.leftDec = string4;
                    }
                }
            }
            return this;
        }
    }
}

